/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.core.sgbd;

import br.intelidata.commons.bridge.Bridge;
import br.intelidata.commons.bridge.ContextoHolder;
import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.sistema.Sessao;
import br.intelidata.commons.core.sql.PostgreSQLManager;
import br.intelidata.commons.core.sql.SGBDManager;
import br.intelidata.commons.domain.pojo.AbstractPojo;
import br.intelidata.commons.domain.pojo.Controle;
import br.intelidata.commons.domain.regranegocio.ControleRN;
import br.intelidata.core.sgdb.IConnectionHandler;
import br.intelidata.uniplusweb.core.service.AtualizacaoBaseDadosService;
import br.intelidata.uniplusweb.core.spring.multitenant.TenantService;
import br.intelidata.uniplusweb.service.MDCConfigService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Profile;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Profile(value={"dev", "prod", "aws"})
@RestController
public class MigracaoController {
    private final Logger log = LoggerFactory.getLogger(MigracaoController.class);
    private IConnectionHandler connectionHandler;
    private MDCConfigService mdcConfigService;
    private AtualizacaoBaseDadosService atualizacaoBaseDadosService;
    private TenantService tenantService;

    public MigracaoController(IConnectionHandler connectionHandler, MDCConfigService mdcConfigService, AtualizacaoBaseDadosService atualizacaoBaseDadosService, TenantService tenantService) {
        this.connectionHandler = connectionHandler;
        this.mdcConfigService = mdcConfigService;
        this.atualizacaoBaseDadosService = atualizacaoBaseDadosService;
        this.tenantService = tenantService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/migracao/{tenant}"})
    public ResponseEntity<String> atualizaTabelas(@PathVariable String tenant) {
        String msg = "Base de dados atualizada com sucesso.";
        HttpStatus status = HttpStatus.OK;
        if (SGBDManager.getInstance() instanceof PostgreSQLManager) {
            this.mdcConfigService.confiMDC(tenant);
            this.log.info("Verificando a base de dados do tenant " + tenant);
            try {
                ContextoHolder.setTenant((String)tenant, (String)this.tenantService.getDatabase(tenant));
                this.connectionHandler.createConnection(true);
                this.connectionHandler.beginTransaction();
                Bridge.getBridge().initCache();
                SessaoUtil.setSessaoJob((Sessao)SessaoUtil.getSessaoSistema());
                this.atualizacaoBaseDadosService.atualizacaoBaseDados(tenant);
                this.log.info("Fim da verifica\u00e7\u00e3o da base de dados");
            }
            catch (Exception ex) {
                msg = "N\u00e3o foi poss\u00edvel atualizar a base de dados, verifique o log para mais detalhes: " + ex.getMessage();
                status = HttpStatus.INTERNAL_SERVER_ERROR;
                this.log.error(msg, (Throwable)ex);
            }
            finally {
                if (this.connectionHandler.isConnected()) {
                    this.connectionHandler.commit();
                    this.connectionHandler.releaseConnection();
                }
                Bridge.getBridge().remove();
            }
        }
        return new ResponseEntity((Object)msg, status);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/reinicializar-dashboard/{tenant}"})
    public ResponseEntity<String> reinicializarDashboard(@PathVariable String tenant) {
        HttpStatus status = HttpStatus.OK;
        this.mdcConfigService.confiMDC(tenant);
        String msg = "Resumo de Dashboard reinicializado";
        try {
            ContextoHolder.setTenant((String)tenant, (String)this.tenantService.getDatabase(tenant));
            this.connectionHandler.createConnection(true);
            this.connectionHandler.beginTransaction();
            Bridge.getBridge().initCache();
            Controle controle = ControleRN.getInstance().buscar();
            controle.setDashboardInit(0);
            ControleRN.getInstance().alterar((AbstractPojo)controle, SessaoUtil.getSessao());
        }
        catch (Exception ex) {
            msg = "N\u00e3o foi poss\u00edvel reinicializar o dashboed: " + ex.getMessage();
            status = HttpStatus.INTERNAL_SERVER_ERROR;
            this.log.error(msg, (Throwable)ex);
        }
        finally {
            if (this.connectionHandler.isConnected()) {
                this.connectionHandler.commit();
                this.connectionHandler.releaseConnection();
            }
            Bridge.getBridge().remove();
        }
        return new ResponseEntity((Object)msg, status);
    }
}

