/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.core.spring.multitenant;

import br.intelidata.commons.bridge.ContextoHolder;
import br.intelidata.uniplusweb.core.spring.multitenant.TenantService;
import br.intelidata.uniplusweb.core.util.StringUtil;
import br.intelidata.uniplusweb.service.MDCConfigService;
import br.intelidata.uniplusweb.web.rest.app.batch.serices.MetricaService;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.oauth2.provider.OAuth2Authentication;
import org.springframework.security.oauth2.provider.authentication.OAuth2AuthenticationDetails;
import org.springframework.web.filter.GenericFilterBean;

/*
 * Exception performing whole class analysis ignored.
 */
public class TenantFilter
extends GenericFilterBean {
    private final MDCConfigService mdcConfigService;
    private final TenantService tenantService;
    private final MetricaService metricaService;

    public TenantFilter(MDCConfigService mdcConfigService, TenantService tenantService, MetricaService metricaService) {
        this.mdcConfigService = mdcConfigService;
        this.tenantService = tenantService;
        this.metricaService = metricaService;
    }

    public static String getTenant(ServletRequest request) {
        Authentication authentication;
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        String tenantByParameter = request.getParameter("tenant");
        if (tenantByParameter != null) {
            return tenantByParameter;
        }
        String tenantByHeader = httpRequest.getHeader("X-Uniplusweb-Tenant");
        if (tenantByHeader != null) {
            return tenantByHeader;
        }
        String token = httpRequest.getHeader("authorization");
        if (token != null && token.startsWith("Bearer") && (authentication = SecurityContextHolder.getContext().getAuthentication()) != null) {
            String tenantByClaim;
            OAuth2AuthenticationDetails details;
            Map decodedDetails;
            OAuth2Authentication oAuth2Authentication = (OAuth2Authentication)authentication;
            if (oAuth2Authentication.getDetails() != null && (decodedDetails = (Map)(details = (OAuth2AuthenticationDetails)oAuth2Authentication.getDetails()).getDecodedDetails()) != null && (tenantByClaim = (String)decodedDetails.get("tenant")) != null) {
                return tenantByClaim;
            }
            return oAuth2Authentication.getOAuth2Request().getClientId();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        String tenant = TenantFilter.getTenant((ServletRequest)request);
        long start = System.currentTimeMillis();
        try {
            ContextoHolder.setTenant((String)tenant, (String)this.tenantService.getDatabase(tenant));
            this.mdcConfigService.confiMDC(tenant);
            this.verifyHeaderTimestamp((HttpServletRequest)request, (HttpServletResponse)response);
            chain.doFilter(request, response);
        }
        finally {
            long duration = System.currentTimeMillis() - start;
            CompletableFuture.runAsync(() -> this.metricaService.gerarMetrica(tenant, request, response, duration)).exceptionally(ex -> null);
            ContextoHolder.remove();
        }
    }

    private void verifyHeaderTimestamp(HttpServletRequest request, HttpServletResponse response) {
        String startTimestamp = request.getHeader("startTimestamp");
        if (!StringUtil.stringNullOrEmpty((String)startTimestamp) && (startTimestamp = this.removeSpecial(startTimestamp)).matches("^[0-9]+$")) {
            response.setHeader("startTimestamp", startTimestamp);
        }
    }

    private String removeSpecial(String str) {
        return str.replaceAll("[^0-9 ]", "");
    }
}

