/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.exceptions.api;

import br.intelidata.commons.core.execoes.UnicoException;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.uniplusweb.core.util.NumberUtil;
import br.intelidata.uniplusweb.core.util.ULID;
import br.intelidata.uniplusweb.exceptions.api.RestControllerAdvice;
import br.intelidata.uniplusweb.security.AutenticacaoException;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MaxUploadSizeExceededException;

@ControllerAdvice
public class RestControllerAdvice {
    private static final Logger logger = LoggerFactory.getLogger(RestControllerAdvice.class);
    @Value(value="${exception.log:true}")
    private String logException;
    @Value(value="${spring.servlet.multipart.max-file-size}")
    private String maxFileSize;

    @ExceptionHandler(value={UnicoMensagemUsuarioException.class})
    public ResponseEntity<ExceptionResponse> unicoMensagemUsuarioException(UnicoMensagemUsuarioException ex) {
        String codigo = new ULID().nextULID();
        this.logarError("UnicoMensagemUsuarioException", codigo, (Exception)((Object)ex));
        ExceptionResponse response = new ExceptionResponse(codigo, Integer.valueOf(HttpStatus.UNPROCESSABLE_ENTITY.value()), ex);
        return new ResponseEntity((Object)response, HttpStatus.UNPROCESSABLE_ENTITY);
    }

    @ExceptionHandler(value={UnicoException.class})
    public ResponseEntity<ExceptionResponse> unicoMensagemUsuarioException(UnicoException ex) {
        String codigo = new ULID().nextULID();
        this.logarError("UnicoException", codigo, (Exception)ex);
        ExceptionResponse response = new ExceptionResponse(codigo, Integer.valueOf(HttpStatus.INTERNAL_SERVER_ERROR.value()), ex);
        return new ResponseEntity((Object)response, HttpStatus.INTERNAL_SERVER_ERROR);
    }

    @ExceptionHandler(value={MaxUploadSizeExceededException.class})
    @ResponseBody
    public void maxUploadSizeExceededException(HttpServletRequest request, HttpServletResponse response, MaxUploadSizeExceededException e) throws IOException {
        int tamanho = Integer.parseInt(NumberUtil.apenasNumeros((String)this.maxFileSize));
        String sufixo = this.maxFileSize.substring(this.maxFileSize.length() - 2);
        response.sendError(HttpStatus.UNPROCESSABLE_ENTITY.value(), "O tamanho m\u00e1ximo do arquivo deve ser " + tamanho + sufixo);
    }

    @ExceptionHandler(value={Exception.class})
    @ResponseBody
    public ResponseEntity<ExceptionResponse> exception(Exception e) {
        String codigo = new ULID().nextULID();
        if (this.logException.equalsIgnoreCase("true")) {
            this.logarError("Erro na api causada pela exception", codigo, e);
        }
        ExceptionResponse response = new ExceptionResponse(codigo, Integer.valueOf(HttpStatus.INTERNAL_SERVER_ERROR.value()), e, "Erro interno no servidor");
        return new ResponseEntity((Object)response, HttpStatus.INTERNAL_SERVER_ERROR);
    }

    @ExceptionHandler(value={MethodArgumentNotValidException.class})
    public ResponseEntity<ExceptionResponse> methodArgumentNotValidException(MethodArgumentNotValidException ex) {
        this.logarError("Erro na valida\u00e7\u00e3o dos dados", null, (Exception)ex);
        return new ResponseEntity((Object)new ExceptionResponse(ex), HttpStatus.BAD_REQUEST);
    }

    private void logarError(String marcador, String codigo, Exception e) {
        if (e instanceof UnicoException || e instanceof UnicoMensagemUsuarioException || e instanceof AutenticacaoException) {
            if (e.getCause() != null) {
                logger.error(marcador + " - " + codigo + " " + e.getMessage(), e.getCause());
            } else {
                logger.warn(marcador + " - " + codigo + " " + e.getMessage());
            }
        } else {
            logger.error(marcador + " - " + codigo, (Throwable)e);
        }
    }
}

