/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.security.oauth2;

import br.intelidata.core.sgdb.IConnectionHandler;
import br.intelidata.uniplusweb.security.AutenticacaoService;
import br.intelidata.uniplusweb.security.oauth2.CustomClientDetailsService;
import br.intelidata.uniplusweb.security.oauth2.CustomJwtTokenStore;
import br.intelidata.uniplusweb.security.oauth2.CustomWebResponseExceptionTranslator;
import br.intelidata.uniplusweb.security.oauth2.JwtTokenEnhancer;
import br.intelidata.uniplusweb.security.oauth2.OAuth2AuthorizationServer;
import java.util.Arrays;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Primary;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.jwt.crypto.sign.MacSigner;
import org.springframework.security.jwt.crypto.sign.SignatureVerifier;
import org.springframework.security.oauth2.config.annotation.configurers.ClientDetailsServiceConfigurer;
import org.springframework.security.oauth2.config.annotation.web.configuration.AuthorizationServerConfigurerAdapter;
import org.springframework.security.oauth2.config.annotation.web.configuration.EnableAuthorizationServer;
import org.springframework.security.oauth2.config.annotation.web.configurers.AuthorizationServerEndpointsConfigurer;
import org.springframework.security.oauth2.provider.ClientDetailsService;
import org.springframework.security.oauth2.provider.error.WebResponseExceptionTranslator;
import org.springframework.security.oauth2.provider.token.AccessTokenConverter;
import org.springframework.security.oauth2.provider.token.DefaultTokenServices;
import org.springframework.security.oauth2.provider.token.TokenEnhancer;
import org.springframework.security.oauth2.provider.token.TokenEnhancerChain;
import org.springframework.security.oauth2.provider.token.TokenStore;
import org.springframework.security.oauth2.provider.token.store.JwtAccessTokenConverter;
import org.springframework.security.oauth2.provider.token.store.JwtTokenStore;
import org.springframework.stereotype.Component;

@Component
@EnableAuthorizationServer
public class OAuth2AuthorizationServer
extends AuthorizationServerConfigurerAdapter {
    private final CustomClientDetailsService customClientDetailsService;
    @Autowired
    private AuthenticationManager authenticationManager;
    @Autowired
    private AutenticacaoService autenticacaoService;
    @Autowired
    private JwtTokenEnhancer tokenEnhancer;
    @Autowired
    private IConnectionHandler connectionHandler;

    public OAuth2AuthorizationServer(CustomClientDetailsService customClientDetailsService) {
        this.customClientDetailsService = customClientDetailsService;
    }

    @Bean
    @Primary
    public DefaultTokenServices tokenServices() {
        DefaultTokenServices tokenServices = new DefaultTokenServices();
        tokenServices.setTokenStore((TokenStore)this.jwtTokenStore());
        tokenServices.setSupportRefreshToken(true);
        return tokenServices;
    }

    @Bean
    public JwtTokenStore jwtTokenStore() {
        return new CustomJwtTokenStore(this.accessTokenConverter(), this.connectionHandler);
    }

    @Bean
    public JwtAccessTokenConverter accessTokenConverter() {
        JwtAccessTokenConverter converter = new JwtAccessTokenConverter();
        converter.setSigningKey("zx09qwe98df76kj12u72bdjd7203543mjzbndh");
        converter.setAccessTokenConverter((AccessTokenConverter)new JwtConverter());
        converter.setVerifier(this.verifier());
        return converter;
    }

    @Bean
    public SignatureVerifier verifier() {
        return new MacSigner("zx09qwe98df76kj12u72bdjd7203543mjzbndh");
    }

    public void configure(AuthorizationServerEndpointsConfigurer endpoints) {
        TokenEnhancerChain tokenEnhancerChain = new TokenEnhancerChain();
        tokenEnhancerChain.setTokenEnhancers(Arrays.asList(this.tokenEnhancer, this.accessTokenConverter()));
        endpoints.exceptionTranslator((WebResponseExceptionTranslator)new CustomWebResponseExceptionTranslator()).authenticationManager(this.authenticationManager).userDetailsService((UserDetailsService)this.autenticacaoService).tokenStore((TokenStore)this.jwtTokenStore()).tokenEnhancer((TokenEnhancer)tokenEnhancerChain).accessTokenConverter((AccessTokenConverter)this.accessTokenConverter());
    }

    public void configure(ClientDetailsServiceConfigurer clients) throws Exception {
        clients.withClientDetails((ClientDetailsService)this.customClientDetailsService);
    }
}

