/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.service;

import br.intelidata.commons.core.licenca.MicroFuncionalidade;
import br.intelidata.commons.core.licenca.Modulo;
import br.intelidata.commons.core.licenca.ModuloManager;
import br.intelidata.commons.domain.regranegocio.ConfiguradorModuloCommonRN;
import br.intelidata.core.dashboard.base.interfaces.IModuloSistema;
import br.intelidata.uniplusweb.core.service.CacheService;
import br.intelidata.uniplusweb.core.util.TipoCache;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.cache.support.SimpleValueWrapper;
import org.springframework.stereotype.Service;

@Service
public class ModuloService
implements IModuloSistema {
    private final CacheService cacheService;

    public ModuloService(CacheService cacheService) {
        this.cacheService = cacheService;
    }

    public boolean isAtivo(Modulo modulo) {
        if (!modulo.isValidarNoBanco()) {
            return modulo.getInterfaceModulo().isLicenciado();
        }
        Boolean isAtivo = (Boolean)this.getMapModulos().get(modulo.getId());
        if (isAtivo == null) {
            isAtivo = modulo.getInterfaceModulo().isLicenciado() && modulo.getInterfaceModulo().isModuloDefault();
            this.getMapModulos().put(modulo.getId(), isAtivo);
        }
        return isAtivo;
    }

    public Map<String, Boolean> getMapModulosAtivos() {
        return Stream.of(Modulo.values()).filter(m -> m.getInterfaceModulo().isAtivado()).collect(Collectors.toMap(Enum::name, m -> true, (m1, m2) -> m2, LinkedHashMap::new));
    }

    public boolean isMicroFuncionalidadeAtiva(MicroFuncionalidade microFuncionalidade) {
        return ModuloManager.getInstance().isMicroFuncionalidadeAtiva(microFuncionalidade);
    }

    public synchronized Map<Integer, Boolean> getMapModulos() {
        SimpleValueWrapper wrapper = (SimpleValueWrapper)this.cacheService.get((Object)TipoCache.ID_MODULO.getId());
        Map mapModulos = null;
        if (wrapper != null) {
            mapModulos = (Map)wrapper.get();
        }
        if (mapModulos == null) {
            mapModulos = ConfiguradorModuloCommonRN.getInstance().buscarMapModulos();
            this.cacheService.put((Object)TipoCache.ID_MODULO.getId(), (Object)mapModulos);
        }
        return mapModulos;
    }
}

