/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.service.monitor;

import br.intelidata.commons.core.util.DataHoraFactory;
import br.intelidata.uniplusweb.core.util.DateUtil;
import br.intelidata.uniplusweb.core.util.FileUtil;
import br.intelidata.uniplusweb.service.monitor.DadosCPUWrapper;
import com.sun.management.OperatingSystemMXBean;
import java.io.File;
import java.lang.management.ManagementFactory;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.Temporal;
import org.springframework.stereotype.Component;

@Component
public class MonitorService {
    private final DadosCPUWrapper monitorCpu = new DadosCPUWrapper();

    public void monitorarCpu(int totalThread, int threadsAtivas, Instant start) {
        this.monitorCpu.setAvailableProcessors(ManagementFactory.getOperatingSystemMXBean().getAvailableProcessors());
        String SOVersion = ManagementFactory.getOperatingSystemMXBean().getName() + " " + ManagementFactory.getOperatingSystemMXBean().getVersion() + " (" + ManagementFactory.getOperatingSystemMXBean().getArch() + ")";
        this.monitorCpu.setSOVersion(SOVersion);
        this.monitorCpu.setThreads(totalThread - threadsAtivas);
        this.monitorCpu.setTotalThreads(totalThread);
        long segundos = Duration.between(start, Instant.now()).getSeconds();
        this.monitorCpu.setTempoExecucao(DateUtil.formataDataHora((Temporal)DataHoraFactory.ofInstantUTC((Instant)Instant.ofEpochSecond(segundos)), (String)"HH:mm:ss"));
        Double percCpu = ((OperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean()).getSystemCpuLoad();
        String hora = DateUtil.formataDataHora((Temporal)DataHoraFactory.ofInstant((Instant)Instant.now()), (String)"HH:mm:ss");
        DadosCPUWrapper.Cpu cpu = new DadosCPUWrapper.Cpu(percCpu, hora);
        this.monitorCpu.getListaCpu().adicionar((Object)cpu);
        File file = new File(".");
        this.monitorCpu.setDiskFreeSpace(FileUtil.toGB((Long)file.getFreeSpace()));
        this.monitorCpu.setDiskTotalSpace(FileUtil.toGB((Long)file.getTotalSpace()));
    }

    public DadosCPUWrapper getMonitorCpu() {
        return this.monitorCpu;
    }
}

