/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.client.schedulers;

import br.intelidata.commons.bridge.Bridge;
import br.intelidata.commons.bridge.ContextoHolder;
import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.sistema.Sessao;
import br.intelidata.commons.core.util.DataHoraFactory;
import br.intelidata.commons.modulo.cadastros.regranegocio.LicencaRN;
import br.intelidata.core.sgdb.IConnectionHandler;
import br.intelidata.uniplusweb.config.UnipluswebProperties;
import br.intelidata.uniplusweb.core.spring.multitenant.Tenant;
import br.intelidata.uniplusweb.core.spring.multitenant.TenantService;
import br.intelidata.uniplusweb.service.MDCConfigService;
import br.intelidata.uniplusweb.web.enums.TipoInstancia;
import br.intelidata.uniplusweb.web.rest.app.client.schedulers.SchedulersMap;
import br.intelidata.uniplusweb.web.rest.app.client.schedulers.map.ExecucaoSchedulerInfoAdicional;
import java.time.LocalDateTime;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import unico.pojo.Licenca;

public abstract class AbstractScheduler {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    protected IConnectionHandler connectionHandler;
    protected MDCConfigService mdcConfigService;
    protected UnipluswebProperties uwp;
    protected TenantService tenantService;
    private LocalDateTime dataHoraInicio;

    public AbstractScheduler(UnipluswebProperties unipluswebProperties, IConnectionHandler connectionHandler, TenantService tenantService, MDCConfigService mdcConfigService) {
        this.uwp = unipluswebProperties;
        this.connectionHandler = connectionHandler;
        this.tenantService = tenantService;
        this.mdcConfigService = mdcConfigService;
    }

    protected abstract String nomeScheduler();

    protected abstract void agendador();

    protected abstract void executar(Tenant var1) throws Throwable;

    protected abstract String logarUnicoException();

    protected List<Tenant> getTenants() {
        return this.tenantService.getTenants(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void run() {
        Long millisInicio = System.currentTimeMillis();
        boolean sucesso = true;
        String mensagem = "";
        String erro = "";
        String licencaPrincipal = "";
        if (!this.executarMaquinaJob()) {
            this.log.warn("O schedule n\u00e3o ser\u00e1 executado pois esta n\u00e3o \u00e9 uma m\u00e1quina do tipo job.");
            return;
        }
        for (Tenant tenant : this.getTenants()) {
            List infoAdicional;
            Long millisInicioTenant;
            block21: {
                millisInicioTenant = System.currentTimeMillis();
                this.mdcConfigService.confiMDC(tenant.getCodigo());
                this.log.debug("Verificando schedule " + this.nomeScheduler() + " do tenant " + tenant.getCodigo());
                ContextoHolder.setTenant((String)tenant.getCodigo(), (String)this.tenantService.getDatabase(tenant.getCodigo()));
                infoAdicional = null;
                try {
                    this.connectionHandler.createConnection(false);
                    if (!this.isExecutar()) continue;
                    this.connectionHandler.beginTransaction();
                    Bridge.getBridge().initCache();
                    this.login();
                    ContextoHolder.setsessaoScheduler((Sessao)SessaoUtil.getSessaoSistema());
                    Licenca licenca = LicencaRN.getInstance().buscarLicencaPrincipal();
                    if (licenca != null) {
                        licencaPrincipal = licenca.getChaveAtivacao();
                    }
                    this.dataHoraInicio = DataHoraFactory.getDataHora();
                    this.executar(tenant);
                    this.finalizarProcesso(this.dataHoraInicio, DataHoraFactory.getDataHora());
                    infoAdicional = this.getListaInfoAdicional();
                    if (this.connectionHandler.isAutoCommit()) break block21;
                    this.connectionHandler.commit();
                }
                catch (Throwable ex) {
                    sucesso = false;
                    if (ex instanceof UnicoMensagemUsuarioException) {
                        this.log.error(this.logarUnicoException() + " no tenant {} : ", (Object)ex.getMessage(), (Object)tenant.getCodigo());
                    }
                    mensagem = this.logarUnicoException() + " no tenant " + tenant.getCodigo();
                    erro = ex.getMessage();
                    try {
                        if (!this.connectionHandler.isAutoCommit()) {
                            this.connectionHandler.rollback();
                            this.log.error("Falhou ao executar tenant " + tenant.getCodigo(), ex);
                        }
                    }
                    catch (Exception ex2) {
                        this.log.error("Falhou ao executar rolback no schedule " + this.nomeScheduler() + " no tenant {} : " + ex2.getMessage(), (Object)tenant.getCodigo());
                    }
                }
                finally {
                    Bridge.getBridge().remove();
                    if (!this.connectionHandler.isConnected()) continue;
                    try {
                        this.connectionHandler.releaseConnection();
                    }
                    catch (Exception ex) {
                        this.log.error("Falhou ao fechar a conex\u00e3o do schedule  " + this.nomeScheduler() + " do tenant {} : " + ex.getMessage(), (Object)tenant.getCodigo());
                    }
                    continue;
                }
            }
            if (!this.isEnviarLogScheduler()) continue;
            SchedulersMap.setExecucaoTenant((String)this.nomeScheduler(), (String)tenant.getCodigo(), (Long)millisInicioTenant, (boolean)sucesso, (String)mensagem, (String)erro, (String)licencaPrincipal, (List)infoAdicional);
        }
        this.log.debug(this.nomeScheduler() + " conclu\u00eddo para todos os tenants ativos.");
    }

    protected boolean executarMaquinaJob() {
        return this.uwp.getAmbiente().isLocal() || this.uwp.getAmbiente().getTipoInstancia().equals((Object)TipoInstancia.job) || !this.uwp.getAmbiente().isUsarMaquinaJob();
    }

    protected LocalDateTime getDataHoraInicio() {
        return this.dataHoraInicio;
    }

    protected void finalizarProcesso(LocalDateTime dataHoraInicio, LocalDateTime dataHoraFim) {
    }

    protected void login() {
    }

    protected List<ExecucaoSchedulerInfoAdicional> getListaInfoAdicional() throws UnicoMensagemUsuarioException {
        return null;
    }

    protected boolean isExecutar() {
        return true;
    }

    protected boolean isEnviarLogScheduler() {
        return true;
    }
}

