/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.client.schedulers;

import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.sistema.Sessao;
import br.intelidata.commons.cron.Cron;
import br.intelidata.commons.domain.pojo.enuns.TipoJob;
import br.intelidata.commons.modulo.ferramentas.centralpendencias.pojo.PendenciaSistemaFilial;
import br.intelidata.commons.modulo.ferramentas.centralpendencias.regranegocio.PendenciaSistemaRN;
import br.intelidata.uniplusweb.config.UnipluswebProperties;
import br.intelidata.uniplusweb.core.util.BeanUtil;
import br.intelidata.uniplusweb.service.socket.NotificationService;
import br.intelidata.uniplusweb.service.socket.NotificationType;
import br.intelidata.uniplusweb.web.rest.app.client.schedulers.AbstractPrepareScheduler;
import br.intelidata.uniplusweb.web.rest.app.crud.pendenciasistema.PendenciaSistemaCache;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PendenciaSistemaScheduler
extends AbstractPrepareScheduler {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final NotificationService notificationService = (NotificationService)BeanUtil.getBean((String)"notificationService");
    private final UnipluswebProperties unipluswebProperties = (UnipluswebProperties)BeanUtil.getBean((String)"uniplusweb-br.intelidata.uniplusweb.config.UnipluswebProperties");

    public PendenciaSistemaScheduler() {
        super("Verificar pend\u00eancias do sistema", Cron.hourly(), TipoJob.PENDENCIAS_SISTEMA);
    }

    public boolean abstractControlTransaction() {
        return false;
    }

    public void execute() throws Exception {
        this.log.info("Verificando as pend\u00eancias do sistema do tenant: " + this.getTask().getTenant());
        this.verificarPendencias();
        this.log.info("Verifica\u00e7\u00e3o das pend\u00eancias do sistema completada para o tenant: " + this.getTask().getTenant());
    }

    public void onFailure(Exception ex) {
    }

    private void verificarPendencias() {
        Sessao sessao = SessaoUtil.getSessaoSistema();
        PendenciaSistemaRN pendenciaSistemaRN = new PendenciaSistemaRN();
        List pendencias = pendenciaSistemaRN.verificaPendencias(sessao, true, this.unipluswebProperties.getConfiguracaoSchedulers().isHabilitarEnvioEmailPendenciaSistema(), null);
        PendenciaSistemaCache.getInstance().setPendencias(this.getTask().getTenant(), pendencias);
        int totalPendencias = pendencias.stream().mapToInt(PendenciaSistemaFilial::getQuantidade).sum();
        this.notificationService.notifyTenantNow(NotificationType.PENDENCIAS_SISTEMA, (Object)totalPendencias);
    }

    public boolean isAtivo() {
        return true;
    }
}

