/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.client.schedulers;

import br.intelidata.commons.core.sql.SqlStats;
import br.intelidata.commons.core.util.JSONUtil;
import br.intelidata.commons.cron.Cron;
import br.intelidata.uniplusweb.adm.SystemStatus;
import br.intelidata.uniplusweb.adm.SystemStatusService;
import br.intelidata.uniplusweb.service.ConnectionOAuth2Service;
import br.intelidata.uniplusweb.web.rest.app.client.schedulers.AbstractPrepareScheduler;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnProperty(prefix="uniplusweb.configuracaoSchedulers", name={"habilitarEnvioStatus"}, havingValue="true")
public class StatusInstanciaScheduler
extends AbstractPrepareScheduler {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final ConnectionOAuth2Service connectionOAuth2Service;
    private final SystemStatusService systemStatusService;

    public StatusInstanciaScheduler(ConnectionOAuth2Service connectionOAuth2Service, SystemStatusService systemStatusService) {
        super("Status da Inst\u00e2ncia", Cron.hourly((int)1), null);
        this.connectionOAuth2Service = connectionOAuth2Service;
        this.systemStatusService = systemStatusService;
    }

    public void execute() throws Exception {
    }

    public void onFailure(Exception ex) {
    }

    private void enviarStatus() {
        try {
            SystemStatus status = this.systemStatusService.getSystemStatus();
            status.setTotalQueries(SqlStats.getMapTotalQueries());
            JSONObject statusJson = JSONUtil.getJSONObject((Object)status);
            ResponseEntity response = this.connectionOAuth2Service.execute("/api/", "status-instancia/incluir", statusJson, String.class, HttpMethod.POST, new Object[0]);
            if (response.getStatusCode() != HttpStatus.OK && response.getBody() != null) {
                this.log.error("N\u00e3o foi poss\u00edvel enviar informa\u00e7\u00f5es da inst\u00e2ncia para o Portal Canal");
            }
        }
        catch (Exception ex) {
            this.log.error("N\u00e3o foi poss\u00edvel enviar informa\u00e7\u00f5es da inst\u00e2ncia para o Portal Canal", (Throwable)ex);
        }
    }

    public boolean isAtivo() {
        return false;
    }
}

