/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.client.schedulers.exportacaoxml;

import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.sistema.Sessao;
import br.intelidata.commons.core.util.DataHoraFactory;
import br.intelidata.commons.core.util.JSONUtil;
import br.intelidata.commons.core.util.Util;
import br.intelidata.commons.cron.Cron;
import br.intelidata.commons.domain.pojo.ConfiguracaoCampos;
import br.intelidata.commons.domain.pojo.Filial;
import br.intelidata.commons.domain.pojo.enuns.TipoJob;
import br.intelidata.commons.modulo.cadastros.regranegocio.ConfiguracaoCamposRN;
import br.intelidata.commons.modulo.cadastros.regranegocio.FilialRN;
import br.intelidata.commons.modulo.exportacaoxml.pojo.ArquivoExportacaoXML;
import br.intelidata.commons.modulo.exportacaoxml.pojo.ExportacaoXMLFiltro;
import br.intelidata.commons.modulo.exportacaoxml.regranegocio.ExportacaoXMLNovaRN;
import br.intelidata.uniplusweb.core.util.BeanUtil;
import br.intelidata.uniplusweb.core.util.EmailUtil;
import br.intelidata.uniplusweb.core.util.FileUtil;
import br.intelidata.uniplusweb.service.StorageService;
import br.intelidata.uniplusweb.web.enums.TipoArquivoArmazenado;
import br.intelidata.uniplusweb.web.rest.app.batch.TaskManager;
import br.intelidata.uniplusweb.web.rest.app.client.crud.CreateTaskEmail;
import br.intelidata.uniplusweb.web.rest.app.client.schedulers.AbstractPrepareScheduler;
import br.intelidata.uniplusweb.wrapper.ParametrosEmailWeb;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.time.LocalDate;
import java.time.temporal.Temporal;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipOutputStream;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import org.apache.commons.io.FilenameUtils;
import org.json.JSONObject;

public class ExportarXmlScheduler
extends AbstractPrepareScheduler {
    private final TaskManager taskManager = (TaskManager)BeanUtil.getBean((String)"taskManager");

    public ExportarXmlScheduler() {
        super(TipoJob.EXPORTA_XML.getDescricao() + " (agendado)", Cron.monthly((int)2, (int)22), TipoJob.EXPORTA_XML);
    }

    public void execute() throws Exception {
        for (Filial filial : FilialRN.getInstance().buscarLista()) {
            ExportacaoXMLFiltro filtros = null;
            ConfiguracaoCampos conf = ConfiguracaoCamposRN.getInstance().buscarPorIdFilialTabela(filial.getId(), "documento-fiscal");
            if (conf != null) {
                filtros = (ExportacaoXMLFiltro)JSONUtil.getObject((JSONObject)conf.getCamposSerializados(), ExportacaoXMLFiltro.class);
            }
            if (filtros == null) continue;
            LocalDate inicio = DataHoraFactory.getData().minusMonths(1L).withDayOfMonth(1);
            LocalDate fim = DataHoraFactory.getData().withDayOfMonth(1).minusDays(1L);
            filtros.setDataInicial(inicio);
            filtros.setDataFinal(fim);
            filtros.setIdFiliais(Collections.singletonList(filial.getId()));
            filtros.setCodigoFiliais(Collections.singletonList(filial.getCodigo()));
            Sessao sessao = SessaoUtil.getSessaoSistema();
            ExportacaoXMLNovaRN exportacao = new ExportacaoXMLNovaRN(sessao, filtros);
            if (filtros.isGravarEmDiretorio()) {
                List arquivos = exportacao.getArquivos().values().stream().map(ArquivoExportacaoXML::getFile).collect(Collectors.toList());
                arquivos.addAll(exportacao.getRelatorios());
                File file = this.montaZipFile(arquivos);
                this.saveFile(file);
                continue;
            }
            StringBuilder sbNomeCnpj = new StringBuilder();
            String nomeCnpj = "- " + filial.getNome() + " - " + filial.getCnpj();
            if (sbNomeCnpj.length() > 0) {
                sbNomeCnpj.append(Util.lineSeparator).append(nomeCnpj);
            } else {
                sbNomeCnpj.append(nomeCnpj);
            }
            String assunto = "Arquivos XML do per\u00edodo " + Util.formataDataHora((Temporal)filtros.getDataInicial(), (String)"dd/MM/yyyy") + " at\u00e9 " + Util.formataDataHora((Temporal)filtros.getDataFinal(), (String)"dd/MM/yyyy");
            String descricao = "Segue em anexo arquivos XML referentes aos documentos fiscais do per\u00edodo " + Util.formataDataHora((Temporal)filtros.getDataInicial(), (String)"dd/MM/yyyy") + " at\u00e9 " + Util.formataDataHora((Temporal)filtros.getDataFinal(), (String)"dd/MM/yyyy") + "." + Util.lineSeparator + Util.lineSeparator;
            descricao = descricao + (filtros.getIdFiliais().size() > 1 ? "<B>Contribuintes:</B> " : "<B>Contribuinte:</B> ") + Util.lineSeparator + sbNomeCnpj;
            FileDataSource[] dataSource = (FileDataSource[])Stream.concat(exportacao.getArquivos().values().stream().map(ArquivoExportacaoXML::getFile).map(FileDataSource::new), exportacao.getRelatorios().stream().map(FileDataSource::new)).toArray(FileDataSource[]::new);
            String email = filtros.getEmail();
            if (filtros.isEnviarEmailContador()) {
                email = filial.getContador().getEmail();
            }
            ParametrosEmailWeb parametrosEmailWeb = EmailUtil.getParametros((Sessao)sessao, (String)email, null, (String)assunto, (String)descricao);
            parametrosEmailWeb.setAnexos((DataSource[])dataSource);
            CreateTaskEmail taskEmail = new CreateTaskEmail(this.taskManager, parametrosEmailWeb, "Exporta\u00e7\u00e3o de documentos fiscais para a contabilidade");
            taskEmail.createTask((Object)parametrosEmailWeb, this.getTask().getUuid(), parametrosEmailWeb.getAssunto(), false);
        }
    }

    public void onFailure(Exception ex) {
    }

    private File montaZipFile(List<File> arquivos) throws UnicoMensagemUsuarioException {
        try {
            File scratchFile = File.createTempFile("XMLS", ".zip");
            scratchFile.deleteOnExit();
            try (FileOutputStream fos = new FileOutputStream(scratchFile);
                 ZipOutputStream zipOut = new ZipOutputStream(fos);){
                for (File file : arquivos) {
                    String nomeArquivo = file.getName();
                    if (FilenameUtils.getExtension((String)nomeArquivo).equalsIgnoreCase("pdf")) {
                        nomeArquivo = "exportacao" + System.currentTimeMillis() + ".pdf";
                    } else if (nomeArquivo.contains("-temp")) {
                        nomeArquivo = nomeArquivo.substring(0, nomeArquivo.indexOf("-temp")) + ".zip";
                    }
                    FileUtil.comprimirArquivoEmDisco((ZipOutputStream)zipOut, (File)file, (String)nomeArquivo);
                    if (file.delete()) continue;
                    this.log.error("N\u00e3o foi poss\u00edvel excluir o arquivo tempor\u00e1rio de exporta\u00e7\u00e3o de XMLs. Arquivo: " + file.getName());
                }
            }
            return scratchFile;
        }
        catch (IOException e) {
            throw new UnicoMensagemUsuarioException("WWW714", e.getMessage());
        }
    }

    public void saveFile(File file) {
        StorageService storageService = (StorageService)BeanUtil.getBean((String)"storageService");
        String url = storageService.saveFile(this.getTask().getTenant(), TipoArquivoArmazenado.DOCUMENTO_FISCAL, file, this.isGzip(), null, true);
        this.getTask().setUrl(url);
    }

    public boolean isAtivo() {
        return true;
    }
}

