/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.administradoracartao;

import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.sql.usql.Coalesce;
import br.intelidata.commons.core.sql.usql.ColunaSQL;
import br.intelidata.commons.core.sql.usql.Referencia;
import br.intelidata.commons.domain.pojo.AbstractPojo;
import br.intelidata.commons.domain.pojo.enuns.TipoPOS;
import br.intelidata.commons.domain.pojo.pafecf.AdmCartaoIdentificador;
import br.intelidata.commons.domain.pojo.pafecf.AdministradoraCartao;
import br.intelidata.commons.domain.pojo.pafecf.AdministradoraCartaoTaxa;
import br.intelidata.commons.domain.regranegocio.AbstractRegraNegocio;
import br.intelidata.commons.modulo.pdv.regranegocio.AdmCartaoIdentificadorRN;
import br.intelidata.commons.modulo.pdv.regranegocio.AdministradoraCartaoRN;
import br.intelidata.commons.modulo.pdv.regranegocio.AdministradoraCartaoTaxaRN;
import br.intelidata.core.aop.DBAutoCommit;
import br.intelidata.core.aop.DBTransaction;
import br.intelidata.uniplusweb.core.coreinterfaces.SubMenuMapping;
import br.intelidata.uniplusweb.core.grid.GridBuilder;
import br.intelidata.uniplusweb.core.util.NumberUtil;
import br.intelidata.uniplusweb.web.rest.app.client.crud.CrudController;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/administradoras-cartao"})
@SubMenuMapping(MENU="SubMenuFinanceiroAuxiliar", NOME="Administradoras de cart\u00e3o e bandeiras", ROTA="/financeiros/administradoras-cartao", PROGRAMA=37)
public class AdministradoraCartaoCrudController
extends CrudController<AdministradoraCartao, AdministradoraCartaoRN> {
    public AdministradoraCartaoCrudController() {
        super((AbstractRegraNegocio)AdministradoraCartaoRN.getInstance(), AdministradoraCartao::new, false, false);
    }

    @RequestMapping(value={"/buscar-por-nome"})
    @DBAutoCommit
    public boolean buscarPorNome(@RequestParam(value="value") String nome, @RequestParam(value="cod", required=false) String cod) {
        return AdministradoraCartaoRN.getInstance().existeAdministradoraCartaoCadastrada(nome, cod);
    }

    @RequestMapping(value={"/combo"})
    @DBAutoCommit
    public List<AdministradoraCartao> getCombo(@RequestParam(required=false) String query) {
        return AdministradoraCartaoRN.getInstance().getComboWeb(query, false);
    }

    @RequestMapping(value={"/combo-carteiras"})
    @DBAutoCommit
    public List<AdministradoraCartao> getComboCarteiras(@RequestParam(required=false) String query) {
        return AdministradoraCartaoRN.getInstance().getComboWeb(query, true);
    }

    protected void beforeSave(AdministradoraCartao administradoraCartao, Optional<Long> parentId) throws UnicoMensagemUsuarioException {
        if (!NumberUtil.longNullOuZero((Long)administradoraCartao.getId())) {
            administradoraCartao.setTaxas(AdministradoraCartaoTaxaRN.getInstance().buscarListaPorAdministradora(administradoraCartao.getId()));
        }
    }

    @RequestMapping(value={"/buscar-por-tipo-pos"})
    @DBAutoCommit
    public List<AdministradoraCartao> buscarPorTipoPOS(@RequestParam TipoPOS tipo) {
        return tipo.equals((Object)TipoPOS.DEBITO) ? AdministradoraCartaoRN.getInstance().getComboDebitoWeb() : AdministradoraCartaoRN.getInstance().getComboCreditoWeb();
    }

    @RequestMapping(value={"/buscar-taxa-adm"})
    @DBAutoCommit
    public List<AdministradoraCartaoTaxa> getTaxasAdm(@RequestParam Long idAdm, @RequestParam(required=false, defaultValue="0") Long idFilial) {
        return AdministradoraCartaoTaxaRN.getInstance().buscarListaPorAdministradora(idAdm, idFilial);
    }

    @RequestMapping(value={"/gravar-taxa-adm"}, method={RequestMethod.POST})
    @DBTransaction
    public void gravarTaxasAdm(@RequestBody List<AdministradoraCartaoTaxa> taxas, @RequestParam(required=false, defaultValue="0") Long idAdm, Long idFilial) throws UnicoMensagemUsuarioException {
        AdministradoraCartaoTaxaRN.getInstance().gravarLista(idAdm, idFilial, taxas, SessaoUtil.getSessao());
    }

    @RequestMapping(value={"/buscar-identificadores"})
    @DBAutoCommit
    public List<AdmCartaoIdentificador> buscarListaIdentificador(@RequestParam Long idAdministradora) {
        return AdmCartaoIdentificadorRN.getInstance().buscarPorAdministradora(idAdministradora);
    }

    @RequestMapping(value={"/gravar-identificadores"}, method={RequestMethod.POST})
    @DBTransaction
    public void gravarListaIdentificador(@RequestBody List<AdmCartaoIdentificador> identificadores, @RequestParam Long idAdministradora) throws UnicoMensagemUsuarioException {
        AdmCartaoIdentificadorRN.getInstance().gravarLista(idAdministradora, identificadores, SessaoUtil.getSessao());
    }

    protected void beforeRead(AdministradoraCartao administradoraCartao, int modo, Optional<Long> parentId) throws UnicoMensagemUsuarioException {
        super.beforeRead((AbstractPojo)administradoraCartao, modo, parentId);
    }

    protected GridBuilder<AdministradoraCartaoRN> getGridBuilder() {
        ArrayList<ColunaSQL> colunas = new ArrayList<ColunaSQL>();
        colunas.add(new ColunaSQL("id", "ID", 0, false));
        colunas.add(new ColunaSQL("rede", "Rede", 0, false));
        colunas.add(new ColunaSQL("codigo", "C\u00f3digo", 0, false));
        colunas.add(new ColunaSQL("manual", "Manual", 0, false));
        colunas.add(new ColunaSQL("nome", "Nome", 0, true));
        colunas.add(new ColunaSQL("prazoVencimentoCredito", "prazoVencimentoCredito", 0, false));
        colunas.add(new ColunaSQL("prazoVencimentoDebito", "prazoVencimentoDebito", 0, false));
        colunas.add(new ColunaSQL("permiteTaxaZero", "permiteTaxaZero", 0, false));
        GridBuilder grid = new GridBuilder(AdministradoraCartaoRN.getInstance().getTabela(), colunas);
        grid.addReferenciaDefault(new Referencia(new Coalesce("inativo", "0"), "inativo"));
        return grid;
    }

    protected String getCacheId() {
        return "administradoras-cartao";
    }
}

