/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.alterasenha;

import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.util.BCrypt;
import br.intelidata.commons.domain.pojo.SimpleController;
import br.intelidata.commons.domain.pojo.Usuario;
import br.intelidata.commons.domain.pojo.UsuarioReseteSenha;
import br.intelidata.commons.domain.pojo.enuns.NivelPoliticaSeguranca;
import br.intelidata.commons.domain.regranegocio.ControleRN;
import br.intelidata.commons.domain.regranegocio.UsuarioCommonRN;
import br.intelidata.commons.modulo.cadastros.regranegocio.UsuarioRN;
import br.intelidata.core.aop.DBTransaction;
import br.intelidata.uniplusweb.core.coreinterfaces.SubMenuMapping;
import br.intelidata.uniplusweb.core.util.StringUtil;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/alterar-senha"})
@SubMenuMapping(MENU="SubMenuFerramentasGeral", ICONE="icon-dica-campo", NOME="Alterar sua senha", ROTA="/ferramentas/alterar-senha", PROGRAMA=507)
public class AlteraSenhaCrudController
extends SimpleController {
    @RequestMapping(value={"/gravar-senha"}, method={RequestMethod.POST})
    @DBTransaction
    public void gravarSenha(@RequestBody UsuarioReseteSenha alteracaoSenha) throws UnicoMensagemUsuarioException {
        Usuario usuarioCorrente = UsuarioRN.getInstance().buscarPorId(SessaoUtil.getSessao().getIdUsuario());
        if (!BCrypt.checkpw((String)alteracaoSenha.getToken(), (String)usuarioCorrente.getSenha())) {
            throw new UnicoMensagemUsuarioException("COM236369", "Senha atual incorreta. Verifique.");
        }
        if (BCrypt.checkpw((String)alteracaoSenha.getNovasenha(), (String)usuarioCorrente.getSenha())) {
            throw new UnicoMensagemUsuarioException("WWW465", "A nova senha deve ser diferente da atual. Verifique.");
        }
        this.validarDados(alteracaoSenha);
        UsuarioCommonRN.getInstance().atualizaSenha(SessaoUtil.getSessao(), usuarioCorrente, BCrypt.hashpw((String)alteracaoSenha.getNovasenha(), (String)BCrypt.gensalt()));
    }

    @RequestMapping(value={"/alterar-dados-usuario-ativacao"}, method={RequestMethod.POST})
    @DBTransaction
    public void alterarDadosUsuarioAtivacao(@RequestBody UsuarioReseteSenha usuarioReseteSenha) throws UnicoMensagemUsuarioException {
        Usuario usuario = UsuarioRN.getInstance().buscarPorId(usuarioReseteSenha.getIdUsuario());
        this.validarDados(usuarioReseteSenha);
        usuario.setCodigo(usuarioReseteSenha.getCodigo());
        usuario.setSenha(BCrypt.hashpw((String)usuarioReseteSenha.getNovasenha(), (String)BCrypt.gensalt()));
        usuario.setEmail(usuarioReseteSenha.getEmail());
        UsuarioRN.getInstance().alterar(usuario, SessaoUtil.getSessao());
    }

    private void validarDados(UsuarioReseteSenha usuarioReseteSenha) throws UnicoMensagemUsuarioException {
        NivelPoliticaSeguranca nivelPoliticaSeguranca = ControleRN.getInstance().getNivelPoliticaSeguranca();
        if (StringUtil.stringNullOrEmpty((String)usuarioReseteSenha.getToken()) || StringUtil.stringNullOrEmpty((String)usuarioReseteSenha.getNovasenha())) {
            throw new UnicoMensagemUsuarioException("WWW305", "O campo de senha n\u00e3o pode ser vazio. Verifique.");
        }
        if (!usuarioReseteSenha.getNovasenha().equalsIgnoreCase(usuarioReseteSenha.getConfirmasenha())) {
            throw new UnicoMensagemUsuarioException("COM236609", "A nova senha n\u00e3o confere com a confirma\u00e7\u00e3o. Verifique.");
        }
        if (!(nivelPoliticaSeguranca == null || nivelPoliticaSeguranca == NivelPoliticaSeguranca.BAIXA || NivelPoliticaSeguranca.validar((String)usuarioReseteSenha.getNovasenha(), (String)nivelPoliticaSeguranca.getRegex()) && NivelPoliticaSeguranca.validar((String)usuarioReseteSenha.getConfirmasenha(), (String)nivelPoliticaSeguranca.getRegex()))) {
            throw new UnicoMensagemUsuarioException("COM236608", "O valor informado n\u00e3o atende a pol\u00edtica de seguran\u00e7a configurada. Por favor verifique os crit\u00e9rios exigidos.");
        }
    }
}

