/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.backup;

import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.sistema.PropriedadeRN;
import br.intelidata.commons.core.util.BeanUtil;
import br.intelidata.commons.domain.pojo.AbstractPojo;
import br.intelidata.commons.domain.pojo.BackupAgendado;
import br.intelidata.commons.domain.pojo.Controle;
import br.intelidata.commons.domain.pojo.enuns.TarefaAgendamento;
import br.intelidata.commons.domain.regranegocio.ControleRN;
import br.intelidata.commons.modulo.ferramentas.agendamento.regranegocio.BackupAgendadoRN;
import br.intelidata.core.aop.DBAutoCommit;
import br.intelidata.core.aop.DBTransaction;
import br.intelidata.uniplusweb.config.UnipluswebProperties;
import br.intelidata.uniplusweb.core.coreinterfaces.SubMenuMapping;
import br.intelidata.uniplusweb.core.service.BackupService;
import br.intelidata.uniplusweb.core.util.FileUtil;
import br.intelidata.uniplusweb.core.util.SystemUtil;
import br.intelidata.uniplusweb.web.rest.app.client.crud.SimpleCrudController;
import br.intelidata.uniplusweb.web.rest.app.crud.backup.BackupAgendadoWeb;
import br.intelidata.uniplusweb.web.rest.app.wrapper.PreferenciasBackupWrapper;
import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/agendamento-backup"})
@SubMenuMapping(MENU="SubMenuFerramentasGeral", NOME="Configura\u00e7\u00e3o de c\u00f3pia de seguran\u00e7a", ROTA="/ferramentas/agendamento-backup", PROGRAMA=503, ICONE="icon-backup")
public class AgendamentoBackupSimpleController
extends SimpleCrudController<BackupAgendadoWeb, BackupAgendadoRN> {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final UnipluswebProperties unipluswebProperties;
    private final BackupService backupService;

    public AgendamentoBackupSimpleController(UnipluswebProperties unipluswebProperties, BackupService backupService) {
        this.unipluswebProperties = unipluswebProperties;
        this.backupService = backupService;
    }

    @DBAutoCommit
    public BackupAgendadoWeb get(@RequestParam(required=false) Long parentId) {
        BackupAgendado backup = BackupAgendadoRN.getInstance().buscaBackupAgendado();
        if (backup == null) {
            backup = new BackupAgendado();
        }
        BackupAgendadoWeb backupAgendadoWeb = new BackupAgendadoWeb();
        BeanUtil.copiarValores((Object)backup, (Object)backupAgendadoWeb, (boolean)true, null);
        backupAgendadoWeb.setDiretorio(FileUtil.DIRETORIO_BACKUP);
        backupAgendadoWeb.setPreferencias(this.backupService.carregarPreferencias(SessaoUtil.getSessao()));
        return backupAgendadoWeb;
    }

    @RequestMapping(method={RequestMethod.POST})
    @DBTransaction
    public Long create(@RequestBody BackupAgendadoWeb backupAgendadoWeb) throws UnicoMensagemUsuarioException {
        if (this.unipluswebProperties.getAmbiente().isLocal()) {
            this.validarDiretorio();
        }
        this.gravarPreferencias(backupAgendadoWeb.getPreferencias());
        return this.gravarBackup(backupAgendadoWeb);
    }

    @RequestMapping(method={RequestMethod.PUT})
    @DBTransaction
    public Long update(@RequestBody BackupAgendadoWeb backupAgendadoWeb) throws UnicoMensagemUsuarioException {
        if (this.unipluswebProperties.getAmbiente().isLocal()) {
            this.validarDiretorio();
        }
        this.gravarPreferencias(backupAgendadoWeb.getPreferencias());
        return this.gravarBackup(backupAgendadoWeb);
    }

    @RequestMapping(method={RequestMethod.DELETE})
    @DBTransaction
    public void excluirAgendamento() throws UnicoMensagemUsuarioException {
        BackupAgendado backupAgendado = BackupAgendadoRN.getInstance().buscaBackupAgendado();
        if (backupAgendado != null) {
            BackupAgendadoRN.getInstance().excluir((AbstractPojo)backupAgendado, SessaoUtil.getSessao());
        }
    }

    private Long gravarBackup(BackupAgendadoWeb backupAgendadoWeb) throws UnicoMensagemUsuarioException {
        BackupAgendadoRN.getInstance().agendar(SessaoUtil.getSessao(), TarefaAgendamento.BACKUP.getId(), backupAgendadoWeb.getDias(), backupAgendadoWeb.getHoras());
        return BackupAgendadoRN.getInstance().buscaBackupAgendado().getId();
    }

    private void validarDiretorio() throws UnicoMensagemUsuarioException {
        File file = new File(FileUtil.DIRETORIO_BACKUP);
        if (!file.exists() || !file.isDirectory()) {
            throw new UnicoMensagemUsuarioException("WWW376", "Diret\u00f3rio para a c\u00f3pia de seguran\u00e7a do sistema \u00e9 inv\u00e1lido! Verifique.");
        }
        BigDecimal espacoLivre = SystemUtil.getEspacoLivre((String)FileUtil.DIRETORIO_BACKUP);
        if (espacoLivre.compareTo(BigDecimal.TEN) < 0) {
            throw new UnicoMensagemUsuarioException("WWW377", "Espa\u00e7o insuficiente em disco! Verifique.");
        }
        this.verificarSePodeGravarNaPasta();
    }

    private void verificarSePodeGravarNaPasta() throws UnicoMensagemUsuarioException {
        try {
            File file = new File(FileUtil.DIRETORIO_BACKUP + File.separator + "teste.txt");
            if (!file.createNewFile()) {
                throw new UnicoMensagemUsuarioException("WWW378", "O acesso ao diret\u00f3rio foi negado. Por favor verifique");
            }
            if (!file.delete()) {
                this.log.error("N\u00e3o foi poss\u00edvel excluir o arquivo de teste para o diret\u00f3rio de backup.");
            }
        }
        catch (IOException ex) {
            throw new UnicoMensagemUsuarioException("WWW379", "O acesso ao diret\u00f3rio foi negado. Por favor verifique");
        }
    }

    private void gravarPreferencias(PreferenciasBackupWrapper preferenciasBackupWrapper) throws UnicoMensagemUsuarioException {
        Controle controle = ControleRN.getInstance().buscar();
        controle.setDiasBackup(preferenciasBackupWrapper.getDiasBackup());
        controle.setDataHora(preferenciasBackupWrapper.isDataHora());
        controle.setRazaoSocial(preferenciasBackupWrapper.isRazaoSocial());
        controle.setExclusaoAuditoria(preferenciasBackupWrapper.isExclusaoAuditoria());
        controle.setConsiderarTamanhoMenorErro(preferenciasBackupWrapper.isConsiderarTamanhoMenorErro());
        ControleRN.getInstance().alterar((AbstractPojo)controle, SessaoUtil.getSessao());
        PropriedadeRN.getInstance().setPropriedade(SessaoUtil.getSessao(), 742, Boolean.valueOf(this.getIgnoraUltimoTamanhoBackup1(preferenciasBackupWrapper)), true);
    }

    private boolean getIgnoraUltimoTamanhoBackup1(PreferenciasBackupWrapper preferenciasBackupWrapper) {
        boolean chkConsiderarTamanhoMenorErroBkp1Aux = PropriedadeRN.getInstance().getPropriedadeBoolean(SessaoUtil.getSessao().getFilial(), 692);
        boolean chkExcluirAuditoriaBkp1Aux = PropriedadeRN.getInstance().getPropriedadeBoolean(SessaoUtil.getSessao().getFilial(), 675);
        if (chkConsiderarTamanhoMenorErroBkp1Aux && chkExcluirAuditoriaBkp1Aux) {
            return false;
        }
        return preferenciasBackupWrapper.isConsiderarTamanhoMenorErro() && preferenciasBackupWrapper.isExclusaoAuditoria();
    }
}

