/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.blocox.estoque;

import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.sistema.Sessao;
import br.intelidata.commons.core.util.DataHoraFactory;
import br.intelidata.commons.domain.pojo.Filial;
import br.intelidata.commons.domain.pojo.pafecf.EnvioBlocoX;
import br.intelidata.commons.modulo.pdv.blocox.CredenciamentoBlocoX;
import br.intelidata.commons.modulo.pdv.regranegocio.EnvioBlocoXRN;
import br.intelidata.core.aop.DBAutoCommit;
import br.intelidata.uniplusweb.core.coreinterfaces.SubMenuMapping;
import br.intelidata.uniplusweb.web.rest.app.crud.blocox.BlocoXController;
import java.time.LocalDate;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import unipaf.geracaoarquivo.blocox.GravacaoArquivoBlocoX;

@RestController
@RequestMapping(value={"/api/blocox-estoque"})
@SubMenuMapping(MENU="SubMenuPdvAuxiliar", NOME="Bloco X - Estoque", ROTA="/pdvs/blocox-estoque", PROGRAMA=1446)
public class BlocoXEstoqueController
extends BlocoXController {
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    @RequestMapping(value={"/envios"})
    @DBAutoCommit
    public List<EnvioBlocoX> buscarEnvios() {
        Sessao sessao = SessaoUtil.getSessao();
        LocalDate dataInicial = CredenciamentoBlocoX.getDataObrigacaoEstoque((Filial)sessao.getFilial());
        try {
            this.limparEnvios(sessao);
        }
        catch (Throwable ex) {
            this.log.error("Erro ao limpar envios do Bloco X do Estoque", ex);
        }
        return EnvioBlocoXRN.getInstance().consultarEstoque(sessao, dataInicial, DataHoraFactory.getData(), false);
    }

    protected void limparEnvios(Sessao sessao) throws UnicoMensagemUsuarioException {
        super.limparEnvios(sessao);
        EnvioBlocoXRN.getInstance().excluirEnviosEstoqueDesobrigados(sessao, (GravacaoArquivoBlocoX)this.gravacaoArquivoBlocoXService);
    }
}

