/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.centrocusto;

import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.sql.usql.ColunaSQL;
import br.intelidata.commons.core.sql.usql.Condicao;
import br.intelidata.commons.core.sql.usql.Operador;
import br.intelidata.commons.core.sql.usql.Ordem;
import br.intelidata.commons.core.sql.usql.Referencia;
import br.intelidata.commons.core.util.BeanUtil;
import br.intelidata.commons.core.util.Util;
import br.intelidata.commons.domain.pojo.AbstractPojo;
import br.intelidata.commons.domain.pojo.enuns.TipoCentroCusto;
import br.intelidata.commons.domain.pojo.financeiro.CentroCusto;
import br.intelidata.commons.domain.pojo.financeiro.CodigoReduzidoCentroCustoGrupo;
import br.intelidata.commons.domain.pojo.financeiro.ConfiguracaoCentroCusto;
import br.intelidata.commons.domain.regranegocio.AbstractRegraNegocio;
import br.intelidata.commons.modulo.financeiro.centrocusto.regranegocio.CentroCustoRN;
import br.intelidata.commons.modulo.financeiro.centrocusto.regranegocio.CodigoReduzidoCentroCustoGrupoRN;
import br.intelidata.commons.modulo.financeiro.centrocusto.regranegocio.ConfiguracaoCentroCustoRN;
import br.intelidata.core.aop.DBAutoCommit;
import br.intelidata.uniplusweb.core.coreinterfaces.SubMenuMapping;
import br.intelidata.uniplusweb.core.grid.GridBuilder;
import br.intelidata.uniplusweb.core.util.NumberUtil;
import br.intelidata.uniplusweb.web.rest.app.client.crud.CrudController;
import br.intelidata.uniplusweb.web.rest.app.crud.centrocusto.ConfiguracaoCampoCodigoReduzidoWrapper;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/centros-custo"})
@SubMenuMapping(MENU="SubMenuFinanceiroAuxiliar", NOME="Centros de custo", ROTA="/financeiros/centros-custo", PROGRAMA=1339)
public class CentroCustoCrudController
extends CrudController<CentroCusto, CentroCustoRN> {
    public CentroCustoCrudController() {
        super((AbstractRegraNegocio)CentroCustoRN.getInstance(), CentroCusto::new, true, false);
    }

    @RequestMapping(value={"/combo"})
    @DBAutoCommit
    public List<CentroCusto> getComboWeb() {
        return CentroCustoRN.getInstance().getComboWeb();
    }

    @RequestMapping(value={"/validar-sintetico"})
    @DBAutoCommit
    public boolean validarSintetico(@RequestParam Long id) throws UnicoMensagemUsuarioException {
        CentroCusto centroCusto = (CentroCusto)CentroCustoRN.getInstance().buscarPorId(id);
        if (centroCusto != null && centroCusto.getTipoCentroCusto().equals((Object)TipoCentroCusto.SINTETICO)) {
            throw new UnicoMensagemUsuarioException("WFIN175", "N\u00e3o \u00e9 poss\u00edvel selecionar um centro de custo do tipo sint\u00e9tico.");
        }
        return true;
    }

    protected GridBuilder<CentroCustoRN> getGridBuilder() {
        ArrayList<ColunaSQL> colunas = new ArrayList<ColunaSQL>();
        colunas.add(new ColunaSQL("id", "ID", 0, false));
        colunas.add(new ColunaSQL("idCentroCustoPai", "Centro Pai", 0, false));
        colunas.add(new ColunaSQL("nivelCentro", "N\u00edvel", 0, false));
        colunas.add(new ColunaSQL("idEmpresa", "Empresa", 0, false));
        colunas.add(new ColunaSQL("codigoExtenso", "Extenso", 0, true));
        colunas.add(new ColunaSQL("codigoReduzido", "Reduzido", 0, true));
        colunas.add(new ColunaSQL("descricao", "Descri\u00e7\u00e3o", 0, true));
        GridBuilder grid = new GridBuilder(CentroCustoRN.getInstance().getTabela(), colunas);
        grid.setOrdemDefault(new Ordem("codigoExtenso"));
        grid.addReferenciaDefault(new Referencia("idEmpresa"));
        grid.addCodicaoDefault(new Condicao("idEmpresa", Operador.IGUAL, SessaoUtil.getSessao().getFilial().getIdEmpresa()));
        return grid;
    }

    @RequestMapping(value={"/validar-codigo"})
    @DBAutoCommit
    public String validarCodigo(@RequestParam String valor, @RequestParam Long idCentroCustoPai, @RequestParam Long idCentroCusto, @RequestParam int nivelAtual) throws UnicoMensagemUsuarioException {
        if (valor == null || valor.isEmpty()) {
            return "Informe o c\u00f3digo extenso";
        }
        CentroCusto centroCusto = CentroCustoRN.getInstance().buscaCentroCusto(Util.limpaMascara((String)valor, (String)"."), SessaoUtil.getSessao().getFilial().getIdEmpresa());
        if (centroCusto != null && !centroCusto.getId().equals(idCentroCusto)) {
            return "O centro de custo j\u00e1 existe!";
        }
        ConfiguracaoCentroCusto configuracao = ConfiguracaoCentroCustoRN.getInstance().getConfiguracaoValida(SessaoUtil.getSessao().getFilial(), nivelAtual);
        String valorComMascara = Util.formatarString((String)valor, (String)CentroCustoRN.getInstance().getMascara(nivelAtual, configuracao));
        String[] valorPorNiveis = valorComMascara.split("[.]");
        for (int i = 0; i < valorPorNiveis.length; ++i) {
            String valorNivel = valorPorNiveis[i];
            int quantidadeConfiguracao = CentroCustoRN.getInstance().getQuantidadePorNivel(i + 1, configuracao);
            if (valorNivel.trim().length() == quantidadeConfiguracao) continue;
            return "C\u00f3digo inv\u00e1lido no n\u00edvel " + (i + 1);
        }
        if (!NumberUtil.longNullOuZero((Long)idCentroCustoPai)) {
            CentroCusto centroCustoPai = (CentroCusto)CentroCustoRN.getInstance().buscarPorId(idCentroCustoPai);
            for (int i = 0; i < centroCustoPai.getNivelCentro(); ++i) {
                if (valorPorNiveis[i].equals(BeanUtil.get((Object)centroCustoPai, (String)("numeroNivel" + (i + 1)), (Object[])new Object[0]))) continue;
                return "Centro de custo inv\u00e1lido!";
            }
        }
        return null;
    }

    @RequestMapping(value={"/buscar-mascara"})
    @DBAutoCommit
    public ConfiguracaoCampoCodigoReduzidoWrapper carregarConfCampo(@RequestParam Long idCentroCustoPai, @RequestParam int nivelAtual, @RequestParam boolean create) throws UnicoMensagemUsuarioException {
        ConfiguracaoCentroCusto configuracao = ConfiguracaoCentroCustoRN.getInstance().getConfiguracaoValida(SessaoUtil.getSessao().getFilial(), nivelAtual);
        ConfiguracaoCampoCodigoReduzidoWrapper conf = new ConfiguracaoCampoCodigoReduzidoWrapper();
        CentroCusto centroCustoPai = (CentroCusto)CentroCustoRN.getInstance().buscarPorId(idCentroCustoPai);
        conf.setMascara(CentroCustoRN.getInstance().getMascara(nivelAtual, configuracao));
        if (create) {
            String cod = CentroCustoRN.getInstance().buscaCodigoExtenso(configuracao, centroCustoPai, nivelAtual, SessaoUtil.getSessao().getFilial().getIdEmpresa());
            conf.setValor(Util.formatarString((String)cod, (String)conf.getMascara()));
        }
        return conf;
    }

    @RequestMapping(value={"/validar-codigo-reduzido"})
    @DBAutoCommit
    public String validarCodigoReduzido(@RequestParam String valor) {
        if (Util.stringNullOrEmpty((String)valor)) {
            return "Informe o c\u00f3digo reduzido!";
        }
        CentroCusto centroCusto = CentroCustoRN.getInstance().buscaCentroCustoPorCodigoReduzido(valor, SessaoUtil.getSessao().getFilial().getIdEmpresa());
        if (centroCusto != null) {
            return "Centro de custo j\u00e1 cadastrado para este c\u00f3digo reduzido!";
        }
        return null;
    }

    @RequestMapping(value={"/dados-tree"})
    @DBAutoCommit
    public List buscarDadosTree(@RequestParam(required=false) boolean apenasAtivos, @RequestParam(required=false) Object tipoMovimento) {
        return ((CentroCustoRN)this.rn).buscarLista();
    }

    @RequestMapping(value={"/nome/{id}"})
    @DBAutoCommit
    public CentroCusto getNome(@PathVariable Long id) {
        return (CentroCusto)((CentroCustoRN)this.rn).buscarPorId(id);
    }

    @RequestMapping(value={"/validar-grupo-codigo-reduzido"})
    @DBAutoCommit
    public String validarGrupoCodReduzido(@RequestParam String valor) throws UnicoMensagemUsuarioException {
        if (Util.stringNullOrEmpty((String)valor)) {
            return "Informe o grupo!";
        }
        int codigoGrupo = Integer.parseInt(valor);
        if (codigoGrupo < 0 || codigoGrupo > CodigoReduzidoCentroCustoGrupoRN.getInstance().getTamanhoMaximo()) {
            return "Grupo inv\u00e1lido";
        }
        CodigoReduzidoCentroCustoGrupo grupo = CodigoReduzidoCentroCustoGrupoRN.getInstance().buscaGrupoCodigoReduzido(SessaoUtil.getSessao().getFilial().getIdEmpresa(), Integer.valueOf(codigoGrupo));
        if (grupo == null) {
            return "Grupo n\u00e3o cadastrado!";
        }
        if (grupo.getContadorAtual() == null || grupo.getContadorAtual() == 0) {
            return "Contador atual n\u00e3o informado para o grupo!";
        }
        return null;
    }

    @RequestMapping(value={"/buscar-codigo-reduzido"})
    @DBAutoCommit
    public Integer buscarCodigoReduzido(@RequestParam int codGrupo) throws UnicoMensagemUsuarioException {
        CodigoReduzidoCentroCustoGrupo grupo = CodigoReduzidoCentroCustoGrupoRN.getInstance().buscaGrupoCodigoReduzido(SessaoUtil.getSessao().getFilial().getIdEmpresa(), Integer.valueOf(codGrupo));
        return grupo != null ? grupo.getContadorAtual() : null;
    }

    @RequestMapping(value={"/validar-inclusao"})
    @DBAutoCommit
    public void validarInclusao(@RequestParam int nivelAtual) throws UnicoMensagemUsuarioException {
        ConfiguracaoCentroCustoRN.getInstance().getConfiguracaoValida(SessaoUtil.getSessao().getFilial(), nivelAtual);
    }

    protected void beforeSave(CentroCusto centroCusto, Optional<Long> parentId) throws UnicoMensagemUsuarioException {
        centroCusto.setCodigoExtensoFormatado(centroCusto.getCodigoExtenso());
        centroCusto.setCodigoExtenso(Util.limpaMascara((String)centroCusto.getCodigoExtenso(), (String)"./-"));
    }

    protected void beforeRead(CentroCusto centroCusto, int modo, Optional<Long> parentId) throws UnicoMensagemUsuarioException {
        ConfiguracaoCentroCusto configuracao = ConfiguracaoCentroCustoRN.getInstance().getConfiguracaoValida(SessaoUtil.getSessao().getFilial(), centroCusto.getNivelCentro().intValue());
        String mascara = CentroCustoRN.getInstance().getMascara(centroCusto.getNivelCentro().intValue(), configuracao);
        centroCusto.setCodigoExtenso(Util.limpaMascara((String)centroCusto.getCodigoExtenso(), (String)"./-"));
        centroCusto.setCodigoExtensoFormatado(Util.formatarString((String)centroCusto.getCodigoExtenso(), (String)mascara));
    }

    protected void afterCreate(CentroCusto centroCusto, Optional<Long> parentId) throws UnicoMensagemUsuarioException {
        CodigoReduzidoCentroCustoGrupo grupo = CodigoReduzidoCentroCustoGrupoRN.getInstance().buscaGrupoCodigoReduzido(SessaoUtil.getSessao().getFilial().getIdEmpresa(), centroCusto.getGrupoCodigoReduzido());
        if (grupo != null) {
            grupo.setContadorAtual(Integer.valueOf(NumberUtil.string2int((String)centroCusto.getCodigoReduzido()) + 1));
            CodigoReduzidoCentroCustoGrupoRN.getInstance().alterar((AbstractPojo)grupo, SessaoUtil.getSessao());
        }
    }

    protected String getCacheId() {
        return "centros-custo".concat("_").concat(SessaoUtil.getSessao().getFilial().getIdEmpresa().toString());
    }
}

