/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.conhecimentotransporte.conhecimentotransportesaida;

import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.util.Util;
import br.intelidata.commons.domain.pojo.conhecimento.ConhecimentoTransporte;
import br.intelidata.commons.domain.pojo.enuns.AbstractEnum;
import br.intelidata.commons.domain.pojo.enuns.conhecimento.StatusConhecimento;
import br.intelidata.commons.domain.regranegocio.AbstractRegraNegocio;
import br.intelidata.commons.modulo.cte.CteManagerWeb;
import br.intelidata.commons.modulo.cte.enums.TipoRetornoAtualizarStatusCTE;
import br.intelidata.commons.modulo.cte.regranegocio.ConhecimentoTransporteRN;
import br.intelidata.core.aop.DBAutoCommit;
import br.intelidata.core.aop.DBTransaction;
import br.intelidata.uniplusweb.core.util.FileUtil;
import br.intelidata.uniplusweb.web.rest.app.client.crud.CrudController;
import br.intelidata.uniplusweb.web.rest.app.crud.conhecimentotransporte.ConhecimentoTransporteSaidaComponent;
import br.intelidata.uniplusweb.web.rest.app.crud.conhecimentotransporte.conhecimentotransportesaida.inutilizacao.InutilizacaoCteWrapper;
import br.intelidata.uniplusweb.web.rest.app.crud.conhecimentotransporte.conhecimentotransportesaida.wrapper.ConhecimentoTransporteAtualizacaoStatusWrapper;
import java.io.File;
import java.util.HashMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.multipart.MultipartFile;

public abstract class TransmissaoConhecimentoTransporteController
extends CrudController<ConhecimentoTransporte, ConhecimentoTransporteRN> {
    @Autowired
    private ConhecimentoTransporteSaidaComponent conhecimentoTransporteSaidaComponent;

    public TransmissaoConhecimentoTransporteController() {
        super((AbstractRegraNegocio)ConhecimentoTransporteRN.getInstance(), ConhecimentoTransporte::new, true, true);
    }

    @RequestMapping(value={"/cancelar"})
    @DBTransaction
    public void cancelar(@RequestParam Long idCte, @RequestParam String justificativa) {
        try {
            CteManagerWeb mdfeManagerWeb = this.conhecimentoTransporteSaidaComponent.getCteManagerWeb();
            mdfeManagerWeb.cancelar(idCte, justificativa);
        }
        catch (UnicoMensagemUsuarioException ex) {
            String erro = ex.getMensagemSemCodigo();
            if (ex.getCause() != null) {
                erro = erro + Util.newLine() + ex.getCause().getMessage();
            }
            this.notificationService.notifyCteNow(erro);
        }
    }

    @RequestMapping(value={"/download-xml"}, method={RequestMethod.POST})
    @DBAutoCommit
    public ResponseEntity<byte[]> downloadXML(@RequestBody Long idCte) throws UnicoMensagemUsuarioException {
        ConhecimentoTransporte conhecimento = (ConhecimentoTransporte)ConhecimentoTransporteRN.getInstance().buscarPorId(idCte);
        if (conhecimento != null) {
            HashMap<String, byte[]> mapArquivos = new HashMap<String, byte[]>();
            String chaveAutorizada = "";
            if (!conhecimento.getStatus().in(new AbstractEnum[]{StatusConhecimento.CTE_AUTORIZADA, StatusConhecimento.CANCELADA})) {
                throw new UnicoMensagemUsuarioException("CTE168", "N\u00e3o \u00e9 poss\u00edvel fazer download de XML do CT-e " + conhecimento.getNumeroConhecimento() + " com status " + conhecimento.getStatus());
            }
            if (conhecimento.getArquivoXmlAutorizada() != null) {
                chaveAutorizada = conhecimento.getChaveAcesso().concat("-cte");
                mapArquivos.put(chaveAutorizada, conhecimento.getArquivoXmlAutorizada());
            }
            if (conhecimento.getArquivoXmlCancelada() != null) {
                mapArquivos.put(conhecimento.getChaveAcesso().concat("-can"), conhecimento.getArquivoXmlCancelada());
            }
            if (mapArquivos.size() == 1) {
                return this.responseEntityService.createXMLResponse((byte[])mapArquivos.get(chaveAutorizada), chaveAutorizada);
            }
            File file = FileUtil.montaZipFilePorByte(mapArquivos, (String)"Xmls da CT-e ".concat(conhecimento.getChaveAcesso()).concat(".zip"));
            return this.responseEntityService.createZIPResponse(FileUtil.file2ByteArray((File)file), "Xmls do CT-e ".concat(conhecimento.getChaveAcesso()));
        }
        throw new UnicoMensagemUsuarioException("CTE169", "CT-e n\u00e3o encontrado.");
    }

    @RequestMapping(value={"/atualizar-status"}, method={RequestMethod.POST})
    @DBTransaction
    public TipoRetornoAtualizarStatusCTE atualizarStatus(@RequestPart(value="wrapper") ConhecimentoTransporteAtualizacaoStatusWrapper wrapper, @RequestPart(value="file", required=false) MultipartFile file) throws UnicoMensagemUsuarioException {
        try {
            CteManagerWeb cteManagerWeb = this.conhecimentoTransporteSaidaComponent.getCteManagerWeb();
            this.conhecimentoTransporteSaidaComponent.verificarValidadeCertificado(cteManagerWeb);
            return cteManagerWeb.atualizarStatus(wrapper.getIdCte(), wrapper.getChaveAcesso(), file != null ? file.getBytes() : null, wrapper.getJustificativaCancelamento());
        }
        catch (UnicoMensagemUsuarioException ex) {
            throw ex;
        }
        catch (Throwable ex) {
            throw new UnicoMensagemUsuarioException("CTE180", "N\u00e3o foi poss\u00edvel atualizar o status do CT-e.", ex);
        }
    }

    @RequestMapping(value={"/inutilizar"}, method={RequestMethod.POST})
    @DBTransaction
    public void inutilizarNumeracao(@RequestBody InutilizacaoCteWrapper wrapper) throws UnicoMensagemUsuarioException {
        CteManagerWeb cteManager = this.conhecimentoTransporteSaidaComponent.getCteManagerWeb();
        cteManager.inutilizarNumeracao(wrapper.getAno(), wrapper.getIdSerie(), wrapper.getNumeracaoInicial(), wrapper.getNumeracaoFinal(), wrapper.getJustificativa());
    }

    @RequestMapping(value={"/transmitir-cce"}, method={RequestMethod.POST})
    @DBTransaction
    public void enviarCartaCorrecao(@RequestBody Long idCartaCorrecao) throws UnicoMensagemUsuarioException {
        CteManagerWeb cteManagerWeb = this.conhecimentoTransporteSaidaComponent.getCteManagerWeb();
        cteManagerWeb.enviarCartaCorrecao(idCartaCorrecao);
    }
}

