/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.conhecimentotransporte.conhecimentotransportesaida.serie;

import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.sql.usql.ColunaSQL;
import br.intelidata.commons.core.sql.usql.Condicao;
import br.intelidata.commons.core.sql.usql.Operador;
import br.intelidata.commons.core.util.Util;
import br.intelidata.commons.domain.pojo.AbstractPojo;
import br.intelidata.commons.domain.pojo.conhecimento.SerieConhecimentoTransporte;
import br.intelidata.commons.domain.regranegocio.AbstractRegraNegocio;
import br.intelidata.commons.modulo.cte.regranegocio.SerieConhecimentoTransporteRN;
import br.intelidata.core.aop.DBAutoCommit;
import br.intelidata.uniplusweb.core.coreinterfaces.SubMenuMapping;
import br.intelidata.uniplusweb.core.grid.GridBuilder;
import br.intelidata.uniplusweb.web.rest.app.client.crud.CrudController;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/serie-conhecimento-transporte"})
@SubMenuMapping(MENU="SubMenuFiscalAuxiliarParametrosNotaFiscal", NOME="S\u00e9ries de CT-e", ROTA="/conhecimento-transporte-saida/serie-conhecimento-transporte", PROGRAMA=86)
public class SerieConhecimentoTransporteCrudController
extends CrudController<SerieConhecimentoTransporte, SerieConhecimentoTransporteRN> {
    public SerieConhecimentoTransporteCrudController() {
        super((AbstractRegraNegocio)SerieConhecimentoTransporteRN.getInstance(), SerieConhecimentoTransporte::new, true, true);
    }

    protected GridBuilder<SerieConhecimentoTransporteRN> getGridBuilder() {
        ArrayList<ColunaSQL> colunas = new ArrayList<ColunaSQL>();
        colunas.add(new ColunaSQL("id", "ID", 0, false));
        colunas.add(new ColunaSQL("idfilial", "idfilial", 0, false));
        colunas.add(new ColunaSQL("modelo", "Modelo", 100, true));
        colunas.add(new ColunaSQL("serie", "S\u00e9rie", 0, true));
        colunas.add(new ColunaSQL("proximonumeroconhecimento", "Pr\u00f3ximo n\u00famero de conhecimento", 0, true));
        GridBuilder grid = new GridBuilder(SerieConhecimentoTransporteRN.getInstance().getTabela(), colunas);
        grid.addCodicaoDefault(new Condicao("idfilial", Operador.IGUAL, SessaoUtil.getSessao().getIdFilial()));
        return grid;
    }

    @RequestMapping(value={"/combo"})
    @DBAutoCommit
    public List<SerieConhecimentoTransporte> getCombo() {
        return SerieConhecimentoTransporteRN.getInstance().getComboWeb(SessaoUtil.getSessao());
    }

    @RequestMapping(value={"/proximo-numero-cte"})
    @DBAutoCommit
    public String getProximoNumeroCTE(@RequestParam Long idModelo) {
        SerieConhecimentoTransporte serie = (SerieConhecimentoTransporte)SerieConhecimentoTransporteRN.getInstance().buscarPorId(idModelo);
        return serie != null ? serie.getProximoNumeroConhecimento().toString() : "";
    }

    protected String getCacheId() {
        return "serie-conhecimento-transporte";
    }

    protected void beforeRead(SerieConhecimentoTransporte serieConhecimentoTransporte, int modo, Optional<Long> parentId) throws UnicoMensagemUsuarioException {
        super.beforeRead((AbstractPojo)serieConhecimentoTransporte, modo, parentId);
        serieConhecimentoTransporte.setSerieView(Integer.valueOf(Util.string2int((String)serieConhecimentoTransporte.getSerie())));
    }

    protected void beforeSave(SerieConhecimentoTransporte serieConhecimentoTransporte, Optional<Long> parentId) throws UnicoMensagemUsuarioException {
        super.beforeSave((AbstractPojo)serieConhecimentoTransporte, parentId);
        serieConhecimentoTransporte.setSerie(serieConhecimentoTransporte.getSerieView().toString());
    }
}

