/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.contrato.notafiscalcontrato;

import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.sql.usql.ColunaSQL;
import br.intelidata.commons.core.sql.usql.Ordem;
import br.intelidata.commons.core.sql.usql.Referencia;
import br.intelidata.commons.domain.pojo.vendas.ContratoVendaNotaFiscal;
import br.intelidata.commons.domain.regranegocio.AbstractRegraNegocio;
import br.intelidata.commons.modulo.contrato.regranegocio.ContratoVendaNotaFiscalRN;
import br.intelidata.uniplusweb.core.coreinterfaces.SubMenuMapping;
import br.intelidata.uniplusweb.core.grid.GridBuilder;
import br.intelidata.uniplusweb.web.rest.app.client.crud.CrudController;
import java.util.ArrayList;
import java.util.Optional;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/notas-fiscais-contratos"})
@SubMenuMapping(MENU="SubMenuFiscalGeral", NOME="Notas fiscais de contratos", ICONE="icon-em-pedido", ROTA="/vendas/notas-fiscais-contratos", PROGRAMA=1359)
public class ContratoNotaFiscalCrudController
extends CrudController<ContratoVendaNotaFiscal, ContratoVendaNotaFiscalRN> {
    public ContratoNotaFiscalCrudController() {
        super((AbstractRegraNegocio)ContratoVendaNotaFiscalRN.getInstance(), ContratoVendaNotaFiscal::new);
        this.setColunaTotalizador("idNotaFiscal");
    }

    protected String getCacheId() {
        return "notas-fiscais-contratos";
    }

    protected GridBuilder<ContratoVendaNotaFiscalRN> getGridBuilder() {
        ArrayList<ColunaSQL> colunas = new ArrayList<ColunaSQL>();
        colunas.add(new ColunaSQL("id", "idNotaFiscal", "Nota fiscal", 10, false, new String[]{"fk_contratovendanotafiscal_nf"}));
        colunas.add(new ColunaSQL("idserie", "idSerie", "Id Serie", 1, false, new String[]{"fk_contratovendanotafiscal_nf"}));
        colunas.add(new ColunaSQL("numeronotafiscal", "numeroNotaFiscal", "N\u00famero da Nota", 0, true, new String[]{"fk_contratovendanotafiscal_nf"}));
        colunas.add(new ColunaSQL("serie", "modelo", "Modelo", 0, true, new String[]{"fk_contratovendanotafiscal_nf"}));
        colunas.add(new ColunaSQL("modelo", "serie", "S\u00e9rie", 0, true, new String[]{"fk_contratovendanotafiscal_nf"}));
        colunas.add(new ColunaSQL("codigo", "codigoCfop", "CFOP", 0, true, new String[]{"fk_contratovendanotafiscal_nf", "fk_notafiscal_cfop"}));
        colunas.add(new ColunaSQL("emissao", "emissao", "Emiss\u00e3o", 0, true, new String[]{"fk_contratovendanotafiscal_nf"}));
        colunas.add(new ColunaSQL("razaosocial", "cliente", "Cliente", 280, true, new String[]{"fk_contratovendanotafiscal_nf"}));
        colunas.add(new ColunaSQL("valortotalnota", "valorTotalNota", "Valor", 0, true, new String[]{"fk_contratovendanotafiscal_nf"}));
        colunas.add(new ColunaSQL("status", "status", "Status", 0, true, new String[]{"fk_contratovendanotafiscal_nf"}));
        GridBuilder grid = new GridBuilder(((ContratoVendaNotaFiscalRN)this.rn).getTabela(), colunas);
        grid.setDistinct(true);
        grid.addReferenciaDefault(new Referencia("emissao", "emissaoContrato", new String[]{"fk_contratovendanotafiscal_nf"}));
        grid.addOrdemDefault(new Ordem("emissaoContrato", true));
        return grid;
    }

    @RequestMapping(method={RequestMethod.POST})
    public Long create(@RequestBody ContratoVendaNotaFiscal contratoVendaNotaFiscal, Optional<Long> parentId) throws UnicoMensagemUsuarioException {
        throw new UnicoMensagemUsuarioException("WWW240", "Opera\u00e7\u00e3o n\u00e3o permitida.");
    }

    @RequestMapping(method={RequestMethod.PUT})
    public Long update(@RequestBody ContratoVendaNotaFiscal contratoVendaNotaFiscal, Optional<Long> parentId) throws UnicoMensagemUsuarioException {
        throw new UnicoMensagemUsuarioException("WWW241", "Opera\u00e7\u00e3o n\u00e3o permitida.");
    }

    @RequestMapping(value={"{id}"}, method={RequestMethod.DELETE})
    public void delete(@PathVariable Long id) throws UnicoMensagemUsuarioException {
        throw new UnicoMensagemUsuarioException("WWW242", "Opera\u00e7\u00e3o n\u00e3o permitida.");
    }
}

