/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.documentoauxiliarfaturamento.orcamentofaturamento;

import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.impressao.TrataImagemWeb;
import br.intelidata.commons.core.impressao.TrataModeloIReportWeb;
import br.intelidata.commons.core.sistema.Sessao;
import br.intelidata.commons.core.util.InputStreamDataSource;
import br.intelidata.commons.core.util.Malote;
import br.intelidata.commons.core.util.Notificacao;
import br.intelidata.commons.core.util.Remessa;
import br.intelidata.commons.domain.pojo.ModeloImpressaoCabecalho;
import br.intelidata.commons.domain.pojo.OrcamentoFaturamento;
import br.intelidata.commons.domain.regranegocio.ModeloImpressaoCabecalhoRN;
import br.intelidata.commons.domain.wrapper.NotificacaoCompartilhamento;
import br.intelidata.commons.modulo.documentoauxiliarfaturamento.impressao.ImpressaoOrcamentoFaturamento;
import br.intelidata.commons.modulo.documentoauxiliarfaturamento.regranegocio.OrcamentoFaturamentoRN;
import br.intelidata.uniplusweb.web.rest.app.batch.TaskManager;
import br.intelidata.uniplusweb.web.rest.app.client.crud.CreateTaskEmail;
import br.intelidata.uniplusweb.web.rest.app.crud.documentoauxiliarfaturamento.FaturamentoJobController;
import br.intelidata.uniplusweb.wrapper.ParametrosEmailWeb;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.activation.DataSource;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/jobs/orcamentos-faturamentos"})
public class OrcamentoFaturamentoJobcontroller
extends FaturamentoJobController<OrcamentoFaturamento, OrcamentoFaturamentoRN> {
    public OrcamentoFaturamentoJobcontroller(TaskManager taskManager) {
        super(taskManager);
    }

    protected List<Notificacao> getNotificacoes(Sessao sessao, NotificacaoCompartilhamento compartilhamento) throws UnicoMensagemUsuarioException {
        Notificacao notificacao = new Notificacao();
        notificacao.setFone(compartilhamento.getCelular());
        notificacao.setEmail(compartilhamento.getEmail());
        notificacao.setEmailCopia(compartilhamento.getCopiaPara());
        notificacao.setAssunto(compartilhamento.getAssunto());
        notificacao.setMsg(compartilhamento.getMensagem());
        ModeloImpressaoCabecalho modeloImpressaoCabecalho = (ModeloImpressaoCabecalho)ModeloImpressaoCabecalhoRN.getInstance().buscarPorId(compartilhamento.getIdModelo());
        ArrayList<InputStreamDataSource> sources = new ArrayList<InputStreamDataSource>();
        Malote malote = new Malote();
        List orcamentos = OrcamentoFaturamentoRN.getInstance().buscarListaPorIds(compartilhamento.getIdsDocumentos());
        for (OrcamentoFaturamento orcamento : orcamentos) {
            ImpressaoOrcamentoFaturamento impressao = new ImpressaoOrcamentoFaturamento(sessao);
            impressao.setTrataImagemWeb((TrataImagemWeb)this);
            Remessa remessa = impressao.imprimir(modeloImpressaoCabecalho, (TrataModeloIReportWeb)this.trataModeloIReportWeb, new Long[]{orcamento.getId()});
            byte[] arquivo = remessa.getMalote().extrai("pdf");
            if (arquivo == null) continue;
            String nome = "Orcamento" + orcamento.getCodigo() + ".pdf";
            InputStreamDataSource dataSourceXml = new InputStreamDataSource(nome, "application/pdf", (InputStream)new ByteArrayInputStream(arquivo));
            sources.add(dataSourceXml);
            malote.inclui(nome, arquivo);
        }
        notificacao.setDataSources(sources.toArray(new DataSource[0]));
        notificacao.setMalote(malote);
        return Collections.singletonList(notificacao);
    }

    protected void createJobEmail(Sessao sessao, ParametrosEmailWeb parametrosEmail, NotificacaoCompartilhamento compartilhamento) throws UnicoMensagemUsuarioException {
        CreateTaskEmail taskEmail = new CreateTaskEmail(this.taskManager, parametrosEmail, "Or\u00e7amento");
        taskEmail.createTask((Object)parametrosEmail, "Envio de e-mail de or\u00e7amento");
    }
}

