/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.ecommerce.categoriaprodutomercadolivre;

import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.sql.usql.ColunaSQL;
import br.intelidata.commons.core.sql.usql.Ordem;
import br.intelidata.commons.domain.pojo.CategoriaMercadoLivre;
import br.intelidata.commons.domain.pojo.enuns.TipoMovimentoPlanoContas;
import br.intelidata.commons.domain.regranegocio.AbstractRegraNegocio;
import br.intelidata.commons.domain.regranegocio.CategoriaMercadoLivreCommonRN;
import br.intelidata.core.aop.DBAutoCommit;
import br.intelidata.uniplusweb.core.grid.GridBuilder;
import br.intelidata.uniplusweb.web.rest.app.client.crud.CrudController;
import java.util.Arrays;
import java.util.List;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/categorias-mercadolivre"})
public class CategoriaProdutoMercadoLivreCrudController
extends CrudController<CategoriaMercadoLivre, CategoriaMercadoLivreCommonRN> {
    public CategoriaProdutoMercadoLivreCrudController() {
        super((AbstractRegraNegocio)CategoriaMercadoLivreCommonRN.getInstance(), CategoriaMercadoLivre::new);
    }

    protected GridBuilder<CategoriaMercadoLivreCommonRN> getGridBuilder() {
        List<ColunaSQL> colunas = Arrays.asList(new ColunaSQL("id", "id", 0, false), new ColunaSQL("codigo", "C\u00f3digo", 0, false), new ColunaSQL("nome", "Nome", 0, true));
        GridBuilder grid = new GridBuilder(CategoriaMercadoLivreCommonRN.getInstance().getTabela(), colunas);
        grid.setOrdemDefault(new Ordem("codigo"));
        return grid;
    }

    @RequestMapping(value={"/dados-tree"})
    @DBAutoCommit
    public List<CategoriaMercadoLivre> buscarDadosTree(@RequestParam(required=false) boolean apenasAtivos, @RequestParam(required=false) TipoMovimentoPlanoContas tipoMovimento) {
        return CategoriaMercadoLivreCommonRN.getInstance().buscarLista();
    }

    @RequestMapping(value={"/nome/{id}"})
    @DBAutoCommit
    public CategoriaMercadoLivre getNome(@PathVariable Long id) throws UnicoMensagemUsuarioException {
        return (CategoriaMercadoLivre)CategoriaMercadoLivreCommonRN.getInstance().buscarPorId(id);
    }

    protected String getCacheId() {
        return "/api/categorias-mercadolivre";
    }
}

