/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.entidade.cliente.historicobloqueio;

import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.sql.usql.ColunaSQL;
import br.intelidata.commons.core.util.DataHoraFactory;
import br.intelidata.commons.core.util.EnumSimNao;
import br.intelidata.commons.domain.pojo.AbstractPojo;
import br.intelidata.commons.domain.pojo.Entidade;
import br.intelidata.commons.domain.pojo.vendas.HistoricoBloqueioCliente;
import br.intelidata.commons.domain.regranegocio.AbstractRegraNegocio;
import br.intelidata.commons.modulo.entidade.regranegocio.EntidadeRN;
import br.intelidata.commons.modulo.entidade.regranegocio.HistoricoBloqueioClienteRN;
import br.intelidata.core.aop.DBAutoCommit;
import br.intelidata.uniplusweb.core.grid.GridBuilder;
import br.intelidata.uniplusweb.core.util.NumberUtil;
import br.intelidata.uniplusweb.web.rest.app.client.crud.CrudController;
import java.util.ArrayList;
import java.util.Optional;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/historico-bloqueios"})
public class HistoricoBloqueioClienteCrudController
extends CrudController<HistoricoBloqueioCliente, HistoricoBloqueioClienteRN> {
    public HistoricoBloqueioClienteCrudController() {
        super((AbstractRegraNegocio)HistoricoBloqueioClienteRN.getInstance(), HistoricoBloqueioCliente::new, false);
        this.dependsOn("idCliente");
    }

    @RequestMapping(value={"/credito-restrito"})
    @DBAutoCommit
    public boolean creditoRestrito(@RequestParam Long idEntidade) {
        Entidade entidade = (Entidade)EntidadeRN.getInstance().buscarPorId(idEntidade);
        return entidade.getCreditoRestrito().equals(EnumSimNao.SIM.getId());
    }

    protected void beforeSave(HistoricoBloqueioCliente historicoBloqueioCliente, Optional<Long> parentId) throws UnicoMensagemUsuarioException {
        if (NumberUtil.longNullOuZero((Long)historicoBloqueioCliente.getIdCliente())) {
            throw new UnicoMensagemUsuarioException("WWW53", "Entidade n\u00e3o informada.");
        }
        historicoBloqueioCliente.setDataInclusao(DataHoraFactory.getData());
        historicoBloqueioCliente.setIdUsuarioResponsavel(SessaoUtil.getSessao().getIdUsuario());
        Entidade entidade = (Entidade)EntidadeRN.getInstance().buscarPorId(historicoBloqueioCliente.getIdCliente());
        if (entidade != null) {
            entidade.setCreditoRestrito(historicoBloqueioCliente.getBloquear());
            EntidadeRN.getInstance().alterar((AbstractPojo)entidade, SessaoUtil.getSessao());
        }
    }

    protected GridBuilder<HistoricoBloqueioClienteRN> getGridBuilder() {
        ArrayList<ColunaSQL> colunas = new ArrayList<ColunaSQL>();
        colunas.add(new ColunaSQL("id", "ID", 0, false));
        colunas.add(new ColunaSQL("idCliente", "idCliente", 0, false));
        colunas.add(new ColunaSQL("idUsuarioResponsavel", "idUsuarioResponsavel", 0, false));
        colunas.add(new ColunaSQL("dataInclusao", "Data", 150, true));
        colunas.add(new ColunaSQL("nome", "usuarioResponsavel", "Usuario", 150, true, new String[]{"historico_bloq_clie_usu_fk"}));
        colunas.add(new ColunaSQL("justificativa", "Observa\u00e7\u00e3o", 150, true));
        colunas.add(new ColunaSQL("descricao", "descricaoMotivoBloqueio", "Motivo", 150, true, new String[]{"historico_bloq_clie_motivo_fk"}));
        colunas.add(new ColunaSQL("bloquear", "Bloqueado", 150, true));
        return new GridBuilder(HistoricoBloqueioClienteRN.getInstance().getTabela(), colunas);
    }

    protected String getCacheId() {
        return "historico-bloqueios";
    }
}

