/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.entidade.cliente.notificacaoposvenda;

import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.sistema.Sessao;
import br.intelidata.commons.core.sql.usql.ColunaSQL;
import br.intelidata.commons.core.sql.usql.Ordem;
import br.intelidata.commons.core.util.DataHoraFactory;
import br.intelidata.commons.core.util.Notificacao;
import br.intelidata.commons.core.util.TipoNotificacao;
import br.intelidata.commons.core.util.Util;
import br.intelidata.commons.core.whatsapp.TipoIntegracaoWhatsAppEnum;
import br.intelidata.commons.domain.pojo.NotificacaoPosVenda;
import br.intelidata.commons.domain.pojo.NotificacaoPosVendaProcessado;
import br.intelidata.commons.domain.pojo.NotificarPosVenda;
import br.intelidata.commons.domain.pojo.RetornoGrid;
import br.intelidata.commons.domain.regranegocio.AbstractRegraNegocio;
import br.intelidata.commons.domain.regranegocio.NotificacaoPosVendaCommonRN;
import br.intelidata.core.aop.DBAutoCommit;
import br.intelidata.core.aop.DBTransaction;
import br.intelidata.uniplusweb.core.coreinterfaces.SubMenuMapping;
import br.intelidata.uniplusweb.core.grid.FilterField;
import br.intelidata.uniplusweb.core.grid.GridBuilder;
import br.intelidata.uniplusweb.core.util.EmailUtil;
import br.intelidata.uniplusweb.core.util.ListMapUtil;
import br.intelidata.uniplusweb.service.WhatsAppService;
import br.intelidata.uniplusweb.web.rest.app.batch.TaskManager;
import br.intelidata.uniplusweb.web.rest.app.client.crud.CreateTaskEmail;
import br.intelidata.uniplusweb.web.rest.app.client.crud.CrudController;
import br.intelidata.uniplusweb.web.rest.app.crud.entidade.cliente.notificacaoposvenda.NotificacaoEnvioRetorno;
import br.intelidata.uniplusweb.web.rest.app.crud.entidade.cliente.notificacaoposvenda.NotificacaoEnvioWrapper;
import br.intelidata.uniplusweb.wrapper.ParametrosEmailWeb;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/notificacao-posvenda"})
@SubMenuMapping(MENU="SubMenuVendasGeral", NOME="Notifica\u00e7\u00f5es de p\u00f3s-venda", ICONE="icon-cliente", ROTA="/vendas/notificacao-posvenda", PROGRAMA=1512)
public class NotificacaoPosVendaController
extends CrudController<NotificacaoPosVenda, NotificacaoPosVendaCommonRN> {
    private final TaskManager taskManager;
    @Autowired
    private WhatsAppService whatsAppService;

    public NotificacaoPosVendaController(TaskManager taskManager) {
        super((AbstractRegraNegocio)NotificacaoPosVendaCommonRN.getInstance(), NotificacaoPosVenda::new);
        this.taskManager = taskManager;
    }

    @RequestMapping(value={"/buscar-notificacoes-pendentes"})
    @DBAutoCommit
    public RetornoGrid buscarNotificacoes(@RequestParam(value="page", required=false, defaultValue="1") int page, @RequestParam(value="limit", required=false, defaultValue="35") int limit, @RequestParam(value="totalAtual", required=false, defaultValue="0") int totalAtual, @RequestParam(value="query", required=false) String query, @RequestParam(value="sort", required=false) String sort) {
        List sorts = this.getFilter(sort, null);
        Ordem ordem = !ListMapUtil.listNullOrEmpty((List)sorts) ? new Ordem(((FilterField)sorts.get(0)).getField(), Boolean.parseBoolean(((FilterField)sorts.get(0)).getValue1())) : null;
        return NotificacaoPosVendaCommonRN.getInstance().buscarNotificacoes(page, limit, totalAtual, query, ordem);
    }

    @PostMapping(value={"/enviar"})
    @DBTransaction
    public NotificacaoEnvioRetorno enviarNotificacoes(@RequestBody NotificacaoEnvioWrapper wrapper) throws UnicoMensagemUsuarioException {
        NotificacaoEnvioRetorno notificacaoEnvioRetorno = new NotificacaoEnvioRetorno();
        Sessao sessao = SessaoUtil.getSessao();
        NotificacaoPosVendaProcessado processado = NotificacaoPosVendaCommonRN.getInstance().gerarNotificacoes(sessao, wrapper.getTipoNotificacao(), wrapper.getAssunto(), wrapper.getMensagem(), wrapper.getListaParaNotificar());
        for (Notificacao notificacao : processado.getNotificacoes()) {
            if (processado.getTipoIntegracaoWhatsAppEnum() != null) {
                if (processado.getTipoIntegracaoWhatsAppEnum().equals((Object)TipoIntegracaoWhatsAppEnum.PADRAO)) {
                    notificacaoEnvioRetorno.setStrWhatsAppPadrao(this.whatsAppService.enviarWhatsApp(Collections.singletonList(notificacao), sessao));
                }
            } else if (TipoNotificacao.EMAIL.equals((Object)wrapper.getTipoNotificacao())) {
                ParametrosEmailWeb parametrosEmail = EmailUtil.getParametros((Sessao)sessao, (String)notificacao.getEmail(), null, (String)notificacao.getAssunto(), (String)notificacao.getMsg());
                CreateTaskEmail taskEmail = new CreateTaskEmail(this.taskManager, parametrosEmail, "Notifica\u00e7\u00e3o de pos-venda para ".concat(notificacao.getNotificarClienteVenda().getNomeCliente()));
                taskEmail.createTask((Object)parametrosEmail, "Notifica\u00e7\u00e3o de pos-venda");
            }
            NotificarPosVenda notificarPosVenda = notificacao.getNotificarClienteVenda();
            String endereco = TipoNotificacao.EMAIL.equals((Object)wrapper.getTipoNotificacao()) ? notificacao.getEmail() : notificacao.getFone();
            NotificacaoPosVendaCommonRN.getInstance().gravarNotificacao(sessao, notificarPosVenda.getIdCliente(), notificarPosVenda.getIdProduto(), notificarPosVenda.getIdItem(), sessao.getIdUsuario(), wrapper.getMensagem(), wrapper.getTipoNotificacao(), endereco, DataHoraFactory.getDataHora(), false, wrapper.getOrigem());
        }
        if (TipoIntegracaoWhatsAppEnum.WHATS_GW.equals((Object)processado.getTipoIntegracaoWhatsAppEnum()) && !Util.listNullOrEmpty((List)processado.getNotificacoes())) {
            this.whatsAppService.enviarWhatsApp(processado.getNotificacoes(), sessao);
        }
        notificacaoEnvioRetorno.setErros(String.join((CharSequence)"<br>", processado.getErros()));
        return notificacaoEnvioRetorno;
    }

    @PostMapping(value={"/marcar-enviado"})
    @DBTransaction
    public void marcarComoEnviado(@RequestBody NotificacaoEnvioWrapper wrapper) throws UnicoMensagemUsuarioException {
        Sessao sessao = SessaoUtil.getSessao();
        for (NotificarPosVenda notificarPosVenda : wrapper.getListaParaNotificar()) {
            NotificacaoPosVendaCommonRN.getInstance().gravarNotificacao(sessao, notificarPosVenda.getIdCliente(), notificarPosVenda.getIdProduto(), notificarPosVenda.getIdItem(), sessao.getIdUsuario(), wrapper.getMensagem(), null, "", DataHoraFactory.getDataHora(), true, wrapper.getOrigem());
        }
    }

    protected String getCacheId() {
        return "notificacao-posvenda";
    }

    protected GridBuilder<?> getGridBuilder() {
        ArrayList<ColunaSQL> colunas = new ArrayList<ColunaSQL>();
        colunas.add(new ColunaSQL("id", "ID", 0, false));
        colunas.add(new ColunaSQL("origem", "origem", 0, false));
        colunas.add(new ColunaSQL("nome", "cliente", "Cliente", 0, true, new String[]{"fk_notposvenda_entidade"}));
        colunas.add(new ColunaSQL("nome", "produto", "Produto", 0, true, new String[]{"fk_notposvenda_produto"}));
        colunas.add(new ColunaSQL("dataHoraEnvio", "Data envio", 120, true));
        colunas.add(new ColunaSQL("nome", "usuario", "Usu\u00e1rio envio", 0, true, new String[]{"fk_notposvenda_usuario"}));
        colunas.add(new ColunaSQL("tipo", "Tipo de notifica\u00e7\u00e3o", 160, true));
        colunas.add(new ColunaSQL("endereco", "Enviado para", 0, true));
        GridBuilder gridBuilder = new GridBuilder(NotificacaoPosVendaCommonRN.getInstance().getTabela(), colunas);
        gridBuilder.addOrdem(new Ordem("dataHoraEnvio"));
        return gridBuilder;
    }
}

