/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.entidade.representante;

import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.licenca.Funcionalidade;
import br.intelidata.commons.domain.pojo.Entidade;
import br.intelidata.commons.domain.pojo.PreferenciaUsuario;
import br.intelidata.commons.domain.pojo.enuns.QuantidadeCampoExtra;
import br.intelidata.commons.domain.pojo.enuns.TipoEntidade;
import br.intelidata.commons.domain.regranegocio.EntidadePautaPrecoRN;
import br.intelidata.commons.modulo.cadastros.regranegocio.PreferenciaUsuarioRN;
import br.intelidata.uniplusweb.core.coreinterfaces.ConfiguracaoCampoExtra;
import br.intelidata.uniplusweb.core.coreinterfaces.SubMenuMapping;
import br.intelidata.uniplusweb.service.FuncionalidadeService;
import br.intelidata.uniplusweb.web.rest.app.crud.entidade.EntidadeCrudController;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@ConfiguracaoCampoExtra(TABELA="cad_representante", QUANTIDADE=QuantidadeCampoExtra.ENTIDADE)
@RestController
@RequestMapping(value={"/api/representantes"})
@SubMenuMapping(MENU="SubMenuCadastroGeral", NOME="Vendedores", ICONE="icon-vendedor", ROTA="/entidades/representantes", PROGRAMA=5)
public class RepresentanteCrudController
extends EntidadeCrudController {
    public final FuncionalidadeService funcionalidadeService;

    @Autowired
    public RepresentanteCrudController(FuncionalidadeService funcionalidadeService) {
        super(TipoEntidade.REPRESENTANTE);
        this.funcionalidadeService = funcionalidadeService;
    }

    protected void beforeRead(Entidade entidade, int modo, Optional<Long> parentId) throws UnicoMensagemUsuarioException {
        super.beforeRead(entidade, modo, parentId);
        PreferenciaUsuario preferenciaUsuario = PreferenciaUsuarioRN.getInstance().buscaPorIdVendedor(entidade.getId());
        if (preferenciaUsuario != null) {
            entidade.setIdUsuarioVendedor(preferenciaUsuario.getIdUsuario());
        }
        if (this.funcionalidadeService.isAtiva(Funcionalidade.PAUTA_PRECO_CADASTRO)) {
            entidade.setPautasPreco(EntidadePautaPrecoRN.getInstance().buscarListaPorIdEntidade(entidade.getId()));
        }
    }
}

