/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.estado.cidade;

import br.intelidata.commons.core.sql.usql.ColunaSQL;
import br.intelidata.commons.domain.pojo.Cidade;
import br.intelidata.commons.domain.regranegocio.AbstractRegraNegocio;
import br.intelidata.commons.modulo.cadastros.regranegocio.CidadeRN;
import br.intelidata.core.aop.DBAutoCommit;
import br.intelidata.uniplusweb.core.coreinterfaces.SubMenuMapping;
import br.intelidata.uniplusweb.core.grid.GridBuilder;
import br.intelidata.uniplusweb.core.service.ResponseEntityService;
import br.intelidata.uniplusweb.core.util.JsonUtil;
import br.intelidata.uniplusweb.web.rest.app.client.crud.CrudController;
import java.util.ArrayList;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/cidades"})
@SubMenuMapping(MENU="SubMenuCadastroAuxiliarEnderecos", NOME="Cidades", ROTA="/enderecos/estados/:idEstado/cidades", PROGRAMA=15, CUSTOM_ACTION=true)
public class CidadeCrudController
extends CrudController<Cidade, CidadeRN> {
    private ResponseEntityService responseEntityService;

    @Autowired
    public CidadeCrudController(ResponseEntityService responseEntityService) {
        super((AbstractRegraNegocio)CidadeRN.getInstance(), Cidade::new);
        this.responseEntityService = responseEntityService;
    }

    @RequestMapping(value={"/filtrar-por-estado"})
    @DBAutoCommit
    public ResponseEntity<String> filtrarCidades(@RequestParam Long idEstado) {
        String json = CidadeRN.getInstance().getCidadesPorEstadoWeb(new Long[]{idEstado}).stream().map(cidade -> new StringBuilder("{\"id\":").append(cidade.getId().toString()).append(", \"nome\":").append(JsonUtil.escapeQuote((String)cidade.getNome())).append("}")).collect(Collectors.joining(","));
        return this.responseEntityService.createJSONResponse("[" + json + "]");
    }

    @RequestMapping(value={"/filtrar-por-estados"})
    @DBAutoCommit
    public ResponseEntity<String> filtrarCidadesPorIDsEstado(@RequestParam Long[] idEstados) {
        String json = CidadeRN.getInstance().getCidadesPorEstadoWeb(idEstados).stream().map(cidade -> new StringBuilder("{\"id\":").append(cidade.getId().toString()).append(", \"nome\":").append(JsonUtil.escapeQuote((String)cidade.getNome())).append("}")).collect(Collectors.joining(","));
        return this.responseEntityService.createJSONResponse("[" + json + "]");
    }

    protected GridBuilder<CidadeRN> getGridBuilder() {
        ArrayList<ColunaSQL> colunas = new ArrayList<ColunaSQL>();
        colunas.add(new ColunaSQL("id", "ID", 0, false));
        colunas.add(new ColunaSQL("idEstado", "idEstado", 0, false));
        colunas.add(new ColunaSQL("codigo", "C\u00f3digo", 100, true));
        colunas.add(new ColunaSQL("nome", "Descri\u00e7\u00e3o", 0, true));
        colunas.add(new ColunaSQL("nome", "nomeEstado", "Estado", 0, true, new String[]{"fk_cidade_estado"}));
        colunas.add(new ColunaSQL("nome", "nomePais", "Pa\u00eds", 0, true, new String[]{"fk_cidade_estado", "fk_estado_pais"}));
        return new GridBuilder(CidadeRN.getInstance().getTabela(), colunas);
    }

    protected String getCacheId() {
        return "cidades";
    }
}

