/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.exportarxml;

import br.intelidata.api.batch.AbstractJob;
import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.sistema.Sessao;
import br.intelidata.commons.core.util.DataHoraFactory;
import br.intelidata.commons.core.util.JSONUtil;
import br.intelidata.commons.core.util.Util;
import br.intelidata.commons.domain.pojo.ConfiguracaoCampos;
import br.intelidata.commons.domain.pojo.Entidade;
import br.intelidata.commons.domain.pojo.Filial;
import br.intelidata.commons.domain.pojo.enuns.TipoJob;
import br.intelidata.commons.domain.regranegocio.AbstractRegraNegocio;
import br.intelidata.commons.modulo.cadastros.regranegocio.ConfiguracaoCamposRN;
import br.intelidata.commons.modulo.cadastros.regranegocio.FilialRN;
import br.intelidata.commons.modulo.entidade.regranegocio.EntidadeRN;
import br.intelidata.commons.modulo.exportacaoxml.pojo.ExportacaoXMLFiltro;
import br.intelidata.core.aop.DBAutoCommit;
import br.intelidata.core.aop.DBTransaction;
import br.intelidata.uniplusweb.core.util.NumberUtil;
import br.intelidata.uniplusweb.core.util.StringUtil;
import br.intelidata.uniplusweb.web.rest.app.batch.TaskManager;
import br.intelidata.uniplusweb.web.rest.app.client.crud.ICreateTask;
import br.intelidata.uniplusweb.web.rest.app.client.crud.SimpleCrudController;
import br.intelidata.uniplusweb.web.rest.app.crud.exportarxml.JobExportarXml;
import java.time.LocalDate;
import java.time.temporal.ChronoUnit;
import java.time.temporal.Temporal;
import java.util.List;
import java.util.stream.Collectors;
import org.json.JSONObject;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

public abstract class ExportarXMLCrudControllerAbstract
extends SimpleCrudController<ExportacaoXMLFiltro, ConfiguracaoCamposRN>
implements ICreateTask {
    private final TaskManager taskManager;
    private final String tabela;

    public ExportarXMLCrudControllerAbstract(TaskManager taskManager, String tabela) {
        super((AbstractRegraNegocio)ConfiguracaoCamposRN.getInstance());
        this.taskManager = taskManager;
        this.tabela = tabela;
    }

    public TipoJob getTipoJob() {
        return TipoJob.EXPORTA_XML;
    }

    public Class<? extends AbstractJob> job() {
        return JobExportarXml.class;
    }

    public TaskManager taskManager() {
        return this.taskManager;
    }

    @DBAutoCommit
    public ExportacaoXMLFiltro get(Long parentId) throws UnicoMensagemUsuarioException {
        ConfiguracaoCampos conf = ((ConfiguracaoCamposRN)this.getRegraNegocio()).buscarPorIdFilialTabela(SessaoUtil.getSessao().getIdFilial(), this.tabela);
        if (conf != null) {
            return (ExportacaoXMLFiltro)JSONUtil.getObject((JSONObject)conf.getCamposSerializados(), ExportacaoXMLFiltro.class);
        }
        return new ExportacaoXMLFiltro();
    }

    @RequestMapping(method={RequestMethod.POST})
    @DBTransaction
    public Long create(@RequestBody ExportacaoXMLFiltro exportacaoXMLFiltro) throws UnicoMensagemUsuarioException {
        Sessao sessao = SessaoUtil.getSessao();
        boolean isAgendado = this.tabela.equals("documento-fiscal");
        if (Util.listNullOrEmpty((List)exportacaoXMLFiltro.getIdFiliais())) {
            throw new UnicoMensagemUsuarioException("WWW553", "Nenhuma filial foi informada! Verifique!");
        }
        if (!isAgendado) {
            if (exportacaoXMLFiltro.getDataInicial() == null || exportacaoXMLFiltro.getDataHoraFinal() == null) {
                throw new UnicoMensagemUsuarioException("WWW554", "O per\u00edodo n\u00e3o foi informado! Verifique!");
            }
            if (ChronoUnit.DAYS.between(exportacaoXMLFiltro.getDataInicial(), exportacaoXMLFiltro.getDataHoraFinal()) > 62L) {
                throw new UnicoMensagemUsuarioException("WWW555", "O per\u00edodo informado \u00e9 muito grande! Informe um per\u00edodo de at\u00e9 dois meses!");
            }
        }
        exportacaoXMLFiltro.setCodigoFiliais(FilialRN.getInstance().buscarListaPorIds(exportacaoXMLFiltro.getIdFiliais()).stream().map(Filial::getCodigo).collect(Collectors.toList()));
        if (!NumberUtil.longNullOuZero((Long)exportacaoXMLFiltro.getIdEntidade())) {
            Entidade entidade = (Entidade)EntidadeRN.getInstance().buscarPorId(exportacaoXMLFiltro.getIdEntidade());
            if (entidade != null) {
                exportacaoXMLFiltro.setCodigoEntidade(entidade.getCodigo());
            } else {
                exportacaoXMLFiltro.setCodigoEntidade(null);
            }
        } else {
            exportacaoXMLFiltro.setCodigoEntidade(null);
        }
        if (isAgendado) {
            LocalDate inicio = DataHoraFactory.getData().minusMonths(1L).withDayOfMonth(1);
            LocalDate fim = DataHoraFactory.getData().withDayOfMonth(1).minusDays(1L);
            exportacaoXMLFiltro.setDataInicial(inicio);
            exportacaoXMLFiltro.setDataFinal(fim);
        }
        this.createTask((Object)exportacaoXMLFiltro, this.resumoFiltros(exportacaoXMLFiltro));
        exportacaoXMLFiltro.setDataInicial(null);
        exportacaoXMLFiltro.setDataFinal(null);
        exportacaoXMLFiltro.setIdEntidade(null);
        return ((ConfiguracaoCamposRN)this.getRegraNegocio()).gravarConfiguracaoPorFilial(sessao, (Object)exportacaoXMLFiltro, this.tabela);
    }

    private String resumoFiltros(ExportacaoXMLFiltro parametros) {
        return "Periodo: " + StringUtil.formataDataHora((Temporal)parametros.getDataInicial(), (String)"dd/MM/yy") + " \u00e0 " + StringUtil.formataDataHora((Temporal)parametros.getDataFinal(), (String)"dd/MM/yy");
    }
}

