/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.financeiro.cobrancaescritural.remessa;

import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.sistema.PropriedadeRN;
import br.intelidata.commons.core.sql.usql.ColunaSQL;
import br.intelidata.commons.domain.pojo.Entidade;
import br.intelidata.commons.domain.pojo.financeiro.ContaCorrente;
import br.intelidata.commons.domain.pojo.financeiro.cobranca.ArquivoRemessa;
import br.intelidata.commons.domain.pojo.financeiro.cobranca.DocumentoCobranca;
import br.intelidata.commons.domain.regranegocio.AbstractRegraNegocio;
import br.intelidata.commons.modulo.cobrancaescritural.regranegocio.ArquivoRemessaRN;
import br.intelidata.commons.modulo.cobrancaescritural.regranegocio.DocumentoCobrancaRN;
import br.intelidata.commons.modulo.entidade.regranegocio.EntidadeRN;
import br.intelidata.commons.modulo.financeiro.regranegocio.ContaCorrenteRN;
import br.intelidata.uniplusweb.core.coreinterfaces.SubMenuMapping;
import br.intelidata.uniplusweb.core.grid.FilterField;
import br.intelidata.uniplusweb.core.grid.GridBuilder;
import br.intelidata.uniplusweb.core.util.ListMapUtil;
import br.intelidata.uniplusweb.core.util.StringUtil;
import br.intelidata.uniplusweb.web.rest.app.client.crud.CrudController;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/documentos-cobranca"})
@SubMenuMapping(MENU="SubMenuFinanceiroCobrancaEscritural", NOME="Documentos cobran\u00e7a", ROTA="/financeiros/remessas/:idArquivoRemessa/documentos-cobranca", PROGRAMA=422, CUSTOM_ACTION=true)
public class DocumentoCobrancaCrudController
extends CrudController<DocumentoCobranca, DocumentoCobrancaRN> {
    public DocumentoCobrancaCrudController() {
        super((AbstractRegraNegocio)DocumentoCobrancaRN.getInstace(), DocumentoCobranca::new);
        this.dependsOn("idArquivoRemessa");
    }

    protected void afterLoadGrid(List<ColunaSQL> colunas, List<Object[]> dados, List<FilterField> filters, MultiValueMap<String, String> parameters) {
        Optional<FilterField> filter;
        if (!ListMapUtil.listNullOrEmpty(filters) && (filter = filters.stream().filter(filterField -> filterField.getField().equals("idArquivoRemessa")).findFirst()).isPresent()) {
            ArquivoRemessa arquivoRemessa = (ArquivoRemessa)ArquivoRemessaRN.getInstance().buscarPorId(Long.valueOf(Long.parseLong(filter.get().getValue1())));
            ContaCorrente conta = (ContaCorrente)ContaCorrenteRN.getInstance().buscarPorId(Long.valueOf(arquivoRemessa.getIdContaCorrente()));
            BigDecimal jurosDia = BigDecimal.ZERO;
            BigDecimal multa = BigDecimal.ZERO;
            if (!conta.isNaoGerarMensagemJuros()) {
                jurosDia = PropriedadeRN.getInstance().getPropriedadeBigDecimal(SessaoUtil.getSessao().getFilial(), 23);
            }
            if (!conta.isNaoGerarMensagemMulta()) {
                multa = PropriedadeRN.getInstance().getPropriedadeBigDecimal(SessaoUtil.getSessao().getFilial(), 24);
            }
            BigDecimal finalJurosDia = jurosDia;
            BigDecimal finalMulta = multa;
            dados.forEach(registro -> {
                int idxMulta;
                int idxJuros = this.getIndexColuna("percJurosAoDia", colunas);
                if (idxJuros > -1) {
                    registro[idxJuros] = finalJurosDia;
                }
                if ((idxMulta = this.getIndexColuna("percMultaAtraso", colunas)) > -1) {
                    registro[idxMulta] = finalMulta;
                }
                Long idEntidade = (Long)registro[this.getIndexColuna("idEntidade", colunas)];
                Entidade cliente = (Entidade)EntidadeRN.getInstance().buscarPorId(idEntidade);
                if (cliente != null) {
                    String email = cliente.getEmail();
                    if (!StringUtil.stringNullOrEmpty((String)cliente.getEmailFinanceiro())) {
                        email = cliente.getEmailFinanceiro();
                    }
                    registro[this.getIndexColuna((String)"emailEntidade", (List)colunas)] = email;
                }
            });
        }
    }

    protected String getCacheId() {
        return "documentos-cobranca";
    }

    protected GridBuilder<DocumentoCobrancaRN> getGridBuilder() {
        ArrayList<ColunaSQL> colunas = new ArrayList<ColunaSQL>();
        colunas.add(new ColunaSQL("id", "id", 0, false));
        colunas.add(new ColunaSQL("idArquivoRemessa", "idArquivoRemessa", 0, false));
        colunas.add(new ColunaSQL("idEntidade", "idEntidade", 0, false));
        colunas.add(new ColunaSQL("idFinanceiroDado", "idFinanceiroDado", 0, false));
        colunas.add(new ColunaSQL("documento", "Numero documento", 150, true));
        colunas.add(new ColunaSQL("nomeSacado", "Sacado", 300, true));
        colunas.add(new ColunaSQL("emissao", "Emiss\u00e3o", 100, true));
        colunas.add(new ColunaSQL("vencimento", "Vencimento", 100, true));
        colunas.add(new ColunaSQL("valorDocumento", "Valor", 110, true));
        colunas.add(new ColunaSQL("nossoNumero", "Nosso n\u00famero", 130, true));
        colunas.add(new ColunaSQL("aceiteCobrebem", "Aceite", 70, true));
        colunas.add(new ColunaSQL("tipoDocumento", "Tipo documento", 100, true));
        colunas.add(new ColunaSQL("diasProtesto", "Dias protesto", 100, true));
        colunas.add(new ColunaSQL("percJurosAoDia", "% Juros ao m\u00eas", 100, true));
        colunas.add(new ColunaSQL("percMultaAtraso", "% Multa Atraso", 100, true));
        colunas.add(new ColunaSQL("cnpjCpfSacado", "Cnpj/Cpf sacado", 130, true));
        colunas.add(new ColunaSQL("enderecoSacado", "Endereco sacado", 200, true));
        colunas.add(new ColunaSQL("cepSacado", "CEP sacado", 100, true));
        colunas.add(new ColunaSQL("bairroSacado", "Bairro sacado", 150, true));
        colunas.add(new ColunaSQL("estadoSacado", "UF sacado", 80, true));
        ColunaSQL coluna = new ColunaSQL("emailEntidade", "Email", 0, false);
        coluna.setVirtual(true);
        colunas.add(coluna);
        return new GridBuilder(DocumentoCobrancaRN.getInstace().getTabela(), colunas);
    }
}

