/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.financeiro.cobrancaescritural.remessa;

import br.intelidata.commons.core.bancoonline.IntegracaoBancoOnline;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.sistema.PropriedadeRN;
import br.intelidata.commons.core.sistema.Sessao;
import br.intelidata.commons.core.sql.Sql;
import br.intelidata.commons.core.sql.usql.ColunaUPD;
import br.intelidata.commons.core.sql.usql.UUpdate;
import br.intelidata.commons.core.uboleto.boleto.Boleto;
import br.intelidata.commons.core.uboleto.enums.BancoDisponivel;
import br.intelidata.commons.core.util.Email;
import br.intelidata.commons.core.util.Notificacao;
import br.intelidata.commons.core.util.Util;
import br.intelidata.commons.domain.pojo.Banco;
import br.intelidata.commons.domain.pojo.ParametrosEmail;
import br.intelidata.commons.domain.pojo.adicional.CobrancaEmailWeb;
import br.intelidata.commons.domain.pojo.batch.JobMetadata;
import br.intelidata.commons.domain.pojo.batch.Task;
import br.intelidata.commons.domain.pojo.enuns.StatusJobItem;
import br.intelidata.commons.domain.pojo.enuns.TipoNotificacaoSimples;
import br.intelidata.commons.domain.pojo.financeiro.ContaCorrente;
import br.intelidata.commons.domain.pojo.financeiro.ContaCorrenteAcaoGeracaoRemessa;
import br.intelidata.commons.domain.pojo.financeiro.ContaCorrenteCarteira;
import br.intelidata.commons.domain.pojo.financeiro.cobranca.DocumentoCobranca;
import br.intelidata.commons.domain.regranegocio.BancoCommonRN;
import br.intelidata.commons.domain.regranegocio.financeiro.cobranca.CobrancaEscrituralRN;
import br.intelidata.commons.domain.wrapper.GeracaoRemessaWrapper;
import br.intelidata.commons.domain.wrapper.NotificacaoCompartilhamento;
import br.intelidata.commons.modulo.financeiro.bancoonline.BancoOnlineRetorno;
import br.intelidata.commons.modulo.financeiro.regranegocio.ContaCorrenteCarteiraRN;
import br.intelidata.commons.modulo.financeiro.regranegocio.ContaCorrenteRN;
import br.intelidata.commons.modulo.financeiro.regranegocio.FinanceiroDadoRN;
import br.intelidata.uniplusweb.core.util.BeanUtil;
import br.intelidata.uniplusweb.core.util.EmailUtil;
import br.intelidata.uniplusweb.core.util.NumberUtil;
import br.intelidata.uniplusweb.web.rest.app.batch.TaskManager;
import br.intelidata.uniplusweb.web.rest.app.client.crud.CreateTaskEmail;
import br.intelidata.uniplusweb.web.rest.app.client.thread.AbstractPrepareJob;
import br.intelidata.uniplusweb.wrapper.ParametrosEmailWeb;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;

public class GeracaoRemessaOnlineJobSimpleController
extends AbstractPrepareJob {
    private final TaskManager taskManager = (TaskManager)BeanUtil.getBean((String)"taskManager");

    public GeracaoRemessaOnlineJobSimpleController(String parameters, JobMetadata metadata) {
        super(parameters, metadata);
    }

    public boolean abstractControlTransaction() {
        return false;
    }

    public void execute() throws Exception {
        GeracaoRemessaWrapper remessaWrapper = (GeracaoRemessaWrapper)this.getObjetoDeserializado(GeracaoRemessaWrapper.class);
        Sessao sessao = this.getSessao();
        ContaCorrente contaCorrente = (ContaCorrente)ContaCorrenteRN.getInstance().buscarPorId(remessaWrapper.getIdContaCorrenteRemessa());
        Banco banco = (Banco)BancoCommonRN.getInstance().buscarPorId(contaCorrente.getIdbanco());
        boolean isAsaas = BancoDisponivel.isAsaas((String)banco.getCodigo());
        ContaCorrenteCarteira contaCarteira = this.getContaCorrenteCarteira(remessaWrapper, isAsaas);
        ContaCorrenteAcaoGeracaoRemessa contaAcaoRemessa = new ContaCorrenteAcaoGeracaoRemessa();
        contaAcaoRemessa.setAcaoCobrancaAPI(remessaWrapper.getAcaoCobrancaAPI());
        NotificacaoCompartilhamento notificacao = remessaWrapper.getNotificacao();
        CobrancaEmailWeb cobranca = CobrancaEscrituralRN.getInstance().gerarBoletoWeb(sessao, remessaWrapper.getDocumentos(), contaCorrente, contaCarteira, banco, false, remessaWrapper.getTipoSaidaBoleto(), contaAcaoRemessa, remessaWrapper.getTipoImpressao(), remessaWrapper.getPercentualDescontoPagamentoAteVencimento(), remessaWrapper.getInstrucaoProtesto(), remessaWrapper.getDiasInstrucao(), remessaWrapper.getObservacao(), notificacao.getTipo(), true);
        List boletos = cobranca.getMapBoleto().values().stream().flatMap(Collection::stream).collect(Collectors.toList());
        PropriedadeRN.getInstance().setPropriedade(sessao, 592, remessaWrapper.getPercentualDescontoPagamentoAteVencimento().toString());
        BancoOnlineRetorno retorno = new IntegracaoBancoOnline(sessao, contaCorrente, false).processar(contaAcaoRemessa.getAcaoCobrancaAPI(), boletos);
        this.agendarEmail(sessao, boletos, cobranca.getMapPdf(), retorno, notificacao);
    }

    public void onFailure(Exception ex) {
        try {
            GeracaoRemessaWrapper remessaWrapper = (GeracaoRemessaWrapper)this.getObjetoDeserializado(GeracaoRemessaWrapper.class);
            List idsDocumentos = remessaWrapper.getDocumentos().stream().map(DocumentoCobranca::getIdFinanceiroDado).collect(Collectors.toList());
            this.atualizarStatus(idsDocumentos);
        }
        catch (UnicoMensagemUsuarioException e) {
            this.addMensagemRetorno("Erro ao atualizar o status ap\u00f3s exce\u00e7\u00e3o. " + e.getMessage());
        }
    }

    protected br.intelidata.uniplusweb.web.rest.app.client.thread.Notificacao getNotificacaoSucesso(Task jobExecutor) {
        return new br.intelidata.uniplusweb.web.rest.app.client.thread.Notificacao(TipoNotificacaoSimples.SUCCESS, "Gera\u00e7\u00e3o de remessa conclu\u00edda para envio.");
    }

    protected br.intelidata.uniplusweb.web.rest.app.client.thread.Notificacao getNotificacaoErro(Task task) {
        return new br.intelidata.uniplusweb.web.rest.app.client.thread.Notificacao(TipoNotificacaoSimples.ERROR, "Ocorreu um problema ao gerar as remessas para envio. Por favor, verifique a tarefa para mais detalhes.");
    }

    private ContaCorrenteCarteira getContaCorrenteCarteira(GeracaoRemessaWrapper remessaWrapper, boolean isAsaas) throws UnicoMensagemUsuarioException {
        if (isAsaas) {
            ContaCorrenteCarteira carteira = new ContaCorrenteCarteira();
            carteira.setId(Long.valueOf(-1L));
            carteira.setDescricaoCarteiraBoleto("Carteira de integra\u00e7\u00e3o Asaas");
            carteira.setIdContaCorrente(remessaWrapper.getIdContaCorrenteRemessa());
            carteira.setInativo(false);
            carteira.setEspecie("OUTROS - Outros");
            return carteira;
        }
        ContaCorrenteCarteira contaCarteira = (ContaCorrenteCarteira)ContaCorrenteCarteiraRN.getInstance().buscarPorId(remessaWrapper.getIdCarteira());
        if (contaCarteira == null) {
            List carteiras = ContaCorrenteCarteiraRN.getInstance().buscarListaPorContaCorrente(remessaWrapper.getIdContaCorrenteRemessa(), true);
            if (Util.listNullOrEmpty((List)carteiras) || carteiras.size() > 1) {
                throw new UnicoMensagemUsuarioException("WWW724", "Carteira n\u00e3o encontrada.");
            }
            contaCarteira = (ContaCorrenteCarteira)carteiras.get(0);
        }
        return contaCarteira;
    }

    private void agendarEmail(Sessao sessao, List<Boleto> boletos, HashMap<String, List<Object>> pdfs, BancoOnlineRetorno retorno, NotificacaoCompartilhamento notificacaoCompartilhamento) throws UnicoMensagemUsuarioException {
        this.addMensagemRetorno("Remessa enviada com sucesso para o(s) seguinte(s) endere\u00e7o(s): ");
        ParametrosEmail configuracoesEmail = Email.getParametrosEmail((Sessao)sessao);
        List notificacoes = CobrancaEscrituralRN.getInstance().geraNotificacaoDocumentosWeb(sessao, pdfs, retorno, notificacaoCompartilhamento);
        for (Notificacao n : notificacoes) {
            ParametrosEmailWeb parametro = EmailUtil.getParametros((Sessao)sessao, (ParametrosEmail)configuracoesEmail, (String)n.getFone(), null, (String)n.getAssunto(), (String)n.getMsg());
            parametro.setAnexos(n.getDataSources());
            CreateTaskEmail taskEmail = new CreateTaskEmail(this.taskManager, parametro);
            taskEmail.createTask((Object)parametro, parametro.getAssunto());
        }
        List ids = boletos.stream().map(b -> NumberUtil.toLong((String)b.getIdentificacaoEmpresa())).collect(Collectors.toList());
        this.atualizarStatus(ids);
    }

    private void atualizarStatus(List<Long> ids) {
        ids.forEach(id -> {
            Sql sqlUpdate = new Sql(new UUpdate(FinanceiroDadoRN.getInstance().getTabela(), id, new ColunaUPD[]{new ColunaUPD("statusjob", StatusJobItem.PROCESSADO.getId())}));
            sqlUpdate.executaUpdate();
            sqlUpdate.close();
        });
    }
}

