/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.financeiro.cobrancaescritural.retorno;

import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.sql.usql.ColunaSQL;
import br.intelidata.commons.core.sql.usql.Ordem;
import br.intelidata.commons.core.util.Remessa;
import br.intelidata.commons.domain.pojo.financeiro.cobranca.ArquivoRetorno;
import br.intelidata.commons.domain.regranegocio.AbstractRegraNegocio;
import br.intelidata.commons.modulo.cobrancaescritural.regranegocio.ArquivoRetornoRN;
import br.intelidata.commons.modulo.cobrancaescritural.relatorio.FrancesinhaRelatorio;
import br.intelidata.core.aop.DBAutoCommit;
import br.intelidata.uniplusweb.core.coreinterfaces.SubMenuMapping;
import br.intelidata.uniplusweb.core.grid.GridBuilder;
import br.intelidata.uniplusweb.core.service.ResponseEntityService;
import br.intelidata.uniplusweb.web.rest.app.client.crud.CrudController;
import java.util.ArrayList;
import java.util.Collections;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/arquivos-retorno"})
@SubMenuMapping(MENU="SubMenuFinanceiroCobrancaEscritural", ICONE="icon-gravar", NOME="Consulta de retorno", ROTA="/financeiros/arquivos-retorno", PROGRAMA=423)
public class ArquivoRetornoCrudController
extends CrudController<ArquivoRetorno, ArquivoRetornoRN> {
    private final ResponseEntityService responseEntityService;

    @Autowired
    public ArquivoRetornoCrudController(ResponseEntityService responseEntityService) {
        super((AbstractRegraNegocio)ArquivoRetornoRN.getInstance(), ArquivoRetorno::new);
        this.responseEntityService = responseEntityService;
    }

    @RequestMapping(value={"/imprimir-francesinha"}, method={RequestMethod.POST})
    @DBAutoCommit
    public ResponseEntity<byte[]> imprimirFrancesinha(@RequestBody ArquivoRetorno arquivoRetorno) throws UnicoMensagemUsuarioException {
        Remessa remessa = FrancesinhaRelatorio.getInstance().getRemessa(Collections.singletonList(ArquivoRetornoRN.getInstance().buscarPorId(arquivoRetorno.getId(), true)));
        return this.responseEntityService.createPDFResponse(remessa.getMalote().extrai("pdf"), "francesinha");
    }

    protected String getCacheId() {
        return "arquivos-retorno";
    }

    protected GridBuilder<ArquivoRetornoRN> getGridBuilder() {
        ArrayList<ColunaSQL> colunas = new ArrayList<ColunaSQL>();
        colunas.add(new ColunaSQL("id", "id", 0, false));
        colunas.add(new ColunaSQL("idContaCorrente", "idContaCorrente", 0, false));
        colunas.add(new ColunaSQL("dataLeitura", "Data da leitura", 130, true));
        colunas.add(new ColunaSQL("horaLeitura", "Hora da leitura", 130, true));
        colunas.add(new ColunaSQL("nomeArquivo", "Nome do arquivo", 0, true));
        colunas.add(new ColunaSQL("layout", "layout", 130, true));
        colunas.add(new ColunaSQL("nome", "nomeUsuario", "Usu\u00e1rio", 200, true, new String[]{"fk_arquivoretorno_usuario"}));
        colunas.add(new ColunaSQL("descricao", "descricaoContaCorrente", "Conta corrente", 200, true, new String[]{"fk_arquivoretorno_cc"}));
        GridBuilder grid = new GridBuilder(ArquivoRetornoRN.getInstance().getTabela(), colunas);
        grid.addOrdemDefault(new Ordem("dataLeitura", true));
        grid.addOrdemDefault(new Ordem("horaLeitura", true));
        return grid;
    }
}

