/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.financeiro.cobrancaescritural.retorno;

import br.intelidata.commons.core.sql.model.TipoDadoBase;
import br.intelidata.commons.core.sql.usql.ColunaSQL;
import br.intelidata.commons.core.sql.usql.Condicao;
import br.intelidata.commons.core.sql.usql.Operador;
import br.intelidata.commons.core.sql.usql.Referencia;
import br.intelidata.commons.core.sql.usql.USelect;
import br.intelidata.commons.domain.pojo.financeiro.cobranca.OcorrenciaCobranca;
import br.intelidata.commons.domain.regranegocio.AbstractRegraNegocio;
import br.intelidata.commons.modulo.cobrancaescritural.regranegocio.OcorrenciaCobrancaRN;
import br.intelidata.uniplusweb.core.coreinterfaces.SubMenuMapping;
import br.intelidata.uniplusweb.core.grid.FilterField;
import br.intelidata.uniplusweb.core.grid.GridBuilder;
import br.intelidata.uniplusweb.web.rest.app.client.crud.CrudController;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/ocorrencias-cobranca"})
@SubMenuMapping(MENU="SubMenuFinanceiroCobrancaEscritural", NOME="Documentos cobran\u00e7a", ROTA="/financeiros/arquivos-retorno/:idArquivoRetorno/ocorrencias-cobranca", PROGRAMA=423, CUSTOM_ACTION=true)
public class OcorrenciaCobrancaCrudController
extends CrudController<OcorrenciaCobranca, OcorrenciaCobrancaRN> {
    public OcorrenciaCobrancaCrudController() {
        super((AbstractRegraNegocio)OcorrenciaCobrancaRN.getInstance(), OcorrenciaCobranca::new);
        this.dependsOn("idArquivoRetorno");
    }

    protected void afterLoadGrid(List<ColunaSQL> colunas, List<Object[]> dados, List<FilterField> filters, MultiValueMap<String, String> parameters) {
    }

    protected String getCacheId() {
        return "ocorrencias-cobranca";
    }

    protected GridBuilder<OcorrenciaCobrancaRN> getGridBuilder() {
        ArrayList<ColunaSQL> colunas = new ArrayList<ColunaSQL>();
        colunas.add(new ColunaSQL("id", "id", 0, false));
        colunas.add(new ColunaSQL("idFinanceiroDado", "idFinanceiroDado", 0, false));
        colunas.add(new ColunaSQL("idArquivoRetorno", "idArquivoRetorno", 0, false));
        colunas.add(new ColunaSQL("agencia", "Ag\u00eancia", 100, true));
        colunas.add(new ColunaSQL("banco", "Banco", 100, true));
        colunas.add(new ColunaSQL("carteira", "Cart.", 100, true));
        colunas.add(new ColunaSQL("codigoCedente", "Cod. Cedente", 100, true));
        colunas.add(new ColunaSQL("numeroContaCorrente", "C.C.", 100, true));
        colunas.add(new ColunaSQL("nossoNumero", "Nosso n\u00famero", 120, true));
        colunas.add(new ColunaSQL("numeroDocumento", "N\u00famero documento", 140, true));
        colunas.add(this.geraColunaNomeSacado());
        colunas.add(this.geraColunaValorDocumento());
        colunas.add(new ColunaSQL("valorPago", "Valor pago", 100, true));
        colunas.add(new ColunaSQL("dataVencimento", "Vencimento", 100, true));
        colunas.add(new ColunaSQL("dataCredito", "Data cr\u00e9dito", 100, true));
        colunas.add(new ColunaSQL("dataOcorrencia", "Data ocorr\u00eancia", 100, true));
        colunas.add(new ColunaSQL("codigoOcorrencia", "C\u00f3d ocorr\u00eancia", 100, true));
        colunas.add(new ColunaSQL("motivosOcorrencia", "Motivo ocorr\u00eancia", 140, true));
        colunas.add(new ColunaSQL("valorDesconto", "Desconto", 100, true));
        colunas.add(new ColunaSQL("valorAbatimento", "Abatimento", 100, true));
        colunas.add(new ColunaSQL("valorJurosPago", "Juros pago", 100, true));
        colunas.add(new ColunaSQL("valorMultaPaga", "Multa paga", 100, true));
        colunas.add(new ColunaSQL("valorOutrosAcrescimos", "Outros acresc.", 140, true));
        colunas.add(new ColunaSQL("valorTaxaCobranca", "Taxa cobran\u00e7a", 120, true));
        colunas.add(new ColunaSQL("valorIOF", "Valor IOF", 100, true));
        return new GridBuilder(OcorrenciaCobrancaRN.getInstance().getTabela(), colunas);
    }

    public ColunaSQL geraColunaValorDocumento() {
        USelect uSelect = new USelect("financeiro", "valorDocumento");
        uSelect.add(new ColunaSQL("valor", "valorDocumento"));
        uSelect.add((ColunaSQL)new Referencia("id", "idfinanceiro"));
        uSelect.add(new Condicao("idfinanceiro", Operador.IGUAL_REFERENCIA_EXTERNA, "idFinanceiroDado"));
        uSelect.setLimit(1);
        ColunaSQL colunaValorDocumento = new ColunaSQL(uSelect, "Valor Documento", 140, true);
        colunaValorDocumento.setVirtual(true);
        colunaValorDocumento.setTipoDadoBase(TipoDadoBase.NUMERIC);
        colunaValorDocumento.setClasseValor(BigDecimal.class);
        return colunaValorDocumento;
    }

    public ColunaSQL geraColunaNomeSacado() {
        USelect sqlConsultaNomeSacado = new USelect("financeiro", "nomeSacado");
        sqlConsultaNomeSacado.add(new ColunaSQL("nome", "nomeSacado", new String[]{"fk_financeiro_entidade"}));
        sqlConsultaNomeSacado.add((ColunaSQL)new Referencia("id", "idfinanceiro"));
        sqlConsultaNomeSacado.add(new Condicao("idfinanceiro", Operador.IGUAL_REFERENCIA_EXTERNA, "idFinanceiroDado"));
        sqlConsultaNomeSacado.setLimit(1);
        ColunaSQL colunaNomeSacado = new ColunaSQL(sqlConsultaNomeSacado, "Nome sacado", 250, true);
        colunaNomeSacado.setVirtual(true);
        return colunaNomeSacado;
    }
}

