/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.financeiro.conciliacaorecebimento.filtrogrid;

import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.licenca.LicencaManager;
import br.intelidata.commons.core.sistema.Sessao;
import br.intelidata.commons.core.sql.usql.Condicao;
import br.intelidata.commons.core.sql.usql.Operador;
import br.intelidata.commons.core.util.LogSistema;
import br.intelidata.commons.core.util.Util;
import br.intelidata.commons.domain.pojo.integracao.ConfiguracaoConciliadoraRecebimento;
import br.intelidata.commons.modulo.financeiro.regranegocio.ConfiguracaoConciliadoraRecebimentoFilialRN;
import br.intelidata.uniplusweb.core.grid.CustomFilterGrid;
import br.intelidata.uniplusweb.core.grid.FilterField;
import br.intelidata.uniplusweb.core.grid.Grid;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class FiltroGridFilial
implements CustomFilterGrid {
    public void addFilter(Grid<?> grid, List<FilterField> filters) {
        FilterField filtroIdFilial = this.getFiltro("idFilial", filters);
        if (filtroIdFilial != null) {
            List<Long> ids = Stream.of(filtroIdFilial.getValue1().split(",")).map(Long::parseLong).collect(Collectors.toList());
            ids.add(-1L);
            grid.getGridBuilder().addCondicao(new Condicao("idFilial", Operador.CONTIDO_EM, ids.toArray(new Long[0])));
            this.removeFiltro("idFilial", filters);
        } else {
            try {
                ConfiguracaoConciliadoraRecebimento configuracao;
                Sessao sessao = SessaoUtil.getSessao();
                if (LicencaManager.getInstance().isEnterprise() && ConfiguracaoConciliadoraRecebimentoFilialRN.getInstance().isPossuiMaisDeUmaFilialLicenciadaHabilitada(sessao) && (configuracao = ConfiguracaoConciliadoraRecebimentoFilialRN.getInstance().getConfiguracao(sessao)) != null && !Util.listNullOrEmpty((List)configuracao.getIdsFiliais())) {
                    grid.getGridBuilder().addCondicao(new Condicao("idFilial", Operador.CONTIDO_EM, configuracao.getIdsFiliais().toArray(new Long[0])));
                }
            }
            catch (UnicoMensagemUsuarioException ex) {
                LogSistema.escreveErroFatal((Throwable)ex);
            }
        }
    }
}

