/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.financeiro.lancamento;

import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.sistema.Contexto;
import br.intelidata.commons.core.sql.usql.ColunaSQL;
import br.intelidata.commons.core.sql.usql.Condicao;
import br.intelidata.commons.core.sql.usql.Operador;
import br.intelidata.commons.core.sql.usql.Referencia;
import br.intelidata.commons.core.util.DataHoraFactory;
import br.intelidata.commons.domain.pojo.EventoFinanceiro;
import br.intelidata.commons.domain.pojo.FinanceiroLancamento;
import br.intelidata.commons.domain.pojo.Operacao;
import br.intelidata.commons.domain.pojo.enuns.StatusEvento;
import br.intelidata.commons.domain.pojo.enuns.TipoEventoFinanceiro;
import br.intelidata.commons.domain.pojo.financeiro.NegociacaoFinanceiro;
import br.intelidata.commons.domain.pojo.financeiro.TipoFinanceiro;
import br.intelidata.commons.domain.regranegocio.AbstractRegraNegocio;
import br.intelidata.commons.modulo.financeiro.regranegocio.EventoFinanceiroRN;
import br.intelidata.commons.modulo.financeiro.regranegocio.FinanceiroLancamentoRN;
import br.intelidata.commons.modulo.financeiro.regranegocio.NegociacaoFinanceiroRN;
import br.intelidata.commons.modulo.pdv.regranegocio.OperacaoRN;
import br.intelidata.core.aop.DBAutoCommit;
import br.intelidata.core.aop.DBTransaction;
import br.intelidata.uniplusweb.core.grid.FilterField;
import br.intelidata.uniplusweb.core.grid.GridBuilder;
import br.intelidata.uniplusweb.web.rest.app.client.crud.CrudController;
import br.intelidata.uniplusweb.web.rest.app.crud.financeiro.lancamento.AcaoUsuarioWrapper;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/financeiros-lancamentos"})
public class FinanceiroLancamentoCrudController
extends CrudController<FinanceiroLancamento, FinanceiroLancamentoRN> {
    public FinanceiroLancamentoCrudController() {
        super((AbstractRegraNegocio)FinanceiroLancamentoRN.getInstance(), FinanceiroLancamento::new, true, true);
    }

    @RequestMapping(value={"/validar-estorno"})
    @DBAutoCommit
    public AcaoUsuarioWrapper validarEstorno(@RequestParam Long idEvento) throws UnicoMensagemUsuarioException {
        EventoFinanceiro eventoFinanceiro = EventoFinanceiroRN.getInstance().buscarPorId(idEvento);
        if (eventoFinanceiro != null) {
            if (EventoFinanceiroRN.getInstance().podeEstornarBaixa(eventoFinanceiro)) {
                if (eventoFinanceiro.getOrigem() == 1 && eventoFinanceiro.getTipoevento().equals(TipoEventoFinanceiro.BAIXA.getId())) {
                    return new AcaoUsuarioWrapper(false, null, "FIN97".concat(" - ").concat(this.getMensagemEstornoPDV(eventoFinanceiro.getIdOrigem().longValue())));
                }
                NegociacaoFinanceiro negociacao = NegociacaoFinanceiroRN.getInstance().buscarNegociacaoPorEventoFinanceiro(idEvento);
                if (negociacao != null) {
                    return new AcaoUsuarioWrapper(false, "FIN99 - Este lan\u00e7amento foi originado da negocia\u00e7\u00e3o " + negociacao.getId() + "! Deseja estornar esta negocia\u00e7\u00e3o?");
                }
                return new AcaoUsuarioWrapper(true);
            }
            return new AcaoUsuarioWrapper(false, "", "WFIN100 - Existem documentos com lan\u00e7amentos que impedem o estorno");
        }
        return new AcaoUsuarioWrapper(false, "", "FIN300 - Lan\u00e7amento n\u00e3o encontrado");
    }

    @RequestMapping(value={"/estornar"})
    @DBTransaction
    public boolean estornar(@RequestParam Long idEvento) throws UnicoMensagemUsuarioException {
        EventoFinanceiro eventoFinanceiro = EventoFinanceiroRN.getInstance().buscarPorId(idEvento);
        if (eventoFinanceiro != null) {
            if (EventoFinanceiroRN.getInstance().podeEstornarBaixa(eventoFinanceiro)) {
                if (eventoFinanceiro.getOrigem() == 1 && eventoFinanceiro.getTipoevento().equals(TipoEventoFinanceiro.BAIXA.getId())) {
                    throw new UnicoMensagemUsuarioException("FIN301", this.getMensagemEstornoPDV(eventoFinanceiro.getIdOrigem().longValue()));
                }
                NegociacaoFinanceiro negociacao = NegociacaoFinanceiroRN.getInstance().buscarNegociacaoPorEventoFinanceiro(idEvento);
                if (negociacao != null) {
                    NegociacaoFinanceiroRN.getInstance().estornarNegociacao(Contexto.getInstance().getSessao(), negociacao.getId());
                } else {
                    EventoFinanceiroRN.getInstance().estornaBaixa(eventoFinanceiro, Contexto.getInstance().getSessao());
                }
            } else {
                throw new UnicoMensagemUsuarioException("WFIN100", "Existem documentos com lan\u00e7amentos que impedem o estorno");
            }
        }
        return true;
    }

    protected void afterLoadGrid(List<ColunaSQL> colunas, List<Object[]> dados, List<FilterField> filters, MultiValueMap<String, String> parameters) throws UnicoMensagemUsuarioException {
        dados.forEach(registro -> {
            LocalDate ldBaixa2;
            LocalDate ldBaixa;
            EventoFinanceiro evento;
            Date baixa2 = (Date)registro[this.getIndexColuna("baixa2", colunas)];
            Long idEvento = (Long)registro[this.getIndexColuna("evento", colunas)];
            if (baixa2 != null && (evento = EventoFinanceiroRN.getInstance().buscarPorId(idEvento)) != null && (TipoEventoFinanceiro.ACRESCIMO.getId().equals(evento.getTipoevento()) || TipoEventoFinanceiro.BAIXA.getId().equals(evento.getTipoevento())) && (ldBaixa = DataHoraFactory.date2LocalDate((Date)((Date)registro[this.getIndexColuna("baixa", colunas)]))).compareTo(ldBaixa2 = DataHoraFactory.date2LocalDate((Date)baixa2)) != 0) {
                registro[this.getIndexColuna((String)"baixa", (List)colunas)] = baixa2;
            }
        });
    }

    protected GridBuilder<FinanceiroLancamentoRN> getGridBuilder() {
        ColunaSQL colunaJuros = new ColunaSQL("juros", "Juros", 75, true);
        colunaJuros.setTotalizar(true);
        ColunaSQL colunaMulta = new ColunaSQL("multa", "Multa", 75, true);
        colunaMulta.setTotalizar(true);
        ColunaSQL colunaDesconto = new ColunaSQL("desconto", "Desconto", 105, true);
        colunaDesconto.setTotalizar(true);
        ColunaSQL colunaAcrescimo = new ColunaSQL("acrescimo", "Acr\u00e9scimo", 105, true);
        colunaAcrescimo.setTotalizar(true);
        ColunaSQL colunaDevolucao = new ColunaSQL("valorDevolucao", "valorDevolucao", "Devolu\u00e7\u00e3o", 105, true, new String[0]);
        colunaDevolucao.setTotalizar(true);
        ColunaSQL colunaValorPago = new ColunaSQL("valor", "valor", "Pago", 75, true, new String[0]);
        colunaValorPago.setTotalizar(true);
        ColunaSQL colunaValorBaixa = new ColunaSQL("valorBaixa", "valorBaixa", "Baixado", 75, true, new String[0]);
        colunaValorBaixa.setTotalizar(true);
        ColunaSQL colunaValorSubstituido = new ColunaSQL("valorSubstituido", "valorSubstituido", "Substitu\u00eddo", 120, true, new String[0]);
        colunaValorSubstituido.setTotalizar(true);
        ColunaSQL colunaReabertura = new ColunaSQL("reabertura", "Reabertura", 100, true);
        colunaReabertura.setTotalizar(true);
        ColunaSQL colunaTipoFinanceiro = new ColunaSQL("tipo", "tipoFinanceiro", "Id", 0, false, new String[]{"fk_financeirolancamento_fin"});
        colunaTipoFinanceiro.setClasseEnum(TipoFinanceiro.class);
        ArrayList<ColunaSQL> colunas = new ArrayList<ColunaSQL>();
        colunas.add(new ColunaSQL("evento", "Id", 0, false));
        colunas.add(colunaTipoFinanceiro);
        colunas.add(new ColunaSQL("baixa2", "Baixa 2", 0, false));
        colunas.add(new ColunaSQL("pagamento", "Pagamento", 120, true));
        colunas.add(new ColunaSQL("baixa", "Baixa / Entrada", 120, true));
        colunas.add(new ColunaSQL("valoranterior", "valoranterior", "Saldo anterior", 120, true, new String[0]));
        colunas.add(colunaJuros);
        colunas.add(colunaMulta);
        colunas.add(colunaDesconto);
        colunas.add(colunaAcrescimo);
        colunas.add(colunaDevolucao);
        colunas.add(colunaValorPago);
        colunas.add(colunaValorBaixa);
        colunas.add(colunaValorSubstituido);
        colunas.add(colunaReabertura);
        colunas.add(new ColunaSQL("historico", "Hist\u00f3rico", 200, true));
        colunas.add(new ColunaSQL("observacao", "Observa\u00e7\u00e3o", 200, true));
        GridBuilder grid = new GridBuilder(FinanceiroLancamentoRN.getInstance().getTabela(), colunas);
        grid.addReferenciaDefault(new Referencia("status", "status", new String[]{"fk_finlan_evento"}));
        grid.addReferenciaDefault(new Referencia("idfinanceiro"));
        grid.addCodicaoDefault(new Condicao("status", Operador.DIFERENTE, StatusEvento.ESTORNADO.getId()));
        return grid;
    }

    protected String getCacheId() {
        return "financeiros-lancamentos";
    }

    private String getMensagemEstornoPDV(long idOrigem) {
        String msg = "Estorno n\u00e3o permitido.";
        Operacao operacao = (Operacao)OperacaoRN.getInstance().buscarPorId(Long.valueOf(idOrigem));
        if (operacao != null) {
            msg = "Para estornar o documento PDV: " + operacao.getPdv() + ", ";
            msg = operacao.isNfce() ? (operacao.getModeloNfce().equals("65") ? msg + "N\u00ba NFCe: " + operacao.getNumeroNfce() + ", acessar PDV > Fiscal > Consulta NFC-e" : msg + "N\u00ba SAT: " + operacao.getNumeroNfce() + ", acessar PDV > Fiscal > Consulta CF-e") : msg + "COO: " + operacao.getCoo() + ", acessar PDV > Geral > Opera\u00e7\u00f5es realizadas";
        }
        return msg;
    }
}

