/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.fiscal;

import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.sql.usql.ColunaSQL;
import br.intelidata.commons.core.util.EnumSimNao;
import br.intelidata.commons.domain.pojo.fiscal.ClassificacaoTributariaIbsCbs;
import br.intelidata.commons.domain.regranegocio.AbstractRegraNegocio;
import br.intelidata.commons.modulo.fiscal.regranegocio.ClassificacaoTributariaIbsCbsRN;
import br.intelidata.core.aop.DBAutoCommit;
import br.intelidata.uniplusweb.core.coreinterfaces.SubMenuMapping;
import br.intelidata.uniplusweb.core.grid.GridBuilder;
import br.intelidata.uniplusweb.web.rest.app.client.crud.CrudController;
import java.util.ArrayList;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/classificacoes-tributarias"})
@SubMenuMapping(MENU="SubMenuFiscalAuxiliarParametrosNotaFiscal", PROGRAMA=1516, NOME="Classifica\u00e7\u00f5es tribut\u00e1rias do IBS e CBS", ROTA="/notas-fiscais/classificacoes-tributarias")
public class ClassificacaoTributariaIbsCbsCrudController
extends CrudController<ClassificacaoTributariaIbsCbs, ClassificacaoTributariaIbsCbsRN> {
    public ClassificacaoTributariaIbsCbsCrudController() {
        super((AbstractRegraNegocio)ClassificacaoTributariaIbsCbsRN.getInstance(), ClassificacaoTributariaIbsCbs::new);
    }

    protected GridBuilder<ClassificacaoTributariaIbsCbsRN> getGridBuilder() {
        ArrayList<ColunaSQL> colunas = new ArrayList<ColunaSQL>();
        colunas.add(new ColunaSQL("id", "ID", 0, false));
        colunas.add(new ColunaSQL("codigo", "C\u00f3digo", 100, true));
        colunas.add(new ColunaSQL("cst", "CST", 300, true));
        colunas.add(new ColunaSQL("nome", "Nome", 0, true));
        colunas.add(new ColunaSQL("dataInicioVigencia", "In\u00edcio da vig\u00eancia", 150, true));
        colunas.add(new ColunaSQL("dataFimVigencia", "Fim da vig\u00eancia", 150, true));
        colunas.add(new ColunaSQL("dataAtualizacao", "Atualiza\u00e7\u00e3o", 120, true));
        colunas.add(new ColunaSQL("grupoTributacaoRegular", "Tem tributa\u00e7\u00e3o regular", 0, false, EnumSimNao.class));
        return new GridBuilder(ClassificacaoTributariaIbsCbsRN.getInstance().getTabela(), colunas);
    }

    protected String getCacheId() {
        return "classificacoes-tributarias";
    }

    @GetMapping(value={"/validar-licenca-rtc"})
    @DBAutoCommit
    public boolean validarLicencaRTC() throws UnicoMensagemUsuarioException {
        return ClassificacaoTributariaIbsCbsRN.getInstance().habilitarIbsCbs(SessaoUtil.getSessao().getFilial());
    }

    @GetMapping(value={"/validar-licenca-rtc-compativel-filial"})
    @DBAutoCommit
    public void validarLicencaRTCCompativelComFilial() throws UnicoMensagemUsuarioException {
        ClassificacaoTributariaIbsCbsRN.getInstance().validarLicenciamento(SessaoUtil.getSessao().getFilial());
    }
}

