/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.geracaosped;

import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.util.DataHoraFactory;
import br.intelidata.commons.domain.pojo.batch.JobMetadata;
import br.intelidata.commons.domain.pojo.batch.Task;
import br.intelidata.commons.sped.fiscal.GeracaoSpedFiscalRN;
import br.intelidata.commons.sped.fiscal.RegistroSpedFiscalAnotacao;
import br.intelidata.commons.sped.fiscal.SpedException;
import br.intelidata.uniplusweb.core.util.StringUtil;
import br.intelidata.uniplusweb.web.rest.app.client.thread.JobSpedSintegra;
import br.intelidata.uniplusweb.web.rest.app.client.thread.Notificacao;
import br.intelidata.uniplusweb.web.rest.app.crud.geracaosped.GeradorSpedFiscalWrapper;
import java.time.temporal.Temporal;

public class JobGeracaoSped
extends JobSpedSintegra {
    public JobGeracaoSped(String parameters, JobMetadata metadata) {
        super(parameters, metadata);
    }

    public void execute() throws Exception {
        GeradorSpedFiscalWrapper geracaoSped = (GeradorSpedFiscalWrapper)this.getObjetoDeserializado(GeradorSpedFiscalWrapper.class);
        this.nomeArquivo = "sped-" + StringUtil.formataDataHora((Temporal)DataHoraFactory.getDataHora(), (String)"dd-MM-yyyy_HHmmss");
        try {
            this.remessa = GeracaoSpedFiscalRN.getInstance().geraArquivo(geracaoSped.getDataInicial(), geracaoSped.getDataFinal(), this.nomeArquivo, geracaoSped.getFinalidadeArquivo(), geracaoSped.isGeraDadosCartaoCreditoDebito(), geracaoSped.getTipoCalculoCusto(), geracaoSped.getMotivoInventario(), geracaoSped.getDataInventario(), geracaoSped.getTipoGeracaoInventario(), geracaoSped.isEnviarProdutosInativos(), geracaoSped.isSubstituiCsonPor900(), geracaoSped.isGerar1400(), SessaoUtil.getSessao(), geracaoSped.isExportacaoJB(), geracaoSped.getTiposProduto(), geracaoSped.getTiposProdutoBlocoK(), geracaoSped.isEnviarInativosBlocoK(), geracaoSped.isGerar0210(), false, false, geracaoSped.isValidarSaltoNumeracao(), geracaoSped.isGeraDadosDesmontagemBlocoK(), geracaoSped.isEnviarCodigoBarras0220(), geracaoSped.isGerarRegistro1601(), geracaoSped.getTipoBlocok(), geracaoSped.getTipo1601List(), geracaoSped.getTipoOperacao1601(), geracaoSped.getTipoImpressao1601(), geracaoSped.isExportarSufixoCfop());
            this.temErro = this.remessa.getMalote().contem("pdf");
            if (this.temErro) {
                this.addMensagemRetorno("Arquivo do SPED gerado com exce\u00e7\u00f5es");
            } else {
                this.addMensagemRetorno("Arquivo gerado com sucesso.");
            }
        }
        catch (SpedException e) {
            String message;
            if (e.getClasse().isAnnotationPresent(RegistroSpedFiscalAnotacao.class)) {
                RegistroSpedFiscalAnotacao anotacao = e.getClasse().getAnnotation(RegistroSpedFiscalAnotacao.class);
                message = "Registro: " + anotacao.registro() + " - " + anotacao.descricao() + ". Erro: " + e.getMensagemSemCodigoDeErro();
            } else {
                message = e.getMensagemSemCodigoDeErro();
            }
            throw new UnicoMensagemUsuarioException("COM236582", message);
        }
        this.saveFile(this.getFile());
    }

    public void onFailure(Exception ex) {
    }

    protected Notificacao getNotificacaoSucesso(Task task) {
        String msg = this.temErro ? "Arquivo do SPED gerado com exce\u00e7\u00f5es" : "Arquivo de sped gerado com sucesso";
        return new Notificacao(msg);
    }

    protected Notificacao getNotificacaoErro(Task task) {
        return new Notificacao("Falhou ao executar o sped " + task.getResumo());
    }
}

