/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.geracaospedcontribuicoes;

import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.util.DataHoraFactory;
import br.intelidata.commons.domain.pojo.Filial;
import br.intelidata.commons.domain.pojo.batch.JobMetadata;
import br.intelidata.commons.domain.pojo.batch.Task;
import br.intelidata.commons.domain.regranegocio.FilialCommonRN;
import br.intelidata.commons.sped.contribuicoes.GeracaoSpedPisCofinsRN;
import br.intelidata.commons.sped.contribuicoes.IndicadorIncidenciaTributaria;
import br.intelidata.commons.sped.contribuicoes.interfaces.EnvioNotasEntrada;
import br.intelidata.commons.sped.fiscal.RegistroSpedFiscalAnotacao;
import br.intelidata.commons.sped.fiscal.SpedException;
import br.intelidata.uniplusweb.core.util.StringUtil;
import br.intelidata.uniplusweb.web.rest.app.client.thread.JobSpedSintegra;
import br.intelidata.uniplusweb.web.rest.app.client.thread.Notificacao;
import br.intelidata.uniplusweb.web.rest.app.crud.geracaospedcontribuicoes.SpedContribuicoesWrapper;
import java.time.temporal.Temporal;

public class JobGeracaoSpedContribuicoes
extends JobSpedSintegra {
    public JobGeracaoSpedContribuicoes(String parameters, JobMetadata metadata) {
        super(parameters, metadata);
    }

    protected Notificacao getNotificacaoSucesso(Task task) {
        String msg = this.temErro ? "Arquivo do SPED contribui\u00e7\u00f5es gerado com exce\u00e7\u00f5es" : "Arquivo de SPED contribui\u00e7\u00f5es gerado com sucesso";
        return new Notificacao(msg);
    }

    protected Notificacao getNotificacaoErro(Task task) {
        return new Notificacao("Falhou ao executar o SPED contribui\u00e7\u00f5es " + task.getResumo());
    }

    public void onFailure(Exception ex) {
    }

    public void execute() throws Exception {
        SpedContribuicoesWrapper spedContribuicao = (SpedContribuicoesWrapper)this.getObjetoDeserializado(SpedContribuicoesWrapper.class);
        this.nomeArquivo = "sped-contribuicoes-" + StringUtil.formataDataHora((Temporal)DataHoraFactory.getDataHora(), (String)"dd-MM-yyyy_HHmmss");
        try {
            EnvioNotasEntrada finalidadeNotas = this.permiteTrocarEnvioEntrada() ? spedContribuicao.getFinalidadeNotas() : EnvioNotasEntrada.ENVIAR_NOTAS;
            this.remessa = GeracaoSpedPisCofinsRN.getInstance().geraSped(this.nomeArquivo, spedContribuicao.getDataInicial(), spedContribuicao.getDataFinal(), spedContribuicao.getFinalidadeArquivo(), spedContribuicao.getNumeroReciboAnterior(), spedContribuicao.getSituacaoEspecial(), finalidadeNotas, SessaoUtil.getSessao());
            this.temErro = this.remessa.getMalote().contem("pdf");
            if (this.temErro) {
                this.addMensagemRetorno("Arquivo do SPED contribui\u00e7\u00f5es gerado com exce\u00e7\u00f5es");
            } else {
                this.addMensagemRetorno("Arquivo gerado com sucesso.");
            }
        }
        catch (SpedException e) {
            String message;
            if (e.getClasse().isAnnotationPresent(RegistroSpedFiscalAnotacao.class)) {
                RegistroSpedFiscalAnotacao anotacao = e.getClasse().getAnnotation(RegistroSpedFiscalAnotacao.class);
                message = "Registro: " + anotacao.registro() + " - " + anotacao.descricao() + "\nErro: " + e.getMessage();
            } else {
                message = e.getMessage();
            }
            throw new UnicoMensagemUsuarioException("WCOM147", message);
        }
        this.saveFile(this.getFile());
    }

    private boolean permiteTrocarEnvioEntrada() throws UnicoMensagemUsuarioException {
        Filial matriz = FilialCommonRN.getInstance().getMatrizDaFilialAtual(SessaoUtil.getSessao());
        return matriz != null && IndicadorIncidenciaTributaria.CUMULATIVO_2.equals((Object)matriz.getParametroSpedPisCofins().getIncidenciaTributaria());
    }
}

