/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.ibpt;

import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.sql.usql.ColunaSQL;
import br.intelidata.commons.core.sql.usql.Condicao;
import br.intelidata.commons.core.sql.usql.Operador;
import br.intelidata.commons.core.sql.usql.Referencia;
import br.intelidata.commons.domain.pojo.Ibpt;
import br.intelidata.commons.domain.pojo.enuns.TipoRegistroNcm;
import br.intelidata.commons.domain.regranegocio.AbstractRegraNegocio;
import br.intelidata.commons.modulo.produto.regranegocio.IbptRN;
import br.intelidata.uniplusweb.core.coreinterfaces.SubMenuMapping;
import br.intelidata.uniplusweb.core.grid.GridBuilder;
import br.intelidata.uniplusweb.core.util.NumberUtil;
import br.intelidata.uniplusweb.core.util.StringUtil;
import br.intelidata.uniplusweb.web.rest.app.client.crud.CrudController;
import java.util.ArrayList;
import java.util.Optional;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/tabelas-ibpt"})
@SubMenuMapping(MENU="SubMenuFiscalAuxiliarParametrosNotaFiscal", NOME="Ibpt", ROTA="/notas-fiscais/tabelas-ibpt", PROGRAMA=1000031)
public class IbptCrudController
extends CrudController<Ibpt, IbptRN> {
    public IbptCrudController() {
        super((AbstractRegraNegocio)IbptRN.getInstance(), Ibpt::new, true, true);
    }

    public GridBuilder<IbptRN> getGridBuilder() {
        ArrayList<ColunaSQL> colunas = new ArrayList<ColunaSQL>();
        colunas.add(new ColunaSQL("id", "ID", 0, false));
        colunas.add(new ColunaSQL("codigo", "C\u00f3digo", 120, true));
        colunas.add(new ColunaSQL("registroNcm", "Registro NCM", 200, true, TipoRegistroNcm.class));
        colunas.add(new ColunaSQL("descricao", "Descri\u00e7\u00e3o", 0, true));
        GridBuilder grid = new GridBuilder(IbptRN.getInstance().getTabela(), colunas);
        grid.addReferenciaDefault(new Referencia("idEstado"));
        grid.addCodicaoDefault(new Condicao("idEstado", Operador.IGUAL, SessaoUtil.getSessao().getFilial().getIdEstado()));
        return grid;
    }

    protected String getCacheId() {
        return "tabelas-ibpt".concat("_").concat(SessaoUtil.getSessao().getFilial().getIdEstado().toString());
    }

    protected void beforeSave(Ibpt ibpt, Optional<Long> parentId) throws UnicoMensagemUsuarioException {
        if (StringUtil.stringNullOrEmpty((String)ibpt.getCodigo())) {
            throw new UnicoMensagemUsuarioException("WWW77", "C\u00f3digo n\u00e3o informado.");
        }
        if (ibpt.getDataInicio() == null || ibpt.getDataFim() == null) {
            throw new UnicoMensagemUsuarioException("WWW78", "Data de inicio e fim devem ser informadas.");
        }
        if (NumberUtil.longNullOuZero((Long)ibpt.getIdEstado())) {
            throw new UnicoMensagemUsuarioException("WWW79", "Estado n\u00e3o informado.");
        }
    }
}

