/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.importarnota.importacaoxml;

import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.documentosfiscais.common.enums.TipoImportacaoXML;
import br.intelidata.commons.core.documentosfiscais.sefaz.nfe.pojo.CadastroRealizadoImportacaoXML;
import br.intelidata.commons.core.documentosfiscais.sefaz.nfe.pojo.DocumentoNFeImportadoXML;
import br.intelidata.commons.core.documentosfiscais.sefaz.nfe.pojo.ItemImportadoXML;
import br.intelidata.commons.core.documentosfiscais.sefaz.nfe.pojo.StatusDetalheItemImportacaoXML;
import br.intelidata.commons.core.documentosfiscais.sefaz.nfe.pojo.StatusItemImportacaoXML;
import br.intelidata.commons.core.documentosfiscais.util.Danfe2;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.sistema.PropriedadeRN;
import br.intelidata.commons.core.sistema.Sessao;
import br.intelidata.commons.core.sistema.UnicoSistema;
import br.intelidata.commons.core.util.CacheSistema;
import br.intelidata.commons.core.util.Util;
import br.intelidata.commons.domain.pojo.AbstractPojo;
import br.intelidata.commons.domain.pojo.CondicaoPagamento;
import br.intelidata.commons.domain.pojo.DescontoInterface;
import br.intelidata.commons.domain.pojo.DetalheImportacaoXML;
import br.intelidata.commons.domain.pojo.DetalheImportacaoXMLCfop;
import br.intelidata.commons.domain.pojo.DetalheImportacaoXMLDiferencaCadastro;
import br.intelidata.commons.domain.pojo.DetalheImportacaoXMLEanEmbalagem;
import br.intelidata.commons.domain.pojo.DetalheImportacaoXMLEstadoTransportador;
import br.intelidata.commons.domain.pojo.DetalheImportacaoXMLNumeroSerie;
import br.intelidata.commons.domain.pojo.DetalheImportacaoXMLOperacaoFiscal;
import br.intelidata.commons.domain.pojo.DetalheImportacaoXMLProduto;
import br.intelidata.commons.domain.pojo.DetalheImportacaoXMLServico;
import br.intelidata.commons.domain.pojo.DetalheImportacaoXMLVariacao;
import br.intelidata.commons.domain.pojo.Entidade;
import br.intelidata.commons.domain.pojo.Estado;
import br.intelidata.commons.domain.pojo.ImportacaoXmlNotaFiscal;
import br.intelidata.commons.domain.pojo.ItemCriticaImportacaoImpostosXmlNfe;
import br.intelidata.commons.domain.pojo.ItemKit;
import br.intelidata.commons.domain.pojo.ModeloNotaFiscal;
import br.intelidata.commons.domain.pojo.NaturezaOperacao;
import br.intelidata.commons.domain.pojo.OperacaoFiscal;
import br.intelidata.commons.domain.pojo.ParametrosNotaFiscalInterface;
import br.intelidata.commons.domain.pojo.ProdutoDTOWeb;
import br.intelidata.commons.domain.pojo.ProdutoItem;
import br.intelidata.commons.domain.pojo.Unidademedida;
import br.intelidata.commons.domain.pojo.enuns.CstPisCofins;
import br.intelidata.commons.domain.pojo.enuns.EnumUtils;
import br.intelidata.commons.domain.pojo.enuns.FinalidadeEmissaoNfeCFOP;
import br.intelidata.commons.domain.pojo.enuns.StatusImportacaoXMLNotaFiscal;
import br.intelidata.commons.domain.pojo.enuns.StatusNotaFiscal;
import br.intelidata.commons.domain.pojo.enuns.TipoAcaoDetalheImportacaoXML;
import br.intelidata.commons.domain.pojo.enuns.TipoAcaoImportacaoImpostosXmlNfe;
import br.intelidata.commons.domain.pojo.enuns.TipoCriticaImportacaoImpostosXmlNfe;
import br.intelidata.commons.domain.pojo.enuns.TipoEmissaoNotaFiscal;
import br.intelidata.commons.domain.pojo.enuns.TipoKit;
import br.intelidata.commons.domain.pojo.enuns.TipoLogAcaoUsuario;
import br.intelidata.commons.domain.pojo.enuns.TipoNotaFiscal;
import br.intelidata.commons.domain.pojo.enuns.TipoValorPreco;
import br.intelidata.commons.domain.pojo.enuns.notafiscal.SituacaoDocumentoFiscalFornecedor;
import br.intelidata.commons.domain.pojo.enuns.notafiscal.TipoCalculoImposto;
import br.intelidata.commons.domain.pojo.notafiscal.DocumentoFiscalFornecedor;
import br.intelidata.commons.domain.pojo.notafiscal.ItemTributavelInterface;
import br.intelidata.commons.domain.pojo.notafiscal.NotaFiscal;
import br.intelidata.commons.domain.pojo.notafiscal.NotaFiscalItem;
import br.intelidata.commons.domain.regranegocio.DescontoRN;
import br.intelidata.commons.domain.regranegocio.ProdutoItemRN;
import br.intelidata.commons.domain.regranegocio.notafiscal.CalculoImposto;
import br.intelidata.commons.domain.regranegocio.notafiscal.CalculoRateioKitEntradaTerceiros;
import br.intelidata.commons.modulo.cadastros.regranegocio.EstadoRN;
import br.intelidata.commons.modulo.entidade.regranegocio.EntidadeRN;
import br.intelidata.commons.modulo.notafiscal.nfe.NfeManagerWeb;
import br.intelidata.commons.modulo.notafiscal.regranegocio.DocumentoDestinadoRN;
import br.intelidata.commons.modulo.notafiscal.regranegocio.DocumentoFiscalFornecedorRN;
import br.intelidata.commons.modulo.notafiscal.regranegocio.GeradorXMLParaNotaFiscal2;
import br.intelidata.commons.modulo.notafiscal.regranegocio.GeradorXMLParaNotaFiscalImpostos;
import br.intelidata.commons.modulo.notafiscal.regranegocio.LogAcaoUsuarioRN;
import br.intelidata.commons.modulo.notafiscal.regranegocio.NaturezaOperacaoRN;
import br.intelidata.commons.modulo.notafiscal.regranegocio.NotaFiscalItemRN;
import br.intelidata.commons.modulo.notafiscal.regranegocio.OperacaoFiscalRN;
import br.intelidata.commons.modulo.notafiscal.regranegocio.ValidadorXMLEntradaImpostos;
import br.intelidata.commons.modulo.produto.regranegocio.GeradorKitVendaNotaFiscal;
import br.intelidata.commons.modulo.produto.regranegocio.ImportacaoXmlNotaFiscalRN;
import br.intelidata.commons.modulo.produto.regranegocio.KitRN;
import br.intelidata.commons.modulo.produto.regranegocio.ProdutoRN;
import br.intelidata.commons.modulo.produto.regranegocio.UnidademedidaRN;
import br.intelidata.commons.modulo.vendas.regranegocio.PromocaoRN;
import br.intelidata.core.aop.DBAutoCommit;
import br.intelidata.core.aop.DBTransaction;
import br.intelidata.uniplusweb.core.coreinterfaces.SubMenuMapping;
import br.intelidata.uniplusweb.core.service.ResponseEntityService;
import br.intelidata.uniplusweb.core.util.ListMapUtil;
import br.intelidata.uniplusweb.core.util.NumberUtil;
import br.intelidata.uniplusweb.core.util.StringUtil;
import br.intelidata.uniplusweb.service.socket.NotificationService;
import br.intelidata.uniplusweb.service.socket.NotificationType;
import br.intelidata.uniplusweb.web.rest.app.crud.importarnota.importacaoxml.ConfiguracaoImportacaoXmlWrapper;
import br.intelidata.uniplusweb.web.rest.app.crud.importarnota.importacaoxml.ValidadorXmlEntradaWeb;
import br.intelidata.uniplusweb.web.rest.app.crud.importarnota.importacaoxml.wrapper.IcmsImportacaoXMLWrapper;
import br.intelidata.uniplusweb.web.rest.app.crud.importarnota.importacaoxml.wrapper.IcmsStImportacaoXMLWrapper;
import br.intelidata.uniplusweb.web.rest.app.crud.importarnota.importacaoxml.wrapper.ImportacaoXmlDetalheWrapper;
import br.intelidata.uniplusweb.web.rest.app.crud.importarnota.importacaoxml.wrapper.ImportacaoXmlGestaoWrapper;
import br.intelidata.uniplusweb.web.rest.app.crud.importarnota.importacaoxml.wrapper.ImportacaoXmlImpostoWrapper;
import br.intelidata.uniplusweb.web.rest.app.crud.importarnota.importacaoxml.wrapper.ImportacaoXmlNotaFiscalWrapper;
import br.intelidata.uniplusweb.web.rest.app.crud.importarnota.importacaoxml.wrapper.ImportacaoXmlWrapper;
import br.intelidata.uniplusweb.web.rest.app.crud.importarnota.importacaoxml.wrapper.IpiImportacaoXMLWrapper;
import br.intelidata.uniplusweb.web.rest.app.crud.importarnota.importacaoxml.wrapper.PisCofinsImportacaoXMLWrapper;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/api/importacoes-xmls"})
@SubMenuMapping(MENU="SubMenuFiscalGeral", NOME="Importa\u00e7\u00e3o de NF-e do fornecedor", ICONE="icon-importar", ROTA="/importacoes-xmls-module/importacoes-xmls", PROGRAMA=230)
public class ImportacaoXmlController {
    private final ResponseEntityService responseEntityService;
    private final NotificationService notificationService;

    public ImportacaoXmlController(ResponseEntityService responseEntityService, NotificationService notificationService) {
        this.responseEntityService = responseEntityService;
        this.notificationService = notificationService;
    }

    @RequestMapping(value={"/download-xml-sefaz"}, method={RequestMethod.POST})
    @DBTransaction
    public ResponseEntity<byte[]> downloadNfePorChave(@RequestBody String chave, @RequestParam(required=false) Long idDocDestinado) throws UnicoMensagemUsuarioException {
        if (chave == null || chave.length() < 44) {
            throw new UnicoMensagemUsuarioException("WWW484", "O campo 'Chave da NF-e na SEFAZ' deve ter 44 d\u00edgitos");
        }
        if (!NumberUtil.longNullOuZero((Long)idDocDestinado)) {
            LogAcaoUsuarioRN.getInstance().incluirAcaoUsuarioCorrente(SessaoUtil.getSessao(), DocumentoDestinadoRN.getInstance().getTabela(), idDocDestinado, "Baixou XML da NF-e " + chave, TipoLogAcaoUsuario.DOWNLOAD_NFE);
        }
        return this.responseEntityService.createXMLResponse(new NfeManagerWeb(SessaoUtil.getSessao(), null).reconhecerEBaixarNFe(chave), chave.concat(".xml"));
    }

    @RequestMapping(value={"/recuperar-importacao"}, method={RequestMethod.POST})
    @DBTransaction
    public ImportacaoXmlWrapper recuperarImportacao(@RequestBody ConfiguracaoImportacaoXmlWrapper wrapper, @RequestParam(required=false) String chave) throws UnicoMensagemUsuarioException {
        ImportacaoXmlWrapper importacaoXmlWrapper = null;
        Sessao sessao = SessaoUtil.getSessao();
        ImportacaoXmlNotaFiscal importacaoGravada = !StringUtil.stringNullOrEmpty((String)chave) ? ImportacaoXmlNotaFiscalRN.getInstance().buscarPorChaveAcessoSemUsuario(chave) : ImportacaoXmlNotaFiscalRN.getInstance().buscarPorIdUsuario(sessao.getIdUsuario());
        if (importacaoGravada != null) {
            ValidadorXmlEntradaWeb validador = new ValidadorXmlEntradaWeb(TipoImportacaoXML.PADRAO, importacaoGravada.getArquivoXml(), wrapper.getNfeImportadoAntesDeReprocessar(), sessao, wrapper.getAcaoCest(), wrapper.getAcaoCnpjFabricante(), wrapper.getAcaoEan(), wrapper.getAcaoEanTributavel(), wrapper.getAcaoEscala(), wrapper.getAcaoNcm(), wrapper.getAcaoOrigem(), wrapper.getAcaoProdutoInativo(), wrapper.getAcaoAtualizacaoEanEmbalagem(), wrapper.isVincularVariacaoEAN(), wrapper.isBuscarCfopUltimaNFProdutoFornecedor(), wrapper.isBuscarProdutoApenasEan(), wrapper.isControlarPorUsuario(), false);
            DocumentoNFeImportadoXML documentoNFeImportadoXML = validador.getNfeImportadoXml();
            if (!ListMapUtil.listNullOrEmpty((List)documentoNFeImportadoXML.getListaItens())) {
                documentoNFeImportadoXML.getListaItens().forEach(arg_0 -> ((ValidadorXmlEntradaWeb)validador).atualizaDadosItem(arg_0));
            }
            importacaoXmlWrapper = new ImportacaoXmlWrapper(validador.getNfeImportadoXml(), validador.getFornecedor(), validador.getProximoCodigoProduto(), validador.getIdFornecedor(), validador.getCacheUltimaResolucaoDiferencasPorTipo());
        }
        return importacaoXmlWrapper;
    }

    @RequestMapping(value={"/excluir-importacao"}, method={RequestMethod.POST})
    @DBTransaction
    public void excluirImportacaoUsuario(@RequestParam(required=false) String uuid) throws UnicoMensagemUsuarioException {
        if (!StringUtil.stringNullOrEmpty((String)uuid)) {
            ImportacaoXmlNotaFiscalRN.getInstance().excluirPorUuid(SessaoUtil.getSessao(), uuid);
        } else {
            ImportacaoXmlNotaFiscalRN.getInstance().excluirPorIdUsuario(SessaoUtil.getSessao());
        }
    }

    @RequestMapping(value={"/processar-arquivo"}, method={RequestMethod.POST}, consumes={"multipart/form-data"})
    @ResponseBody
    @DBTransaction
    public ImportacaoXmlWrapper processarArquivo(@RequestPart(value="file") MultipartFile multipartFile, @RequestPart(value="configuracoes") ConfiguracaoImportacaoXmlWrapper wrapper, @RequestParam TipoImportacaoXML tipo, @RequestParam(required=false) String uuid) throws UnicoMensagemUsuarioException {
        byte[] arquivo;
        String nomeArquivo = multipartFile.getOriginalFilename();
        if (StringUtil.stringNullOrEmpty((String)nomeArquivo)) {
            nomeArquivo = multipartFile.getName();
        }
        if (multipartFile.isEmpty() || !"text/xml".equals(multipartFile.getContentType()) && !"application/xml".equals(multipartFile.getContentType()) || !nomeArquivo.toUpperCase().endsWith("XML")) {
            throw new UnicoMensagemUsuarioException("WWW483", "Arquivo de XML n\u00e3o informado e/ou incorreto.");
        }
        try {
            arquivo = multipartFile.getBytes();
        }
        catch (IOException ex) {
            throw new UnicoMensagemUsuarioException("WWW470", "N\u00e3o foi posss\u00edvel importar o arquivo. Por favor verifique a integridade do arquivo.");
        }
        ValidadorXmlEntradaWeb validador = new ValidadorXmlEntradaWeb(tipo, arquivo, wrapper.getNfeImportadoAntesDeReprocessar(), SessaoUtil.getSessao(), wrapper.getAcaoCest(), wrapper.getAcaoCnpjFabricante(), wrapper.getAcaoEan(), wrapper.getAcaoEanTributavel(), wrapper.getAcaoEscala(), wrapper.getAcaoNcm(), wrapper.getAcaoOrigem(), wrapper.getAcaoProdutoInativo(), wrapper.getAcaoAtualizacaoEanEmbalagem(), wrapper.isVincularVariacaoEAN(), wrapper.isBuscarCfopUltimaNFProdutoFornecedor(), wrapper.isBuscarProdutoApenasEan(), wrapper.isControlarPorUsuario());
        DocumentoNFeImportadoXML documentoNFeImportadoXML = validador.getNfeImportadoXml();
        if (!ListMapUtil.listNullOrEmpty((List)documentoNFeImportadoXML.getListaItens())) {
            documentoNFeImportadoXML.getListaItens().forEach(item -> {
                validador.atualizaDadosItem(item);
                validador.atualizaStatusItens();
            });
        }
        if (tipo.equals((Object)TipoImportacaoXML.XML_55_DI)) {
            validador.setUuid(uuid);
        }
        validador.gravarAlteracoes(SessaoUtil.getSessao());
        return new ImportacaoXmlWrapper(validador.getNfeImportadoXml(), validador.getFornecedor(), validador.getProximoCodigoProduto(), validador.getIdFornecedor(), validador.getCacheUltimaResolucaoDiferencasPorTipo());
    }

    @RequestMapping(value={"/gerar-nota-fiscal"}, method={RequestMethod.POST})
    @ResponseBody
    @DBTransaction
    public ImportacaoXmlImpostoWrapper gerarNotaFiscal(@RequestBody ImportacaoXmlNotaFiscalWrapper wrapper, @RequestParam(required=false) String chave, @RequestParam TipoImportacaoXML tipo) throws UnicoMensagemUsuarioException {
        Sessao sessao = SessaoUtil.getSessao();
        DocumentoNFeImportadoXML documento = wrapper.getDocumento();
        byte[] arquivo = this.buscarDocumentoGravado(chave).getArquivoXml();
        if (!ListMapUtil.listNullOrEmpty((List)documento.getListaItens()) && documento.getListaItens().stream().anyMatch(i -> i.getStatus().equals((Object)StatusItemImportacaoXML.PENDENTE))) {
            throw new UnicoMensagemUsuarioException("WWW480", "N\u00e3o \u00e9 poss\u00edvel verificar a tributa\u00e7\u00e3o sem ter resolvido todos os detalhes dos itens! Verifique.");
        }
        if (PropriedadeRN.getInstance().getPropriedadeBoolean(sessao.getFilial(), 747)) {
            if (NumberUtil.longNullOuZero((Long)wrapper.getIdOperacaoFiscal())) {
                throw new UnicoMensagemUsuarioException("WWW481", "Opera\u00e7\u00e3o fiscal n\u00e3o informada! Verifique.");
            }
            Optional<DetalheImportacaoXML> optionalOperacaoFiscal = documento.getListaDetalhes().stream().filter(det -> det instanceof DetalheImportacaoXMLOperacaoFiscal).findFirst();
            if (optionalOperacaoFiscal.isPresent()) {
                DetalheImportacaoXMLOperacaoFiscal detalheOperacaoFiscal = (DetalheImportacaoXMLOperacaoFiscal)optionalOperacaoFiscal.get();
                detalheOperacaoFiscal.setIdAssociado(wrapper.getIdOperacaoFiscal());
                detalheOperacaoFiscal.setStatus(StatusDetalheItemImportacaoXML.OK);
            }
        }
        if (Util.longNullOuZero((Long)documento.getIdTransportador()) && Util.stringNullOrEmpty((String)documento.getUfTransportador())) {
            if (NumberUtil.longNullOuZero((Long)wrapper.getIdEstado()) && documento.getDadosImportadoXML().isHabilitarEstado()) {
                throw new UnicoMensagemUsuarioException("WWW482", "Estado da transportadora n\u00e3o informado! Verifique.");
            }
            Optional<DetalheImportacaoXML> optionalEstadoTransportador = documento.getListaDetalhes().stream().filter(det -> det instanceof DetalheImportacaoXMLEstadoTransportador).findFirst();
            if (optionalEstadoTransportador.isPresent()) {
                DetalheImportacaoXMLEstadoTransportador detalheEstadoTransportador = (DetalheImportacaoXMLEstadoTransportador)optionalEstadoTransportador.get();
                detalheEstadoTransportador.setIdAssociado(wrapper.getIdEstado());
                detalheEstadoTransportador.setStatus(StatusDetalheItemImportacaoXML.OK);
            }
        }
        this.verificarItensAssociados(documento);
        NotaFiscal notaFiscal = new GeradorXMLParaNotaFiscal2(sessao, arquivo, documento, tipo).getNotaFiscal();
        notaFiscal.getNotaFiscalItens().forEach(notaFiscalItem -> {
            notaFiscalItem.setDecimaisPreco(NotaFiscalItemRN.getInstance().getDecimaisPrecoProdutoWeb(notaFiscal, notaFiscalItem));
            notaFiscalItem.setDecimaisQuantidade(CacheSistema.getInstance().getCasasDecimaisUnidadeMedida(notaFiscalItem.getIdUnidadeMedida()).intValue());
        });
        if (!notaFiscal.getTipoEmissao().equals((Object)TipoEmissaoNotaFiscal.PROPRIA)) {
            ModeloNotaFiscal modelo = (ModeloNotaFiscal)EnumUtils.getPorId(ModeloNotaFiscal.class, (Object)notaFiscal.getSerie());
            notaFiscal.setSerie(modelo.name());
        }
        if (!StringUtil.stringNullOrEmpty((String)notaFiscal.getInfoCompPersonalizada())) {
            notaFiscal.setInfoCompPersonalizada(notaFiscal.getInfoCompPersonalizada().replaceAll("\\|", ""));
        }
        ImportacaoXmlNotaFiscalRN.getInstance().alterarStatusImportacaoPorUsuario(sessao, documento, StatusImportacaoXMLNotaFiscal.CADASTROS_EFETUADOS, StringUtil.stringNullOrEmpty((String)chave));
        List criticasImpostos = new ValidadorXMLEntradaImpostos(tipo, notaFiscal, sessao.getFilial()).getCriticas();
        ImportacaoXmlImpostoWrapper wrapperImposto = new ImportacaoXmlImpostoWrapper();
        wrapperImposto.setDocumento(documento);
        wrapperImposto.setNotaFiscal(notaFiscal);
        if (!ListMapUtil.listNullOrEmpty((List)criticasImpostos)) {
            this.separarCriticas(wrapperImposto, criticasImpostos);
        } else {
            new GeradorXMLParaNotaFiscalImpostos(tipo, sessao.getFilial(), Collections.emptyList(), notaFiscal);
            if (notaFiscal.getStatus() == null) {
                notaFiscal.setStatus(StatusNotaFiscal.NORMAL);
            }
            notaFiscal.setIdFilial(sessao.getIdFilial());
            notaFiscal.getNotaFiscalItens().forEach(item -> item.setItemPermiteDesconto(DescontoRN.getInstance().isItemPermiteDesconto(sessao.getFilial(), (DescontoInterface)item, !NumberUtil.longNullOuZero((Long)item.getIdPromocao()) ? PromocaoRN.getInstance().buscarPorId(item.getIdPromocao()) : null)));
            this.limparCachesClient();
        }
        return wrapperImposto;
    }

    @RequestMapping(value={"/finalizar-importacao"}, method={RequestMethod.POST})
    @DBTransaction
    public NotaFiscal finalizarImportacao(@RequestBody ImportacaoXmlImpostoWrapper wrapper, @RequestParam TipoImportacaoXML tipo) throws UnicoMensagemUsuarioException {
        CondicaoPagamento conPagamento;
        Sessao sessao = SessaoUtil.getSessao();
        NotaFiscal notaFiscal = wrapper.getNotaFiscal();
        List criticasTratadas = this.criticasTratadas(wrapper);
        new GeradorXMLParaNotaFiscalImpostos(tipo, sessao.getFilial(), criticasTratadas, notaFiscal, false);
        if (notaFiscal.getStatus() == null) {
            notaFiscal.setStatus(StatusNotaFiscal.NORMAL);
        }
        notaFiscal.setIdFilial(sessao.getIdFilial());
        if (!StringUtil.stringNullOrEmpty((String)notaFiscal.getInfoCompPersonalizada())) {
            notaFiscal.setInfoCompPersonalizada(notaFiscal.getInfoCompPersonalizada().replaceAll("\\|", ""));
        }
        this.limparCachesClient();
        notaFiscal.getNotaFiscalItens().forEach(item -> item.setItemPermiteDesconto(DescontoRN.getInstance().isItemPermiteDesconto(sessao.getFilial(), (DescontoInterface)item, !NumberUtil.longNullOuZero((Long)item.getIdPromocao()) ? PromocaoRN.getInstance().buscarPorId(item.getIdPromocao()) : null)));
        notaFiscal.setNotaFiscalItens(KitRN.getInstance().agruparItensKit(notaFiscal.getNotaFiscalItens()));
        GeradorKitVendaNotaFiscal geradorKitVendaNotaFiscal = new GeradorKitVendaNotaFiscal(notaFiscal.getTipoDocumento());
        if (!TipoEmissaoNotaFiscal.PROPRIA.equals((Object)notaFiscal.getTipoEmissao())) {
            ProdutoItemRN produtoItemRN = new ProdutoItemRN();
            for (NotaFiscalItem notaFiscalItem : notaFiscal.getNotaFiscalItens()) {
                if (notaFiscalItem.getTipoKit() != TipoKit.KIT_PAI.getId().intValue()) continue;
                for (NotaFiscalItem itemNfKit : notaFiscalItem.getFilhosKit()) {
                    ProdutoDTOWeb produtoDTOWeb = ProdutoRN.getInstance().buscarProdutoDTOWeb(SessaoUtil.getSessao(), itemNfKit.getIdProduto());
                    produtoItemRN.atualizarPreco(sessao, null, produtoDTOWeb, (ProdutoItem)itemNfKit, TipoValorPreco.PRECO, notaFiscal.getIdCondicaoPagto(), notaFiscal.getPautaPreco(), true, true, false, false, null, notaFiscal.getIdEntidade());
                    this.calcularImpostos(notaFiscal, itemNfKit);
                }
                CalculoRateioKitEntradaTerceiros.getInstance().divideImpostosKitNotaTerceiros(notaFiscalItem, notaFiscalItem.getFilhosKit());
                geradorKitVendaNotaFiscal.calcularRateioKit(SessaoUtil.getSessao(), (ItemKit)notaFiscalItem, notaFiscalItem.getFilhosKit(), notaFiscal.getIdCondicaoPagto(), null, false);
                CalculoRateioKitEntradaTerceiros.getInstance().acertaBaseAliquotaItensKitNotaTerceiros(SessaoUtil.getSessao().getFilial(), notaFiscal.getTipoDocumento(), notaFiscalItem, notaFiscalItem.getFilhosKit());
            }
        }
        if ((conPagamento = CacheSistema.getInstance().getCondicaoPagamento(notaFiscal.getIdCondicaoPagto())) != null && conPagamento.isInativo()) {
            throw new UnicoMensagemUsuarioException("WNTF556", "A condi\u00e7\u00e3o de pagamento " + conPagamento.getDescricao() + " esta inativa! Selecione uma nova condi\u00e7\u00e3o.");
        }
        return notaFiscal;
    }

    @RequestMapping(value={"/finalizar-importacao-gestao"}, method={RequestMethod.POST})
    @DBTransaction
    public void finalizarImportacao(@RequestBody ImportacaoXmlGestaoWrapper wrapper, @RequestParam Long idDocumento) throws UnicoMensagemUsuarioException {
        Sessao sessao = SessaoUtil.getSessao();
        DocumentoFiscalFornecedor doc = (DocumentoFiscalFornecedor)DocumentoFiscalFornecedorRN.getInstance().buscarPorId(idDocumento);
        ValidadorXmlEntradaWeb validador = new ValidadorXmlEntradaWeb(TipoImportacaoXML.PADRAO, doc.getArquivoXml(), wrapper.getConfiguracao().getNfeImportadoAntesDeReprocessar(), sessao, wrapper.getConfiguracao().getAcaoCest(), wrapper.getConfiguracao().getAcaoCnpjFabricante(), wrapper.getConfiguracao().getAcaoEan(), wrapper.getConfiguracao().getAcaoEanTributavel(), wrapper.getConfiguracao().getAcaoEscala(), wrapper.getConfiguracao().getAcaoNcm(), wrapper.getConfiguracao().getAcaoOrigem(), wrapper.getConfiguracao().getAcaoProdutoInativo(), wrapper.getConfiguracao().getAcaoAtualizacaoEanEmbalagem(), wrapper.getConfiguracao().isVincularVariacaoEAN(), wrapper.getConfiguracao().isBuscarCfopUltimaNFProdutoFornecedor(), wrapper.getConfiguracao().isBuscarProdutoApenasEan(), wrapper.getConfiguracao().isControlarPorUsuario());
        DocumentoNFeImportadoXML documentoNFeImportadoXML = validador.getNfeImportadoXml();
        if (!ListMapUtil.listNullOrEmpty((List)documentoNFeImportadoXML.getListaItens())) {
            documentoNFeImportadoXML.getListaItens().forEach(arg_0 -> ((ValidadorXmlEntradaWeb)validador).atualizaDadosItem(arg_0));
        }
        documentoNFeImportadoXML.setListaCriticasImpostos(this.criticasTratadas(wrapper.getImposto()));
        ImportacaoXmlNotaFiscalRN.getInstance().gravarAlteracoes(sessao, false, doc.getChaveAcesso(), documentoNFeImportadoXML, doc.getArquivoXml());
        doc.setSituacaoDocumentoFiscal(SituacaoDocumentoFiscalFornecedor.LIBERACAO_PENDENTE);
        DocumentoFiscalFornecedorRN.getInstance().alterar((AbstractPojo)doc, sessao);
        this.notificationService.notifyUserNow(NotificationType.GESTAO_NFE, (Object)"");
    }

    private void calcularImpostos(NotaFiscal notaFiscal, NotaFiscalItem item) throws UnicoMensagemUsuarioException {
        Estado estado;
        Object parametros = !Util.longNullOuZero((Long)notaFiscal.getIdOperacaoFiscal()) ? CacheSistema.getInstance().getOperacaoFiscal(notaFiscal.getIdOperacaoFiscal()) : CacheSistema.getInstance().getNaturezaOperacao(notaFiscal.getIdCfop());
        if (FinalidadeEmissaoNfeCFOP.TRANSFERENCIA_CREDITO_ICMS.equals((Object)parametros.getFinalidadeEmissaoNfe()) || FinalidadeEmissaoNfeCFOP.CREDITO_ICMS.equals((Object)parametros.getFinalidadeEmissaoNfe())) {
            return;
        }
        Entidade entidade = (Entidade)EntidadeRN.getInstance().buscarPorId(notaFiscal.getIdEntidade());
        TipoNotaFiscal tipoNotaFiscal = notaFiscal.getTipoDocumento();
        LocalDate dataEmissao = notaFiscal.getEmissao();
        String codigoEstado = "";
        if (!Util.longNullOuZero((Long)notaFiscal.getIdEstado()) && (estado = CacheSistema.getInstance().getEstado(notaFiscal.getIdEstado())) != null) {
            codigoEstado = estado.getCodigo();
        }
        TipoEmissaoNotaFiscal tipoEmissaoNotaFiscal = notaFiscal.getTipoEmissao();
        new CalculoImposto().calcularImpostos((ItemTributavelInterface)item, entidade, TipoCalculoImposto.CST_IPI, tipoNotaFiscal, dataEmissao, codigoEstado, tipoEmissaoNotaFiscal, (ParametrosNotaFiscalInterface)parametros, SessaoUtil.getSessao().getFilial(), false, 11);
    }

    @RequestMapping(value={"/visualizar-danfe"}, method={RequestMethod.POST})
    @ResponseBody
    @DBAutoCommit
    public ResponseEntity<byte[]> visualizarDanfe(@RequestParam(required=false) String chave) throws UnicoMensagemUsuarioException {
        byte[] arquivo = this.buscarDocumentoGravado(chave).getArquivoXml();
        byte[] danfe = Danfe2.getInstance().geraDanfeWeb("0000001", null, (InputStream)new ByteArrayInputStream(arquivo), false, null, null, null, null, false, UnicoSistema.getNomeSistema(), null, SessaoUtil.getSessao().getFilial(), StatusNotaFiscal.NORMAL);
        return this.responseEntityService.createPDFResponse(danfe, "Danfe XML");
    }

    @RequestMapping(value={"/confirmar-cadastro-produto"}, method={RequestMethod.POST})
    @DBAutoCommit
    public ImportacaoXmlWrapper confirmarCadastroProduto(@RequestBody ImportacaoXmlDetalheWrapper produtoWrapper, @RequestParam boolean cadastrarComGrade, @RequestParam(required=false) String chave) throws UnicoMensagemUsuarioException {
        ItemImportadoXML item = produtoWrapper.getItem();
        DetalheImportacaoXMLProduto detalhe = (DetalheImportacaoXMLProduto)produtoWrapper.getDetalhe();
        ImportacaoXmlNotaFiscal importacao = this.buscarDocumentoGravado(chave);
        ValidadorXmlEntradaWeb validadorXmlEntradaWeb = new ValidadorXmlEntradaWeb(SessaoUtil.getSessao().getFilial(), this.getDocumentoSubstituido(item, importacao.getObjetoNfeImportacao()), importacao.getArquivoXml(), importacao.getChaveNFE(), produtoWrapper.getCacheUltimaResolucaoDiferencasPorTipo());
        validadorXmlEntradaWeb.confirmaCadastroProduto(detalhe.getProdutoNovo(), item, detalhe, cadastrarComGrade);
        if (produtoWrapper.isReplicarAcao()) {
            validadorXmlEntradaWeb.atribuirValoresParaOutrosItens(item, (DetalheImportacaoXML)detalhe, false, true);
        }
        validadorXmlEntradaWeb.setUuid(chave);
        return this.verificaItensAssociadosComResolucao(validadorXmlEntradaWeb, item, (DetalheImportacaoXML)detalhe);
    }

    @RequestMapping(value={"/confirmar-cadastro-servico"}, method={RequestMethod.POST})
    @DBAutoCommit
    public ImportacaoXmlWrapper confirmarCadastroServico(@RequestBody ImportacaoXmlDetalheWrapper servicoWrapper, @RequestParam(required=false) String chave) throws UnicoMensagemUsuarioException {
        ItemImportadoXML item = servicoWrapper.getItem();
        DetalheImportacaoXMLServico detalhe = (DetalheImportacaoXMLServico)servicoWrapper.getDetalhe();
        ImportacaoXmlNotaFiscal importacao = this.buscarDocumentoGravado(chave);
        ValidadorXmlEntradaWeb validadorXmlEntradaWeb = new ValidadorXmlEntradaWeb(SessaoUtil.getSessao().getFilial(), this.getDocumentoSubstituido(item, importacao.getObjetoNfeImportacao()), importacao.getArquivoXml(), importacao.getChaveNFE(), servicoWrapper.getCacheUltimaResolucaoDiferencasPorTipo());
        validadorXmlEntradaWeb.confirmaCadastroServico(detalhe.getServicoNovo(), detalhe);
        if (servicoWrapper.isReplicarAcao()) {
            validadorXmlEntradaWeb.atribuirValoresParaOutrosItens(item, (DetalheImportacaoXML)detalhe, false, true);
        }
        validadorXmlEntradaWeb.setUuid(chave);
        return this.verificaItensAssociadosComResolucao(validadorXmlEntradaWeb, item, (DetalheImportacaoXML)detalhe);
    }

    @RequestMapping(value={"/confirmar-cadastro-cfop"}, method={RequestMethod.POST})
    @DBAutoCommit
    public ImportacaoXmlWrapper confirmarCadastroCFOP(@RequestBody ImportacaoXmlDetalheWrapper cfopWrapper, @RequestParam(required=false) String chave) throws UnicoMensagemUsuarioException {
        ItemImportadoXML item = cfopWrapper.getItem();
        DetalheImportacaoXMLCfop detalhe = (DetalheImportacaoXMLCfop)cfopWrapper.getDetalhe();
        ImportacaoXmlNotaFiscal importacao = this.buscarDocumentoGravado(chave);
        ValidadorXmlEntradaWeb validadorXmlEntradaWeb = new ValidadorXmlEntradaWeb(SessaoUtil.getSessao().getFilial(), this.getDocumentoSubstituido(item, importacao.getObjetoNfeImportacao()), importacao.getArquivoXml(), importacao.getChaveNFE(), cfopWrapper.getCacheUltimaResolucaoDiferencasPorTipo());
        String codigo = detalhe.getCfopNova().getCodigo();
        if (!(codigo.startsWith("1") || codigo.startsWith("2") || codigo.startsWith("3"))) {
            throw new UnicoMensagemUsuarioException("WWW498", "O c\u00f3digo informado n\u00e3o diz respeito \u00e0 uma natureza de opera\u00e7\u00e3o de entrada!");
        }
        validadorXmlEntradaWeb.confirmaCadastroCfop((DetalheImportacaoXML)detalhe, detalhe.getCfopNova());
        if (cfopWrapper.isReplicarAcao()) {
            validadorXmlEntradaWeb.atribuirValoresParaOutrosItens(item, (DetalheImportacaoXML)detalhe, false, true);
        }
        validadorXmlEntradaWeb.setUuid(chave);
        return this.verificaItensAssociadosComResolucao(validadorXmlEntradaWeb, item, (DetalheImportacaoXML)detalhe);
    }

    @RequestMapping(value={"/confirmar-cadastro-unidade-medida"}, method={RequestMethod.POST})
    @DBTransaction
    public ImportacaoXmlWrapper cadastrarUnidadeMedida(@RequestBody ImportacaoXmlDetalheWrapper unidadeMedidaWrapper, @RequestParam(required=false) String chave) throws UnicoMensagemUsuarioException {
        ItemImportadoXML item = unidadeMedidaWrapper.getItem();
        DetalheImportacaoXML detalhe = unidadeMedidaWrapper.getDetalhe();
        Unidademedida unidadeMedida = new Unidademedida();
        int transacao = !NumberUtil.longNullOuZero((Long)unidadeMedida.getId()) ? 1 : 0;
        Sessao sessao = SessaoUtil.getSessao();
        UnidademedidaRN.getInstance().gravar(transacao, unidadeMedida, sessao);
        ImportacaoXmlNotaFiscal importacao = this.buscarDocumentoGravado(chave);
        ValidadorXmlEntradaWeb validadorXmlEntradaWeb = new ValidadorXmlEntradaWeb(SessaoUtil.getSessao().getFilial(), this.getDocumentoSubstituido(item, importacao.getObjetoNfeImportacao()), importacao.getArquivoXml(), importacao.getChaveNFE(), unidadeMedidaWrapper.getCacheUltimaResolucaoDiferencasPorTipo());
        if (unidadeMedidaWrapper.isReplicarAcao()) {
            validadorXmlEntradaWeb.atribuirValoresParaOutrosItens(item, detalhe, false, true);
        }
        this.notificationService.notifyTenantNow(NotificationType.CACHE_REFRESH, "unidades-medida");
        validadorXmlEntradaWeb.setUuid(chave);
        return this.verificaItensAssociadosComResolucao(validadorXmlEntradaWeb, item, detalhe);
    }

    @RequestMapping(value={"/confirmar-cadastro-grade"}, method={RequestMethod.POST})
    @DBTransaction
    public ImportacaoXmlWrapper cadastrarGrade(@RequestBody ImportacaoXmlDetalheWrapper gradeWrapper, @RequestParam(required=false) String chave) throws UnicoMensagemUsuarioException {
        ItemImportadoXML item = gradeWrapper.getItem();
        DetalheImportacaoXMLVariacao detalhe = (DetalheImportacaoXMLVariacao)gradeWrapper.getDetalhe();
        ImportacaoXmlNotaFiscal importacao = this.buscarDocumentoGravado(chave);
        ValidadorXmlEntradaWeb validadorXmlEntradaWeb = new ValidadorXmlEntradaWeb(SessaoUtil.getSessao().getFilial(), this.getDocumentoSubstituido(item, importacao.getObjetoNfeImportacao()), importacao.getArquivoXml(), importacao.getChaveNFE(), gradeWrapper.getCacheUltimaResolucaoDiferencasPorTipo());
        validadorXmlEntradaWeb.confirmaCadastroGradePadrao(item, detalhe, detalhe.getVariacoes(), detalhe.getVariacaoNova(), detalhe.getIdGradeColuna(), detalhe.getIdGradeLinha());
        validadorXmlEntradaWeb.setUuid(chave);
        return this.verificaItensAssociadosComResolucao(validadorXmlEntradaWeb, item, (DetalheImportacaoXML)detalhe);
    }

    @RequestMapping(value={"/confirmar-distribuicao-grade"}, method={RequestMethod.POST})
    @DBTransaction
    public ImportacaoXmlWrapper confirmaDistribuicaoGrade(@RequestBody ImportacaoXmlDetalheWrapper gradeWrapper, @RequestParam(required=false) String chave) throws UnicoMensagemUsuarioException {
        ItemImportadoXML item = gradeWrapper.getItem();
        ImportacaoXmlNotaFiscal importacao = this.buscarDocumentoGravado(chave);
        ValidadorXmlEntradaWeb validadorXmlEntradaWeb = new ValidadorXmlEntradaWeb(SessaoUtil.getSessao().getFilial(), this.getDocumentoSubstituido(item, importacao.getObjetoNfeImportacao()), importacao.getArquivoXml(), importacao.getChaveNFE(), gradeWrapper.getCacheUltimaResolucaoDiferencasPorTipo());
        DetalheImportacaoXMLVariacao detalhe = (DetalheImportacaoXMLVariacao)gradeWrapper.getDetalhe();
        validadorXmlEntradaWeb.confirmaDistribuicaoGrade(detalhe, detalhe.getVariacaoNova());
        validadorXmlEntradaWeb.setUuid(chave);
        return this.verificaItensAssociadosComResolucao(validadorXmlEntradaWeb, item, (DetalheImportacaoXML)detalhe);
    }

    @RequestMapping(value={"/confirmar-cadastro-embalagem"}, method={RequestMethod.POST})
    @DBTransaction
    public ImportacaoXmlWrapper confirmaDadosEmbalagem(@RequestBody ImportacaoXmlDetalheWrapper embalagemWrapper, @RequestParam(required=false) String chave) throws UnicoMensagemUsuarioException {
        ItemImportadoXML item = embalagemWrapper.getItem();
        DetalheImportacaoXMLEanEmbalagem detalhe = (DetalheImportacaoXMLEanEmbalagem)embalagemWrapper.getDetalhe();
        ImportacaoXmlNotaFiscal importacao = this.buscarDocumentoGravado(chave);
        ValidadorXmlEntradaWeb validadorXmlEntradaWeb = new ValidadorXmlEntradaWeb(SessaoUtil.getSessao().getFilial(), this.getDocumentoSubstituido(item, importacao.getObjetoNfeImportacao()), importacao.getArquivoXml(), importacao.getChaveNFE(), embalagemWrapper.getCacheUltimaResolucaoDiferencasPorTipo());
        validadorXmlEntradaWeb.confirmaDadosEmbalagem(item, detalhe, detalhe.getUnidadeMedidaEscolhida().getId(), detalhe.getFatorConversao(), detalhe.getTipoEmbalagem(), detalhe.isAtualizarEanEmbalagem());
        if (embalagemWrapper.isReplicarAcao()) {
            validadorXmlEntradaWeb.atribuirValoresParaOutrosItens(item, (DetalheImportacaoXML)detalhe, false, true);
        }
        validadorXmlEntradaWeb.setUuid(chave);
        return this.verificaItensAssociadosComResolucao(validadorXmlEntradaWeb, item, (DetalheImportacaoXML)detalhe);
    }

    @RequestMapping(value={"/confirmar-cadastro-numeroserie"}, method={RequestMethod.POST})
    @DBTransaction
    public ImportacaoXmlWrapper confirmaNumerosSerie(@RequestBody ImportacaoXmlDetalheWrapper embalagemWrapper, @RequestParam(required=false) String chave) throws UnicoMensagemUsuarioException {
        ItemImportadoXML item = embalagemWrapper.getItem();
        DetalheImportacaoXMLNumeroSerie detalhe = (DetalheImportacaoXMLNumeroSerie)embalagemWrapper.getDetalhe();
        ImportacaoXmlNotaFiscal importacao = this.buscarDocumentoGravado(chave);
        ValidadorXmlEntradaWeb validadorXmlEntradaWeb = new ValidadorXmlEntradaWeb(SessaoUtil.getSessao().getFilial(), this.getDocumentoSubstituido(item, importacao.getObjetoNfeImportacao()), importacao.getArquivoXml(), importacao.getChaveNFE(), embalagemWrapper.getCacheUltimaResolucaoDiferencasPorTipo());
        validadorXmlEntradaWeb.confirmaNumerosSerie(detalhe, detalhe.getNumerosSerieNovo());
        if (embalagemWrapper.isReplicarAcao()) {
            validadorXmlEntradaWeb.atribuirValoresParaOutrosItens(item, (DetalheImportacaoXML)detalhe, false, true);
        }
        validadorXmlEntradaWeb.setUuid(chave);
        return this.verificaItensAssociadosComResolucao(validadorXmlEntradaWeb, item, (DetalheImportacaoXML)detalhe);
    }

    @RequestMapping(value={"/confirmar-associacao"}, method={RequestMethod.POST})
    @DBTransaction
    public ImportacaoXmlWrapper confirmarAssociacao(@RequestBody ImportacaoXmlDetalheWrapper wrapper, @RequestParam(required=false) String chave) throws UnicoMensagemUsuarioException {
        ItemImportadoXML item = wrapper.getItem();
        DetalheImportacaoXML detalhe = wrapper.getDetalhe();
        this.ajustaObservacaoAssociacao(detalhe);
        ImportacaoXmlNotaFiscal importacao = this.buscarDocumentoGravado(chave);
        ValidadorXmlEntradaWeb validadorXmlEntradaWeb = new ValidadorXmlEntradaWeb(SessaoUtil.getSessao().getFilial(), this.getDocumentoSubstituido(item, importacao.getObjetoNfeImportacao()), importacao.getArquivoXml(), importacao.getChaveNFE(), wrapper.getCacheUltimaResolucaoDiferencasPorTipo());
        if (detalhe instanceof DetalheImportacaoXMLProduto) {
            validadorXmlEntradaWeb.confirmaAssociacaoProduto(item, (DetalheImportacaoXMLProduto)detalhe);
        }
        if (wrapper.isReplicarAcao()) {
            validadorXmlEntradaWeb.atribuirValoresParaOutrosItens(item, detalhe, false, true);
        }
        validadorXmlEntradaWeb.setUuid(chave);
        return this.verificaItensAssociadosComResolucao(validadorXmlEntradaWeb, item, detalhe);
    }

    @RequestMapping(value={"/confirmar-ativacao"}, method={RequestMethod.POST})
    @DBTransaction
    public ImportacaoXmlWrapper confirmarAtivacao(@RequestBody ImportacaoXmlDetalheWrapper wrapper, @RequestParam(required=false) String chave) throws UnicoMensagemUsuarioException {
        ItemImportadoXML item = wrapper.getItem();
        DetalheImportacaoXML detalhe = wrapper.getDetalhe();
        ImportacaoXmlNotaFiscal importacao = this.buscarDocumentoGravado(chave);
        ValidadorXmlEntradaWeb validadorXmlEntradaWeb = new ValidadorXmlEntradaWeb(SessaoUtil.getSessao().getFilial(), this.getDocumentoSubstituido(item, importacao.getObjetoNfeImportacao()), importacao.getArquivoXml(), importacao.getChaveNFE(), wrapper.getCacheUltimaResolucaoDiferencasPorTipo());
        validadorXmlEntradaWeb.confirmaAtivacaoCadastro(item, detalhe);
        validadorXmlEntradaWeb.setUuid(chave);
        return this.verificaItensAssociadosComResolucao(validadorXmlEntradaWeb, item, detalhe);
    }

    @RequestMapping(value={"/confirmar-atualizacao"}, method={RequestMethod.POST})
    @DBTransaction
    public ImportacaoXmlWrapper confirmarAtualizacao(@RequestBody ImportacaoXmlDetalheWrapper wrapper, @RequestParam(required=false) String chave) throws UnicoMensagemUsuarioException {
        ItemImportadoXML item = wrapper.getItem();
        DetalheImportacaoXML detalhe = wrapper.getDetalhe();
        ImportacaoXmlNotaFiscal importacao = this.buscarDocumentoGravado(chave);
        ValidadorXmlEntradaWeb validadorXmlEntradaWeb = new ValidadorXmlEntradaWeb(SessaoUtil.getSessao().getFilial(), this.getDocumentoSubstituido(item, importacao.getObjetoNfeImportacao()), importacao.getArquivoXml(), importacao.getChaveNFE(), wrapper.getCacheUltimaResolucaoDiferencasPorTipo());
        validadorXmlEntradaWeb.confirmaAtualizacaoCadastro(item, (DetalheImportacaoXMLDiferencaCadastro)detalhe);
        validadorXmlEntradaWeb.setUuid(chave);
        return this.verificaItensAssociadosComResolucao(validadorXmlEntradaWeb, item, detalhe);
    }

    @RequestMapping(value={"/confirmar-nao-atualizar"}, method={RequestMethod.POST})
    @DBTransaction
    public ImportacaoXmlWrapper confirmarNaoAtualizar(@RequestBody ImportacaoXmlDetalheWrapper wrapper, @RequestParam(required=false) String chave) throws UnicoMensagemUsuarioException {
        ItemImportadoXML item = wrapper.getItem();
        DetalheImportacaoXML detalhe = wrapper.getDetalhe();
        ImportacaoXmlNotaFiscal importacao = this.buscarDocumentoGravado(chave);
        ValidadorXmlEntradaWeb validadorXmlEntradaWeb = new ValidadorXmlEntradaWeb(SessaoUtil.getSessao().getFilial(), this.getDocumentoSubstituido(item, importacao.getObjetoNfeImportacao()), importacao.getArquivoXml(), importacao.getChaveNFE(), wrapper.getCacheUltimaResolucaoDiferencasPorTipo());
        validadorXmlEntradaWeb.confirmaNaoAtualizar(item, (DetalheImportacaoXMLDiferencaCadastro)detalhe);
        validadorXmlEntradaWeb.setUuid(chave);
        return this.verificaItensAssociadosComResolucao(validadorXmlEntradaWeb, item, detalhe);
    }

    @RequestMapping(value={"/confirmar-sem-acao"}, method={RequestMethod.POST})
    @DBTransaction
    public ImportacaoXmlWrapper confirmarSemAcao(@RequestBody ImportacaoXmlDetalheWrapper wrapper, @RequestParam(required=false) String chave) throws UnicoMensagemUsuarioException {
        ItemImportadoXML item = wrapper.getItem();
        DetalheImportacaoXML detalhe = wrapper.getDetalhe();
        ImportacaoXmlNotaFiscal importacao = this.buscarDocumentoGravado(chave);
        ValidadorXmlEntradaWeb validadorXmlEntradaWeb = new ValidadorXmlEntradaWeb(SessaoUtil.getSessao().getFilial(), this.getDocumentoSubstituido(item, importacao.getObjetoNfeImportacao()), importacao.getArquivoXml(), importacao.getChaveNFE(), wrapper.getCacheUltimaResolucaoDiferencasPorTipo());
        validadorXmlEntradaWeb.confirmaSemAcao(item, detalhe);
        validadorXmlEntradaWeb.setUuid(chave);
        return this.verificaItensAssociadosComResolucao(validadorXmlEntradaWeb, item, detalhe);
    }

    @RequestMapping(value={"/cadastrar-todos-produtos-servicos"}, method={RequestMethod.POST})
    @DBTransaction
    public ImportacaoXmlWrapper cadastrarTodosProdutosServicos(@RequestBody ImportacaoXmlDetalheWrapper wrapper, @RequestParam(required=false) String chave) throws UnicoMensagemUsuarioException {
        Sessao sessao = SessaoUtil.getSessao();
        ImportacaoXmlNotaFiscal importacao = this.buscarDocumentoGravado(chave);
        ValidadorXmlEntradaWeb validadorXmlEntradaWeb = new ValidadorXmlEntradaWeb(SessaoUtil.getSessao().getFilial(), (DocumentoNFeImportadoXML)Util.getObjetoSerializadoDeInputStream((byte[])importacao.getObjetoNfeImportacao()), importacao.getArquivoXml(), importacao.getChaveNFE(), wrapper.getCacheUltimaResolucaoDiferencasPorTipo());
        validadorXmlEntradaWeb.setUltimoCodigoProdutoCadastrado(wrapper.getUltimoCodigoProduto());
        validadorXmlEntradaWeb.cadastrarTodosProdutosServicosNaoEncontrados(wrapper.getIdGrupoProduto(), validadorXmlEntradaWeb.isPossuiProdutoNaoCadastrado(), wrapper.getIdsEmpresas());
        validadorXmlEntradaWeb.setUuid(chave);
        validadorXmlEntradaWeb.gravarAlteracoes(sessao);
        return new ImportacaoXmlWrapper(validadorXmlEntradaWeb.getNfeImportadoXml(), validadorXmlEntradaWeb.getCacheUltimaResolucaoDiferencasPorTipo());
    }

    @RequestMapping(value={"/buscar-itens-resolvidos"}, method={RequestMethod.POST})
    @DBAutoCommit
    public List<CadastroRealizadoImportacaoXML> buscarItensResolvidosPorTipoDetalhe(@RequestBody ImportacaoXmlDetalheWrapper wrapper, @RequestParam(required=false) String chave) throws UnicoMensagemUsuarioException {
        ItemImportadoXML item = wrapper.getItem();
        DetalheImportacaoXML detalhe = wrapper.getDetalhe();
        ImportacaoXmlNotaFiscal importacao = this.buscarDocumentoGravado(chave);
        ValidadorXmlEntradaWeb validadorXmlEntradaWeb = new ValidadorXmlEntradaWeb(SessaoUtil.getSessao().getFilial(), this.getDocumentoSubstituido(item, importacao.getObjetoNfeImportacao()), importacao.getArquivoXml(), importacao.getChaveNFE(), wrapper.getCacheUltimaResolucaoDiferencasPorTipo());
        return validadorXmlEntradaWeb.getItensResolvidosPorTipoDetalhe(item, detalhe);
    }

    private void verificarItensAssociados(DocumentoNFeImportadoXML documento) throws UnicoMensagemUsuarioException {
        for (ItemImportadoXML item : documento.getListaItens()) {
            for (DetalheImportacaoXML detalhe : item.getListaDetalhes()) {
                if (!detalhe.getAcaoEscolhida().equals((Object)TipoAcaoDetalheImportacaoXML.ASSOCIAR) || detalhe.getItemAssociado() == null) continue;
                Optional<ItemImportadoXML> filtroItem = documento.getListaItens().stream().filter(i -> i.getId().equals(detalhe.getItemAssociado().getId())).findFirst();
                if (filtroItem.isPresent()) {
                    detalhe.setItemAssociado(filtroItem.get());
                    continue;
                }
                throw new UnicoMensagemUsuarioException("WWW485", "N\u00e3o foi poss\u00edvel determinar o item associado \u00e1 critica " + detalhe.getConteudoArquivo());
            }
        }
    }

    private ImportacaoXmlWrapper verificaItensAssociadosComResolucao(ValidadorXmlEntradaWeb validadorXmlEntradaWeb, ItemImportadoXML item, DetalheImportacaoXML detalhe) throws UnicoMensagemUsuarioException {
        validadorXmlEntradaWeb.verificaItensAssociadosComResolucao(item, detalhe);
        validadorXmlEntradaWeb.atualizaStatusItens();
        validadorXmlEntradaWeb.atualizaDadosItem(item);
        validadorXmlEntradaWeb.gravarAlteracoes(SessaoUtil.getSessao());
        return new ImportacaoXmlWrapper(validadorXmlEntradaWeb.getNfeImportadoXml(), validadorXmlEntradaWeb.getCacheUltimaResolucaoDiferencasPorTipo());
    }

    private void ajustaObservacaoAssociacao(DetalheImportacaoXML detalheImportacaoXML) throws UnicoMensagemUsuarioException {
        if (!NumberUtil.longNullOuZero((Long)detalheImportacaoXML.getIdAssociado())) {
            ProdutoDTOWeb servico;
            String observacao = "Associado ";
            if (detalheImportacaoXML instanceof DetalheImportacaoXMLCfop) {
                NaturezaOperacao cfop = NaturezaOperacaoRN.getInstance().buscarPorId(detalheImportacaoXML.getIdAssociado());
                if (cfop != null) {
                    observacao = observacao + "\u00e0 natureza de opera\u00e7\u00e3o " + cfop.getCodigo();
                }
            } else if (detalheImportacaoXML instanceof DetalheImportacaoXMLEstadoTransportador) {
                Estado estado = (Estado)EstadoRN.getInstance().buscarPorId(detalheImportacaoXML.getIdAssociado());
                if (estado != null) {
                    observacao = observacao + "ao estado de " + estado.getCodigo();
                }
            } else if (detalheImportacaoXML instanceof DetalheImportacaoXMLOperacaoFiscal) {
                OperacaoFiscal operacaoFiscal = (OperacaoFiscal)OperacaoFiscalRN.getInstance().buscarPorId(detalheImportacaoXML.getIdAssociado());
                if (operacaoFiscal != null) {
                    observacao = observacao + "\u00e0 opera\u00e7\u00e3o fiscal " + operacaoFiscal.getDescricao();
                }
            } else if (detalheImportacaoXML instanceof DetalheImportacaoXMLProduto) {
                ProdutoDTOWeb produto = ProdutoRN.getInstance().buscarProdutoDTOWeb(SessaoUtil.getSessao(), detalheImportacaoXML.getIdAssociado());
                if (produto != null) {
                    observacao = observacao + "ao produto " + produto + (!Util.stringNullOrEmpty((String)produto.getEan()) ? " EAN-" + produto.getEan() : "");
                }
            } else if (detalheImportacaoXML instanceof DetalheImportacaoXMLServico && (servico = ProdutoRN.getInstance().buscarProdutoDTOWeb(SessaoUtil.getSessao(), detalheImportacaoXML.getIdAssociado())) != null) {
                observacao = observacao + "ao servi\u00e7o " + servico;
            }
            detalheImportacaoXML.setObservacao(observacao);
            detalheImportacaoXML.setStatus(StatusDetalheItemImportacaoXML.OK);
        } else if (detalheImportacaoXML.getItemAssociado() != null) {
            ItemImportadoXML itemResolvido = detalheImportacaoXML.getItemAssociado();
            Optional<DetalheImportacaoXML> detalheAssociado = itemResolvido.getListaDetalhes().stream().filter(det -> det.getClass().equals(detalheImportacaoXML.getClass())).findFirst();
            if (!detalheAssociado.isPresent()) {
                throw new UnicoMensagemUsuarioException("WWW477", "N\u00e3o foi poss\u00edvel identificar o detalhe da associa\u00e7\u00e3o.");
            }
            detalheImportacaoXML.setObservacao("Associado \u00e0 resolu\u00e7\u00e3o do item " + itemResolvido.getId() + " (" + detalheAssociado.get().getObservacao() + ")");
            detalheImportacaoXML.setStatus(StatusDetalheItemImportacaoXML.OK);
        } else {
            throw new UnicoMensagemUsuarioException("WWW478", "N\u00e3o foi poss\u00edvel prosseguir pois n\u00e3o foi apresentado a associa\u00e7\u00e3o.");
        }
    }

    private void separarCriticas(ImportacaoXmlImpostoWrapper wrapper, List<ItemCriticaImportacaoImpostosXmlNfe> criticas) {
        boolean simples = SessaoUtil.getSessao().getFilial().isSimplesNacional();
        criticas.forEach(critica -> {
            boolean isRegraFiscal;
            String descricaoCritica = critica.getTipoCritica().getDescricao() + ",\r\nitem [" + critica.getItemOriginal().getProduto() + " - " + critica.getItemOriginal().getDescricao() + "].";
            boolean bl = isRegraFiscal = TipoCriticaImportacaoImpostosXmlNfe.ICMS_NAO_CONFERE.equals((Object)critica.getTipoCritica()) && critica.getItemRecalculado().isAplicouRegraFiscalIcms();
            if (critica.getTipoCritica().equals((Object)TipoCriticaImportacaoImpostosXmlNfe.ICMS_NAO_CONFERE)) {
                wrapper.getIcms().add(new IcmsImportacaoXMLWrapper(critica, descricaoCritica, critica.getAcoesDisponiveis(), isRegraFiscal ? TipoAcaoImportacaoImpostosXmlNfe.TRIBUTACAO_SISTEMA : TipoAcaoImportacaoImpostosXmlNfe.TRIBUTACAO_XML, critica.getItemOriginal().getPercentualReducaoIcms(), critica.getItemRecalculado().getPercentualReducaoIcms(), critica.getItemOriginal().getBaseIcms(), critica.getItemRecalculado().getBaseIcms(), critica.getItemOriginal().getPercentualIcms(), critica.getItemRecalculado().getPercentualIcms(), critica.getItemOriginal().getIcms(), critica.getItemRecalculado().getIcms(), critica.getItemOriginal().getIcmsFundoPobrezaInterno(), critica.getItemRecalculado().getIcmsFundoPobrezaInterno(), simples ? critica.getItemOriginal().getSituacaotributariaSN() : critica.getItemOriginal().getSituacaotributaria(), simples ? critica.getItemRecalculado().getSituacaotributariaSN() : critica.getItemRecalculado().getSituacaotributaria()));
            } else if (critica.getTipoCritica().equals((Object)TipoCriticaImportacaoImpostosXmlNfe.CST_IPI_NAO_CONFIGURADA)) {
                wrapper.getIpi().add(new IpiImportacaoXMLWrapper(critica, descricaoCritica, critica.getAcoesDisponiveis(), TipoAcaoImportacaoImpostosXmlNfe.SEM_ACAO, critica.getItemOriginal().getSituacaoTributariaIPI() != null ? critica.getItemOriginal().getSituacaoTributariaIPI().getId() : "", critica.getItemOriginal().getBaseIpi(), critica.getItemOriginal().getPercentualIpi(), critica.getItemOriginal().getIpi()));
            } else if (critica.getTipoCritica().equals((Object)TipoCriticaImportacaoImpostosXmlNfe.ICMS_ST_NAO_CONFERE)) {
                wrapper.getIcmsST().add(new IcmsStImportacaoXMLWrapper(critica, descricaoCritica, critica.getAcoesDisponiveis(), isRegraFiscal ? TipoAcaoImportacaoImpostosXmlNfe.TRIBUTACAO_SISTEMA : TipoAcaoImportacaoImpostosXmlNfe.TRIBUTACAO_XML, critica.getItemOriginal().getBaseIcmsSubstituicao(), critica.getItemRecalculado().getBaseIcmsSubstituicao(), critica.getItemOriginal().getPercReducaoIcmsSubstituicao() == null ? BigDecimal.ZERO : critica.getItemOriginal().getPercReducaoIcmsSubstituicao(), critica.getItemRecalculado().getPercReducaoIcmsSubstituicao() == null ? BigDecimal.ZERO : critica.getItemRecalculado().getPercReducaoIcmsSubstituicao(), critica.getItemOriginal().getPercentualIcmsSubstituicao(), critica.getItemRecalculado().getPercentualIcmsSubstituicao(), critica.getItemOriginal().getIcmsSubstituicao(), critica.getItemRecalculado().getIcmsSubstituicao(), critica.getItemOriginal().getIcmsFundoPobrezaST(), critica.getItemRecalculado().getIcmsFundoPobrezaST()));
            } else if (critica.getTipoCritica().equals((Object)TipoCriticaImportacaoImpostosXmlNfe.CST_PIS_COFINS_NAO_CONFERE)) {
                wrapper.getPisCofins().add(new PisCofinsImportacaoXMLWrapper(critica, descricaoCritica, critica.getAcoesDisponiveis(), TipoAcaoImportacaoImpostosXmlNfe.SEM_ACAO, critica.getItemOriginal().getCstPis(), critica.getCstPisCofinsInformadaUsuario() != null ? critica.getCstPisCofinsInformadaUsuario().getId() : null));
            }
        });
    }

    private DocumentoNFeImportadoXML getDocumentoSubstituido(ItemImportadoXML itemSubstituicao, byte[] objetoNfeImportacao) {
        DocumentoNFeImportadoXML nfeImportadoXml = (DocumentoNFeImportadoXML)Util.getObjetoSerializadoDeInputStream((byte[])objetoNfeImportacao);
        nfeImportadoXml.setListaItens(nfeImportadoXml.getListaItens().stream().map(i -> i.getId().equals(itemSubstituicao.getId()) ? itemSubstituicao : i).collect(Collectors.toList()));
        return nfeImportadoXml;
    }

    private ImportacaoXmlNotaFiscal buscarDocumentoGravado(String chave) throws UnicoMensagemUsuarioException {
        ImportacaoXmlNotaFiscal importacaoGravada;
        if (!StringUtil.stringNullOrEmpty((String)chave)) {
            importacaoGravada = ImportacaoXmlNotaFiscalRN.getInstance().buscarPorChaveAcessoSemUsuario(chave);
            if (importacaoGravada == null) {
                importacaoGravada = ImportacaoXmlNotaFiscalRN.getInstance().buscarPorUuid(chave);
            }
        } else {
            importacaoGravada = ImportacaoXmlNotaFiscalRN.getInstance().buscarPorIdUsuario(SessaoUtil.getSessao().getIdUsuario());
        }
        if (importacaoGravada == null) {
            throw new UnicoMensagemUsuarioException("WWW533", "Documento n\u00e3o encontrado, por favor importe o XML novamente.");
        }
        return importacaoGravada;
    }

    private void limparCachesClient() {
        this.notificationService.notifyTenantNow(NotificationType.CACHE_REFRESH, "naturezas-operacao");
        this.notificationService.notifyTenantNow(NotificationType.CACHE_REFRESH, "unidades-medida");
    }

    private List<ItemCriticaImportacaoImpostosXmlNfe> criticasTratadas(ImportacaoXmlImpostoWrapper wrapper) throws UnicoMensagemUsuarioException {
        ArrayList<ItemCriticaImportacaoImpostosXmlNfe> criticasTratadas = new ArrayList<ItemCriticaImportacaoImpostosXmlNfe>();
        if (!ListMapUtil.listNullOrEmpty((List)wrapper.getIcms())) {
            for (IcmsImportacaoXMLWrapper icms : wrapper.getIcms()) {
                if (icms.getAcaoEscolhida().equals((Object)TipoAcaoImportacaoImpostosXmlNfe.SEM_ACAO)) {
                    throw new UnicoMensagemUsuarioException("WWW486", "Resolva todas as cr\u00edticas selecionando uma a\u00e7\u00e3o para os itens de ICMS.");
                }
                icms.getCritica().setAcaoEscolhida(icms.getAcaoEscolhida());
                criticasTratadas.add(icms.getCritica());
            }
        }
        if (!ListMapUtil.listNullOrEmpty((List)wrapper.getIcmsST())) {
            for (IcmsStImportacaoXMLWrapper icmsst : wrapper.getIcmsST()) {
                if (icmsst.getAcaoEscolhida().equals((Object)TipoAcaoImportacaoImpostosXmlNfe.SEM_ACAO)) {
                    throw new UnicoMensagemUsuarioException("WWW487", "Resolva todas as cr\u00edticas selecionando uma a\u00e7\u00e3o para os itens de ICMS Substitui\u00e7\u00e3o.");
                }
                icmsst.getCritica().setAcaoEscolhida(icmsst.getAcaoEscolhida());
                criticasTratadas.add(icmsst.getCritica());
            }
        }
        if (!ListMapUtil.listNullOrEmpty((List)wrapper.getIpi())) {
            for (IpiImportacaoXMLWrapper ipi : wrapper.getIpi()) {
                if (ipi.getAcaoEscolhida().equals((Object)TipoAcaoImportacaoImpostosXmlNfe.SEM_ACAO)) {
                    throw new UnicoMensagemUsuarioException("WWW488", "Resolva todas as cr\u00edticas selecionando uma a\u00e7\u00e3o para os itens de IPI.");
                }
                if (ipi.getAcaoEscolhida().equals((Object)TipoAcaoImportacaoImpostosXmlNfe.INFORMAR_CST) && ipi.getCstIpiSelecionada() == null) {
                    throw new UnicoMensagemUsuarioException("WWW489", "Selecione a CST de IPI para o item [" + ipi.getCritica().getItemOriginal().getProduto() + "]");
                }
                if (ipi.getAcaoEscolhida().equals((Object)TipoAcaoImportacaoImpostosXmlNfe.NAO_INFORMAR_CST) && !NumberUtil.bigDecimalNullOrZero((BigDecimal)ipi.getCritica().getItemOriginal().getIpi())) {
                    throw new UnicoMensagemUsuarioException("WWW490", "Selecione a CST de IPI para o item [" + ipi.getCritica().getItemOriginal().getProduto() + "], pois o mesmo possui valor de IPI.");
                }
                ipi.getCritica().setAcaoEscolhida(ipi.getAcaoEscolhida());
                ipi.getCritica().setCstIpiInformadaUsuario(ipi.getCstIpiSelecionada());
                criticasTratadas.add(ipi.getCritica());
            }
        }
        if (!ListMapUtil.listNullOrEmpty((List)wrapper.getPisCofins())) {
            for (PisCofinsImportacaoXMLWrapper piscofins : wrapper.getPisCofins()) {
                if ((piscofins.getAcaoEscolhida() == null || piscofins.getAcaoEscolhida().equals((Object)TipoAcaoImportacaoImpostosXmlNfe.SEM_ACAO)) && Util.stringNullOrEmpty((String)piscofins.getCstPisCofinsConfigurado())) {
                    throw new UnicoMensagemUsuarioException("WNTF9463", "Resolva todas as cr\u00edticas selecionando uma a\u00e7\u00e3o/CST para os itens de PIS/COFINS.");
                }
                piscofins.getCritica().setAcaoEscolhida(piscofins.getAcaoEscolhida());
                piscofins.getCritica().setCstPisCofinsInformadaUsuario((CstPisCofins)EnumUtils.getPorId(CstPisCofins.class, (Object)piscofins.getCstPisCofinsConfigurado()));
                criticasTratadas.add(piscofins.getCritica());
            }
        }
        return criticasTratadas;
    }
}

