/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.kit;

import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.util.Util;
import br.intelidata.commons.domain.pojo.AbstractPojo;
import br.intelidata.commons.domain.pojo.ItemKit;
import br.intelidata.commons.domain.pojo.ItemWeb;
import br.intelidata.commons.domain.pojo.ProdutoDTOWeb;
import br.intelidata.commons.domain.pojo.ProdutoItem;
import br.intelidata.commons.domain.pojo.ProdutoItemWeb;
import br.intelidata.commons.domain.pojo.enuns.TipoEmbalagem;
import br.intelidata.commons.domain.pojo.enuns.TipoKit;
import br.intelidata.commons.domain.pojo.notafiscal.ItemTributavelInterface;
import br.intelidata.commons.domain.regranegocio.AbstractRegraNegocio;
import br.intelidata.commons.domain.regranegocio.notafiscal.UtilNotaFiscal;
import br.intelidata.commons.modulo.notafiscal.regranegocio.NaturezaOperacaoRN;
import br.intelidata.commons.modulo.produto.regranegocio.GeradorKitVenda;
import br.intelidata.commons.modulo.produto.regranegocio.KitRN;
import br.intelidata.commons.modulo.produto.regranegocio.ProdutoRN;
import br.intelidata.core.aop.DBAutoCommit;
import br.intelidata.uniplusweb.core.coreinterfaces.ProdutoItemInterface;
import br.intelidata.uniplusweb.core.util.DateUtil;
import br.intelidata.uniplusweb.core.util.ListMapUtil;
import br.intelidata.uniplusweb.core.util.NumberUtil;
import br.intelidata.uniplusweb.core.util.StringUtil;
import br.intelidata.uniplusweb.web.enums.TipoArquivoArmazenado;
import br.intelidata.uniplusweb.web.rest.app.client.crud.CrudController;
import br.intelidata.uniplusweb.web.rest.app.crud.kit.ItemKitWrapper;
import br.intelidata.uniplusweb.web.rest.app.crud.kit.ItemProdutoKit;
import java.math.BigDecimal;
import java.time.temporal.Temporal;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

public abstract class ItemKitController<POJO extends AbstractPojo, IK extends ItemKit<?>, RN extends AbstractRegraNegocio>
extends CrudController<POJO, RN>
implements ProdutoItemInterface<IK> {
    public ItemKitController(RN rn, Supplier<POJO> pojoSupplier, boolean lazyLoad, boolean paginado) {
        super(rn, pojoSupplier, lazyLoad, paginado);
    }

    public ItemKitController(RN rn, Supplier<POJO> entitySupplier, boolean lazyLoad, boolean paginado, TipoArquivoArmazenado tipoArmazenamento, boolean permiteConfigurarGrid) {
        super(rn, entitySupplier, lazyLoad, paginado, tipoArmazenamento, permiteConfigurarGrid);
    }

    protected GeradorKitVenda<IK> getGeradorKitVenda() {
        return new GeradorKitVenda();
    }

    @RequestMapping(value={"/zerar-descontos-itens"}, method={RequestMethod.POST})
    @DBAutoCommit
    public List<IK> zerarDescontosItens(@RequestBody ItemKitWrapper<POJO, IK> wrapper) throws UnicoMensagemUsuarioException {
        GeradorKitVenda geradorKitVendaDav = this.getGeradorKitVenda();
        for (ItemKit item : wrapper.getItens()) {
            item.setIdEntidadeDesconto(null);
            item.setIdUsuarioDesconto(null);
            item.setNomeUsuarioDesconto(null);
            item.setPercentualDesconto(BigDecimal.ZERO);
            item.setDesconto(BigDecimal.ZERO);
            geradorKitVendaDav.calcularTotalItem(item);
            if (item.getTipoKit() != TipoKit.KIT_PAI.getId().intValue() || !this.isCalcularRateioValoreKit()) continue;
            geradorKitVendaDav.calcularRateioKit(SessaoUtil.getSessao(), item, item.getFilhosKit(), wrapper.getIdCondicaoPagamento());
        }
        return this.afterRateioKit(wrapper, wrapper.getItens());
    }

    @RequestMapping(value={"/buscar-itens-kit"}, method={RequestMethod.POST})
    @DBAutoCommit
    public List<ProdutoItemWeb<IK>> buscarItensKit(@RequestBody ItemKitWrapper<POJO, IK> wrapper) throws UnicoMensagemUsuarioException {
        List itensKit = KitRN.getInstance().buscarListaPorIdProdutoKit(SessaoUtil.getSessao(), wrapper.getItem().getIdProduto());
        if (!ListMapUtil.listNullOrEmpty((List)itensKit)) {
            LinkedHashMap itensMap = new LinkedHashMap();
            itensKit.forEach(itK -> itensMap.put(itK.getIdproduto(), itK.getQuantidade()));
            return this.calcularKit(wrapper, itensMap, false);
        }
        return null;
    }

    @RequestMapping(value={"/recalcular-kit"}, method={RequestMethod.POST})
    @DBAutoCommit
    public List<ProdutoItemWeb<IK>> recalcularKit(@RequestBody ItemKitWrapper<POJO, IK> wrapper) throws UnicoMensagemUsuarioException {
        LinkedHashMap<Long, BigDecimal> itensMap = new LinkedHashMap<Long, BigDecimal>();
        if (!ListMapUtil.listNullOrEmpty((List)wrapper.getItensResumido())) {
            for (ItemProdutoKit ik : wrapper.getItensResumido()) {
                itensMap.put(ik.getIdProduto(), ik.getQuantidade());
            }
        } else {
            for (ItemKit ik : wrapper.getItem().getFilhosKit()) {
                itensMap.put(ik.getIdProduto(), ik.getQuantidade());
            }
        }
        return this.calcularKit(wrapper, itensMap, true);
    }

    protected List<ProdutoItemWeb<IK>> calcularKit(ItemKitWrapper<POJO, IK> wrapper, Map<Long, BigDecimal> itensKit, boolean quantidadeFixa) throws UnicoMensagemUsuarioException {
        Object idCfopCabecalho;
        ArrayList<ProdutoItemWeb<IK>> itensKitFinal = new ArrayList<ProdutoItemWeb<IK>>();
        Object idCfopBonificacao = null;
        String cfopBonificacao = null;
        if (wrapper.getItem() instanceof ItemTributavelInterface && !NumberUtil.longNullOuZero((Long)(idCfopCabecalho = ((ItemTributavelInterface)wrapper.getItem()).getIdCfop()))) {
            String string = NaturezaOperacaoRN.getInstance().buscarValorPorID((Long)idCfopCabecalho, "codigo").toString();
            boolean isCfopBonificacao = UtilNotaFiscal.getListaCFOPBonificacao().stream().anyMatch(string::startsWith);
            if (isCfopBonificacao) {
                idCfopBonificacao = idCfopCabecalho;
                cfopBonificacao = string;
            }
        }
        for (Map.Entry entry : itensKit.entrySet()) {
            ProdutoDTOWeb produtoDTOWeb = ProdutoRN.getInstance().buscarProdutoDTOWeb(SessaoUtil.getSessao(), (Long)entry.getKey());
            ProdutoItemWeb produtoItem = this.carregarDadosItem(produtoDTOWeb, this.getMapParamsKit(wrapper));
            if (wrapper.isImportacaoDevolucao()) {
                ItemKit itemKit = wrapper.getItem().getFilhosKit().stream().map(f -> f).filter(item -> Objects.equals(item.getIdProduto(), entryItemKit.getKey())).findAny().orElse(null);
                produtoItem.setItem((ItemWeb)itemKit);
                this.recalcularItensImportacaoDevolucao(produtoItem, (BigDecimal)entry.getValue());
            }
            if (quantidadeFixa) {
                ((ItemKit)produtoItem.getItem()).setQuantidade((BigDecimal)entry.getValue());
            } else {
                ((ItemKit)produtoItem.getItem()).setQuantidade(wrapper.getItem().getQuantidade().multiply((BigDecimal)entry.getValue()));
            }
            if (produtoItem.getProdutoPreco() != null && Util.bigDecimalNullOrZero((BigDecimal)((ItemKit)produtoItem.getItem()).getPrecoUnitario())) {
                ((ItemKit)produtoItem.getItem()).setPrecoUnitario(produtoItem.getProdutoPreco().getPreco());
            }
            if (idCfopBonificacao != null && produtoItem.getItem() instanceof ProdutoItem) {
                ((ProdutoItem)produtoItem.getItem()).setCfop(cfopBonificacao);
                ((ProdutoItem)produtoItem.getItem()).setIdCfop((Long)idCfopBonificacao);
            }
            itensKitFinal.add(produtoItem);
        }
        List itensParaRateio = itensKitFinal.stream().map(ProdutoItemWeb::getItem).collect(Collectors.toList());
        if (this.isCalcularRateioValoreKit() && !wrapper.isImportacaoDevolucao()) {
            GeradorKitVenda geradorKitVenda = this.getGeradorKitVenda();
            geradorKitVenda.calcularRateioKit(SessaoUtil.getSessao(), wrapper.getItem(), itensParaRateio, wrapper.getIdCondicaoPagamento(), wrapper.getForcarCalculoPreco(), wrapper.isValidarPrecoKit());
        }
        itensParaRateio = this.afterRateioKit(wrapper, itensParaRateio);
        for (ItemKit it : itensParaRateio) {
            for (ProdutoItemWeb produtoItemWeb : itensKitFinal) {
                if (!((ItemKit)produtoItemWeb.getItem()).getIdProduto().equals(it.getIdProduto())) continue;
                produtoItemWeb.setItem((ItemWeb)it);
            }
        }
        return itensKitFinal;
    }

    protected List<IK> afterRateioKit(ItemKitWrapper<POJO, IK> wrapper, List<IK> itensParaRateio) throws UnicoMensagemUsuarioException {
        return itensParaRateio;
    }

    protected MultiValueMap<String, String> getMapParamsKit(ItemKitWrapper<POJO, IK> wrapper) {
        LinkedMultiValueMap parametros = new LinkedMultiValueMap();
        parametros.add((Object)"idCliente", (Object)StringUtil.all2Atring((Object)wrapper.getIdCliente()));
        parametros.add((Object)"idParametro", (Object)StringUtil.all2Atring((Object)wrapper.getIdParametro()));
        parametros.add((Object)"idCondicaoPgmto", (Object)StringUtil.all2Atring((Object)wrapper.getIdCondicaoPagamento()));
        parametros.add((Object)"pauta", (Object)StringUtil.all2Atring((Object)wrapper.getPauta()));
        parametros.add((Object)"tiposEmbalagem", (Object)(!StringUtil.stringNullOrEmpty((String)wrapper.getTiposEmbalagem()) ? wrapper.getTiposEmbalagem() : TipoEmbalagem.COMPRAVENDA.name()));
        parametros.add((Object)"possuiItens", (Object)"true");
        parametros.add((Object)"transacao", (Object)StringUtil.all2Atring((Object)wrapper.getTransacao()));
        parametros.add((Object)"estado", (Object)StringUtil.all2Atring((Object)wrapper.getEstado()));
        parametros.add((Object)"transferencia", (Object)StringUtil.all2Atring((Object)wrapper.isTransferencia()));
        parametros.add((Object)"tipoEmissao", (Object)(wrapper.getTipoEmissao() != null ? StringUtil.all2Atring((Object)wrapper.getTipoEmissao().name()) : ""));
        parametros.add((Object)"tipoPreco", (Object)(wrapper.getTipoPreco() != null ? StringUtil.all2Atring((Object)wrapper.getTipoPreco().name()) : ""));
        parametros.add((Object)"dataEmissao", (Object)DateUtil.formataDataHora((Temporal)wrapper.getDataEmissao(), (String)"yyyy-MM-dd"));
        parametros.add((Object)"origemImportada", (Object)StringUtil.all2Atring((Object)wrapper.getOrigemImportada()));
        parametros.add((Object)"cfopItem", (Object)wrapper.getCfopItem());
        parametros.add((Object)"idRepresentante", (Object)StringUtil.all2Atring((Object)wrapper.getIdRepresentante()));
        return parametros;
    }

    protected <IK2 extends ItemKit> List<IK2> separarItensKit(List<IK2> itensOriginal) {
        ArrayList<ItemKit> itens = new ArrayList<ItemKit>();
        if (itensOriginal != null) {
            for (ItemKit it : itensOriginal) {
                itens.add(it);
                if (ListMapUtil.listNullOrEmpty((List)it.getFilhosKit())) continue;
                itens.addAll(it.getFilhosKit());
                it.setFilhosKit(null);
                it.setItemKitPai(null);
            }
        }
        return itens;
    }

    protected <IK2 extends ItemKit> List<IK2> agruparItensKit(List<IK2> itens) {
        return KitRN.getInstance().agruparItensKit(itens);
    }

    protected boolean isCalcularRateioValoreKit() {
        return true;
    }

    protected void recalcularItensImportacaoDevolucao(ProdutoItemWeb<IK> produtoItem, BigDecimal quantidade) {
    }
}

