/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.manifestodocumento;

import br.intelidata.commons.bridge.ContextoHolder;
import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.util.Util;
import br.intelidata.commons.domain.pojo.enuns.TipoNotificacaoSimples;
import br.intelidata.commons.domain.pojo.manifesto.ManifestoCondutorVeiculo;
import br.intelidata.commons.domain.pojo.manifesto.ManifestoDocumento;
import br.intelidata.commons.domain.regranegocio.AbstractRegraNegocio;
import br.intelidata.commons.domain.regranegocio.ManifestoCondutorVeiculoCommonRN;
import br.intelidata.commons.domain.regranegocio.ManifestoEventoPagFreteCommonRN;
import br.intelidata.commons.modulo.manifesto.MdfeManagerWeb;
import br.intelidata.commons.modulo.manifesto.regranegocio.ManifestoDocumentoRN;
import br.intelidata.core.aop.DBAutoCommit;
import br.intelidata.core.aop.DBTransaction;
import br.intelidata.uniplusweb.core.util.FileUtil;
import br.intelidata.uniplusweb.core.util.StringUtil;
import br.intelidata.uniplusweb.web.rest.app.client.crud.CrudController;
import br.intelidata.uniplusweb.web.rest.app.crud.manifestodocumento.EncerrarMDFEWrapper;
import br.intelidata.uniplusweb.web.rest.app.crud.manifestodocumento.ManifestoDocumentoTransmissaoWrapper;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

public abstract class TransmissaoManifestoDocumentoController
extends CrudController<ManifestoDocumento, ManifestoDocumentoRN> {
    @Autowired
    public TransmissaoManifestoDocumentoController() {
        super((AbstractRegraNegocio)ManifestoDocumentoRN.getInstance(), ManifestoDocumento::new, true, false);
    }

    @RequestMapping(value={"/transmissao"}, method={RequestMethod.POST})
    @DBTransaction
    public void transmitirMDFE(@RequestBody ManifestoDocumentoTransmissaoWrapper wrapper) throws UnicoMensagemUsuarioException {
        if (Util.longNullOuZero((Long)wrapper.getId())) {
            throw new UnicoMensagemUsuarioException("WWW511", "Por favor informe uma MDF-e.");
        }
        try {
            MdfeManagerWeb mdfeManagerWeb = new MdfeManagerWeb(SessaoUtil.getSessao(), (mensagem, processo) -> this.notificationService.notifyMdfeNow(mensagem));
            this.verificarValidadeCertificado(mdfeManagerWeb);
            mdfeManagerWeb.processar(wrapper.getId());
        }
        catch (UnicoMensagemUsuarioException ex) {
            this.notificationService.notifyMdfeNow(ex.getMensagemSemCodigo());
        }
    }

    @RequestMapping(value={"/cancelar"})
    @DBTransaction
    public void cancelarMdfe(@RequestParam Long idMdfe, @RequestParam String justificativa) throws UnicoMensagemUsuarioException {
        ManifestoDocumento manifestoDocumento = ManifestoDocumentoRN.getInstance().buscarPorId(idMdfe);
        if (manifestoDocumento == null) {
            throw new UnicoMensagemUsuarioException("WWW512", "MDF-e selecionado n\u00e3o foi encontrado.");
        }
        try {
            MdfeManagerWeb mdfeManagerWeb = new MdfeManagerWeb(SessaoUtil.getSessao(), (mensagem, processo) -> this.notificationService.notifyMdfeNow(mensagem));
            this.verificarValidadeCertificado(mdfeManagerWeb);
            mdfeManagerWeb.getMdfeManager().cancelarMDFe(manifestoDocumento, justificativa);
            this.notificationService.notifyMdfeNow("MDF-e cancelado com sucesso");
        }
        catch (UnicoMensagemUsuarioException ex) {
            String erro = ex.getMensagemSemCodigo();
            if (ex.getCause() != null) {
                erro = erro + Util.newLine() + ex.getCause().getMessage();
            }
            this.notificationService.notifyMdfeNow(erro);
        }
    }

    @RequestMapping(value={"/encerrar"}, method={RequestMethod.POST})
    @DBTransaction
    public void encerrarMdfe(@RequestBody EncerrarMDFEWrapper encerrarMDFEWrapper) throws UnicoMensagemUsuarioException {
        ManifestoDocumento manifestoDocumento = ManifestoDocumentoRN.getInstance().buscarPorId(encerrarMDFEWrapper.getId());
        if (manifestoDocumento == null) {
            throw new UnicoMensagemUsuarioException("WWW513", "MDF-e selecionado n\u00e3o foi encontrado.");
        }
        try {
            this.notificationService.notifyMdfeNow("Encerrando MDF-e " + manifestoDocumento.getNumeroManifesto());
            MdfeManagerWeb mdfeManagerWeb = new MdfeManagerWeb(SessaoUtil.getSessao(), (mensagem, processo) -> this.notificationService.notifyMdfeNow(mensagem));
            this.verificarValidadeCertificado(mdfeManagerWeb);
            mdfeManagerWeb.getMdfeManager().encerrarMDFe(manifestoDocumento, encerrarMDFEWrapper.getDataEncerramento(), encerrarMDFEWrapper.getIdEstadoEncerramento(), encerrarMDFEWrapper.getIdCidadeEncerramento());
            this.notificationService.notifyMdfeNow("MDF-e encerrado com sucesso");
        }
        catch (UnicoMensagemUsuarioException ex) {
            String erro = ex.getMensagemSemCodigo();
            if (ex.getCause() != null) {
                erro = erro + Util.newLine() + ex.getCause().getMessage();
            }
            this.notificationService.notifyMdfeNow(erro);
        }
    }

    @RequestMapping(value={"/incluir-condutor"})
    @DBTransaction
    public void incluirCondutorMdfe(@RequestParam Long idMdfe, @RequestParam Long idCondutor) throws UnicoMensagemUsuarioException {
        ManifestoDocumento manifestoDocumento = ManifestoDocumentoRN.getInstance().buscarPorId(idMdfe);
        if (manifestoDocumento == null) {
            throw new UnicoMensagemUsuarioException("WWW514", "MDF-e selecionado n\u00e3o foi encontrado.");
        }
        try {
            MdfeManagerWeb mdfeManagerWeb = new MdfeManagerWeb(SessaoUtil.getSessao(), (mensagem, processo) -> this.notificationService.notifyMdfeNow(mensagem));
            this.verificarValidadeCertificado(mdfeManagerWeb);
            mdfeManagerWeb.getMdfeManager().incluirCondutor(idMdfe, idCondutor);
            this.notificationService.notifyMdfeNow("Condutor inclu\u00eddo na MDF-e com sucesso");
        }
        catch (UnicoMensagemUsuarioException ex) {
            String erro = ex.getMensagemSemCodigo();
            if (ex.getCause() != null) {
                erro = erro + Util.newLine() + ex.getCause().getMessage();
            }
            this.notificationService.notifyMdfeNow(erro);
        }
    }

    @RequestMapping(value={"/atualizar-status-mdfe"})
    @DBTransaction
    public void atualizarStatusMdfe(@RequestParam Long idMdfe) throws UnicoMensagemUsuarioException {
        ManifestoDocumento manifestoDocumento = ManifestoDocumentoRN.getInstance().buscarPorId(idMdfe);
        if (manifestoDocumento == null) {
            throw new UnicoMensagemUsuarioException("WWW515", "MDF-e selecionado n\u00e3o foi encontrado.");
        }
        try {
            MdfeManagerWeb mdfeManagerWeb = new MdfeManagerWeb(SessaoUtil.getSessao(), (mensagem, processo) -> this.notificationService.notifyMdfeNow(mensagem));
            this.verificarValidadeCertificado(mdfeManagerWeb);
            mdfeManagerWeb.atualizarMdfe(manifestoDocumento);
        }
        catch (UnicoMensagemUsuarioException ex) {
            String erro = ex.getMensagemSemCodigo();
            if (ex.getCause() != null) {
                erro = erro + Util.newLine() + ex.getCause().getMessage();
            }
            this.notificationService.notifyMdfeNow(erro);
        }
    }

    @RequestMapping(value={"/download-xml"}, method={RequestMethod.POST})
    @DBAutoCommit
    public ResponseEntity<byte[]> downloadXML(@RequestBody Long idMdfe) throws UnicoMensagemUsuarioException {
        ManifestoDocumento manifestoDocumento = ManifestoDocumentoRN.getInstance().buscarPorId(idMdfe);
        if (manifestoDocumento != null) {
            List listaEventos;
            if (!manifestoDocumento.getStatus().isPermiteImprimir()) {
                throw new UnicoMensagemUsuarioException("WWW516", "N\u00e3o \u00e9 poss\u00edvel fazer download de XML da MDF-e " + manifestoDocumento.getNumeroManifesto() + " com status " + manifestoDocumento.getStatus());
            }
            HashMap<String, byte[]> mapArquivos = new HashMap<String, byte[]>();
            String chaveAutorizada = "";
            if (!Util.stringNullOrEmpty((String)manifestoDocumento.getArquivoXmlContingencia())) {
                chaveAutorizada = manifestoDocumento.getChaveAcesso().concat("-mdfe-cont.xml");
                mapArquivos.put(chaveAutorizada, manifestoDocumento.getArquivoXmlContingencia().getBytes(StandardCharsets.UTF_8));
            }
            if (!Util.stringNullOrEmpty((String)manifestoDocumento.getArquivoXmlAutorizado())) {
                chaveAutorizada = manifestoDocumento.getChaveAcesso().concat("-procNFe.xml");
                mapArquivos.put(chaveAutorizada, manifestoDocumento.getArquivoXmlAutorizado().getBytes(StandardCharsets.UTF_8));
            }
            if (!Util.stringNullOrEmpty((String)manifestoDocumento.getArquivoXmlCancelado())) {
                mapArquivos.put(manifestoDocumento.getChaveAcesso().concat("-canc.xml"), manifestoDocumento.getArquivoXmlCancelado().getBytes(StandardCharsets.UTF_8));
            }
            if (!Util.stringNullOrEmpty((String)manifestoDocumento.getArquivoXmlEncerrado())) {
                mapArquivos.put(manifestoDocumento.getChaveAcesso().concat("-enc.xml"), manifestoDocumento.getArquivoXmlEncerrado().getBytes(StandardCharsets.UTF_8));
            }
            if (!Util.listNullOrEmpty((List)(listaEventos = ManifestoEventoPagFreteCommonRN.getInstance().buscarListaPorIdManifesto(manifestoDocumento.getId())))) {
                for (Object evento : listaEventos) {
                    if (evento.getArquivoTransmitido() == null || evento.getArquivoTransmitido().length <= 0) continue;
                    mapArquivos.put(manifestoDocumento.getChaveAcesso().concat("-evento-pag-frete" + evento.getSequencia() + ".xml"), evento.getArquivoTransmitido());
                }
            }
            List condutores = ManifestoCondutorVeiculoCommonRN.getInstance().buscarListaPorIdManifesto(manifestoDocumento.getId());
            if (!Util.listNullOrEmpty((List)listaEventos)) {
                for (ManifestoCondutorVeiculo condutor : condutores) {
                    if (Util.stringNullOrEmpty((String)condutor.getArquivoXmlEvento())) continue;
                    mapArquivos.put(manifestoDocumento.getChaveAcesso().concat("-condutor" + condutor.getSequenciaEvento() + ".xml"), condutor.getArquivoXmlEvento().getBytes(StandardCharsets.UTF_8));
                }
            }
            if (mapArquivos.size() == 1) {
                return this.responseEntityService.createXMLResponse((byte[])mapArquivos.get(chaveAutorizada), chaveAutorizada);
            }
            File file = FileUtil.montaZipFilePorByte(mapArquivos, (String)"Xmls da MDF-e ".concat(manifestoDocumento.getChaveAcesso()).concat(".zip"));
            return this.responseEntityService.createZIPResponse(FileUtil.file2ByteArray((File)file), "Xmls da MDF-e ".concat(manifestoDocumento.getChaveAcesso()));
        }
        throw new UnicoMensagemUsuarioException("WWW517", "MDF-e n\u00e3o encontrado.");
    }

    @RequestMapping(value={"/validar-xml-sefaz"})
    @DBAutoCommit
    public String validarXML(@RequestParam Long idMdfe) throws UnicoMensagemUsuarioException {
        return new MdfeManagerWeb(SessaoUtil.getSessao(), null).getMdfeManager().gerarXMLMdfe(idMdfe);
    }

    void verificarValidadeCertificado(MdfeManagerWeb mdfeManagerWeb) throws UnicoMensagemUsuarioException {
        String mensagemCertificado = mdfeManagerWeb.getValidadeCertificado();
        if (!StringUtil.stringNullOrEmpty((String)mensagemCertificado)) {
            this.notificationService.simpleNotifyUserTenantNow(ContextoHolder.getTenant(), SessaoUtil.getSessao().getIdUsuario(), TipoNotificacaoSimples.WARNING, mensagemCertificado);
        }
    }
}

