/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.modeloetiqueta;

import br.intelidata.commons.bridge.ContextoHolder;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.sql.usql.ColunaSQL;
import br.intelidata.commons.core.sql.usql.Condicao;
import br.intelidata.commons.core.sql.usql.Operador;
import br.intelidata.commons.core.sql.usql.OperadorLogico;
import br.intelidata.commons.core.sql.usql.Ordem;
import br.intelidata.commons.core.sql.usql.Referencia;
import br.intelidata.commons.core.sql.usql.Separador;
import br.intelidata.commons.core.util.Malote;
import br.intelidata.commons.core.util.Util;
import br.intelidata.commons.domain.pojo.ModeloEtiqueta;
import br.intelidata.commons.domain.pojo.ModeloEtiquetaCampo;
import br.intelidata.commons.domain.pojo.enuns.LayoutEtiqueta;
import br.intelidata.commons.domain.pojo.enuns.TipoImagem;
import br.intelidata.commons.domain.regranegocio.AbstractRegraNegocio;
import br.intelidata.commons.domain.regranegocio.ModeloEtiquetaCampoCommonRN;
import br.intelidata.commons.modulo.etiqueta.ModeloEtiquetaModel;
import br.intelidata.commons.modulo.etiqueta.regranegocio.ModeloEtiquetaRN;
import br.intelidata.core.aop.DBAutoCommit;
import br.intelidata.uniplusweb.core.grid.GridBuilder;
import br.intelidata.uniplusweb.core.util.StringUtil;
import br.intelidata.uniplusweb.web.enums.TipoArquivoArmazenado;
import br.intelidata.uniplusweb.web.rest.app.client.crud.CrudController;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.multipart.MultipartFile;

public abstract class ModeloEtiquetaCrudController
extends CrudController<ModeloEtiqueta, ModeloEtiquetaRN> {
    protected LayoutEtiqueta layoutEtiqueta;

    public ModeloEtiquetaCrudController() {
        this(null);
    }

    public ModeloEtiquetaCrudController(LayoutEtiqueta layoutEtiqueta) {
        super((AbstractRegraNegocio)ModeloEtiquetaRN.getInstance(), ModeloEtiqueta::new, true, true, TipoArquivoArmazenado.Etiqueta);
        this.layoutEtiqueta = layoutEtiqueta;
    }

    public abstract ModeloEtiquetaModel getModelo();

    @RequestMapping(value={"/modelo-default"})
    @DBAutoCommit
    public List<ModeloEtiquetaCampo> getModeloDefault() {
        return this.carregarModeloDefault();
    }

    protected List<ModeloEtiquetaCampo> carregarModeloDefault() {
        return this.getModelo().getListaCamposPadrao();
    }

    protected void beforeRead(ModeloEtiqueta modeloEtiqueta, int modo, Optional<Long> parentId) {
        List campos = ModeloEtiquetaCampoCommonRN.getInstance().buscarCamposPorModeloEtiqueta(modeloEtiqueta.getId());
        modeloEtiqueta.setCampos(campos);
        ModeloEtiquetaModel modelo = this.getModelo();
        modelo.setModeloEtiqueta(modeloEtiqueta);
        modeloEtiqueta.setCampos(modelo.getListaCampos());
        if (!StringUtil.stringNullOrEmpty((String)modeloEtiqueta.getCaminhoLogo())) {
            modeloEtiqueta.setCaminhoLogo(this.saveFile.publishImagem(ContextoHolder.getTenant(), TipoArquivoArmazenado.Etiqueta, TipoImagem.Pequena, modeloEtiqueta.getCaminhoLogo()));
        }
    }

    protected void beforeDelete(ModeloEtiqueta modeloEtiqueta) {
        List campos = ModeloEtiquetaCampoCommonRN.getInstance().buscarCamposPorModeloEtiqueta(modeloEtiqueta.getId());
        modeloEtiqueta.setCampos(campos);
        if (!StringUtil.stringNullOrEmpty((String)modeloEtiqueta.getCaminhoLogo())) {
            this.saveFile.excluirImagem(ContextoHolder.getTenant(), TipoArquivoArmazenado.Etiqueta, modeloEtiqueta.getCaminhoLogo());
        }
    }

    @RequestMapping(value={"/exportar-etiqueta"}, method={RequestMethod.POST})
    public ResponseEntity<byte[]> exportarModelo(@RequestBody ModeloEtiqueta modelo) throws UnicoMensagemUsuarioException {
        return this.exportar(modelo);
    }

    protected ResponseEntity<byte[]> exportar(ModeloEtiqueta modelo) throws UnicoMensagemUsuarioException {
        Malote malote = new Malote();
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(modelo);
            oos.close();
            malote.inclui("modeloimp", baos);
            malote.fecha();
        }
        catch (IOException io) {
            throw new UnicoMensagemUsuarioException("ETQ63", "Ocorreu um erro ao gerar o arquivo", (Throwable)io);
        }
        String nomeArquivo = "modeloEtiqueta";
        if (!Util.stringNullOrEmpty((String)modelo.getDescricao())) {
            nomeArquivo = modelo.getDescricao();
        }
        HttpHeaders headers = new HttpHeaders();
        headers.add("Content-Disposition", "attachment;filename=" + nomeArquivo + ".obj");
        return new ResponseEntity((Object)malote.extrai("modeloimp"), (MultiValueMap)headers, HttpStatus.OK);
    }

    @RequestMapping(value={"/importar-etiqueta"}, method={RequestMethod.POST})
    public ModeloEtiqueta importarModelo(@RequestPart(value="file") MultipartFile file) throws UnicoMensagemUsuarioException {
        return this.importar(file);
    }

    protected ModeloEtiqueta importar(MultipartFile file) throws UnicoMensagemUsuarioException {
        try {
            Malote malote = new Malote();
            malote.inclui("modeloimp", file.getBytes());
            malote.fecha();
            ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(malote.extrai("modeloimp")));
            Object objeto = ois.readObject();
            ois.close();
            return (ModeloEtiqueta)objeto;
        }
        catch (IOException | ClassCastException | ClassNotFoundException ex) {
            throw new UnicoMensagemUsuarioException("COM236577", "N\u00e3o \u00e9 poss\u00edvel importar o modelo de impress\u00e3o nesta vers\u00e3o do sistema.");
        }
    }

    protected void beforeSave(ModeloEtiqueta modeloEtiqueta, Optional<Long> parentId) throws UnicoMensagemUsuarioException {
        if (!LayoutEtiqueta.DANFE_SIMPLIFICADA.equals((Object)modeloEtiqueta.getTipoLayout())) {
            modeloEtiqueta.setTipoLayout(this.getModelo().getLayoutEtiqueta());
        }
    }

    protected void beforeUpdate(ModeloEtiqueta modeloEtiqueta, Optional<Long> parentId) throws UnicoMensagemUsuarioException {
        ModeloEtiqueta modeloOriginal = (ModeloEtiqueta)((ModeloEtiquetaRN)this.rn).buscarPorId(modeloEtiqueta.getId());
        if (!StringUtil.stringNullOrEmpty((String)modeloOriginal.getCaminhoLogo())) {
            String arquivoRelativo = this.saveFile.publishImagem(ContextoHolder.getTenant(), TipoArquivoArmazenado.Entidade, TipoImagem.Pequena, modeloOriginal.getCaminhoLogo());
            if (StringUtil.stringNullOrEmpty((String)modeloEtiqueta.getCaminhoLogo()) || !modeloEtiqueta.getCaminhoLogo().equals(arquivoRelativo)) {
                this.saveFile.excluirImagem(ContextoHolder.getTenant(), TipoArquivoArmazenado.Usuario, modeloOriginal.getCaminhoLogo());
            } else {
                modeloEtiqueta.setCaminhoLogo(modeloOriginal.getCaminhoLogo());
            }
        }
    }

    protected GridBuilder<ModeloEtiquetaRN> getGridBuilder() {
        List<ColunaSQL> colunas = Arrays.asList(new ColunaSQL("id", "C\u00f3digo", 0, false), new ColunaSQL("descricao", "Descri\u00e7\u00e3o", 0, true));
        GridBuilder gridBuilder = new GridBuilder(ModeloEtiquetaRN.getInstance().getTabela(), colunas);
        gridBuilder.addReferenciaDefault(new Referencia("scriptetiqueta"));
        gridBuilder.addReferenciaDefault(new Referencia("tipolayout"));
        gridBuilder.addCodicaoDefault(new Condicao(Separador.ABRE_PARENTESIS));
        gridBuilder.addCodicaoDefault(new Condicao("scriptetiqueta", Operador.IS_NULL));
        gridBuilder.addCodicaoDefault(new Condicao(OperadorLogico.OU));
        gridBuilder.addCodicaoDefault(new Condicao("scriptetiqueta", Operador.IGUAL, ""));
        gridBuilder.addCodicaoDefault(new Condicao(Separador.FECHA_PARENTESIS));
        gridBuilder.addCodicaoDefault(new Condicao(OperadorLogico.E));
        gridBuilder.addCodicaoDefault(new Condicao("tipolayout", Operador.IGUAL, this.layoutEtiqueta.getId().intValue()));
        gridBuilder.addOrdem(new Ordem("descricao"));
        return gridBuilder;
    }
}

