/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.nfcesat;

import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.periferico.impressoraNaoFiscal.ImpressoraNaoFiscalPDF;
import br.intelidata.commons.core.sistema.Sessao;
import br.intelidata.commons.core.util.Malote;
import br.intelidata.commons.core.util.Notificacao;
import br.intelidata.commons.core.util.TipoNotificacao;
import br.intelidata.commons.core.util.UnicoByteArrayDataSource;
import br.intelidata.commons.core.util.Util;
import br.intelidata.commons.domain.pojo.Filial;
import br.intelidata.commons.domain.pojo.Operacao;
import br.intelidata.commons.domain.pojo.ParametroNfceSat;
import br.intelidata.commons.domain.wrapper.NotificacaoCompartilhamento;
import br.intelidata.commons.modulo.cadastros.regranegocio.FilialRN;
import br.intelidata.commons.modulo.pdv.regranegocio.OperacaoRN;
import br.intelidata.uniplusweb.core.util.StringUtil;
import br.intelidata.uniplusweb.web.rest.app.batch.TaskManager;
import br.intelidata.uniplusweb.web.rest.app.client.crud.CompartilhamentoController;
import br.intelidata.uniplusweb.web.rest.app.client.crud.CreateTaskEmail;
import br.intelidata.uniplusweb.web.rest.app.crud.nfcesat.NfceUtil;
import br.intelidata.uniplusweb.wrapper.ParametrosEmailWeb;
import java.time.temporal.Temporal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.activation.DataSource;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import unipaf.nfce.GeraDanfeNfce;
import unipaf.nfce.ImpressaoDanfePDF;
import unipaf.pojo.nfce.DanfeNfce;

@RestController
@RequestMapping(value={"/jobs/nfces"})
public class NfceSatJobController
extends CompartilhamentoController<NotificacaoCompartilhamento> {
    public NfceSatJobController(TaskManager taskManager) {
        super(taskManager);
    }

    protected List<Notificacao> getNotificacoes(Sessao sessao, NotificacaoCompartilhamento compartilhamento) throws UnicoMensagemUsuarioException {
        Operacao operacao = OperacaoRN.getInstance().buscarOperacaoCompletaPorId((Long)compartilhamento.getIdsDocumentos().get(0));
        if (compartilhamento.getTipoNotificacao().equals((Object)TipoNotificacao.EMAIL) && StringUtil.stringNullOrEmpty((String)compartilhamento.getEmail())) {
            throw new UnicoMensagemUsuarioException("WWW298", "Email n\u00e3o configurado");
        }
        if (compartilhamento.getTipoNotificacao().equals((Object)TipoNotificacao.WHATSAPP) && StringUtil.stringNullOrEmpty((String)compartilhamento.getCelular())) {
            throw new UnicoMensagemUsuarioException("WWW571", "Celular n\u00e3o configurado");
        }
        Notificacao notificacao = new Notificacao();
        notificacao.setFone(compartilhamento.getCelular());
        notificacao.setEmail(compartilhamento.getEmail());
        notificacao.setEmailCopia(compartilhamento.getCopiaPara());
        notificacao.setAssunto(compartilhamento.getAssunto());
        operacao.setEmail(compartilhamento.getEmail());
        OperacaoRN.getInstance().alterar(operacao, sessao);
        Malote malote = new Malote();
        ArrayList<UnicoByteArrayDataSource> dataSources = new ArrayList<UnicoByteArrayDataSource>();
        String numeroNfce = operacao.getNumeroNfce();
        if (operacao.getXmlNfceAutorizado() != null) {
            malote.inclui(numeroNfce + ".xml", operacao.getXmlNfceAutorizado());
            dataSources.add(new UnicoByteArrayDataSource(operacao.getXmlNfceAutorizado(), numeroNfce + ".xml", "text/xml"));
        }
        Filial filialOperacao = (Filial)FilialRN.getInstance().buscarPorCodigo(operacao.getFilial());
        ImpressoraNaoFiscalPDF pdf = new ImpressoraNaoFiscalPDF();
        pdf.setCabecalho(ImpressaoDanfePDF.getCabecalhoPadrao((Filial)filialOperacao));
        pdf.setLogoTipo(NfceUtil.getLogoTipo((ParametroNfceSat)filialOperacao.getParametroNfceSat()));
        DanfeNfce danfe = new GeraDanfeNfce().getDanfe(operacao.getId());
        ImpressaoDanfePDF danfePdf = new ImpressaoDanfePDF(danfe, pdf.getColunas());
        byte[] arquivo = pdf.getBytesImpressao(danfePdf.getDanfe().toString());
        UnicoByteArrayDataSource dataSourcePdf = new UnicoByteArrayDataSource(arquivo, "NFC-e-" + numeroNfce + ".pdf", "application/pdf");
        dataSources.add(dataSourcePdf);
        malote.inclui("NFC-e-" + numeroNfce + ".pdf", arquivo);
        if (operacao.getXmlNfceCancelamento() != null) {
            malote.inclui(numeroNfce + "-canc.xml", operacao.getXmlNfceCancelamento());
            dataSources.add(new UnicoByteArrayDataSource(operacao.getXmlNfceCancelamento(), numeroNfce + "-canc.xml", "text/xml"));
        }
        String msg = "Segue em anexo arquivo digital e c\u00f3pia da Danfe NFC-e\nChave de acesso: " + Util.apenasNumeros((String)danfe.getChaveAcesso()) + "\nS\u00e9rie/N\u00famero: " + danfe.getSerie() + "/" + danfe.getNumero() + "\nEmiss\u00e3o: " + StringUtil.formataDataHora((Temporal)danfe.getHoraFinal(), (String)"dd/MM/yyyy HH:mm:ss") + "\nEmitente: " + sessao.getFilial().getRazaoSocialCompleta();
        String assunto = "Distribui\u00e7\u00e3o de NFC-e " + sessao.getFilial().getRazaoSocialCompleta();
        notificacao.setMsg(msg);
        notificacao.setAssunto(assunto);
        notificacao.setDataSources(dataSources.toArray(new DataSource[0]));
        notificacao.setMalote(malote);
        return Collections.singletonList(notificacao);
    }

    protected void createJobEmail(Sessao sessao, ParametrosEmailWeb parametrosEmail, NotificacaoCompartilhamento compartilhamento) throws UnicoMensagemUsuarioException {
        CreateTaskEmail taskEmail = new CreateTaskEmail(this.taskManager, parametrosEmail, "NFC-e");
        taskEmail.createTask((Object)parametrosEmail, parametrosEmail.getAssunto());
    }
}

