/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.notafiscal;

import br.intelidata.commons.bridge.ContextoHolder;
import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.execoes.UnicoPerguntaUsuarioException;
import br.intelidata.commons.core.licenca.Funcionalidade;
import br.intelidata.commons.core.licenca.FuncionalidadeManager;
import br.intelidata.commons.core.licenca.LicencaManager;
import br.intelidata.commons.core.licenca.Modulo;
import br.intelidata.commons.core.licenca.ModuloManager;
import br.intelidata.commons.core.sistema.PropriedadeRN;
import br.intelidata.commons.core.sistema.Sessao;
import br.intelidata.commons.core.sql.model.Coluna;
import br.intelidata.commons.core.sql.model.TipoDadoBase;
import br.intelidata.commons.core.sql.usql.Caso;
import br.intelidata.commons.core.sql.usql.ColunaCustomizavelGrid;
import br.intelidata.commons.core.sql.usql.ColunaSQL;
import br.intelidata.commons.core.sql.usql.Condicao;
import br.intelidata.commons.core.sql.usql.Escolha;
import br.intelidata.commons.core.sql.usql.Operador;
import br.intelidata.commons.core.sql.usql.Ordem;
import br.intelidata.commons.core.sql.usql.Referencia;
import br.intelidata.commons.core.sql.usql.USelect;
import br.intelidata.commons.core.util.BeanUtil;
import br.intelidata.commons.core.util.CacheSistema;
import br.intelidata.commons.core.util.DataHoraFactory;
import br.intelidata.commons.core.util.EnumSimNao;
import br.intelidata.commons.core.util.IFileStorage;
import br.intelidata.commons.core.util.Util;
import br.intelidata.commons.domain.pojo.AbstractPojo;
import br.intelidata.commons.domain.pojo.CfopItem;
import br.intelidata.commons.domain.pojo.ComponenteSaldoQuantidade;
import br.intelidata.commons.domain.pojo.CondicaoPagamento;
import br.intelidata.commons.domain.pojo.ConsultaPrecoProduto;
import br.intelidata.commons.domain.pojo.Custo;
import br.intelidata.commons.domain.pojo.DescontoInterface;
import br.intelidata.commons.domain.pojo.Embalagem;
import br.intelidata.commons.domain.pojo.Entidade;
import br.intelidata.commons.domain.pojo.Estado;
import br.intelidata.commons.domain.pojo.Filial;
import br.intelidata.commons.domain.pojo.FinanceiroDado;
import br.intelidata.commons.domain.pojo.FormacaoPrecoProduto;
import br.intelidata.commons.domain.pojo.HierarquiaPlanoContas;
import br.intelidata.commons.domain.pojo.ItemKit;
import br.intelidata.commons.domain.pojo.ItemWeb;
import br.intelidata.commons.domain.pojo.LimiteCreditoEntidade;
import br.intelidata.commons.domain.pojo.ModeloNotaFiscal;
import br.intelidata.commons.domain.pojo.NaturezaOperacao;
import br.intelidata.commons.domain.pojo.NaturezaOperacaoDTOWeb;
import br.intelidata.commons.domain.pojo.NotaFiscalItemLote;
import br.intelidata.commons.domain.pojo.OperacaoFiscal;
import br.intelidata.commons.domain.pojo.ParametrosNotaFiscalInterface;
import br.intelidata.commons.domain.pojo.Produto;
import br.intelidata.commons.domain.pojo.ProdutoDTOWeb;
import br.intelidata.commons.domain.pojo.ProdutoItem;
import br.intelidata.commons.domain.pojo.ProdutoItemWeb;
import br.intelidata.commons.domain.pojo.ProdutoPreco;
import br.intelidata.commons.domain.pojo.Promocao;
import br.intelidata.commons.domain.pojo.Serie;
import br.intelidata.commons.domain.pojo.compras.PedidoCompraItem;
import br.intelidata.commons.domain.pojo.entidade.ConfiguracaoLimiteCredito;
import br.intelidata.commons.domain.pojo.entidade.LimiteCreditoFormaPgmto;
import br.intelidata.commons.domain.pojo.enuns.EnumUtils;
import br.intelidata.commons.domain.pojo.enuns.FinalidadeEmissaoNfeCFOP;
import br.intelidata.commons.domain.pojo.enuns.StatusNotaFiscal;
import br.intelidata.commons.domain.pojo.enuns.StatusPrecoCompra;
import br.intelidata.commons.domain.pojo.enuns.TipoAcaoExcluir;
import br.intelidata.commons.domain.pojo.enuns.TipoAcaoFinanceiro;
import br.intelidata.commons.domain.pojo.enuns.TipoEmbalagem;
import br.intelidata.commons.domain.pojo.enuns.TipoEmissaoNotaFiscal;
import br.intelidata.commons.domain.pojo.enuns.TipoFrete;
import br.intelidata.commons.domain.pojo.enuns.TipoIntegracaoFinanceiro;
import br.intelidata.commons.domain.pojo.enuns.TipoKit;
import br.intelidata.commons.domain.pojo.enuns.TipoMascara;
import br.intelidata.commons.domain.pojo.enuns.TipoNotaFiscal;
import br.intelidata.commons.domain.pojo.enuns.TipoNotificacaoSimples;
import br.intelidata.commons.domain.pojo.enuns.TipoPessoa;
import br.intelidata.commons.domain.pojo.enuns.TipoRegistroProduto;
import br.intelidata.commons.domain.pojo.enuns.TipoRemessaTerceiros;
import br.intelidata.commons.domain.pojo.enuns.TipoRetiradaEntregaItem;
import br.intelidata.commons.domain.pojo.enuns.TipoValorPreco;
import br.intelidata.commons.domain.pojo.enuns.notafiscal.CampoRateioCalculoImposto;
import br.intelidata.commons.domain.pojo.enuns.notafiscal.TipoCalculoImposto;
import br.intelidata.commons.domain.pojo.enuns.notafiscal.TipoGeracaoAutomaticaNotaFiscal;
import br.intelidata.commons.domain.pojo.notafiscal.AbstractDocumentoFinanceiro;
import br.intelidata.commons.domain.pojo.notafiscal.AcaoAlterarNotaFiscal;
import br.intelidata.commons.domain.pojo.notafiscal.AcaoExcluirNotaFiscal;
import br.intelidata.commons.domain.pojo.notafiscal.DocumentoPesavelInterface;
import br.intelidata.commons.domain.pojo.notafiscal.ItemTributavelInterface;
import br.intelidata.commons.domain.pojo.notafiscal.NotaFiscal;
import br.intelidata.commons.domain.pojo.notafiscal.NotaFiscalDocumentoFinanceiro;
import br.intelidata.commons.domain.pojo.notafiscal.NotaFiscalDocumentoReferenciado;
import br.intelidata.commons.domain.pojo.notafiscal.NotaFiscalItem;
import br.intelidata.commons.domain.pojo.pafecf.AdministradoraCartao;
import br.intelidata.commons.domain.pojo.pafecf.BandeiraCartao;
import br.intelidata.commons.domain.pojo.vendas.ContratoVendaNotaFiscal;
import br.intelidata.commons.domain.regranegocio.DescontoRN;
import br.intelidata.commons.domain.regranegocio.EmbalagemCommonRN;
import br.intelidata.commons.domain.regranegocio.NotaFiscalItemLoteCommonRN;
import br.intelidata.commons.domain.regranegocio.ProdutoItemRN;
import br.intelidata.commons.domain.regranegocio.UsuarioCommonRN;
import br.intelidata.commons.domain.regranegocio.b2c.TransacaoFinanceiraRN;
import br.intelidata.commons.domain.regranegocio.notafiscal.CalculoImposto;
import br.intelidata.commons.domain.regranegocio.notafiscal.CalculoImpostoRateio;
import br.intelidata.commons.domain.wrapper.ImpostoWrapper;
import br.intelidata.commons.modulo.cadastros.regranegocio.EstadoRN;
import br.intelidata.commons.modulo.cadastros.regranegocio.FilialRN;
import br.intelidata.commons.modulo.compras.regranegocio.PedidoCompraItemRN;
import br.intelidata.commons.modulo.contrato.regranegocio.ContratoVendaNotaFiscalRN;
import br.intelidata.commons.modulo.custo.regranegocio.CustoFactory;
import br.intelidata.commons.modulo.custo.regranegocio.CustoRN;
import br.intelidata.commons.modulo.entidade.regranegocio.EntidadeRN;
import br.intelidata.commons.modulo.entidade.regranegocio.LimiteCreditoFormaPgmtoRN;
import br.intelidata.commons.modulo.financeiro.centrocusto.enuns.OrigemRateioCentroCusto;
import br.intelidata.commons.modulo.financeiro.centrocusto.regranegocio.CentroCustoRateioRN;
import br.intelidata.commons.modulo.financeiro.regranegocio.FinanceiroDadoRN;
import br.intelidata.commons.modulo.financeiro.regranegocio.HierarquiaPlanoContasRN;
import br.intelidata.commons.modulo.notafiscal.nfse.NfseManagerWeb;
import br.intelidata.commons.modulo.notafiscal.regranegocio.GeradorNotaFiscalAutomaticaXML;
import br.intelidata.commons.modulo.notafiscal.regranegocio.NaturezaOperacaoRN;
import br.intelidata.commons.modulo.notafiscal.regranegocio.NotaFiscalDefensivoAgricolaRN;
import br.intelidata.commons.modulo.notafiscal.regranegocio.NotaFiscalDocumentoFinanceiroRN;
import br.intelidata.commons.modulo.notafiscal.regranegocio.NotaFiscalDocumentoReferenciadoRN;
import br.intelidata.commons.modulo.notafiscal.regranegocio.NotaFiscalItemRN;
import br.intelidata.commons.modulo.notafiscal.regranegocio.NotaFiscalObsContribuinteRN;
import br.intelidata.commons.modulo.notafiscal.regranegocio.NotaFiscalObsFiscoRN;
import br.intelidata.commons.modulo.notafiscal.regranegocio.NotaFiscalOrigemRN;
import br.intelidata.commons.modulo.notafiscal.regranegocio.NotaFiscalRN;
import br.intelidata.commons.modulo.notafiscal.regranegocio.SaldoFiscalBaixaRN;
import br.intelidata.commons.modulo.notafiscal.regranegocio.SerieRN;
import br.intelidata.commons.modulo.pdv.regranegocio.AdministradoraCartaoRN;
import br.intelidata.commons.modulo.pdv.regranegocio.BandeiraCartaoRN;
import br.intelidata.commons.modulo.pdv.regranegocio.ItemRN;
import br.intelidata.commons.modulo.preco.regranegocio.FormacaoPrecoProdutoRN;
import br.intelidata.commons.modulo.produto.dao.ColunaCustomizavelCodigoCargaNotaFiscal;
import br.intelidata.commons.modulo.produto.dao.ColunaCustomizavelDataCargaNotaFiscal;
import br.intelidata.commons.modulo.produto.dao.ColunaCustomizavelNotaPossuiDevolucao;
import br.intelidata.commons.modulo.produto.dao.ColunaCustomizavelStatusCargaNotaFiscal;
import br.intelidata.commons.modulo.produto.dao.ColunaCustomizavelUsuarioCargaNotaFiscal;
import br.intelidata.commons.modulo.produto.regranegocio.GeradorKitVenda;
import br.intelidata.commons.modulo.produto.regranegocio.GeradorKitVendaNotaFiscal;
import br.intelidata.commons.modulo.produto.regranegocio.ProdutoRN;
import br.intelidata.commons.modulo.produto.regranegocio.UnidademedidaRN;
import br.intelidata.commons.modulo.produto.regranegocio.VariacaoRN;
import br.intelidata.commons.modulo.vendas.regranegocio.CondicaoPagamentoRN;
import br.intelidata.commons.modulo.vendas.regranegocio.PromocaoRN;
import br.intelidata.commons.sped.fiscal.PosseItem;
import br.intelidata.core.aop.DBAutoCommit;
import br.intelidata.core.aop.DBTransaction;
import br.intelidata.uniplusweb.core.grid.FilterField;
import br.intelidata.uniplusweb.core.grid.GridBuilder;
import br.intelidata.uniplusweb.core.util.DateUtil;
import br.intelidata.uniplusweb.core.util.JsonUtil;
import br.intelidata.uniplusweb.core.util.ListMapUtil;
import br.intelidata.uniplusweb.core.util.NumberUtil;
import br.intelidata.uniplusweb.core.util.StringUtil;
import br.intelidata.uniplusweb.service.ArquivoFiscalWeb;
import br.intelidata.uniplusweb.service.FuncionalidadeService;
import br.intelidata.uniplusweb.service.ModuloService;
import br.intelidata.uniplusweb.service.socket.NotificationType;
import br.intelidata.uniplusweb.web.rest.app.calculoimposto.CalculoImpostoService;
import br.intelidata.uniplusweb.web.rest.app.client.crud.TabelaConfigurada;
import br.intelidata.uniplusweb.web.rest.app.crud.kit.ItemKitWrapper;
import br.intelidata.uniplusweb.web.rest.app.crud.notafiscal.NotaFiscalDTO;
import br.intelidata.uniplusweb.web.rest.app.crud.notafiscal.NotaFiscalExclusaoWrapper;
import br.intelidata.uniplusweb.web.rest.app.crud.notafiscal.NotaFiscalLimiteCreditoWrapper;
import br.intelidata.uniplusweb.web.rest.app.crud.notafiscal.NotaFiscalTratamentoImposto;
import br.intelidata.uniplusweb.web.rest.app.crud.notafiscal.TriangulacaoWrapper;
import br.intelidata.uniplusweb.web.rest.app.crud.notafiscal.transmissao.TransmissaoNotaFiscalCrudController;
import br.intelidata.uniplusweb.web.rest.app.crud.notafiscal.transmissao.wrapper.ItemNotaFiscalWrapper;
import br.intelidata.uniplusweb.web.rest.app.wrapper.ImpostoCalculadoWrapper;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

public abstract class NotaFiscalCrudController
extends TransmissaoNotaFiscalCrudController {
    private final NotaFiscalTratamentoImposto tratamentoImposto;
    private final CalculoImpostoService<NotaFiscalItem> calculoImpostoService;
    private final TipoNotaFiscal tipoNotaFiscal;
    private final FuncionalidadeService funcionalidadeService;
    private final ModuloService moduloService;
    private final ArquivoFiscalWeb arquivoFiscal;

    public NotaFiscalCrudController(NotaFiscalTratamentoImposto tratamentoImposto, CalculoImpostoService<NotaFiscalItem> calculoImpostoService, FuncionalidadeService funcionalidadeService, TipoNotaFiscal tipoNotaFiscal, ArquivoFiscalWeb arquivoFiscal, ModuloService moduloService) {
        super(calculoImpostoService, arquivoFiscal);
        this.tratamentoImposto = tratamentoImposto;
        this.calculoImpostoService = calculoImpostoService;
        this.funcionalidadeService = funcionalidadeService;
        this.tipoNotaFiscal = tipoNotaFiscal;
        this.arquivoFiscal = arquivoFiscal;
        this.moduloService = moduloService;
    }

    @RequestMapping(value={"/buscar-preco-produto"})
    @DBAutoCommit
    public ProdutoPreco getProdutoPreco(@RequestParam Long idProduto, @RequestParam Long pauta, @RequestParam(required=false) Map<Integer, Integer> variacoes, @RequestParam(required=false) Long idEmbalagem) {
        ProdutoPreco produtoPreco = ProdutoRN.getInstance().getPreco(new ConsultaPrecoProduto(SessaoUtil.getSessao().getFilial(), idProduto, pauta, variacoes, idEmbalagem));
        if (this.funcionalidadeService.isAtiva(Funcionalidade.PRECO_POR_FILIAL)) {
            Map precos = FormacaoPrecoProdutoRN.getInstance().getPrecoMinimoVendaProdutoWeb(SessaoUtil.getSessao().getIdFilial(), idProduto);
            produtoPreco.setPrecoMinimoVenda((BigDecimal)precos.get("precoMinimoVenda"));
            produtoPreco.setPrecoProdutoOriginal((BigDecimal)precos.get("precoProdutoOriginal"));
        }
        return produtoPreco;
    }

    @RequestMapping(value={"/quantidade-notas-por-fornecedor"})
    @DBAutoCommit
    public int getQuantidadeNotaPorFornecedor(@RequestParam Long idFornecedor, @RequestParam String numeroNF, @RequestParam String modelo, @RequestParam String serie) {
        return NotaFiscalRN.getInstance().getNumeroOcorrenciasNumeroNotaFiscalPorFornecedor(idFornecedor, numeroNF, modelo, serie);
    }

    @RequestMapping(value={"/verificar-limites-credito"})
    @DBAutoCommit
    public NotaFiscalLimiteCreditoWrapper verificaLimiteDeCredito(@RequestParam Long idEntidade) {
        ConfiguracaoLimiteCredito configuracaoLimiteCredito = new ConfiguracaoLimiteCredito(SessaoUtil.getSessao().getFilial());
        configuracaoLimiteCredito.setConsideraOrdensServico(false);
        LimiteCreditoEntidade limiteCreditoEntidade = EntidadeRN.getInstance().buscaLimiteCredito(idEntidade, null, null, null, configuracaoLimiteCredito);
        NotaFiscalLimiteCreditoWrapper wrapper = new NotaFiscalLimiteCreditoWrapper();
        if (this.funcionalidadeService.isAtiva(Funcionalidade.LIMITE_CREDITO_FORMA_PGMTO)) {
            List limites = LimiteCreditoFormaPgmtoRN.getInstance().buscaLimitesFormaPgmtoDisponivel(idEntidade, configuracaoLimiteCredito);
            BigDecimal limiteCredito = limites.stream().map(LimiteCreditoFormaPgmto::getValorLimiteCredito).reduce(BigDecimal.ZERO, BigDecimal::add);
            wrapper.setValorLimiteCreditoNota(limiteCredito);
            if (!ListMapUtil.listNullOrEmpty((List)limites)) {
                wrapper.setValorLimiteCredito(limiteCredito.subtract(limiteCreditoEntidade.getDividaTotal()));
                wrapper.setValorLimiteCreditoDisponivel(wrapper.getValorLimiteCredito());
                String descLimite = StringUtil.bigDecimal2String((BigDecimal)wrapper.getValorLimiteCredito(), (String)"###,###,##0.00");
                String descLimiteTresPgmtos = LimiteCreditoFormaPgmtoRN.getInstance().getLimiteCredito(limites, true);
                if (!StringUtil.stringNullOrEmpty((String)descLimiteTresPgmtos)) {
                    descLimite = descLimite + descLimiteTresPgmtos;
                }
                wrapper.setDescricaoLimiteCredito(descLimite);
            } else {
                wrapper.setValorLimiteCreditoDisponivel(wrapper.getValorLimiteCredito());
                wrapper.setDescricaoLimiteCredito(StringUtil.bigDecimal2String((BigDecimal)wrapper.getValorLimiteCredito(), (String)"###,###,##0.00"));
            }
        } else {
            wrapper.setValorLimiteCredito(limiteCreditoEntidade.getLimiteCreditoDisponivel());
            wrapper.setValorLimiteCreditoNota(limiteCreditoEntidade.getLimiteCredito());
            wrapper.setValorLimiteCreditoDisponivel(wrapper.getValorLimiteCredito());
            wrapper.setDescricaoLimiteCredito(StringUtil.bigDecimal2String((BigDecimal)wrapper.getValorLimiteCredito(), (String)"###,###,##0.00"));
        }
        wrapper.setValorDividaAtiva(limiteCreditoEntidade.getDividaTotal());
        return wrapper;
    }

    @RequestMapping(value={"/buscar-preco"}, method={RequestMethod.POST})
    @DBAutoCommit
    public ProdutoItemWeb<NotaFiscalItem> getPrecoProduto(@RequestBody ImpostoWrapper<NotaFiscalItem> wrapper) throws UnicoMensagemUsuarioException {
        Promocao promocao;
        CondicaoPagamento cPagamento;
        ConsultaPrecoProduto consultaPrecoProduto;
        Embalagem embalagem;
        Sessao sessao = SessaoUtil.getSessao();
        NotaFiscalItem item = (NotaFiscalItem)wrapper.getItem();
        NaturezaOperacao naturezaOperacao = NaturezaOperacaoRN.getInstance().buscarPorId(item.getIdCfop());
        if (naturezaOperacao == null) {
            throw new UnicoMensagemUsuarioException("WWW188", "Cfop n\u00e3o encontrada.");
        }
        TipoValorPreco tipoValorPreco = naturezaOperacao.getTipoValorPreco();
        BigDecimal fatorConversao = BigDecimal.ONE;
        if (!NumberUtil.longNullOuZero((Long)item.getIdEmbalagem()) && (embalagem = (Embalagem)EmbalagemCommonRN.getInstance().buscarPorId(item.getIdEmbalagem())) != null) {
            fatorConversao = embalagem.getFatorConversao();
        }
        ProdutoPreco produtoPreco = new ProdutoPreco();
        if (tipoValorPreco != null) {
            if (tipoValorPreco.isCusto()) {
                produtoPreco.setPreco(CustoFactory.getCusto((Long)item.getIdProduto(), (Filial)sessao.getFilial()).getValorPorTipo(tipoValorPreco).multiply(fatorConversao));
            } else {
                consultaPrecoProduto = new ConsultaPrecoProduto(sessao.getFilial(), item.getIdProduto(), item.getPautaPrecoLong(), item.getVariacoes(), item.getIdEmbalagem());
                consultaPrecoProduto.setTipoValorPreco(tipoValorPreco);
                produtoPreco = ProdutoRN.getInstance().getPreco(consultaPrecoProduto);
            }
        } else if (wrapper.isTransferencia()) {
            produtoPreco.setPreco(CustoFactory.getCusto((Long)item.getIdProduto(), (Filial)sessao.getFilial()).getCusto().multiply(fatorConversao));
        } else if (this.isNotaSaida()) {
            consultaPrecoProduto = new ConsultaPrecoProduto(sessao.getFilial(), item.getIdProduto(), item.getPautaPrecoLong(), item.getVariacoes(), item.getIdEmbalagem());
            consultaPrecoProduto.setTipoValorPreco(TipoValorPreco.PRECO);
            produtoPreco = ProdutoRN.getInstance().getPreco(consultaPrecoProduto);
        }
        ProdutoDTOWeb produto = ProdutoRN.getInstance().buscarProdutoDTOWeb(sessao, ((NotaFiscalItem)wrapper.getItem()).getIdProduto());
        if (this.funcionalidadeService.isAtiva(Funcionalidade.PRECO_POR_FILIAL)) {
            Map map = FormacaoPrecoProdutoRN.getInstance().getPrecoMinimoVendaProdutoWeb(sessao.getIdFilial(), produto.getId());
            item.setPrecoMinimoVenda((BigDecimal)map.get("precoMinimoVenda"));
            item.setPrecoProdutoOriginal((BigDecimal)map.get("precoProdutoOriginal"));
        } else {
            item.setPrecoMinimoVenda(produto.getPrecoMinimoVenda());
            item.setPrecoProdutoOriginal(produto.getPreco());
        }
        if (!NumberUtil.bigDecimalNullOrZero((BigDecimal)produtoPreco.getPrecoPromocao())) {
            item.setDescontoPromocao(produtoPreco.getPreco().subtract(produtoPreco.getPrecoPromocao()));
            item.setPrecoUnitario(produtoPreco.getPrecoPromocao());
            item.setIdPromocao(produtoPreco.getIdPromocao());
        } else {
            item.setDescontoPromocao(BigDecimal.ZERO);
            item.setPrecoUnitario(produtoPreco.getPreco());
            item.setIdPromocao(null);
        }
        ParametrosNotaFiscalInterface parametros = this.calculoImpostoService.getParametrosNotaFiscalInterface(wrapper.getIdParametrosNF(), this.calculoImpostoService.utilizaOperacaoFiscal(TipoEmissaoNotaFiscal.PROPRIA.equals((Object)wrapper.getTipoEmissao()), sessao.getIdFilial()));
        if (this.calculoImpostoService.possuiIntegracaoComFinanceiro(parametros) && !NumberUtil.longNullOuZero((Long)wrapper.getIdCondicaoPgmto()) && (cPagamento = (CondicaoPagamento)CondicaoPagamentoRN.getInstance().buscarPorId(wrapper.getIdCondicaoPgmto())) != null) {
            item.setPrecoUnitario(cPagamento.getTipo() == 0 ? item.getPrecoUnitario().multiply(cPagamento.getFator()) : item.getPrecoUnitario().subtract(item.getPrecoUnitario().multiply(cPagamento.getFator())));
        }
        ProdutoItemWeb produtoItemWeb = new ProdutoItemWeb();
        produtoItemWeb.setProdutoPreco(produtoPreco);
        this.tratamentoImposto.tratarObjeto(wrapper);
        ImpostoCalculadoWrapper impostoCalculado = this.calculoImpostoService.calcularImpostos(wrapper, true);
        produtoItemWeb.setItem((ItemWeb)impostoCalculado.getItem());
        produtoItemWeb.setAcoes(impostoCalculado.getAcoes());
        if (!NumberUtil.longNullOuZero((Long)((NotaFiscalItem)produtoItemWeb.getItem()).getIdPromocao()) && (promocao = PromocaoRN.getInstance().buscarPorId(((NotaFiscalItem)produtoItemWeb.getItem()).getIdPromocao())) != null) {
            produtoItemWeb.setPromocao(promocao);
        }
        return produtoItemWeb;
    }

    @RequestMapping(value={"/calcular-precos-itens"}, method={RequestMethod.POST})
    @DBAutoCommit
    public List<NotaFiscalItem> calcularItensPorCondicaoPagamento(@RequestBody ImpostoWrapper<NotaFiscalItem> wrapper) throws UnicoMensagemUsuarioException {
        Sessao sessao = SessaoUtil.getSessao();
        CondicaoPagamento condicaoPagamento = (CondicaoPagamento)CondicaoPagamentoRN.getInstance().buscarPorId(wrapper.getIdCondicaoPgmto());
        ParametrosNotaFiscalInterface parametros = this.calculoImpostoService.getParametrosNotaFiscalInterface(wrapper.getIdParametrosNF(), this.calculoImpostoService.utilizaOperacaoFiscal(TipoEmissaoNotaFiscal.PROPRIA.equals((Object)wrapper.getTipoEmissao()), sessao.getIdFilial()));
        boolean isNecessarioVerificaPrecoMinimo = this.isNotaSaida() && (parametros.getTipoValorPreco() == null || parametros.getTipoValorPreco().equals((Object)TipoValorPreco.PRECO) && parametros.isConsideravenda());
        for (NotaFiscalItem item : wrapper.getItens()) {
            BigDecimal preco;
            if (item.getTipoKit() == TipoKit.KIT_COMPONENTE.getId().intValue() || item.isNaoConsiderarValorTotalNota()) continue;
            ConsultaPrecoProduto consultaPrecoProduto = new ConsultaPrecoProduto(sessao.getFilial(), item.getIdProduto(), wrapper.getPauta(), item.getVariacoes(), item.getIdEmbalagem());
            consultaPrecoProduto.setTipoValorPreco(parametros.getTipoValorPreco());
            ProdutoPreco produtoPreco = ProdutoRN.getInstance().getPreco(consultaPrecoProduto);
            if (produtoPreco.getPrecoPromocao().compareTo(BigDecimal.ZERO) > 0) {
                preco = produtoPreco.getPrecoPromocao();
                item.setDescontoPromocao(produtoPreco.getPreco().subtract(produtoPreco.getPrecoPromocao()));
            } else {
                preco = produtoPreco.getPreco();
            }
            BigDecimal precoOriginal = preco;
            if (condicaoPagamento != null && condicaoPagamento.getFator().compareTo(BigDecimal.ZERO) > 0) {
                BigDecimal precoCondPagto = preco;
                if (condicaoPagamento.getFator().compareTo(BigDecimal.ONE) > 0) {
                    precoCondPagto = preco.multiply(condicaoPagamento.getFator());
                    item.setAcrescimoFinanciamento(precoCondPagto.subtract(preco));
                } else if (condicaoPagamento.getFator().compareTo(BigDecimal.ONE) < 0) {
                    precoCondPagto = preco.subtract(preco.multiply(condicaoPagamento.getFator()));
                    item.setDescontoFinanciamento(preco.subtract(precoCondPagto));
                }
                preco = precoCondPagto;
            }
            preco = this.isNotaSaida() ? preco.setScale((int)CacheSistema.getInstance().getCasasDecimaisProduto(item.getIdProduto()), RoundingMode.HALF_EVEN) : preco.setScale((int)CacheSistema.getInstance().getCasasDecimaisCustoProduto(item.getIdProduto()), RoundingMode.HALF_EVEN);
            item.setPrecoUnitario(preco);
            item.setIdPromocao(produtoPreco.getIdPromocao());
            if (isNecessarioVerificaPrecoMinimo) {
                if (this.funcionalidadeService.isAtiva(Funcionalidade.PRECO_POR_FILIAL)) {
                    FormacaoPrecoProduto precoProduto = FormacaoPrecoProdutoRN.getInstance().buscarFormacaoPrecoPorProdutoFilial(item.getIdProduto(), sessao.getIdFilial());
                    if (precoProduto != null) {
                        if (item.getPrecoMinimoVenda().compareTo(BigDecimal.ZERO) == 0 && NumberUtil.longNullOuZero((Long)item.getIdSupervisorVenda())) {
                            item.setPrecoMinimoVenda(precoProduto.getPrecoMinimoVenda());
                        }
                    } else {
                        Produto produto = CacheSistema.getInstance().getProduto(item.getIdProduto());
                        if (item.getPrecoMinimoVenda().compareTo(BigDecimal.ZERO) == 0 && NumberUtil.longNullOuZero((Long)item.getIdSupervisorVenda())) {
                            item.setPrecoMinimoVenda(produto.getPrecoMinimoVenda());
                        }
                    }
                } else {
                    Produto produto = CacheSistema.getInstance().getProduto(item.getIdProduto());
                    if (item.getPrecoMinimoVenda().compareTo(BigDecimal.ZERO) == 0 && NumberUtil.longNullOuZero((Long)item.getIdSupervisorVenda())) {
                        item.setPrecoMinimoVenda(produto.getPrecoMinimoVenda());
                    }
                }
            }
            if (!NumberUtil.bigDecimalNullOrZero((BigDecimal)item.getPercentualDesconto())) {
                BigDecimal bruto = item.getPrecoUnitario().multiply(item.getQuantidade()).setScale(2, RoundingMode.HALF_EVEN);
                if (item.getTipoValorDesconto() == 0) {
                    item.setDesconto(NumberUtil.valorDesconto((BigDecimal)bruto, (BigDecimal)item.getPercentualDesconto(), (int)2));
                } else if (item.getTipoValorDesconto() == 1) {
                    item.setPercentualDesconto(NumberUtil.percentual((BigDecimal)item.getDesconto(), (BigDecimal)bruto));
                }
            }
            wrapper.setItem((ProdutoItem)item);
            this.calculoImpostoService.calcularImpostos(wrapper, false);
        }
        for (NotaFiscalItem item : wrapper.getItens()) {
            if (item.getTipoKit() != TipoKit.KIT_PAI.getId().intValue()) continue;
            GeradorKitVendaNotaFiscal geradorKitVendaNotaFiscal = new GeradorKitVendaNotaFiscal(this.tipoNotaFiscal);
            geradorKitVendaNotaFiscal.calcularRateioKit(sessao, (ItemKit)item, item.getFilhosKit(), wrapper.getIdCondicaoPgmto());
            for (NotaFiscalItem notaFiscalItemKit : item.getFilhosKit()) {
                wrapper.setItem((ProdutoItem)notaFiscalItemKit);
                this.calculoImpostoService.calcularImpostos(wrapper, false);
            }
        }
        return wrapper.getItens();
    }

    @PostMapping(value={"/popula-view-itens"})
    @DBAutoCommit
    public NotaFiscal populaViewItensNotaOutrasOrigens(@RequestBody NotaFiscal notaFiscal) throws UnicoMensagemUsuarioException {
        Sessao sessao = SessaoUtil.getSessao();
        boolean operacaoFiscal = this.calculoImpostoService.utilizaOperacaoFiscal(this.isEmissaoPropria(notaFiscal), sessao.getIdFilial());
        ParametrosNotaFiscalInterface parametros = this.calculoImpostoService.getParametrosNotaFiscalInterface(operacaoFiscal ? notaFiscal.getIdOperacaoFiscal() : notaFiscal.getIdCfop(), operacaoFiscal);
        if (TipoNotaFiscal.ENTRADA.equals((Object)notaFiscal.getTipoDocumento())) {
            notaFiscal.getNotaFiscalItens().forEach(item -> {
                StatusPrecoCompra statusPrecoCompra = StatusPrecoCompra.SEM_ALTERACAO;
                if (!this.calculoImpostoService.isNotaCreditoOuTransferenciaCreditoIcms(parametros)) {
                    Custo custo = CustoRN.getInstance().getCustoAtualProdutoFilial(sessao.getFilial(), item.getIdProduto());
                    BigDecimal precoUnitario = item.getPrecoUnitario().divide(item.getEmbalagem(), 6, RoundingMode.HALF_EVEN).setScale((int)CacheSistema.getInstance().getCasasDecimaisCustoProduto(item.getIdProduto()), RoundingMode.HALF_EVEN);
                    if (custo.getPrecoUltimaCompra().compareTo(precoUnitario) != 0) {
                        statusPrecoCompra = StatusPrecoCompra.PRECO_ALTERADO;
                    }
                }
                item.setStatusPrecoItem(statusPrecoCompra);
            });
        }
        return this.calcularValoresSubtotal(notaFiscal, false, false);
    }

    @RequestMapping(value={"/calcular-subtotal"}, method={RequestMethod.POST})
    @DBAutoCommit
    public NotaFiscal calcularValoresSubtotal(@RequestBody NotaFiscal notaFiscal, @RequestParam(required=false, defaultValue="false") boolean retotalizandoValores, @RequestParam(required=false, defaultValue="true") boolean recalcularDescontoSubtotal) throws UnicoMensagemUsuarioException {
        boolean somarIcmsOutrasDesp;
        Sessao sessao = SessaoUtil.getSessao();
        if (recalcularDescontoSubtotal) {
            this.rateioDescontoSubTotal(sessao, notaFiscal);
        }
        notaFiscal.setNotaFiscalItens(this.separarItensKit(notaFiscal.getNotaFiscalItens()));
        boolean operacaoFiscal = this.calculoImpostoService.utilizaOperacaoFiscal(this.isEmissaoPropria(notaFiscal), sessao.getIdFilial());
        ParametrosNotaFiscalInterface parametros = this.calculoImpostoService.getParametrosNotaFiscalInterface(operacaoFiscal ? notaFiscal.getIdOperacaoFiscal() : notaFiscal.getIdCfop(), operacaoFiscal);
        NotaFiscalItemRN.getInstance().calculaRateioValor(notaFiscal.getNotaFiscalItens(), "frete", notaFiscal.getFrete(), this.isNotaComplementarAjuste(parametros), false);
        NotaFiscalItemRN.getInstance().calculaRateioValor(notaFiscal.getNotaFiscalItens(), "seguro", notaFiscal.getSeguro(), this.isNotaComplementarAjuste(parametros), false);
        NotaFiscalItemRN.getInstance().calculaRateioValor(notaFiscal.getNotaFiscalItens(), "outrasDespesas", notaFiscal.getOutrasDespesas(), this.isNotaComplementarAjuste(parametros), false);
        if (NumberUtil.longNullOuZero((Long)notaFiscal.getIdFilial())) {
            notaFiscal.setIdFilial(sessao.getIdFilial());
        }
        NotaFiscalRN.getInstance().recalculaValoresSubtotal(notaFiscal, notaFiscal.getNotaFiscalItens());
        if (!TransacaoFinanceiraRN.getInstance().isFinanceiroQuitado(notaFiscal.getIdTransacaoFinanceira()).booleanValue()) {
            notaFiscal.setTotalFinanceiro(NotaFiscalDocumentoFinanceiroRN.getInstance().calcularValorTotalFinanceiro(notaFiscal.getNotaFiscalItens(), sessao.getFilial(), notaFiscal.getValorVendor()));
            notaFiscal.setTotalFinanceiroItens(notaFiscal.getTotalFinanceiro());
            notaFiscal.setAPrazo(notaFiscal.getTotalFinanceiro().subtract(notaFiscal.getAVista()));
        }
        if (this.isNotaEntrada()) {
            NotaFiscalItemRN.getInstance().ratearVendor(notaFiscal.getValorVendor(), notaFiscal.getNotaFiscalItens());
        }
        if (this.funcionalidadeService.isAtiva(Funcionalidade.CALCULAR_PESO_VOLUME_NOTA_FISCAL_DAF) && notaFiscal.getOrigemPrincipal() != 18 && notaFiscal.getOrigemPrincipal() != 43) {
            NotaFiscalRN.getInstance().atualizarInformacoesCargaNotaFiscal((DocumentoPesavelInterface)notaFiscal, notaFiscal.getNotaFiscalItens());
        }
        boolean somarCofinsOutrasDesp = parametros != null && parametros.isSomarCofinsOutrasDesp();
        boolean somarPisOutrasDesp = parametros != null && parametros.isSomarPisOutrasDesp();
        boolean somarSiscomexOutrasDesp = parametros != null && parametros.isSomarSiscomexOutrasDesp();
        boolean somarDespAcessoriaOutrasDesp = parametros != null && parametros.isSomarDespAcesOutrasDesp();
        boolean bl = somarIcmsOutrasDesp = parametros != null && parametros.isSomarIcmsOutrasDesp();
        if (!retotalizandoValores) {
            boolean somarOutrasDesp;
            BigDecimal totalOutrasDespesas = BigDecimal.ZERO;
            if (somarPisOutrasDesp) {
                totalOutrasDespesas = totalOutrasDespesas.add(notaFiscal.getPis());
            }
            if (somarCofinsOutrasDesp) {
                totalOutrasDespesas = totalOutrasDespesas.add(notaFiscal.getCofins());
            }
            if (somarSiscomexOutrasDesp) {
                totalOutrasDespesas = totalOutrasDespesas.add(notaFiscal.getTaxaSiscomex());
            }
            if (somarDespAcessoriaOutrasDesp) {
                totalOutrasDespesas = totalOutrasDespesas.add(notaFiscal.getDespesasImportacao());
            }
            if (somarIcmsOutrasDesp) {
                totalOutrasDespesas = totalOutrasDespesas.add(notaFiscal.getIcms());
            }
            boolean bl2 = somarOutrasDesp = somarPisOutrasDesp || somarCofinsOutrasDesp || somarSiscomexOutrasDesp || somarDespAcessoriaOutrasDesp || somarIcmsOutrasDesp;
            if (recalcularDescontoSubtotal || somarOutrasDesp) {
                if (somarOutrasDesp) {
                    notaFiscal.setOutrasDespesas(totalOutrasDespesas);
                    NotaFiscalItemRN.getInstance().calculaRateioValor(notaFiscal.getNotaFiscalItens(), "outrasDespesas", totalOutrasDespesas, this.isNotaComplementarAjuste(parametros), false);
                }
                if (notaFiscal.getEntradaSaida() != null || notaFiscal.getEmissao() != null) {
                    this.recalcularValoresRateio(notaFiscal, parametros, true, false);
                    notaFiscal.setNotaFiscalItens(this.separarItensKit(notaFiscal.getNotaFiscalItens()));
                }
            }
        }
        notaFiscal.setInfoCompGerada(NotaFiscalRN.getInstance().gerarObservacaoNotaFiscal(notaFiscal, notaFiscal.getMapOrigens()));
        notaFiscal.setInfoFiscoGerada(NotaFiscalRN.getInstance().gerarObservacaoFiscoNotaFiscal(notaFiscal));
        notaFiscal.setNotaFiscalItens(this.agruparItensKit(notaFiscal.getNotaFiscalItens()));
        this.setHabilitaFunruralSubtotal(notaFiscal);
        return notaFiscal;
    }

    private void rateioDescontoSubTotal(Sessao sessao, NotaFiscal notaFiscal) throws UnicoMensagemUsuarioException {
        notaFiscal.setNotaFiscalItens(this.separarItensKit(notaFiscal.getNotaFiscalItens()));
        BigDecimal totalBrutoItens = BigDecimal.ZERO;
        List itens = notaFiscal.getNotaFiscalItens();
        ArrayList<NotaFiscalItem> itensParaRateio = new ArrayList<NotaFiscalItem>();
        for (NotaFiscalItem notaFiscalItem : itens) {
            if (notaFiscalItem.getTipoKit() == TipoKit.KIT_PAI.getId().intValue() || notaFiscalItem.isNaoConsiderarValorTotalNota() || !NotaFiscalItemRN.getInstance().permiteDescontoSubtotal(notaFiscalItem, sessao.getFilial()) || notaFiscalItem.isBrinde()) continue;
            totalBrutoItens = totalBrutoItens.add(notaFiscalItem.getTotalBruto());
            itensParaRateio.add(notaFiscalItem);
        }
        if (totalBrutoItens.compareTo(BigDecimal.ZERO) <= 0) {
            return;
        }
        if (notaFiscal.getDescontoSubtotal().compareTo(BigDecimal.ZERO) == 0) {
            itens.forEach(i -> {
                if (i.getDescontoSubtotal().compareTo(BigDecimal.ZERO) > 0 && (i.getTipoKit() != TipoKit.KIT_COMPONENTE.getId().intValue() && NumberUtil.bigDecimalNullOrZero((BigDecimal)i.getDesconto()) || i.getTipoKit() == TipoKit.KIT_COMPONENTE.getId().intValue() && i.getItemKitPai() != null && NumberUtil.bigDecimalNullOrZero((BigDecimal)i.getItemKitPai().getDesconto()))) {
                    i.setIdUsuarioDesconto(null);
                    i.setNomeUsuarioDesconto(null);
                }
                i.setDescontoSubtotal(BigDecimal.ZERO);
                i.setPercentualDesconto(BigDecimal.ZERO);
            });
        } else {
            BigDecimal descontoSubTotal;
            BigDecimal total = totalBrutoItens.subtract(notaFiscal.getDescontoSubtotal());
            if (total.multiply(NumberUtil.CEM).setScale(0, 3).compareTo(new BigDecimal(itensParaRateio.size())) <= 0) {
                throw new UnicoMensagemUsuarioException("WNTF647", "O valor do desconto digitado \u00e9 muito alto e poder\u00e1 zerar o valor de algum item, pois o valor do desconto ser\u00e1 rateado entre os itens da nota fiscal.");
            }
            BigDecimal somaDescontoSubTotal = BigDecimal.ZERO;
            NotaFiscalItem itemMaiorValor = null;
            for (NotaFiscalItem notaFiscalItem : itensParaRateio) {
                if (notaFiscalItem.getTipoKit() == TipoKit.KIT_PAI.getId().intValue() || notaFiscalItem.isNaoConsiderarValorTotalNota()) continue;
                BigDecimal totalItem = notaFiscalItem.getTotalBruto();
                descontoSubTotal = totalItem.divide(totalBrutoItens, 30, 6).multiply(notaFiscal.getDescontoSubtotal()).setScale(2, 5);
                somaDescontoSubTotal = somaDescontoSubTotal.add(descontoSubTotal);
                notaFiscalItem.setDescontoSubtotal(descontoSubTotal);
                notaFiscalItem.setIdUsuarioDesconto(notaFiscal.getIdUsuarioDesconto());
                if (!Util.longNullOuZero((Long)notaFiscalItem.getIdUsuarioDesconto())) {
                    String nomeUsuario = (String)UsuarioCommonRN.getInstance().buscarValorPorID(notaFiscalItem.getIdUsuarioDesconto(), "nome");
                    notaFiscalItem.setNomeUsuarioDesconto(nomeUsuario);
                }
                if (itemMaiorValor != null && totalItem.compareTo(itemMaiorValor.getTotalBruto()) <= 0) continue;
                itemMaiorValor = notaFiscalItem;
            }
            BigDecimal diferenca = notaFiscal.getDescontoSubtotal().subtract(somaDescontoSubTotal);
            if (itemMaiorValor != null) {
                descontoSubTotal = itemMaiorValor.getDescontoSubtotal().add(diferenca);
                itemMaiorValor.setDescontoSubtotal(descontoSubTotal);
            }
        }
        notaFiscal.setNotaFiscalItens(this.agruparItensKit(notaFiscal.getNotaFiscalItens()));
    }

    @RequestMapping(value={"/calcular-rateio-desc-subtotal"}, method={RequestMethod.POST})
    @DBAutoCommit
    public NotaFiscal calculaRateioDescontoSubTotal(@RequestBody NotaFiscal notaFiscal) throws UnicoMensagemUsuarioException {
        int origem;
        Sessao sessao = SessaoUtil.getSessao();
        this.rateioDescontoSubTotal(sessao, notaFiscal);
        boolean operacaoFiscal = this.calculoImpostoService.utilizaOperacaoFiscal(this.isEmissaoPropria(notaFiscal), sessao.getIdFilial());
        ParametrosNotaFiscalInterface parametros = this.calculoImpostoService.getParametrosNotaFiscalInterface(operacaoFiscal ? notaFiscal.getIdOperacaoFiscal() : notaFiscal.getIdCfop(), operacaoFiscal);
        boolean isRateio = parametros != null && parametros.isInformarTotaisManualmente();
        boolean isTipoNotaValidaParaRecalculo = this.isNotaSaida() || this.isNotaEntrada() && this.isEmissaoPropria(notaFiscal) && parametros != null && !parametros.isImportacao() && !isRateio;
        Entidade entidade = (Entidade)EntidadeRN.getInstance().buscarPorId(notaFiscal.getIdEntidade());
        if (entidade == null) {
            throw new UnicoMensagemUsuarioException("WWW191", "Entidade n\u00e3o encontrada.");
        }
        String codigoEstado = null;
        Estado estado = (Estado)EstadoRN.getInstance().buscarPorId(entidade.getEndereco().getIdEstado());
        if (estado != null) {
            codigoEstado = estado.getCodigo();
        }
        LocalDate emissao = this.isNotaEntrada() ? notaFiscal.getEntradaSaida() : notaFiscal.getEmissao();
        List itens = this.separarItensKit(notaFiscal.getNotaFiscalItens());
        int n = origem = this.tipoNotaFiscal == TipoNotaFiscal.SAIDA ? -18 : -21;
        if (isTipoNotaValidaParaRecalculo) {
            for (NotaFiscalItem item : itens) {
                if (item.getTipoKit() == TipoKit.KIT_PAI.getId().intValue()) continue;
                TipoCalculoImposto tipoCalculoImposto = item.getTipo().equalsIgnoreCase(TipoRegistroProduto.PRODUTO.getId()) ? TipoCalculoImposto.CST_IPI : TipoCalculoImposto.CST_PIS;
                new CalculoImposto().calcularImpostos((ItemTributavelInterface)item, entidade, tipoCalculoImposto, this.tipoNotaFiscal, emissao, codigoEstado, notaFiscal.getTipoEmissao(), parametros, sessao.getFilial(), false, origem);
            }
        } else {
            for (NotaFiscalItem item : itens) {
                if (item.getTipoKit() == TipoKit.KIT_PAI.getId().intValue()) continue;
                new CalculoImposto().calcularImpostos((ItemTributavelInterface)item, entidade, TipoCalculoImposto.TOTAL_ITEM, this.tipoNotaFiscal, emissao, codigoEstado, notaFiscal.getTipoEmissao(), parametros, sessao.getFilial(), false, origem);
            }
        }
        notaFiscal.setNotaFiscalItens(this.agruparItensKit(itens));
        return this.calcularValoresSubtotal(notaFiscal, false, true);
    }

    @RequestMapping(value={"/calcular-rateio-valor"}, method={RequestMethod.POST})
    @DBAutoCommit
    public NotaFiscal calculaRateioValor(@RequestBody NotaFiscal notaFiscal, @RequestParam String campo, @RequestParam BigDecimal valor, @RequestParam boolean recalculaImpostos) throws UnicoMensagemUsuarioException {
        boolean rateioImpostos;
        notaFiscal.setNotaFiscalItens(this.separarItensKit(notaFiscal.getNotaFiscalItens()));
        boolean operacaoFiscal = this.calculoImpostoService.utilizaOperacaoFiscal(this.isEmissaoPropria(notaFiscal), SessaoUtil.getSessao().getIdFilial());
        ParametrosNotaFiscalInterface parametros = this.calculoImpostoService.getParametrosNotaFiscalInterface(operacaoFiscal ? notaFiscal.getIdOperacaoFiscal() : notaFiscal.getIdCfop(), operacaoFiscal);
        Filial filial = SessaoUtil.getSessao().getFilial();
        boolean isImpostoImportacao = campo.equalsIgnoreCase("impostoImportacao");
        CampoRateioCalculoImposto campoRateioImposto = Stream.of(CampoRateioCalculoImposto.values()).filter(cp -> cp.getNomeCampoItemTributavel().equalsIgnoreCase(campo)).findAny().orElse(null);
        boolean bl = rateioImpostos = notaFiscal.isNotaEntrada() && parametros.isInformarTotaisManualmente() && (campoRateioImposto != null || isImpostoImportacao);
        if (rateioImpostos) {
            if (isImpostoImportacao) {
                NotaFiscalItemRN.getInstance().calculaRateioValor(notaFiscal.getNotaFiscalItens(), campo, valor, this.isNotaComplementarAjuste(parametros), false);
                BigDecimal impostoRateado = notaFiscal.getNotaFiscalItens().stream().map(NotaFiscalItem::getImpostoImportacao).reduce(BigDecimal.ZERO, BigDecimal::add);
                if (impostoRateado.compareTo(valor) != 0) {
                    throw new UnicoMensagemUsuarioException("WNTF763", "O valor dos impostos de importa\u00e7\u00e3o n\u00e3o pode ser rateado corretamente, verifique as configura\u00e7\u00f5es!");
                }
            } else {
                BigDecimal icmsRateado;
                List itensProduto = notaFiscal.getNotaFiscalItens().stream().filter(it -> TipoRegistroProduto.PRODUTO.getId().equalsIgnoreCase(it.getTipo())).collect(Collectors.toList());
                CalculoImpostoRateio.getInstance().ratearValoresDeImpostos(filial, itensProduto, campoRateioImposto, valor, notaFiscal.getTipoDocumento());
                if (CampoRateioCalculoImposto.VALOR_IPI.getNomeCampoItemTributavel().equalsIgnoreCase(campo)) {
                    BigDecimal ipiRateado = itensProduto.stream().map(NotaFiscalItem::getIpi).reduce(BigDecimal.ZERO, BigDecimal::add);
                    if (ipiRateado.compareTo(valor) != 0) {
                        throw new UnicoMensagemUsuarioException("WNTF757", "O valor do IPI n\u00e3o pode ser rateado corretamente, verifique as CSTS!");
                    }
                } else if (CampoRateioCalculoImposto.VALOR_PIS.equals((Object)campoRateioImposto)) {
                    BigDecimal pisRateado = itensProduto.stream().map(NotaFiscalItem::getPis).reduce(BigDecimal.ZERO, BigDecimal::add);
                    if (valor.compareTo(pisRateado) != 0) {
                        this.notificationService.simpleNotifyUserTenantNow(ContextoHolder.getTenant(), SessaoUtil.getSessao().getIdUsuario(), TipoNotificacaoSimples.WARNING, "O valor do PIS foi recalculado para se ajustar a al\u00edquota configurada!");
                    }
                } else if (CampoRateioCalculoImposto.VALOR_COFINS.equals((Object)campoRateioImposto)) {
                    BigDecimal cofinsRateado = itensProduto.stream().map(NotaFiscalItem::getCofins).reduce(BigDecimal.ZERO, BigDecimal::add);
                    if (valor.compareTo(cofinsRateado) != 0) {
                        this.notificationService.simpleNotifyUserTenantNow(ContextoHolder.getTenant(), SessaoUtil.getSessao().getIdUsuario(), TipoNotificacaoSimples.WARNING, "O valor do COFINS foi recalculado para se ajustar a al\u00edquota configurada!");
                    }
                } else if (CampoRateioCalculoImposto.BASE_ICMS.equals((Object)campoRateioImposto)) {
                    BigDecimal baseIcmsRateada = itensProduto.stream().map(NotaFiscalItem::getBaseIcms).reduce(BigDecimal.ZERO, BigDecimal::add);
                    if (baseIcmsRateada.compareTo(valor) != 0) {
                        throw new UnicoMensagemUsuarioException("WNTF758", "O valor da base de ICMS n\u00e3o pode ser rateado corretamente, verifique as CSTS!");
                    }
                } else if (CampoRateioCalculoImposto.VALOR_ICMS.equals((Object)campoRateioImposto)) {
                    icmsRateado = itensProduto.stream().map(NotaFiscalItem::getIcms).reduce(BigDecimal.ZERO, BigDecimal::add);
                    if (icmsRateado.compareTo(valor) != 0) {
                        throw new UnicoMensagemUsuarioException("WNTF759", "O valor do ICMS n\u00e3o pode ser rateado corretamente, verifique as CSTS!");
                    }
                } else if (CampoRateioCalculoImposto.BASE_ICMS_ST.equals((Object)campoRateioImposto)) {
                    BigDecimal baseRateada = itensProduto.stream().map(NotaFiscalItem::getBaseIcmsSubstituicao).reduce(BigDecimal.ZERO, BigDecimal::add);
                    if (baseRateada.compareTo(valor) != 0) {
                        throw new UnicoMensagemUsuarioException("WNTF760", "O valor da base do ICMS ST n\u00e3o pode ser rateado corretamente, verifique as CSTS!");
                    }
                } else if (CampoRateioCalculoImposto.VALOR_ICMS_ST.equals((Object)campoRateioImposto)) {
                    icmsRateado = itensProduto.stream().map(NotaFiscalItem::getIcmsSubstituicao).reduce(BigDecimal.ZERO, BigDecimal::add);
                    if (icmsRateado.compareTo(valor) != 0) {
                        throw new UnicoMensagemUsuarioException("WNTF761", "O valor do ICMS ST n\u00e3o pode ser rateado corretamente, verifique as CSTS!");
                    }
                } else if (CampoRateioCalculoImposto.FUNTURAL.equals((Object)campoRateioImposto)) {
                    NotaFiscal notaClonada = (NotaFiscal)NotaFiscalRN.getInstance().clonar((AbstractPojo)notaFiscal);
                    NotaFiscalRN.getInstance().recalculaValoresSubtotal(notaClonada, notaClonada.getNotaFiscalItens());
                    BigDecimal funruralRateado = notaClonada.getNotaFiscalItens().stream().map(NotaFiscalItem::getFunrural).reduce(BigDecimal.ZERO, BigDecimal::add);
                    if (funruralRateado.compareTo(valor) != 0) {
                        throw new UnicoMensagemUsuarioException("WNTF762", "O valor do FUNRURAL n\u00e3o pode ser rateado corretamente, verifique as configura\u00e7\u00f5es!");
                    }
                }
            }
        } else {
            NotaFiscalItemRN.getInstance().calculaRateioValor(notaFiscal.getNotaFiscalItens(), campo, valor, this.isNotaComplementarAjuste(parametros), false);
        }
        notaFiscal.setNotaFiscalItens(this.agruparItensKit(notaFiscal.getNotaFiscalItens()));
        if (rateioImpostos) {
            Entidade entidade = (Entidade)EntidadeRN.getInstance().buscarPorId(notaFiscal.getIdEntidade());
            if (entidade == null) {
                throw new UnicoMensagemUsuarioException("WWW193", "Entidade n\u00e3o encontrada.");
            }
            String codigoEstado = null;
            Estado estado = (Estado)EstadoRN.getInstance().buscarPorId(entidade.getEndereco().getIdEstado());
            if (estado != null) {
                codigoEstado = estado.getCodigo();
            }
            LocalDate emissao = this.isNotaEntrada() ? notaFiscal.getEntradaSaida() : notaFiscal.getEmissao();
            int origem = this.tipoNotaFiscal == TipoNotaFiscal.SAIDA ? -18 : -21;
            for (NotaFiscalItem item : notaFiscal.getNotaFiscalItens()) {
                new CalculoImposto().calcularImpostos((ItemTributavelInterface)item, entidade, TipoCalculoImposto.TOTAL_ITEM, this.tipoNotaFiscal, emissao, codigoEstado, notaFiscal.getTipoEmissao(), parametros, SessaoUtil.getSessao().getFilial(), false, origem);
            }
            NotaFiscalRN.getInstance().recalculaValoresSubtotal(notaFiscal, notaFiscal.getNotaFiscalItens());
            notaFiscal.setTotalFinanceiro(NotaFiscalDocumentoFinanceiroRN.getInstance().calcularValorTotalFinanceiro(notaFiscal.getNotaFiscalItens(), filial, notaFiscal.getValorVendor()));
            notaFiscal.setTotalFinanceiroItens(notaFiscal.getTotalFinanceiro());
            notaFiscal.setAPrazo(notaFiscal.getTotalFinanceiro().subtract(notaFiscal.getAVista()));
        } else {
            this.recalcularValoresRateio(notaFiscal, parametros, false, recalculaImpostos);
        }
        return notaFiscal;
    }

    @RequestMapping(value={"/zerar-rateios"}, method={RequestMethod.POST})
    @DBAutoCommit
    public Map<String, Object> zerarValoresRateados(@RequestBody NotaFiscal notaFiscal) throws UnicoMensagemUsuarioException {
        boolean zerarImpostos;
        HashMap<String, Object> retorno = new HashMap<String, Object>();
        retorno.put("zerouImpostos", false);
        Sessao sessao = SessaoUtil.getSessao();
        notaFiscal.setNotaFiscalItens(this.separarItensKit(notaFiscal.getNotaFiscalItens()));
        boolean operacaoFiscal = this.calculoImpostoService.utilizaOperacaoFiscal(this.isEmissaoPropria(notaFiscal), sessao.getIdFilial());
        ParametrosNotaFiscalInterface parametros = this.calculoImpostoService.getParametrosNotaFiscalInterface(operacaoFiscal ? notaFiscal.getIdOperacaoFiscal() : notaFiscal.getIdCfop(), operacaoFiscal);
        boolean bl = zerarImpostos = notaFiscal.isNotaEntrada() && !ListMapUtil.listNullOrEmpty((List)notaFiscal.getNotaFiscalItens()) && parametros.isInformarTotaisManualmente();
        if (zerarImpostos) {
            String[] camposValorNota = new String[]{"baseIcms", "icms", "baseIcmsSubstituicao", "icmsSubstituicao", "pis", "cofins", "ipi", "despesasImportacao", "impostoImportacao"};
            boolean existeValorParaRatear = false;
            for (String campo : camposValorNota) {
                BigDecimal valor = (BigDecimal)BeanUtil.get((Object)notaFiscal, (String)campo, (Object[])new Object[0]);
                if (NumberUtil.bigDecimalNullOrZero((BigDecimal)valor)) continue;
                existeValorParaRatear = true;
                break;
            }
            if (existeValorParaRatear) {
                List itensProduto = notaFiscal.getNotaFiscalItens().stream().filter(it -> TipoRegistroProduto.PRODUTO.getId().equalsIgnoreCase(it.getTipo())).collect(Collectors.toList());
                for (CampoRateioCalculoImposto campoRateioCalculoImposto : CampoRateioCalculoImposto.values()) {
                    CalculoImpostoRateio.getInstance().ratearValoresDeImpostos(sessao.getFilial(), itensProduto, campoRateioCalculoImposto, BigDecimal.ZERO, notaFiscal.getTipoDocumento());
                }
                NotaFiscalItemRN.getInstance().calculaRateioValor(notaFiscal.getNotaFiscalItens(), "despesasAduaneiras", BigDecimal.ZERO, this.isNotaComplementarAjuste(parametros), false);
                NotaFiscalItemRN.getInstance().calculaRateioValor(notaFiscal.getNotaFiscalItens(), "impostoImportacao", BigDecimal.ZERO, this.isNotaComplementarAjuste(parametros), false);
                notaFiscal.setNotaFiscalItens(this.agruparItensKit(notaFiscal.getNotaFiscalItens()));
                NotaFiscalRN.getInstance().recalculaValoresSubtotal(notaFiscal, notaFiscal.getNotaFiscalItens());
                notaFiscal.setTotalFinanceiro(NotaFiscalDocumentoFinanceiroRN.getInstance().calcularValorTotalFinanceiro(notaFiscal.getNotaFiscalItens(), sessao.getFilial(), notaFiscal.getValorVendor()));
                notaFiscal.setTotalFinanceiroItens(notaFiscal.getTotalFinanceiro());
                notaFiscal.setAPrazo(notaFiscal.getTotalFinanceiro().subtract(notaFiscal.getAVista()));
            }
            retorno.put("zerouImpostos", existeValorParaRatear);
        }
        retorno.put("notaFiscal", notaFiscal);
        return retorno;
    }

    @RequestMapping(value={"/gerar-parcelas-financeiro"})
    @DBAutoCommit
    public List<NotaFiscalDocumentoFinanceiro> gerarParcelas(@RequestParam Long idCondicaoPagamento, @RequestParam BigDecimal total, @RequestParam(required=false) boolean isSaida, @RequestParam Long idEntidade, @RequestParam Long idTipoDocumentoFinanceiro, @RequestParam(required=false) String dataPedido, @RequestParam String dataEmissao, @RequestParam(required=false, defaultValue="0") int diaFaturamentoContrato, @RequestParam(required=false) String dataVencimentoContrato, @RequestParam(required=false) BigDecimal valorIcmsSt) throws UnicoMensagemUsuarioException {
        total = total.setScale(2, 6);
        return NotaFiscalDocumentoFinanceiroRN.getInstance().gerarParcelas(idCondicaoPagamento, total, isSaida, idEntidade, idTipoDocumentoFinanceiro, !StringUtil.stringNullOrEmpty((String)dataPedido) ? DataHoraFactory.string2LocalDate((String)dataPedido, (String)"dd/MM/yyyy") : null, DataHoraFactory.string2LocalDate((String)dataEmissao, (String)"dd/MM/yyyy"), diaFaturamentoContrato, !StringUtil.stringNullOrEmpty((String)dataVencimentoContrato) ? DataHoraFactory.string2LocalDate((String)dataVencimentoContrato, (String)"dd/MM/yyyy") : null, SessaoUtil.getSessao().getFilial(), valorIcmsSt);
    }

    @RequestMapping(value={"/buscar-nfe-referenciada"})
    @DBAutoCommit
    public NotaFiscalDocumentoReferenciado buscarNotaFiscalReferenciada(@RequestParam String numero, @RequestParam String modelo, @RequestParam String serie, @RequestParam Long idEntidade) throws UnicoMensagemUsuarioException {
        NotaFiscal notaFiscal = NotaFiscalRN.getInstance().buscarPorNumeroModeloIdFilialIdEntidade(numero, modelo, serie, SessaoUtil.getSessao().getFilial().getId(), idEntidade);
        if (notaFiscal != null) {
            if (!notaFiscal.getSerie().equalsIgnoreCase("55") && Util.apenasNumeros((String)notaFiscal.getCnpjCpf()).length() == 11) {
                throw new UnicoMensagemUsuarioException("WWW472", "NF-e referenciada n\u00e3o pode ser de uma pessoa f\u00edsica!");
            }
            if (notaFiscal.getSerie().equals(ModeloNotaFiscal.NOTA_FISCAL_ELETRONICA.getId()) && !notaFiscal.getStatus().equals((Object)StatusNotaFiscal.NFE_AUTORIZADA) && TipoEmissaoNotaFiscal.PROPRIA.equals((Object)notaFiscal.getTipoEmissao())) {
                throw new UnicoMensagemUsuarioException("WWW473", "NF-e referenciada n\u00e3o est\u00e1 autorizada!");
            }
            if (notaFiscal.getSerie().equals(ModeloNotaFiscal.NOTA_FISCAL_ELETRONICA.getId()) && Util.stringNullOrEmpty((String)notaFiscal.getChaveNfe())) {
                throw new UnicoMensagemUsuarioException("WWW474", "A nota fiscal que voc\u00ea est\u00e1 tentando referenciar n\u00e3o possui chave de acesso!");
            }
        } else {
            throw new UnicoMensagemUsuarioException("WWW475", "Nota fiscal n\u00e3o encontrada!");
        }
        NotaFiscalDocumentoReferenciado documento = new NotaFiscalDocumentoReferenciado();
        documento.setIdDocumentoReferenciado(notaFiscal.getId());
        documento.setNumeroDocumentoNotaFiscal(notaFiscal);
        documento.setOrigem(2);
        return documento;
    }

    @RequestMapping(value={"/validar-exclusao"})
    @DBAutoCommit
    public NotaFiscalExclusaoWrapper verificarExlusao(@RequestParam Long id) throws UnicoMensagemUsuarioException {
        AcaoExcluirNotaFiscal acao = NotaFiscalRN.getInstance().getAcaoExcluirCancelar(id);
        NotaFiscalExclusaoWrapper exclusaoWrapper = new NotaFiscalExclusaoWrapper(acao);
        if (acao.getAcao().equals((Object)TipoAcaoExcluir.EXCLUIR) && NotaFiscalRN.getInstance().isNfse(id) && LicencaManager.getInstance().isNfse()) {
            new NfseManagerWeb(SessaoUtil.getSessao(), null, (IFileStorage)this.arquivoFiscal).validaExclusaoNfse(SessaoUtil.getSessao(), id);
        }
        if (acao.getAcao().equals((Object)TipoAcaoExcluir.EXCLUIR) || acao.getAcao().equals((Object)TipoAcaoExcluir.CANCELAR)) {
            List financeiroDados = NotaFiscalRN.getInstance().buscarFinanceiroNotaFiscalEmRemessaBancaria(id);
            if (!Util.listNullOrEmpty((List)financeiroDados)) {
                List documentoCobrancas = FinanceiroDadoRN.getInstance().buscarDocumentosParaRemessa(SessaoUtil.getSessao(), financeiroDados.stream().map(FinanceiroDado::getId).collect(Collectors.toList()));
                exclusaoWrapper.setDocEmRemessa(documentoCobrancas);
            }
            if (ModuloManager.getInstance().isAtivo(Modulo.EXPEDICAO) && this.isNotaSaida()) {
                String msg = NotaFiscalRN.getInstance().buscarNotasExpedicaoVinculadas(id);
                exclusaoWrapper.setPergunta(msg);
            }
        }
        return exclusaoWrapper;
    }

    @RequestMapping(value={"/buscar-lotes"})
    @DBAutoCommit
    public List<NotaFiscalItemLote> buscarLotesPorNotaFiscal(@RequestParam Long idNotaFiscal, @RequestParam Long idProduto) {
        return NotaFiscalItemLoteCommonRN.getInstance().buscarListaPorNotaFiscal(idNotaFiscal, idProduto);
    }

    @RequestMapping(method={RequestMethod.POST})
    @DBTransaction
    public Long create(@RequestBody NotaFiscal notaFiscal, Optional<Long> parentId) throws UnicoMensagemUsuarioException {
        notaFiscal.setStatus(StatusNotaFiscal.NORMAL);
        this.beforeCreate(notaFiscal, parentId);
        this.beforeSave(notaFiscal, parentId);
        NotaFiscalRN.getInstance().gravarNotaFiscal(0, notaFiscal, SessaoUtil.getSessao());
        this.gravarAuditoriaRegistro(null, (AbstractPojo)notaFiscal, 0);
        this.afterCreate((AbstractPojo)notaFiscal, parentId);
        this.afterSave((AbstractPojo)notaFiscal, parentId);
        this.dashBoardRabbitService.sendMessage(ContextoHolder.getTenant());
        return notaFiscal.getId();
    }

    @RequestMapping(method={RequestMethod.PUT})
    @DBTransaction
    public Long update(@RequestBody NotaFiscal notaFiscal, Optional<Long> parentId) throws UnicoMensagemUsuarioException {
        this.validarCurrentTimeMillis((AbstractPojo)notaFiscal);
        this.beforeUpdate(notaFiscal, parentId);
        this.beforeSave(notaFiscal, parentId);
        this.gravarAuditoriaRegistro(notaFiscal.getId(), (AbstractPojo)notaFiscal, 1);
        NotaFiscalRN.getInstance().gravarNotaFiscal(1, notaFiscal, SessaoUtil.getSessao());
        this.afterUpdate((AbstractPojo)notaFiscal, parentId);
        this.afterSave((AbstractPojo)notaFiscal, parentId);
        this.dashBoardRabbitService.sendMessage(ContextoHolder.getTenant());
        return notaFiscal.getId();
    }

    @RequestMapping(value={"{id}"}, method={RequestMethod.DELETE})
    @DBTransaction
    public void delete(@PathVariable Long id) throws UnicoMensagemUsuarioException {
        NotaFiscal notaFiscal = (NotaFiscal)NotaFiscalRN.getInstance().buscarPorId(id);
        if (notaFiscal == null) {
            throw new UnicoMensagemUsuarioException("WNTF714", "Nota fiscal selecionada n\u00e3o foi encontrada");
        }
        this.gravarAuditoriaRegistro(id, null, 2);
        AcaoExcluirNotaFiscal acaoExcluir = NotaFiscalRN.getInstance().getAcaoExcluirCancelar(notaFiscal, true);
        boolean permiteExcluir = acaoExcluir.getAcao().equals((Object)TipoAcaoExcluir.EXCLUIR);
        if (acaoExcluir.getAcao().equals((Object)TipoAcaoExcluir.NENHUMA)) {
            throw new UnicoMensagemUsuarioException("WNTF840", acaoExcluir.getJustificativa());
        }
        if (!permiteExcluir) {
            if (!NotaFiscalRN.getInstance().isNfse(notaFiscal.getId()) || !LicencaManager.getInstance().isNfse()) {
                NotaFiscalRN.getInstance().cancelaNotaFiscal(SessaoUtil.getSessao(), notaFiscal.getId(), TipoAcaoExcluir.CANCELAR, true);
                return;
            }
            throw new UnicoMensagemUsuarioException("NTF9222", "N\u00e3o \u00e9 poss\u00edvel excluir a nota fiscal selecionada. Utilize a op\u00e7\u00e3o de cancelamento.");
        }
        this.beforeRead(notaFiscal, 2, Optional.empty());
        NotaFiscalRN.getInstance().gravarNotaFiscal(2, notaFiscal, SessaoUtil.getSessao());
        NotaFiscalItemRN.getInstance().verificaCalculoCustoMedio(SessaoUtil.getSessao(), notaFiscal);
        this.dashBoardRabbitService.sendMessage(ContextoHolder.getTenant());
        this.notificationService.notifyTenantNow(NotificationType.DASH_BOARD, "");
    }

    @DBAutoCommit
    public List<NotaFiscalItem> recalcularImpostosItens(@RequestBody ImpostoWrapper<NotaFiscalItem> impostoWrapper) throws UnicoMensagemUsuarioException {
        if (impostoWrapper.isValidarDesconto()) {
            Sessao sessao = SessaoUtil.getSessao();
            boolean operacaoFiscal = this.calculoImpostoService.utilizaOperacaoFiscal(TipoEmissaoNotaFiscal.PROPRIA.equals((Object)impostoWrapper.getTipoEmissao()), sessao.getIdFilial());
            ParametrosNotaFiscalInterface parametros = this.calculoImpostoService.getParametrosNotaFiscalInterface(impostoWrapper.getIdParametrosNF(), operacaoFiscal);
            boolean isRateio = parametros != null && parametros.isInformarTotaisManualmente();
            boolean isNecessarioRecalcularImpostoAoZerarDesconto = this.isNotaSaida() || this.isNotaEntrada() && impostoWrapper.getTipoEmissao().equals((Object)TipoEmissaoNotaFiscal.PROPRIA) && !impostoWrapper.isImportacao() && !isRateio;
            Entidade entidade = impostoWrapper.getEntidade();
            String codigoEstado = this.calculoImpostoService.getCodigoEstado(impostoWrapper);
            int origem = this.tipoNotaFiscal == TipoNotaFiscal.SAIDA ? -18 : -21;
            for (NotaFiscalItem notaFiscalItem : impostoWrapper.getItens()) {
                boolean possuiDesconto = !NumberUtil.bigDecimalNullOrZero((BigDecimal)notaFiscalItem.getDescontoSubtotal());
                notaFiscalItem.setDescontoSubtotal(BigDecimal.ZERO);
                notaFiscalItem.setDescontoFinanciamento(BigDecimal.ZERO);
                notaFiscalItem.setAcrescimoFinanciamento(BigDecimal.ZERO);
                if (!possuiDesconto || !isNecessarioRecalcularImpostoAoZerarDesconto) continue;
                TipoCalculoImposto tipoCalculoImposto = notaFiscalItem.getTipo().equalsIgnoreCase(TipoRegistroProduto.PRODUTO.getId()) ? TipoCalculoImposto.CST_IPI : TipoCalculoImposto.CST_PIS;
                new CalculoImposto().calcularImpostos((ItemTributavelInterface)notaFiscalItem, entidade, tipoCalculoImposto, impostoWrapper.getTipoNotaFiscal(), impostoWrapper.getDataEmissao(), codigoEstado, impostoWrapper.getTipoEmissao(), parametros, sessao.getFilial(), impostoWrapper.isApenasRecalcularBaseEValor(), origem);
            }
            return impostoWrapper.getItens();
        }
        return super.recalcularImpostosItens(impostoWrapper);
    }

    public ProdutoItemWeb<NotaFiscalItem> carregarDadosItem(ProdutoDTOWeb produto, MultiValueMap<String, String> parametros) throws UnicoMensagemUsuarioException {
        ImpostoWrapper imposto;
        ProdutoItemWeb produtoItem = new ProdutoItemWeb();
        NotaFiscalItem item = new NotaFiscalItem();
        produtoItem.setItem((ItemWeb)item);
        produtoItem.setProduto(produto);
        Entidade cliente = null;
        ArrayList<TipoEmbalagem> tipos = new ArrayList<TipoEmbalagem>();
        tipos.add(TipoEmbalagem.COMPRAVENDA);
        Long idParametroFiscal = StringUtil.convertFirstValueMapToLong(parametros, (String)"idParametro");
        Long idCliente = StringUtil.convertFirstValueMapToLong(parametros, (String)"idCliente");
        if (!NumberUtil.longNullOuZero((Long)idCliente)) {
            cliente = (Entidade)EntidadeRN.getInstance().buscarPorId(idCliente);
        }
        Long idCondicaoPgmto = null;
        if (parametros.containsKey((Object)"idCondicaoPgmto")) {
            idCondicaoPgmto = StringUtil.convertFirstValueMapToLong(parametros, (String)"idCondicaoPgmto");
        }
        Long pauta = StringUtil.convertFirstValueMapToLong(parametros, (String)"pauta");
        int transacao = StringUtil.convertFirstValueMapToInt(parametros, (String)"transacao");
        boolean possuiItens = StringUtil.convertFirstValueMapToBoolean(parametros, (String)"possuiItens");
        boolean notaTransferencia = StringUtil.convertFirstValueMapToBoolean(parametros, (String)"transferencia");
        TipoEmissaoNotaFiscal tipoEmissao = Enum.valueOf(TipoEmissaoNotaFiscal.class, StringUtil.getFirstMap(parametros, (String)"tipoEmissao"));
        TipoValorPreco tipoPreco = Enum.valueOf(TipoValorPreco.class, StringUtil.getFirstMap(parametros, (String)"tipoPreco"));
        LocalDate dataEmissao = DateUtil.string2LocalDate((String)StringUtil.getFirstMap(parametros, (String)"dataEmissao"));
        int origemImportada = StringUtil.convertFirstValueMapToInt(parametros, (String)"origemImportada");
        List novosTipos = StringUtil.getAllValuesMap(parametros, (String)"tiposEmbalagem");
        if (!ListMapUtil.listNullOrEmpty(tipos)) {
            novosTipos.forEach(tipo -> {
                TipoEmbalagem tipoEmbalagem = Enum.valueOf(TipoEmbalagem.class, tipo);
                if (!tipos.contains(tipoEmbalagem)) {
                    tipos.add(tipoEmbalagem);
                }
            });
        }
        Sessao sessao = SessaoUtil.getSessao();
        boolean utilizaOperacaoFiscal = this.calculoImpostoService.utilizaOperacaoFiscal(tipoEmissao.equals((Object)TipoEmissaoNotaFiscal.PROPRIA), sessao.getIdFilial());
        if (!parametros.containsKey((Object)"cfopItem")) {
            throw new UnicoMensagemUsuarioException("WWW187", "N\u00e3o foi definido os par\u00e2metros para a busca de natureza de opera\u00e7\u00e3o do item.");
        }
        CfopItem cfopItem = (CfopItem)JsonUtil.fromJson((String)((String)parametros.getFirst((Object)"cfopItem")), CfopItem.class);
        ParametrosNotaFiscalInterface parametrosNotaFiscal = this.calculoImpostoService.getParametrosNotaFiscalInterface(idParametroFiscal, utilizaOperacaoFiscal);
        if (parametrosNotaFiscal != null && parametrosNotaFiscal.getFinalidadeEmissaoNfe() != FinalidadeEmissaoNfeCFOP.COMPLEMENTAR && parametrosNotaFiscal.getFinalidadeEmissaoNfe() != FinalidadeEmissaoNfeCFOP.AJUSTE && parametrosNotaFiscal.getFinalidadeEmissaoNfe() != FinalidadeEmissaoNfeCFOP.COMPLEMENTAR) {
            ((NotaFiscalItem)produtoItem.getItem()).setQuantidade(BigDecimal.ONE);
        }
        boolean aplicarFatorCondicaoPgmto = this.calculoImpostoService.possuiIntegracaoComFinanceiro(parametrosNotaFiscal);
        int origem = this.isNotaSaida() ? -18 : (notaTransferencia ? 12 : -21);
        new ProdutoItemRN().carregaItem(sessao, produtoItem, cliente, idParametroFiscal, idCondicaoPgmto, pauta, true, aplicarFatorCondicaoPgmto, tipoEmissao.equals((Object)TipoEmissaoNotaFiscal.PROPRIA), tipoPreco, utilizaOperacaoFiscal, this.isNotaSaida(), notaTransferencia, cfopItem, tipos, false, null, origem, false);
        if (parametrosNotaFiscal != null && (parametrosNotaFiscal.getFinalidadeEmissaoNfe() == FinalidadeEmissaoNfeCFOP.COMPLEMENTAR || parametrosNotaFiscal.getFinalidadeEmissaoNfe() == FinalidadeEmissaoNfeCFOP.AJUSTE || parametrosNotaFiscal.getFinalidadeEmissaoNfe() == FinalidadeEmissaoNfeCFOP.COMPLEMENTAR)) {
            ((NotaFiscalItem)produtoItem.getItem()).setPrecoUnitario(BigDecimal.ZERO);
        }
        if (!NumberUtil.bigDecimalNullOrZero((BigDecimal)produto.getPesoProduto())) {
            ((NotaFiscalItem)produtoItem.getItem()).setQuantidade(produto.getPesoProduto());
        }
        if (!NumberUtil.bigDecimalNullOrZero((BigDecimal)produto.getPrecoUnitario())) {
            ((NotaFiscalItem)produtoItem.getItem()).setPrecoBruto(produto.getPrecoUnitario());
        }
        NotaFiscalItemRN.getInstance().populaNotaFiscalItem((Produto)ProdutoRN.getInstance().buscarPorId(produto.getId()), (NotaFiscalItem)produtoItem.getItem(), utilizaOperacaoFiscal, sessao.getFilial(), parametrosNotaFiscal, this.tipoNotaFiscal);
        ((NotaFiscalItem)produtoItem.getItem()).setPautaPreco(pauta);
        ImpostoWrapper impostoTratamentoWrapper = new ImpostoWrapper((ProdutoItem)produtoItem.getItem());
        impostoTratamentoWrapper.setTipoNotaFiscal(this.tipoNotaFiscal);
        impostoTratamentoWrapper.setTipoEmissao(tipoEmissao);
        impostoTratamentoWrapper.setIdParametrosNF(idParametroFiscal);
        impostoTratamentoWrapper.setIdEntidade(idCliente);
        this.tratamentoImposto.tratarObjeto(impostoTratamentoWrapper);
        if (produto.getTipo().equals((Object)TipoRegistroProduto.PRODUTO)) {
            imposto = new ImpostoWrapper((ProdutoItem)produtoItem.getItem(), TipoCalculoImposto.CST_IPI, idParametroFiscal, cliente != null ? cliente.getId() : null, possuiItens, transacao);
            if (NumberUtil.bigDecimalNullOrZero((BigDecimal)((NotaFiscalItem)imposto.getItem()).getPrecoUnitario())) {
                if (this.isNotaEntrada() || produtoItem.getProdutoPreco() == null) {
                    ((NotaFiscalItem)produtoItem.getItem()).setPrecoUnitario(BigDecimal.ZERO);
                } else {
                    ((NotaFiscalItem)produtoItem.getItem()).setPrecoUnitario(produtoItem.getProdutoPreco().getPreco());
                }
            }
        } else {
            imposto = new ImpostoWrapper((ProdutoItem)produtoItem.getItem(), TipoCalculoImposto.CST_PIS, idParametroFiscal, cliente != null ? cliente.getId() : null, possuiItens, transacao);
            if (parametrosNotaFiscal != null && (parametrosNotaFiscal.isNaoConsideraTribEspecProduto() || parametrosNotaFiscal instanceof OperacaoFiscal)) {
                ((NotaFiscalItem)produtoItem.getItem()).setTributacaoEspecial(null);
            }
            if (this.isNotaEntrada() || produtoItem.getProdutoPreco() == null) {
                ((NotaFiscalItem)produtoItem.getItem()).setPrecoUnitario(BigDecimal.ZERO);
            } else if (!tipoEmissao.equals((Object)TipoEmissaoNotaFiscal.PROPRIA)) {
                ((NotaFiscalItem)produtoItem.getItem()).setPrecoUnitario(produtoItem.getProdutoPreco().getPreco());
            }
        }
        imposto.setTipoNotaFiscal(this.tipoNotaFiscal);
        imposto.setDataEmissao(dataEmissao);
        imposto.setTipoEmissao(tipoEmissao);
        imposto.setOrigemDocumentoImportado(origemImportada);
        imposto.setTransferencia(notaTransferencia);
        imposto.setEstado(cfopItem != null ? cfopItem.getEstado() : null);
        imposto.setCalcularImposto(true);
        List acoes = this.calculoImpostoService.calcularImpostos(imposto, true).getAcoes();
        produtoItem.setAcoes(acoes);
        ((NotaFiscalItem)produtoItem.getItem()).setPautaPreco(pauta);
        return produtoItem;
    }

    @RequestMapping(value={"/atualizar-triangulacao"}, method={RequestMethod.POST})
    @DBAutoCommit
    public TriangulacaoWrapper atualizarCamposTriangulacao(@RequestBody List<NotaFiscalItem> itens) {
        TriangulacaoWrapper triangulacaoWrapper = new TriangulacaoWrapper();
        if (this.funcionalidadeService.isAtiva(Funcionalidade.LOCAL_ESTOQUE)) {
            for (NotaFiscalItem notaFiscalItem : itens) {
                NaturezaOperacao cfop = NaturezaOperacaoRN.getInstance().buscarPorId(notaFiscalItem.getIdCfop());
                if (cfop == null) continue;
                PosseItem posseItemCfop = cfop.getPosseItem();
                boolean remessaDeTerceiros = PosseItem.PROPRIEDADE_TERCEIROS_EM_POSSE_DO_INFORMANTE.equals((Object)posseItemCfop);
                boolean triangulacao = cfop.getTipoRemessaEmTerceiros() != null && cfop.getTipoRemessaEmTerceiros().isTriangulacao();
                if (!triangulacao) continue;
                if (!remessaDeTerceiros && TipoRemessaTerceiros.ENVIO.equals((Object)cfop.getTipoRemessaEmTerceiros())) {
                    triangulacaoWrapper.setHabilitarBeneficiador(true);
                    triangulacaoWrapper.setHabilitarClienteBeneficiador(false);
                    break;
                }
                if (!remessaDeTerceiros || !TipoRemessaTerceiros.RECEBIMENTO_BENEFICIAMENTO.equals((Object)cfop.getTipoRemessaEmTerceiros())) continue;
                triangulacaoWrapper.setHabilitarBeneficiador(false);
                triangulacaoWrapper.setHabilitarClienteBeneficiador(true);
                break;
            }
        }
        return triangulacaoWrapper;
    }

    @RequestMapping(value={"/imprimir-boletos"})
    @DBAutoCommit
    public List<FinanceiroDado> buscarListaDocumento(@RequestParam List<Long> idsNotasFiscais) throws UnicoMensagemUsuarioException {
        List listaDocumentos = FinanceiroDadoRN.getInstance().buscarBoletosNotasFiscais(idsNotasFiscais);
        if (listaDocumentos != null) {
            ArrayList<FinanceiroDado> documentosParaRemover = new ArrayList<FinanceiroDado>();
            for (FinanceiroDado fd : listaDocumentos) {
                if (fd.getTipoDocumento().isPermiteGerarBoleto() && fd.getTipoDocumento().getAcao().equals((Object)TipoAcaoFinanceiro.RECEBER)) continue;
                documentosParaRemover.add(fd);
            }
            for (FinanceiroDado fd : documentosParaRemover) {
                listaDocumentos.remove(fd);
            }
            if (Util.listNullOrEmpty((List)listaDocumentos)) {
                throw new UnicoMensagemUsuarioException("WNTF9573", "N\u00e3o \u00e9 permitido gerar boletos dos documentos que foram selecionados! Verifique.");
            }
            if (!Util.listNullOrEmpty(documentosParaRemover)) {
                this.notificationService.simpleNotifyUserTenantNow(ContextoHolder.getTenant(), SessaoUtil.getSessao().getIdUsuario(), TipoNotificacaoSimples.WARNING, "Alguns documentos foram exclu\u00eddos da gera\u00e7\u00e3o dos boletos por n\u00e3o possu\u00edrem permiss\u00e3o para essa opera\u00e7\u00e3o.");
            }
        }
        return listaDocumentos;
    }

    @RequestMapping(value={"/notas-fiscais-mdfe"})
    @DBAutoCommit
    public List<NotaFiscalDTO> buscarNotasFiscalAutoCompleteMDFE(@RequestParam(value="limit", required=false, defaultValue="0") int limit, @RequestParam(value="query", required=false) String query) {
        return this.notasFiscaisToListaNotaFiscalDTO(NotaFiscalRN.getInstance().buscarNotasFiscalAutoCompleteMDFEWeb(SessaoUtil.getSessao().getIdFilial(), limit, query, null));
    }

    @RequestMapping(value={"/notas-fiscais-mdfe-por-id/{id}"})
    @DBAutoCommit
    public List<NotaFiscalDTO> buscarNotasFiscalAutoCompleteMDFEPorID(@PathVariable Long id) {
        return this.notasFiscaisToListaNotaFiscalDTO(NotaFiscalRN.getInstance().buscarNotasFiscalAutoCompleteMDFEWeb(SessaoUtil.getSessao().getIdFilial(), 0, null, id));
    }

    @RequestMapping(value={"/notas-fiscais-gnre"})
    @DBAutoCommit
    public List<NotaFiscalDTO> buscarNotasFiscalAutoCompleteGNRE(@RequestParam(value="limit", required=false, defaultValue="0") int limit, @RequestParam(value="query", required=false) String query, @RequestParam(value="apenasNfe", required=false, defaultValue="false") boolean apenasNfe) {
        return this.notasFiscaisToListaNotaFiscalDTO(NotaFiscalRN.getInstance().buscarNotasFiscalAutoCompleteGNREWeb(SessaoUtil.getSessao().getIdFilial(), limit, query, null, apenasNfe));
    }

    @RequestMapping(value={"/notas-fiscais-gnre-por-id/{id}"})
    @DBAutoCommit
    public List<NotaFiscalDTO> buscarNotasFiscalAutoCompleteGNREPorID(@PathVariable Long id) {
        return this.notasFiscaisToListaNotaFiscalDTO(NotaFiscalRN.getInstance().buscarNotasFiscalAutoCompleteGNREWeb(SessaoUtil.getSessao().getIdFilial(), 0, null, id, false));
    }

    @RequestMapping(value={"/notas-fiscais-exportacao"})
    @DBAutoCommit
    public List<NotaFiscalDTO> buscarNotasFiscalAutoCompleteExportacao(@RequestParam(value="limit", required=false, defaultValue="0") int limit, @RequestParam(value="query", required=false) String query) {
        return this.notasFiscaisToListaNotaFiscalDTO(NotaFiscalRN.getInstance().buscarNotasFiscalAutoCompleteExportacaoWeb(limit, query, null));
    }

    @RequestMapping(value={"/notas-fiscais-exportacao-por-id/{id}"})
    @DBAutoCommit
    public List<NotaFiscalDTO> buscarNotasFiscalAutoCompleteExportacaoPorID(@PathVariable Long id) {
        return this.notasFiscaisToListaNotaFiscalDTO(NotaFiscalRN.getInstance().buscarNotasFiscalAutoCompleteExportacaoWeb(0, null, id));
    }

    @RequestMapping(value={"/notas-fiscais-terceiros"})
    @DBAutoCommit
    public List<NotaFiscalDTO> buscarNotasFiscalAutoCompleteTerceiros(@RequestParam(value="limit", required=false, defaultValue="0") int limit, @RequestParam(value="query", required=false) String query) {
        return this.notasFiscaisToListaNotaFiscalDTO(NotaFiscalRN.getInstance().buscarNotasFiscalAutoCompleteTerceirosWeb(limit, query, null));
    }

    @RequestMapping(value={"/notas-fiscais-terceiros-por-id/{id}"})
    @DBAutoCommit
    public List<NotaFiscalDTO> buscarNotasFiscalAutoCompleteTerceirosPorID(@PathVariable Long id) {
        return this.notasFiscaisToListaNotaFiscalDTO(NotaFiscalRN.getInstance().buscarNotasFiscalAutoCompleteTerceirosWeb(0, null, id));
    }

    private List<NotaFiscalDTO> notasFiscaisToListaNotaFiscalDTO(List<NotaFiscal> notas) {
        return notas.stream().map(nf -> (NotaFiscalDTO)BeanUtil.copiarValores((Object)nf, NotaFiscalDTO::new, (boolean)false, (boolean)true, null)).collect(Collectors.toList());
    }

    @RequestMapping(value={"/buscar-itens/{idNotaFiscal}"})
    @DBAutoCommit
    public List<NotaFiscalItem> buscarItens(@PathVariable Long idNotaFiscal) {
        List itens = NotaFiscalItemRN.getInstance().buscarListaByIdNotaFiscal(idNotaFiscal);
        if (!ListMapUtil.listNullOrEmpty((List)itens)) {
            itens.forEach(it -> it.setReferencia(Util.all2Atring((Object)ProdutoRN.getInstance().buscarValorPorID(it.getIdProduto(), "referencia"))));
        }
        return this.agruparItensKit(itens);
    }

    @RequestMapping(value={"/devolucao-parcial"})
    @DBAutoCommit
    public List<HashMap<String, Object>> carregarMapDevolucaoParcial(@RequestParam List<Long> idNotas, @RequestParam(required=false) boolean isDevolucaoConferencia, @RequestParam(required=false) boolean isTransferencia) throws UnicoMensagemUsuarioException {
        if (!Util.listNullOrEmpty(idNotas)) {
            Long idEntidade = null;
            for (Long idNota : idNotas) {
                Map mapNotaFiscal = NotaFiscalRN.getInstance().buscarValoresPorID(idNota, new String[]{"serie", "identidade"});
                if (Util.mapNullOrEmpty((Map)mapNotaFiscal)) continue;
                if (!ModeloNotaFiscal.NOTA_FISCAL_ELETRONICA.getId().equals(mapNotaFiscal.get("serie"))) {
                    throw new UnicoMensagemUsuarioException("WNTF9106", "A nota selecionada n\u00e3o \u00e9 uma NF-e (modelo 55)! Verifique.");
                }
                if (idEntidade == null) {
                    idEntidade = (Long)mapNotaFiscal.get("identidade");
                    continue;
                }
                if (idEntidade.equals(mapNotaFiscal.get("identidade")) || isTransferencia) continue;
                throw new UnicoMensagemUsuarioException("WNTF9290", "As notas selecionadas devem pertencer ao mesmo fornecedor! Verifique.");
            }
        }
        return NotaFiscalItemRN.getInstance().gerarMapParaDevolucaoParcial(idNotas, isDevolucaoConferencia);
    }

    @RequestMapping(value={"/devolucao-total"})
    @DBAutoCommit
    public NotaFiscal gerarDevolucao(@RequestParam List<Long> idNotas) throws UnicoMensagemUsuarioException {
        List hashMaps = this.carregarMapDevolucaoParcial(idNotas, false, false);
        return this.gerarNotaFiscalDevolucao(hashMaps, null, null, null, idNotas, true, true, true);
    }

    @RequestMapping(value={"/gerar-nf-devolucao"}, method={RequestMethod.POST})
    @DBAutoCommit
    public NotaFiscal gerarDevolucao(@RequestBody List<ItemNotaFiscalWrapper> itensDevolvidos, @RequestParam List<Long> idNotas, @RequestParam(required=false) Long idCfop, @RequestParam(required=false) Long idOpFiscal, @RequestParam(required=false) Long idFilial, @RequestParam(required=false) EnumSimNao frete, @RequestParam(required=false) EnumSimNao seguro, @RequestParam(required=false) EnumSimNao outrasDespesas) throws UnicoMensagemUsuarioException {
        ArrayList itens = new ArrayList();
        itensDevolvidos.forEach(item -> itens.add(ListMapUtil.objectToHashMap((Object)item)));
        return this.gerarNotaFiscalDevolucao(itens, idFilial, idCfop, idOpFiscal, idNotas, EnumSimNao.SIM.equals((Object)frete), EnumSimNao.SIM.equals((Object)seguro), EnumSimNao.SIM.equals((Object)outrasDespesas));
    }

    public NotaFiscal gerarNotaFiscalDevolucao(List<HashMap<String, Object>> itens, Long idFilial, Long idCfop, Long idOpFiscal, List<Long> idNotas, boolean devolverFrete, boolean devolverSeguro, boolean devolverOutrasDespesas) throws UnicoMensagemUsuarioException {
        NotaFiscal nota;
        Sessao sessao = SessaoUtil.getSessao();
        List itensSemSaldo = itens.stream().filter(map -> ((BigDecimal)map.get("quantidadeDevolvida")).compareTo((BigDecimal)map.get("saldo")) > 0).collect(Collectors.toList());
        if (!Util.listNullOrEmpty(itensSemSaldo)) {
            throw new UnicoMensagemUsuarioException("WNTF9444", "A quantidade devolvida dos produtos a seguir \u00e9 maior que a compra:", itensSemSaldo.stream().map(map -> map.get("codigoProduto") + " - " + map.get("produto") + "\n").collect(Collectors.joining()));
        }
        Filial filialTransferencia = null;
        TipoGeracaoAutomaticaNotaFiscal tipo = TipoGeracaoAutomaticaNotaFiscal.DEVOLUCAO_AUTOMATICA;
        if (!NumberUtil.longNullOuZero((Long)idFilial)) {
            filialTransferencia = (Filial)FilialRN.getInstance().buscarPorId(idFilial);
            tipo = TipoGeracaoAutomaticaNotaFiscal.TRANSFERENCIA_AUTOMATICA;
        }
        if ((nota = new GeradorNotaFiscalAutomaticaXML(tipo, sessao, idNotas, itens, idOpFiscal, idCfop, filialTransferencia, devolverFrete, devolverSeguro, devolverOutrasDespesas).getNotaFiscalGerada()) != null) {
            nota.getNotaFiscalItens().forEach(notaFiscalItem -> {
                notaFiscalItem.setDecimaisPreco(NotaFiscalItemRN.getInstance().getDecimaisPrecoProdutoWeb(nota, notaFiscalItem));
                notaFiscalItem.setDecimaisQuantidade(CacheSistema.getInstance().getCasasDecimaisUnidadeMedida(notaFiscalItem.getIdUnidadeMedida()).intValue());
            });
        }
        return nota;
    }

    @DBAutoCommit
    public List<NotaFiscalItem> getItens(Long id) {
        return this.buscarItens(id);
    }

    protected void beforeCreate(NotaFiscal notaFiscal, Optional<Long> parentId) throws UnicoMensagemUsuarioException {
        notaFiscal.setIdUsuarioInclusao(SessaoUtil.getSessao().getUsuario().getId());
        notaFiscal.setDataInclusao(DataHoraFactory.getDataHora());
        this.verificaGravar(notaFiscal, false);
    }

    protected void beforeUpdate(NotaFiscal notaFiscal, Optional<Long> parentId) throws UnicoMensagemUsuarioException {
        if (!NotaFiscalRN.getInstance().isPermiteAlterar(notaFiscal.getId())) {
            throw new UnicoMensagemUsuarioException("WNTF712", "Altera\u00e7\u00e3o n\u00e3o permitida");
        }
        notaFiscal.setIdUsuarioAlteracao(SessaoUtil.getSessao().getUsuario().getId());
        notaFiscal.setDataAlteracao(DataHoraFactory.getDataHora());
        this.verificaGravar(notaFiscal, true);
    }

    protected void beforeSave(NotaFiscal notaFiscal, Optional<Long> parentId) throws UnicoMensagemUsuarioException {
        HierarquiaPlanoContas planoContas;
        notaFiscal.setNotaFiscalItens(this.separarItensKit(notaFiscal.getNotaFiscalItens()));
        this.atualizarDadosObjeto(notaFiscal);
        this.atualizaContadorItens(notaFiscal);
        for (Object item : notaFiscal.getNotaFiscalItens()) {
            if (!VariacaoRN.getInstance().isProdutoPossuiVariacaoAtiva(item.getIdProduto()) || !ListMapUtil.mapNullOrEmpty((Map)item.getMapVariacoes())) continue;
            throw new UnicoMensagemUsuarioException("NTF9502", "O item " + item.getDescricao() + " n\u00e3o possui varia\u00e7\u00e3o informada. Verifique");
        }
        if (notaFiscal.getDataHoraEntradaSaida() == null && notaFiscal.getTipoDocumento().equals((Object)TipoNotaFiscal.ENTRADA)) {
            throw new UnicoMensagemUsuarioException("WWW602", "Informe a data de emiss\u00e3o");
        }
        notaFiscal.setInfoCompGerada(NotaFiscalRN.getInstance().gerarObservacaoNotaFiscal(notaFiscal, notaFiscal.getMapOrigens()));
        notaFiscal.setInfoFiscoGerada(NotaFiscalRN.getInstance().gerarObservacaoFiscoNotaFiscal(notaFiscal));
        NotaFiscalRN.getInstance().validarQuantidadeItensNotafiscal(notaFiscal.getTipoEmissao(), notaFiscal.getIdSerie(), notaFiscal.getNotaFiscalItens().size());
        if (!ListMapUtil.listNullOrEmpty((List)notaFiscal.getDocumentosReferenciadosNotaFiscal())) {
            Map<Long, List<NotaFiscalDocumentoReferenciado>> map = notaFiscal.getDocumentosReferenciadosNotaFiscal().stream().collect(Collectors.groupingBy(NotaFiscalDocumentoReferenciado::getIdDocumentoReferenciado));
            for (Map.Entry entry : map.entrySet()) {
                if (((List)entry.getValue()).size() <= 1) continue;
                throw new UnicoMensagemUsuarioException("WWW476", "A nota fiscal foi refer\u00eanciada mais de uma vez");
            }
        }
        if (notaFiscal.isNotaEntrada()) {
            for (Object item : notaFiscal.getNotaFiscalItens()) {
                PedidoCompraItem pedidoCompraItem;
                if (!Util.longNullOuZero((Long)item.getIdPedidoCompraItem()) || Util.stringNullOrEmpty((String)item.getNumeroPedidoCompra()) || Util.stringNullOrEmpty((String)item.getNumeroItemPedidoCompra()) || (pedidoCompraItem = PedidoCompraItemRN.getInstance().buscaPorCodigoPedidoCompraNumeroItem(SessaoUtil.getSessao(), notaFiscal.getIdEntidade(), item.getNumeroPedidoCompra(), item.getNumeroItemPedidoCompra(), false)) == null) continue;
                item.setIdPedidoCompraItem(pedidoCompraItem.getId());
            }
        }
        NotaFiscalRN.getInstance().recalculaValoresSubtotal(notaFiscal, notaFiscal.getNotaFiscalItens());
        ParametrosNotaFiscalInterface parametrosNotaFiscal = NotaFiscalRN.getInstance().getParametrosNotaFiscal(notaFiscal);
        if (parametrosNotaFiscal != null && !TipoIntegracaoFinanceiro.NENHUM.equals((Object)parametrosNotaFiscal.getIntegracao()) && FuncionalidadeManager.getInstance().isAtiva(Funcionalidade.PLANO_DE_CONTAS) && FuncionalidadeManager.getInstance().isAtiva(Funcionalidade.CENTRO_CUSTO) && (planoContas = (HierarquiaPlanoContas)HierarquiaPlanoContasRN.getInstance().buscarPorId(notaFiscal.getIdPlanoContas())) != null && planoContas.isCentroCustoObrigatorio()) {
            CentroCustoRateioRN.getInstance().validarRateio(notaFiscal.getValorTotalNota(), notaFiscal.getRateiosCentroCusto());
        }
    }

    protected void beforeRead(NotaFiscal notaFiscal, int modo, Optional<Long> parentId) throws UnicoMensagemUsuarioException {
        List contratosNotasFiscais;
        boolean saidaOS;
        notaFiscal.setMapOrigens(NotaFiscalOrigemRN.getInstance().getMapOrigens(notaFiscal.getId()));
        notaFiscal.setDocumentosReferenciadosNotaFiscal(NotaFiscalDocumentoReferenciadoRN.getInstance().buscarPorNotaFiscal(notaFiscal.getId(), 2));
        notaFiscal.setDocumentosReferenciadosOperacao(NotaFiscalDocumentoReferenciadoRN.getInstance().buscarPorNotaFiscal(notaFiscal.getId(), 1));
        notaFiscal.setDocumentosReferenciadosNfce(NotaFiscalDocumentoReferenciadoRN.getInstance().buscarPorNotaFiscal(notaFiscal.getId(), 35));
        notaFiscal.setDocumentosReferenciadosSat(NotaFiscalDocumentoReferenciadoRN.getInstance().buscarPorNotaFiscal(notaFiscal.getId(), 42));
        notaFiscal.setDocumentosReferenciadosCteTerceiros(NotaFiscalDocumentoReferenciadoRN.getInstance().buscarPorNotaFiscal(notaFiscal.getId(), -16));
        notaFiscal.setObservacoesFisco(NotaFiscalObsFiscoRN.getInstance().buscarPorNotaFiscal(notaFiscal.getId()));
        notaFiscal.setObservacoesContribuinte(NotaFiscalObsContribuinteRN.getInstance().buscaListaPorNotaFiscal(notaFiscal.getId()));
        notaFiscal.setRateiosCentroCusto(CentroCustoRateioRN.getInstance().buscaRateios(OrigemRateioCentroCusto.NOTA_FISCAL, notaFiscal.getId()));
        AcaoAlterarNotaFiscal acaoAlterarNotaFiscal = NotaFiscalRN.getInstance().getAcaoPermiteAlterar(notaFiscal);
        notaFiscal.setPermiteAlterar(acaoAlterarNotaFiscal.isPermite());
        notaFiscal.setAcaoAlterarNotaFiscal(acaoAlterarNotaFiscal);
        notaFiscal.setAcaoExcluirNotaFiscal(NotaFiscalRN.getInstance().getAcaoExcluirCancelar(notaFiscal, true));
        boolean notaEntradaTerceiros = notaFiscal.isNotaEntrada() && notaFiscal.isEmissaoTerceiros();
        boolean bl = saidaOS = notaFiscal.isNotaSaida() && notaFiscal.getOrigemPrincipal() == 6;
        if ((notaEntradaTerceiros || saidaOS) && modo == 1) {
            notaFiscal.setNaoEstornarFinanceiro(NotaFiscalRN.getInstance().possuiBaixaFinanceiro(notaFiscal.getId(), SessaoUtil.getSessao()));
        }
        notaFiscal.setListaDocumentoFinanceiro(NotaFiscalDocumentoFinanceiroRN.getInstance().buscarListaPorIdNotaFiscal(notaFiscal.getId()));
        notaFiscal.getListaDocumentoFinanceiro().forEach(financeiro -> {
            if (financeiro.getTipoPagamentoPOS() != null) {
                BandeiraCartao bandeira;
                AdministradoraCartao admCartao = (AdministradoraCartao)AdministradoraCartaoRN.getInstance().buscarPorId(financeiro.getIdAdministradoraPOS());
                if (admCartao != null) {
                    financeiro.setNomeAdministradoraPOS(admCartao.getNome());
                }
                if ((bandeira = (BandeiraCartao)BandeiraCartaoRN.getInstance().buscarPorId(financeiro.getIdBandeiraPOS())) != null) {
                    financeiro.setNomeBandeiraPOS(bandeira.getNome());
                }
            }
        });
        if (!notaFiscal.getTipoEmissao().equals((Object)TipoEmissaoNotaFiscal.PROPRIA)) {
            ModeloNotaFiscal modelo = (ModeloNotaFiscal)EnumUtils.getPorId(ModeloNotaFiscal.class, (Object)notaFiscal.getSerie());
            notaFiscal.setSerie(modelo.name());
        }
        List notaFiscalItens = NotaFiscalItemRN.getInstance().buscarListaByIdNotaFiscal(notaFiscal.getId());
        notaFiscalItens.forEach(item -> {
            NaturezaOperacao naturezaOperacao = NaturezaOperacaoRN.getInstance().buscarPorId(item.getIdCfop());
            NaturezaOperacaoDTOWeb dto = new NaturezaOperacaoDTOWeb();
            BeanUtil.copiarValores((Object)naturezaOperacao, (Object)dto, (boolean)false, null);
            item.setCfopItem(dto);
            item.setDecimaisPreco(NotaFiscalItemRN.getInstance().getDecimaisPrecoProdutoWeb(notaFiscal, item));
            item.setDecimaisQuantidade(CacheSistema.getInstance().getCasasDecimaisUnidadeMedida(item.getIdUnidadeMedida()).intValue());
            item.setPrecoUnitario(item.getPrecoUnitario().setScale(item.getDecimaisPreco(), RoundingMode.HALF_EVEN));
            item.setItemPermiteDesconto(DescontoRN.getInstance().isItemPermiteDesconto(SessaoUtil.getSessao().getFilial(), (DescontoInterface)item, !NumberUtil.longNullOuZero((Long)item.getIdPromocao()) ? PromocaoRN.getInstance().buscarPorId(item.getIdPromocao()) : null));
            item.setQuantidade(item.getQuantidade().setScale(UnidademedidaRN.getInstance().getCasasDecimais(item.getIdUnidadeMedida()), RoundingMode.HALF_EVEN));
            if (item.getTipo().equalsIgnoreCase(TipoRegistroProduto.PRODUTO.getId())) {
                this.atualizaPreferenciaIcms1070(notaFiscal, item);
            }
            if (!NumberUtil.longNullOuZero((Long)item.getId()) && this.funcionalidadeService.isAtiva(Funcionalidade.ESTOQUE_TERCEIROS)) {
                item.setSaldoFiscalBaixa(SaldoFiscalBaixaRN.getInstance().buscaBaixaPorItemNotaFiscalSaida(item));
            }
        });
        notaFiscal.setTotalFinanceiro(NotaFiscalDocumentoFinanceiroRN.getInstance().calcularValorTotalFinanceiro(notaFiscalItens, SessaoUtil.getSessao().getFilial(), notaFiscal.getValorVendor()));
        notaFiscal.setTotalFinanceiroItens(notaFiscal.getTotalFinanceiro());
        if (NumberUtil.bigDecimalNullOrZero((BigDecimal)notaFiscal.getAPrazo())) {
            notaFiscal.setAPrazo(notaFiscal.getTotalFinanceiro().subtract(notaFiscal.getAVista()));
        }
        if (ModuloManager.getInstance().isAtivo(Modulo.CONTRATO) && (contratosNotasFiscais = ContratoVendaNotaFiscalRN.getInstance().buscaContratoNotaFiscal(notaFiscal.getId())).size() > 0) {
            notaFiscal.setMesAnoReferenciaContrato(((ContratoVendaNotaFiscal)contratosNotasFiscais.get(0)).getMesAnoReferenciaContrato());
        }
        notaFiscal.setDocumentosEmRemessaBancaria(NotaFiscalRN.getInstance().buscarFinanceiroNotaFiscalEmRemessaBancaria(notaFiscal.getId()));
        if (!StringUtil.stringNullOrEmpty((String)notaFiscal.getCnpjCpfEntrega())) {
            notaFiscal.setTipoDocEntrega(notaFiscal.getCnpjCpfEntrega().length() == 14 ? TipoPessoa.FISICA : TipoPessoa.JURIDICA);
        }
        notaFiscal.setNotaFiscalItens(this.agruparItensKit(notaFiscalItens));
        notaFiscal.setDefensivosAgricolas(NotaFiscalDefensivoAgricolaRN.getInstance().buscarListaPorNotaFiscal(notaFiscal.getId()));
        this.setHabilitaFunruralSubtotal(notaFiscal);
    }

    protected GridBuilder<NotaFiscalRN> getGridBuilder() {
        String descricaoColunaEntidade = "";
        if (this.isNotaEntrada()) {
            descricaoColunaEntidade = "Fornecedor";
        } else if (this.isNotaSaida()) {
            descricaoColunaEntidade = "Cliente";
        }
        ArrayList<ColunaSQL> colunas = new ArrayList<ColunaSQL>();
        colunas.add(new ColunaSQL("id", "ID", 0, false));
        colunas.add(new ColunaSQL("idSerie", "ID S\u00e9rie", 0, false));
        colunas.add(new ColunaSQL("idEntidade", "ID Cliente", 0, false));
        colunas.add(new ColunaSQL("idTransportadora", "ID Trnansportadora", 0, false));
        colunas.add(new ColunaSQL("linkNfse", "Link NFS-e", 0, false));
        colunas.add(new ColunaSQL("precoPendente", "Pre\u00e7o pendente", 0, false));
        colunas.add(new ColunaSQL("numeroNotaFiscal", "N\u00famero", 80, true));
        if (this.isNotaSaida() && LicencaManager.getInstance().isNfse()) {
            colunas.add(new ColunaSQL("numeroNfse", "NFS-e", 80, true));
        }
        colunas.add(new ColunaSQL("serie", "Modelo", 90, true));
        colunas.add(new ColunaSQL("modelo", "S\u00e9rie", 90, true));
        colunas.add(new ColunaSQL("codigo", "codigoCfop", "CFOP", 90, true, new String[]{"fk_notafiscal_cfop"}));
        String nomeColunaEmissao = this.isNotaSaida() ? "Emiss\u00e3o" : "Entrada";
        colunas.add(new ColunaSQL("emissao", nomeColunaEmissao, 100, true));
        colunas.add(new ColunaSQL("razaoSocial", descricaoColunaEntidade, 0, true));
        colunas.add(new ColunaSQL("valorTotalNota", "valorTotal", "Valor", 100, false, new String[0]));
        ColunaSQL colunaValor = new ColunaSQL("valorTotalNota", "Valor", 100, true);
        colunaValor.setTotalizar(true);
        colunas.add(colunaValor);
        colunas.add(new ColunaSQL("status", "Status", 180, true));
        colunas.add(new ColunaSQL("mensagemProtocoloNfe", "Mensagem retorno", 300, true));
        colunas.add(new ColunaSQL("chaveNfe", "Chave NF-e", 300, true));
        colunas.add(new ColunaSQL("impresso", "Impresso", 100, true));
        colunas.add(new ColunaSQL("possuiCartaCorrecao", "Carta corre\u00e7\u00e3o", 130, true));
        colunas.add(new ColunaSQL("tipoEmissao", "tipoEmissao", 0, false));
        colunas.add(new ColunaSQL("notaDesagregacaoInsumos", "notaDesagregacaoInsumos", 0, false));
        colunas.add(new ColunaSQL("transferencia", "transferencia", 0, false));
        colunas.add(new ColunaSQL("idFilial", "idFilial", 0, false));
        ColunaSQL permiteAlterar = new ColunaSQL("permiteAlterar", "Permite alterar nota", 80, false);
        permiteAlterar.setVirtual(true);
        permiteAlterar.setEstatico(true);
        colunas.add(permiteAlterar);
        ColunaSQL permiteAlterarNfConferida = new ColunaSQL("permiteAlterarNfConferida", "Permite alterar nota conferida", 80, false);
        permiteAlterarNfConferida.setVirtual(true);
        permiteAlterarNfConferida.setEstatico(true);
        colunas.add(permiteAlterarNfConferida);
        ColunaSQL acaoAlterarNotaFiscal = new ColunaSQL("acaoAlterarNotaFiscal", "A\u00e7\u00e3o de altera\u00e7\u00e3o", 80, false);
        acaoAlterarNotaFiscal.setVirtual(true);
        acaoAlterarNotaFiscal.setEstatico(true);
        colunas.add(acaoAlterarNotaFiscal);
        ColunaSQL acaoExcluirNotaFiscal = new ColunaSQL("acaoExcluirNotaFiscal", "A\u00e7\u00e3o de exclus\u00e3o", 80, false);
        acaoExcluirNotaFiscal.setVirtual(true);
        acaoExcluirNotaFiscal.setEstatico(true);
        colunas.add(acaoExcluirNotaFiscal);
        ColunaSQL permiteGeracaoNFe = new ColunaSQL("permiteGeracaoNFe", "Permite transmiss\u00e3o de NF-e", 80, false);
        permiteGeracaoNFe.setVirtual(true);
        permiteGeracaoNFe.setEstatico(true);
        colunas.add(permiteGeracaoNFe);
        ColunaSQL nfe = new ColunaSQL("isNfe", "NF-e", 80, false);
        nfe.setVirtual(true);
        nfe.setEstatico(true);
        colunas.add(nfe);
        ColunaSQL nfse = new ColunaSQL("isNfse", "NFSe", 80, false);
        nfse.setVirtual(true);
        nfse.setEstatico(true);
        colunas.add(nfse);
        if (ModuloManager.getInstance().isAtivo(Modulo.EXPEDICAO)) {
            colunas.add(new ColunaSQL("statusConferencia", "statusConferencia"));
            if (this.isNotaSaida()) {
                colunas.add(new ColunaSQL("idestadoentrega", "idestadoentreganf"));
                colunas.add(new ColunaSQL("id", "idestadocliente", "Estado entrega cliente", 0, false, new String[]{"fk_notafiscal_entidade", "fk_entidade_estado"}));
                Escolha escolhaEstadoEntrega = new Escolha(new Caso(new Condicao("idestadoentreganf", Operador.MAIOR_QUE, Long.valueOf(0L)), "idestadoentreganf"), "idestadocliente");
                ColunaSQL colunaSQLEstadoEntrega = new ColunaSQL(escolhaEstadoEntrega, "entregaidestado");
                colunaSQLEstadoEntrega.setTipoDadoBase(TipoDadoBase.NUMERIC);
                colunas.add(colunaSQLEstadoEntrega);
                colunas.add(new ColunaSQL("idcidadeentrega", "idcidadeentreganf"));
                colunas.add(new ColunaSQL("id", "idcidadecliente", "Cidade entrega cliente", 0, false, new String[]{"fk_notafiscal_entidade", "fk_entidade_cidade"}));
                Escolha escolhaCidadeEntrega = new Escolha(new Caso(new Condicao("idestadoentreganf", Operador.MAIOR_QUE, Long.valueOf(0L)), "idcidadeentreganf"), "idcidadecliente");
                ColunaSQL colunaSQLCidadeEntrega = new ColunaSQL(escolhaCidadeEntrega, "entregaidcidade");
                colunaSQLCidadeEntrega.setTipoDadoBase(TipoDadoBase.NUMERIC);
                colunas.add(colunaSQLCidadeEntrega);
                colunas.add(new ColunaSQL("idrota", "idrota", new String[]{"fk_notafiscal_entidade"}));
            }
        }
        if (FuncionalidadeManager.getInstance().isAtiva(Funcionalidade.CONFERENCIA) && (this.isNotaEntrada() && PropriedadeRN.getInstance().getPropriedadeBoolean(SessaoUtil.getSessao().getFilial(), 906) || this.isNotaSaida() && PropriedadeRN.getInstance().getPropriedadeBoolean(SessaoUtil.getSessao().getFilial(), 907))) {
            colunas.add(new ColunaSQL("statusconferencia", "Confer\u00eancia", 200, true));
        }
        String aliasTabela = this.tipoNotaFiscal.equals((Object)TipoNotaFiscal.SAIDA) ? "notafiscal_saida" : "notafiscal_entrada";
        GridBuilder grid = new GridBuilder(((NotaFiscalRN)this.rn).getTabela(), colunas, aliasTabela);
        Sessao sessao = SessaoUtil.getSessao();
        grid.addReferenciaDefault(new Referencia("tipodocumento"));
        grid.addCodicaoDefault(new Condicao("tipodocumento", Operador.IGUAL, this.tipoNotaFiscal.getId()));
        grid.addCodicaoDefault(new Condicao("idFilial", Operador.IGUAL, sessao.getFilial().getId()));
        grid.addReferenciaDefault(new Referencia("modelo"));
        grid.addOrdemDefault(new Ordem("modelo", true));
        grid.addReferenciaDefault(new Referencia("numeronotafiscal"));
        grid.addOrdemDefault(new Ordem("numeronotafiscal", true));
        grid.addReferenciaDefault(new Referencia("emissao", "emissao"));
        if (sessao.getUsuario().getPreferenciaUsuario().isFiltrarFatVendedorUsuario() && !NumberUtil.longNullOuZero((Long)sessao.getUsuario().getIdEntidade())) {
            USelect uSelect = new USelect("entidade");
            uSelect.add(new ColunaSQL("id"));
            uSelect.add((ColunaSQL)new Referencia("idrepresentante"));
            uSelect.add(new Condicao("idrepresentante", Operador.IGUAL, sessao.getUsuario().getIdEntidade()));
            grid.addCodicaoDefault(new Condicao("idEntidade", Operador.CONTIDO_EM, uSelect));
        }
        grid.addColunaCustomizavel((ColunaCustomizavelGrid)new ColunaCustomizavelNotaPossuiDevolucao(sessao));
        if (this.moduloService.isAtivo(Modulo.EXPEDICAO) && this.tipoNotaFiscal.equals((Object)TipoNotaFiscal.SAIDA)) {
            grid.addColunaCustomizavel((ColunaCustomizavelGrid)new ColunaCustomizavelUsuarioCargaNotaFiscal(sessao));
            grid.addColunaCustomizavel((ColunaCustomizavelGrid)new ColunaCustomizavelDataCargaNotaFiscal(sessao));
            grid.addColunaCustomizavel((ColunaCustomizavelGrid)new ColunaCustomizavelStatusCargaNotaFiscal(sessao));
            grid.addColunaCustomizavel((ColunaCustomizavelGrid)new ColunaCustomizavelCodigoCargaNotaFiscal(sessao));
        }
        return grid;
    }

    public List<Coluna> getColunasCustomizaveis() {
        return NotaFiscalRN.getInstance().getColunaGridCustomizavelNotaFiscalWW2(this.tipoNotaFiscal);
    }

    protected void afterLoadGrid(List<ColunaSQL> colunas, List<Object[]> dados, List<FilterField> filters, MultiValueMap<String, String> parameters) throws UnicoMensagemUsuarioException {
        for (Object[] registro : dados) {
            NotaFiscal notaFiscal = this.montarObjetoGrid(registro, colunas);
            AcaoAlterarNotaFiscal acaoAlterarNotaFiscal = NotaFiscalRN.getInstance().getAcaoPermiteAlterar(notaFiscal);
            registro[this.getIndexColuna((String)"permiteAlterar", colunas)] = acaoAlterarNotaFiscal.isPermite();
            registro[this.getIndexColuna((String)"acaoAlterarNotaFiscal", colunas)] = JsonUtil.toJson((Object)acaoAlterarNotaFiscal);
            registro[this.getIndexColuna((String)"permiteAlterarNfConferida", colunas)] = true;
            registro[this.getIndexColuna((String)"isNfe", colunas)] = NotaFiscalRN.getInstance().isNfe(notaFiscal);
            registro[this.getIndexColuna((String)"isNfse", colunas)] = NotaFiscalRN.getInstance().isNfse(notaFiscal);
        }
    }

    protected List<TabelaConfigurada> getTabelasConfiguracaoRelatorio() {
        return Arrays.asList(new TabelaConfigurada(NotaFiscalRN.getInstance().getTabela(), "Nota fiscal"), new TabelaConfigurada(NotaFiscalItemRN.getInstance().getTabela(), "Itens de nota fiscal"), new TabelaConfigurada("vendas_itens_view", "Itens de venda"));
    }

    private NotaFiscal montarObjetoGrid(Object[] registro, List<ColunaSQL> colunas) {
        NotaFiscal notaFiscal = new NotaFiscal();
        Long id = (Long)registro[this.getIndexColuna("id", colunas)];
        Map objectMap = NotaFiscalRN.getInstance().buscarValoresPorID(id, new String[]{"numeroNotaFiscal", "status", "idFilial", "transferencia", "notaDesagregacaoInsumos", "impresso", "serie", "tipoEmissao", "modelo", "idSerie"});
        notaFiscal.setId(id);
        notaFiscal.setNumeroNotaFiscal((String)objectMap.get("numeroNotaFiscal"));
        int idStatus = (Integer)objectMap.get("status");
        notaFiscal.setStatus((StatusNotaFiscal)EnumUtils.getPorId(StatusNotaFiscal.class, (Object)idStatus));
        notaFiscal.setIdFilial((Long)objectMap.get("idFilial"));
        notaFiscal.setTipoDocumento(this.tipoNotaFiscal);
        notaFiscal.setTransferencia(objectMap.get("transferencia") != null && (Integer)objectMap.get("transferencia") == 1);
        notaFiscal.setNotaDesagregacaoInsumos(objectMap.get("notaDesagregacaoInsumos") != null && objectMap.get("notaDesagregacaoInsumos").equals("1"));
        notaFiscal.setImpresso(objectMap.get("impresso").equals("1"));
        notaFiscal.setSerie((String)objectMap.get("serie"));
        String idTipoEmissao = (String)objectMap.get("tipoEmissao");
        notaFiscal.setTipoEmissao((TipoEmissaoNotaFiscal)EnumUtils.getPorId(TipoEmissaoNotaFiscal.class, (Object)idTipoEmissao));
        notaFiscal.setModelo((String)objectMap.get("modelo"));
        notaFiscal.setIdSerie((Long)objectMap.get("idSerie"));
        return notaFiscal;
    }

    private void verificaGravar(NotaFiscal notaFiscal, boolean update) throws UnicoMensagemUsuarioException {
        Serie serie;
        BigDecimal totalFinanceiro;
        BigDecimal total;
        boolean estornarFinanceiro;
        ParametrosNotaFiscalInterface parametrosNotaFiscal = NotaFiscalRN.getInstance().getParametrosNotaFiscal(notaFiscal);
        if (notaFiscal.isNotaSaida() && parametrosNotaFiscal != null) {
            boolean isVendaETemIntegracaoFinanceiro;
            boolean bl = isVendaETemIntegracaoFinanceiro = parametrosNotaFiscal.isConsideravenda() && parametrosNotaFiscal.getIntegracao() != null && parametrosNotaFiscal.getIntegracao().equals((Object)TipoIntegracaoFinanceiro.RECEBER);
            if (isVendaETemIntegracaoFinanceiro) {
                List idsPedidos = null;
                List idsOrdensServico = null;
                if (notaFiscal.getMapOrigens() != null) {
                    if (18 == notaFiscal.getOrigemPrincipal()) {
                        idsPedidos = (List)notaFiscal.getMapOrigens().get(18);
                    } else if (5 == notaFiscal.getOrigemPrincipal()) {
                        idsPedidos = (List)notaFiscal.getMapOrigens().get(5);
                    } else if (6 == notaFiscal.getOrigemPrincipal()) {
                        idsOrdensServico = (List)notaFiscal.getMapOrigens().get(5);
                    }
                }
                if (notaFiscal.getAPrazo().compareTo(BigDecimal.ZERO) > 0 && !CondicaoPagamentoRN.getInstance().isCondicaoPagamentoAVista(notaFiscal.getIdCondicaoPagto())) {
                    NotaFiscal notaOriginal;
                    BigDecimal valorVerificadorCredito = notaFiscal.getAPrazo();
                    if (update && (notaOriginal = (NotaFiscal)NotaFiscalRN.getInstance().buscarPorId(notaFiscal.getId())) != null) {
                        valorVerificadorCredito = valorVerificadorCredito.subtract(notaOriginal.getAPrazo()).add(notaOriginal.getPosAPrazo());
                    }
                    valorVerificadorCredito = valorVerificadorCredito.subtract(notaFiscal.getPosAPrazo());
                    try {
                        EntidadeRN.getInstance().verificaSeEstourouLimiteCreditoClienteIgnorandoDocumentos(SessaoUtil.getSessao(), notaFiscal.getIdEntidade(), notaFiscal.getIdTipoDocumento(), valorVerificadorCredito, true, idsPedidos, idsOrdensServico);
                    }
                    catch (UnicoPerguntaUsuarioException e) {
                        throw new UnicoMensagemUsuarioException("WNTF446", "Venda n\u00e3o permitida! Verifique os limites do cliente.");
                    }
                }
                if (notaFiscal.getAVista().compareTo(BigDecimal.ZERO) > 0 && notaFiscal.getCheque().compareTo(BigDecimal.ZERO) > 0 && this.funcionalidadeService.isAtiva(Funcionalidade.LIMITE_CREDITO_FORMA_PGMTO)) {
                    try {
                        EntidadeRN.getInstance().verificaSeEstourouLimiteCreditoClienteIgnorandoDocumentos(SessaoUtil.getSessao(), notaFiscal.getIdEntidade(), Long.valueOf(-2L), notaFiscal.getCheque(), true, idsPedidos, idsOrdensServico);
                    }
                    catch (UnicoPerguntaUsuarioException e) {
                        throw new UnicoMensagemUsuarioException("WNTF8944", "Venda n\u00e3o permitida!");
                    }
                }
            }
        }
        boolean bl = estornarFinanceiro = !notaFiscal.isNaoEstornarFinanceiro();
        if (estornarFinanceiro && parametrosNotaFiscal != null && parametrosNotaFiscal.getIntegracao() != null && !parametrosNotaFiscal.getIntegracao().equals((Object)TipoIntegracaoFinanceiro.NENHUM) && NumberUtil.longNullOuZero((Long)notaFiscal.getIdTransacaoFinanceira()) && (total = notaFiscal.getListaDocumentoFinanceiro().stream().filter(d -> d.getTipoPagamentoPOS() == null).map(AbstractDocumentoFinanceiro::getValor).reduce(BigDecimal.ZERO, BigDecimal::add)).compareTo(totalFinanceiro = notaFiscal.getAPrazo().subtract(notaFiscal.getPosAPrazo())) != 0) {
            String strTotal = Util.formataNumero((BigDecimal)total, (String)"#,###,##0.00");
            String strTotalFinanceiro = Util.formataNumero((BigDecimal)totalFinanceiro, (String)"#,###,##0.00");
            throw new UnicoMensagemUsuarioException("WNTF447", "Total das parcelas (" + strTotal + ") n\u00e3o \u00e9 igual ao valor a prazo (" + strTotalFinanceiro + "). Verifique.");
        }
        if (notaFiscal.isEmissaoPropria() && (serie = (Serie)SerieRN.getInstance().buscarPorId(notaFiscal.getIdSerie())) != null) {
            NotaFiscal notaFiscalAnterior = (NotaFiscal)NotaFiscalRN.getInstance().buscarPorId(notaFiscal.getId());
            if (update && serie.getCodigo().equalsIgnoreCase(notaFiscalAnterior.getSerie()) && serie.getModelo().equalsIgnoreCase(notaFiscalAnterior.getModelo())) {
                notaFiscal.setNumeroNotaFiscal(notaFiscalAnterior.getNumeroNotaFiscal());
                notaFiscal.setModelo(notaFiscalAnterior.getModelo());
            } else {
                BigDecimal sequencial = SerieRN.getInstance().getProximoNumeroNotaFiscal(serie.getId(), SessaoUtil.getSessao().getFilial().getId());
                notaFiscal.setNumeroNotaFiscal(Util.formataNumero((BigDecimal)sequencial, (String)"000000", (int)6));
                notaFiscal.setModelo(serie.getModelo());
            }
        }
    }

    private void atualizarDadosObjeto(NotaFiscal notaFiscal) throws UnicoMensagemUsuarioException {
        notaFiscal.setIdFilial(SessaoUtil.getSessao().getFilial().getId());
        notaFiscal.setImpresso(false);
        notaFiscal.setNsu(this.getNSU(notaFiscal));
        notaFiscal.setDataHoraNsu(this.isEmissaoPropria(notaFiscal) ? DataHoraFactory.getDataHora() : null);
        if (notaFiscal.getTipoFrete() == null) {
            notaFiscal.setTipoFrete(TipoFrete.SEMFRETE);
        }
        notaFiscal.setTipoDocumento(this.tipoNotaFiscal);
    }

    private boolean isEmissaoPropria(NotaFiscal notaFiscal) {
        return notaFiscal.getTipoEmissao().equals((Object)TipoEmissaoNotaFiscal.PROPRIA);
    }

    private Long getNSU(NotaFiscal notaFiscal) throws UnicoMensagemUsuarioException {
        if (!this.isEmissaoPropria(notaFiscal)) {
            return 0L;
        }
        if (NumberUtil.longNullOuZero((Long)notaFiscal.getNsu())) {
            return FilialRN.getInstance().getNSU(SessaoUtil.getSessao());
        }
        return notaFiscal.getNsu();
    }

    private void atualizaContadorItens(NotaFiscal notaFiscal) {
        NotaFiscalItemRN.getInstance().atualizarContadorListaItens(notaFiscal.getNotaFiscalItens());
    }

    private boolean isNotaEntrada() {
        return this.tipoNotaFiscal.equals((Object)TipoNotaFiscal.ENTRADA);
    }

    private boolean isNotaSaida() {
        return this.tipoNotaFiscal.equals((Object)TipoNotaFiscal.SAIDA);
    }

    private boolean isNotaComplementarAjuste(ParametrosNotaFiscalInterface parametros) {
        if (parametros != null) {
            return parametros.getFinalidadeEmissaoNfe() == FinalidadeEmissaoNfeCFOP.COMPLEMENTAR || parametros.getFinalidadeEmissaoNfe() == FinalidadeEmissaoNfeCFOP.AJUSTE;
        }
        return false;
    }

    private void recalcularValoresRateio(NotaFiscal notaFiscal, ParametrosNotaFiscalInterface parametros, boolean retotalizandoValores, boolean recalculaImpostos) throws UnicoMensagemUsuarioException {
        Estado estado;
        notaFiscal.setTipoDocumento(this.tipoNotaFiscal);
        String codigoEstado = "";
        Sessao sessao = SessaoUtil.getSessao();
        Entidade entidade = (Entidade)EntidadeRN.getInstance().buscarPorId(notaFiscal.getIdEntidade());
        if (entidade != null && (estado = (Estado)EstadoRN.getInstance().buscarPorId(entidade.getEndereco().getIdEstado())) != null) {
            codigoEstado = estado.getCodigo();
        }
        LocalDate emissao = this.isNotaEntrada() ? notaFiscal.getEntradaSaida() : notaFiscal.getEmissao();
        boolean isRateio = parametros != null && parametros.isInformarTotaisManualmente();
        boolean isImportacao = parametros != null && parametros.isImportacao() && this.isNotaEntrada();
        boolean isTipoNotaValidaParaRecalculo = this.isNotaSaida() || this.isNotaEntrada() && this.isEmissaoPropria(notaFiscal) && !isImportacao && !isRateio;
        int origem = this.tipoNotaFiscal == TipoNotaFiscal.SAIDA ? -18 : -21;
        notaFiscal.setNotaFiscalItens(this.separarItensKit(notaFiscal.getNotaFiscalItens()));
        if (recalculaImpostos && isTipoNotaValidaParaRecalculo) {
            for (NotaFiscalItem item : notaFiscal.getNotaFiscalItens()) {
                TipoCalculoImposto tipoCalculoImposto = item.getTipo().equalsIgnoreCase(TipoRegistroProduto.PRODUTO.getId()) ? TipoCalculoImposto.CST_IPI : TipoCalculoImposto.CST_PIS;
                new CalculoImposto().calcularImpostos((ItemTributavelInterface)item, entidade, tipoCalculoImposto, this.tipoNotaFiscal, emissao, codigoEstado, notaFiscal.getTipoEmissao(), parametros, sessao.getFilial(), false, origem);
            }
        } else {
            ArrayList<NotaFiscalItem> produtos = new ArrayList<NotaFiscalItem>();
            ArrayList<NotaFiscalItem> servicos = new ArrayList<NotaFiscalItem>();
            for (NotaFiscalItem item : notaFiscal.getNotaFiscalItens()) {
                if (item.getTipo().equalsIgnoreCase(TipoRegistroProduto.PRODUTO.getId())) {
                    produtos.add(item);
                    continue;
                }
                if (!item.getTipo().equalsIgnoreCase(TipoRegistroProduto.SERVICO.getId())) continue;
                servicos.add(item);
            }
            if (isRateio || isImportacao) {
                for (NotaFiscalItem item : produtos) {
                    if (item.getTipoKit() == TipoKit.KIT_PAI.getId().intValue()) continue;
                    new CalculoImposto().calcularImpostos((ItemTributavelInterface)item, entidade, TipoCalculoImposto.TOTAL_ITEM, this.tipoNotaFiscal, emissao, codigoEstado, notaFiscal.getTipoEmissao(), parametros, sessao.getFilial(), false, origem);
                }
            } else {
                boolean isNotaCreditoOuTransferenciaCreditoIcms = this.calculoImpostoService.isNotaCreditoOuTransferenciaCreditoIcms(parametros);
                for (NotaFiscalItem item : produtos) {
                    if (item.getTipoKit() == TipoKit.KIT_PAI.getId().intValue() || isNotaCreditoOuTransferenciaCreditoIcms) continue;
                    new CalculoImposto().calcularImpostos((ItemTributavelInterface)item, entidade, TipoCalculoImposto.BASE_IPI, this.tipoNotaFiscal, emissao, codigoEstado, notaFiscal.getTipoEmissao(), parametros, sessao.getFilial(), true, origem);
                }
                for (NotaFiscalItem item : servicos) {
                    if (item.getTipoKit() == TipoKit.KIT_PAI.getId().intValue()) continue;
                    new CalculoImposto().calcularImpostos((ItemTributavelInterface)item, entidade, TipoCalculoImposto.TOTAL_ITEM, this.tipoNotaFiscal, emissao, codigoEstado, notaFiscal.getTipoEmissao(), parametros, sessao.getFilial(), false, origem);
                }
            }
        }
        notaFiscal.setNotaFiscalItens(this.agruparItensKit(notaFiscal.getNotaFiscalItens()));
        this.calcularValoresSubtotal(notaFiscal, retotalizandoValores, false);
    }

    private void atualizaPreferenciaIcms1070(NotaFiscal notaFiscal, NotaFiscalItem item) {
        if (notaFiscal.isNotaEntrada() && notaFiscal.getTipoEmissao().equals((Object)TipoEmissaoNotaFiscal.TERCEIROS) && PropriedadeRN.getInstance().getPropriedadeBoolean(SessaoUtil.getSessao().getFilial(), 209) && NotaFiscalItemRN.getInstance().isCST1070(item, SessaoUtil.getSessao().getFilial())) {
            item.setBaseIcms(item.getBaseIcmsNaoAproveitado());
            item.setIcms(item.getIcmsNaoAproveitado());
            item.setPercentualIcms(item.getPercentualIcmsNaoAproveitado());
            item.setPercentualReducaoIcms(item.getPercentualReducaoIcmsNaoAprov());
            if (!NumberUtil.bigDecimalNullOrZero((BigDecimal)item.getIcmsFcpInternoNaoAprovaitado())) {
                item.setBaseFundoPobrezaInterno(item.getBaseFcpInternoNaoAproveitado());
                item.setIcmsFundoPobrezaInterno(item.getIcmsFcpInternoNaoAprovaitado());
                item.setPercIcmsFundoPobrezaInterno(item.getPercFcpInternoNaoAproveitado());
            }
        }
    }

    @PostMapping(value={"/gerar-observacoes"})
    @DBAutoCommit
    public Map<String, String> gerarObservacoes(@RequestBody NotaFiscal notaFiscal) {
        notaFiscal.setTipoDocumento(this.tipoNotaFiscal);
        if (NumberUtil.longNullOuZero((Long)notaFiscal.getIdFilial())) {
            notaFiscal.setIdFilial(SessaoUtil.getSessao().getIdFilial());
        }
        if (!StringUtil.stringNullOrEmpty((String)notaFiscal.getTelefoneEntrega())) {
            notaFiscal.setTelefoneEntrega(StringUtil.formatarString((String)Util.apenasNumeros((String)notaFiscal.getTelefoneEntrega()), (String)TipoMascara.TELEFONE.getId()));
        }
        HashMap<String, String> mapObs = new HashMap<String, String>();
        mapObs.put("obs", NotaFiscalRN.getInstance().gerarObservacaoNotaFiscal(notaFiscal, notaFiscal.getMapOrigens()));
        mapObs.put("obsFisco", NotaFiscalRN.getInstance().gerarObservacaoFiscoNotaFiscal(notaFiscal));
        return mapObs;
    }

    @DBAutoCommit
    public ImpostoCalculadoWrapper<NotaFiscalItem> atualizarComponentes(@RequestBody ImpostoWrapper<NotaFiscalItem> impostoWrapper) throws UnicoMensagemUsuarioException {
        Sessao sessao = SessaoUtil.getSessao();
        ComponenteSaldoQuantidade componenteSaldoQuantidade = ProdutoRN.getInstance().buscaSaldoQuantidadeComponente(sessao, sessao.getIdFilial(), ((NotaFiscalItem)impostoWrapper.getItem()).getIdProduto(), null, null, false);
        Produto produto = (Produto)ProdutoRN.getInstance().buscarPorId(((NotaFiscalItem)impostoWrapper.getItem()).getIdProduto());
        if (produto != null && (!produto.getTipo().equals((Object)TipoRegistroProduto.PRODUTO) || produto.isKit())) {
            ((NotaFiscalItem)impostoWrapper.getItem()).setSaldoProduto(BigDecimal.ZERO);
            ((NotaFiscalItem)impostoWrapper.getItem()).setSaldoProdutoPrevisto(BigDecimal.ZERO);
        } else {
            ((NotaFiscalItem)impostoWrapper.getItem()).setSaldoProduto(componenteSaldoQuantidade.getSaldoAtual());
            ((NotaFiscalItem)impostoWrapper.getItem()).setSaldoProdutoPrevisto(componenteSaldoQuantidade.getSaldoPrevisto());
        }
        return super.atualizarComponentes(impostoWrapper);
    }

    protected GeradorKitVenda<NotaFiscalItem> getGeradorKitVenda() {
        return new GeradorKitVendaNotaFiscal(this.tipoNotaFiscal);
    }

    protected List<NotaFiscalItem> afterRateioKit(ItemKitWrapper<NotaFiscal, NotaFiscalItem> wrapper, List<NotaFiscalItem> itensParaRateio) throws UnicoMensagemUsuarioException {
        ImpostoWrapper impostoWrapper = new ImpostoWrapper(wrapper.getIdCliente(), wrapper.getIdParametro(), itensParaRateio);
        impostoWrapper.setTipoNotaFiscal(this.tipoNotaFiscal);
        impostoWrapper.setEstado(wrapper.getEstado());
        List itensKit = this.recalcularImpostosItens(impostoWrapper);
        boolean operacaoFiscal = this.calculoImpostoService.utilizaOperacaoFiscal(this.isEmissaoPropria((NotaFiscal)wrapper.getCabecalho()), SessaoUtil.getSessao().getIdFilial());
        ParametrosNotaFiscalInterface parametros = this.calculoImpostoService.getParametrosNotaFiscalInterface(operacaoFiscal ? ((NotaFiscal)wrapper.getCabecalho()).getIdOperacaoFiscal() : ((NotaFiscal)wrapper.getCabecalho()).getIdCfop(), operacaoFiscal);
        if (TipoNotaFiscal.ENTRADA.equals((Object)this.tipoNotaFiscal) || TipoNotaFiscal.SAIDA.equals((Object)this.tipoNotaFiscal) && parametros.isDigitarImpostosItemNotaSaida()) {
            NotaFiscalItem itemKit = (NotaFiscalItem)wrapper.getItem();
            boolean isNotaComplementar = this.isNotaComplementarAjuste(parametros);
            CalculoImpostoRateio.getInstance().ratearValoresDeImpostos(SessaoUtil.getSessao().getFilial(), itensKit, CampoRateioCalculoImposto.BASE_ICMS, itemKit.getBaseIcms(), this.tipoNotaFiscal);
            CalculoImpostoRateio.getInstance().ratearValoresDeImpostos(SessaoUtil.getSessao().getFilial(), itensKit, CampoRateioCalculoImposto.VALOR_ICMS, itemKit.getIcms(), this.tipoNotaFiscal);
            CalculoImpostoRateio.getInstance().ratearValoresDeImpostos(SessaoUtil.getSessao().getFilial(), itensKit, CampoRateioCalculoImposto.BASE_ICMS_ST, itemKit.getBaseIcmsSubstituicao(), this.tipoNotaFiscal);
            CalculoImpostoRateio.getInstance().ratearValoresDeImpostos(SessaoUtil.getSessao().getFilial(), itensKit, CampoRateioCalculoImposto.VALOR_ICMS_ST, itemKit.getIcmsSubstituicao(), this.tipoNotaFiscal);
            CalculoImpostoRateio.getInstance().ratearValoresDeImpostos(SessaoUtil.getSessao().getFilial(), itensKit, CampoRateioCalculoImposto.VALOR_IPI, itemKit.getIpi(), this.tipoNotaFiscal);
            CalculoImpostoRateio.getInstance().ratearValoresDeImpostos(SessaoUtil.getSessao().getFilial(), itensKit, CampoRateioCalculoImposto.VALOR_PIS, itemKit.getPis(), this.tipoNotaFiscal);
            CalculoImpostoRateio.getInstance().ratearValoresDeImpostos(SessaoUtil.getSessao().getFilial(), itensKit, CampoRateioCalculoImposto.VALOR_COFINS, itemKit.getCofins(), this.tipoNotaFiscal);
            CalculoImpostoRateio.getInstance().ratearValoresDeImpostos(SessaoUtil.getSessao().getFilial(), itensKit, CampoRateioCalculoImposto.VALOR_FCP_ST, itemKit.getIcmsFundoPobrezaST(), this.tipoNotaFiscal);
            NotaFiscalItemRN.getInstance().calculaRateioValor(itensKit, "impostoImportacao", itemKit.getImpostoImportacao(), isNotaComplementar, false);
            NotaFiscalItemRN.getInstance().calculaRateioValor(itensKit, "iof", itemKit.getIof(), isNotaComplementar, false);
            NotaFiscalItemRN.getInstance().calculaRateioValor(itensKit, "despesasAduaneiras", itemKit.getDespesasAduaneiras(), isNotaComplementar, false);
            NotaFiscalItemRN.getInstance().calculaRateioValor(itensKit, "baseImpostoImportacao", itemKit.getBaseImpostoImportacao(), isNotaComplementar, false);
            NotaFiscalItemRN.getInstance().calculaRateioValor(itensKit, "outrasDespesas", itemKit.getOutrasDespesas(), isNotaComplementar, false);
        }
        return itensKit;
    }

    private void setHabilitaFunruralSubtotal(NotaFiscal notaFiscal) {
        NaturezaOperacao cfopCabecalho;
        notaFiscal.setHabilitarFunruralSubtotal(false);
        if (notaFiscal.isNotaEntrada() && !NumberUtil.longNullOuZero((Long)notaFiscal.getIdCfop()) && (cfopCabecalho = NaturezaOperacaoRN.getInstance().buscarPorId(notaFiscal.getIdCfop())) != null && cfopCabecalho.isInformarTotaisManualmente()) {
            boolean existeItemComFunrural = notaFiscal.getNotaFiscalItens().stream().anyMatch(it -> {
                NaturezaOperacao cfopItem = NaturezaOperacaoRN.getInstance().buscarPorId(it.getIdCfop());
                return cfopItem != null && cfopItem.isContranotafunrural();
            });
            notaFiscal.setHabilitarFunruralSubtotal(existeItemComFunrural);
        }
    }

    @RequestMapping(value={"/buscar-itens-entrega-retirada"})
    @DBAutoCommit
    public List<HashMap<String, Object>> buscarItensEntregaRetirada(@RequestParam Long id, @RequestParam boolean isNfse) throws UnicoMensagemUsuarioException {
        if (isNfse) {
            ItemRN.getInstance().verificaPermiteAlterarEntregaRetirada(id, SessaoUtil.getSessao().getFilial().getId());
        } else {
            NotaFiscalItemRN.getInstance().verificaPermiteAlterarEntregaRetirada(id);
        }
        String mensagemAviso = NotaFiscalRN.getInstance().verificaNotasTransferenciaVinculadas(id);
        if (!Util.stringNullOrEmpty((String)mensagemAviso)) {
            this.notificationService.simpleNotifyUserTenantNow(ContextoHolder.getTenant(), SessaoUtil.getSessao().getIdUsuario(), TipoNotificacaoSimples.WARNING, mensagemAviso);
        }
        if (isNfse) {
            return ItemRN.getInstance().gerarMapParaEntregaRetirada(id);
        }
        return NotaFiscalItemRN.getInstance().gerarMapParaEntregaRetirada(id);
    }

    @PostMapping(value={"/gravar-itens-entrega-retirada"})
    @DBTransaction
    public void gravarItensEntregaRetirada(@RequestBody List<HashMap<String, Object>> itens, @RequestParam boolean isNfse) {
        Long idUsuario = SessaoUtil.getSessao().getUsuario().getId();
        for (HashMap<String, Object> itemMap : itens) {
            String idTipoEntregaRetirada = itemMap.getOrDefault("tipoEntregaRetirada", null);
            TipoRetiradaEntregaItem tipoRetiradaEntregaItem = (TipoRetiradaEntregaItem)EnumUtils.getPorNomeConstante(TipoRetiradaEntregaItem.class, (String)idTipoEntregaRetirada);
            Long idItem = Util.string2Long((String)Util.all2Atring((Object)itemMap.get("idItem")));
            Long idFilialEntregaRetirada = Util.string2Long((String)Util.all2Atring((Object)itemMap.get("idFilialRetirada")));
            Long idLocalEstoque = Util.string2Long((String)Util.all2Atring((Object)itemMap.get("idLocalEstoque")));
            if (isNfse) {
                ItemRN.getInstance().atualizaEntregaRetiradaItem(idItem, tipoRetiradaEntregaItem.getId(), idFilialEntregaRetirada, idLocalEstoque, idUsuario);
                continue;
            }
            NotaFiscalItemRN.getInstance().atualizaEntregaRetiradaItem(idItem, tipoRetiradaEntregaItem.getId(), idFilialEntregaRetirada, idLocalEstoque, idUsuario);
        }
    }
}

