/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.notafiscal.transmissao.documentodestinado.cartacorrecao;

import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.domain.pojo.CartaCorrecao;
import br.intelidata.commons.domain.pojo.DocumentoDestinado;
import br.intelidata.commons.domain.pojo.enuns.TipoEmissaoNotaFiscal;
import br.intelidata.commons.domain.pojo.enuns.TipoLogAcaoUsuario;
import br.intelidata.commons.domain.pojo.enuns.TipoNotaFiscal;
import br.intelidata.commons.domain.pojo.enuns.TipoRegistroConsultaDocumentoDestinatario;
import br.intelidata.commons.domain.pojo.notafiscal.NotaFiscal;
import br.intelidata.commons.modulo.notafiscal.regranegocio.CartaCorrecaoRN;
import br.intelidata.commons.modulo.notafiscal.regranegocio.DocumentoDestinadoRN;
import br.intelidata.commons.modulo.notafiscal.regranegocio.LogAcaoUsuarioRN;
import br.intelidata.commons.modulo.notafiscal.regranegocio.NotaFiscalRN;
import br.intelidata.core.aop.DBTransaction;
import br.intelidata.uniplusweb.web.rest.app.crud.notafiscal.transmissao.documentodestinado.DocumentoDestinadoCrudController;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/documentos-destinados-cartas-correcao"})
public class DocumentoDestinadoCartaCorrecaoCrudController
extends DocumentoDestinadoCrudController {
    public DocumentoDestinadoCartaCorrecaoCrudController() {
        super(TipoRegistroConsultaDocumentoDestinatario.CARTA_CORRECAO);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @RequestMapping(value={"/importar"})
    @DBTransaction
    public void importarCCEParaSistema(@RequestParam Long idDocumento) throws UnicoMensagemUsuarioException {
        DocumentoDestinado doc = (DocumentoDestinado)DocumentoDestinadoRN.getInstance().buscarPorId(idDocumento);
        if (doc == null) throw new UnicoMensagemUsuarioException("WWW275", "Documento n\u00e3o encontrado.");
        NotaFiscal nf = NotaFiscalRN.getInstance().buscarPorChaveNFe(doc.getChaveAcesso());
        if (nf == null) throw new UnicoMensagemUsuarioException("WNTF373", "N\u00e3o foi encontrado nenhuma nota de entrada com a chave de acesso " + doc.getChaveAcesso());
        if (!nf.getTipoDocumento().equals((Object)TipoNotaFiscal.ENTRADA) || !nf.getTipoEmissao().equals((Object)TipoEmissaoNotaFiscal.TERCEIROS)) {
            throw new UnicoMensagemUsuarioException("WNTF372", "Nota fiscal encontrada n\u00e3o \u00e9 uma nota de entrada com emiss\u00e3o desmarcado. Por favor verifique.");
        }
        CartaCorrecao cce = new CartaCorrecao();
        cce.setIdNotaFiscal(nf.getId());
        cce.setDataHora(doc.getDataHora());
        cce.setDescricao(doc.getCorrecao());
        cce.setSequencia(doc.getSequencia().intValue());
        CartaCorrecaoRN.getInstance().gravar(0, cce, SessaoUtil.getSessao());
        LogAcaoUsuarioRN.getInstance().incluirAcaoUsuarioCorrente(SessaoUtil.getSessao(), DocumentoDestinadoRN.getInstance().getTabela(), doc.getId(), "Importou carta de corre\u00e7\u00e3o para a nota " + doc.getChaveAcesso(), TipoLogAcaoUsuario.IMPORTOU_CCE_POR_DOCUMENTO);
    }

    protected String getCacheId() {
        return "documentos-destinados-cartas-correcao";
    }
}

