/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.objetos;

import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.execoes.UnicoException;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.sql.usql.ColunaSQL;
import br.intelidata.commons.core.sql.usql.Ordem;
import br.intelidata.commons.core.util.BeanUtil;
import br.intelidata.commons.domain.pojo.AbstractPojo;
import br.intelidata.commons.domain.pojo.ConfiguracaoOrdemServico;
import br.intelidata.commons.domain.pojo.Objeto;
import br.intelidata.commons.domain.pojo.enuns.QuantidadeCampoExtra;
import br.intelidata.commons.domain.regranegocio.AbstractRegraNegocio;
import br.intelidata.commons.domain.regranegocio.ConfiguracaoOrdemServicoCommonRN;
import br.intelidata.commons.modulo.ordemservico.regranegocio.ObjetoRN;
import br.intelidata.core.aop.DBAutoCommit;
import br.intelidata.core.aop.DBTransaction;
import br.intelidata.uniplusweb.core.coreinterfaces.ConfiguracaoCampoExtra;
import br.intelidata.uniplusweb.core.coreinterfaces.SubMenuMapping;
import br.intelidata.uniplusweb.core.grid.FilterField;
import br.intelidata.uniplusweb.core.grid.GridBuilder;
import br.intelidata.uniplusweb.core.util.StringUtil;
import br.intelidata.uniplusweb.web.rest.app.client.crud.CrudController;
import br.intelidata.uniplusweb.web.rest.app.client.crud.ObjetoAuxiliar;
import br.intelidata.uniplusweb.web.rest.app.crud.objetos.ConfiguracaoObjetoWrapper;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@ConfiguracaoCampoExtra(TABELA="objeto", QUANTIDADE=QuantidadeCampoExtra.OBJETO)
@RestController
@RequestMapping(value={"/api/objetos"})
@SubMenuMapping(MENU="SubMenuVendasAuxiliarOrdemServico", NOME="Configurar Objeto", ROTA="/ordens-servicos/objetos", PROGRAMA=607)
public class ObjetoCrudController
extends CrudController<Objeto, ObjetoRN> {
    public ObjetoCrudController() {
        super((AbstractRegraNegocio)ObjetoRN.getInstance(), Objeto::new, true, true, true);
    }

    @RequestMapping(value={"/filtrar-objeto"})
    @DBAutoCommit
    public List<Objeto> buscarEntidadesAutoComplete(@RequestParam(value="query", required=false) String textoPesquisado, @RequestParam(value="limite", required=false, defaultValue="6") Integer limite, @RequestParam(value="exibirInativos", required=false, defaultValue="true") boolean exibirInativos) {
        return ObjetoRN.getInstance().buscarDadosAutoCompleteWeb(SessaoUtil.getSessao(), textoPesquisado, limite.intValue(), exibirInativos);
    }

    @DBAutoCommit
    public String lastValidCode() {
        try {
            ConfiguracaoOrdemServico confOrdemServico = ConfiguracaoOrdemServicoCommonRN.getInstance().buscarPorIdFilial(SessaoUtil.getSessao());
            if (!StringUtil.stringNullOrEmpty((String)confOrdemServico.getDescricaoCampoChave())) {
                return ObjetoRN.getInstance().buscarProximoCampoChave();
            }
            return super.lastValidCode();
        }
        catch (UnicoMensagemUsuarioException ex) {
            throw new UnicoException("ORS209", (Throwable)ex);
        }
    }

    protected String getCacheId() {
        return "objetos".concat(SessaoUtil.getSessao().getIdFilial().toString());
    }

    protected GridBuilder<ObjetoRN> getGridBuilder() {
        ArrayList<ColunaSQL> colunas = new ArrayList<ColunaSQL>();
        colunas.add(new ColunaSQL("id", "ID", 0, false));
        colunas.add(new ColunaSQL("inativo", "inativo", 0, false));
        colunas.add(new ColunaSQL("idEntidade", "idEntidade", 0, false));
        colunas.add(new ColunaSQL("campoChave", "campoChave", 0, false));
        colunas.add(new ColunaSQL("codigo", "C\u00f3digo", 250, true));
        colunas.add(new ColunaSQL("descricao", "Descri\u00e7\u00e3o", 500, true));
        colunas.add(new ColunaSQL("nome", "nomeCliente", "Cliente", 500, true, new String[]{"fk_objeto_entidade"}));
        colunas.add(new ColunaSQL("cnpjCpf", "cnpjCpf", "CNPJ/CPF", 250, true, new String[]{"fk_objeto_entidade"}));
        GridBuilder grid = new GridBuilder(ObjetoRN.getInstance().getTabela(), colunas);
        grid.setOrdemDefault(new Ordem("codigo"));
        return grid;
    }

    protected void beforeSave(Objeto objeto, Optional<Long> parentId) throws UnicoMensagemUsuarioException {
        ConfiguracaoOrdemServico confOrdemServico = ConfiguracaoOrdemServicoCommonRN.getInstance().buscarPorIdFilial(SessaoUtil.getSessao());
        if (confOrdemServico != null && !StringUtil.stringNullOrEmpty((String)confOrdemServico.getDescricaoCampoChave())) {
            ObjetoRN.getInstance().validarCampoChave(SessaoUtil.getSessao(), objeto.getCampoChave(), objeto);
        }
    }

    protected ObjetoAuxiliar getObjetoAuxiliar() throws UnicoMensagemUsuarioException {
        ConfiguracaoObjetoWrapper configuracao = new ConfiguracaoObjetoWrapper();
        ConfiguracaoOrdemServico confOrdemServico = ConfiguracaoOrdemServicoCommonRN.getInstance().buscarPorIdFilial(SessaoUtil.getSessao());
        configuracao.setConfiguracao(confOrdemServico);
        return configuracao;
    }

    @DBTransaction
    public Long create(@RequestBody Objeto objeto, Optional<Long> parentId) throws UnicoMensagemUsuarioException {
        objeto.setCodigo(ObjetoRN.getInstance().getCodigoUnico(SessaoUtil.getSessao()));
        return super.create((AbstractPojo)objeto, parentId);
    }

    protected void afterLoadGrid(List<ColunaSQL> colunas, List<Object[]> dados, List<FilterField> filters, MultiValueMap<String, String> parameters) throws UnicoMensagemUsuarioException {
        filters.forEach(filterField -> {
            if (filterField.getField().equalsIgnoreCase("idEntidade")) {
                List listDados = ((ObjetoRN)this.rn).buscarObjetosSemClienteWeb();
                listDados.forEach(dado -> {
                    Object[] obj = new Object[colunas.size()];
                    for (int i = 0; i < colunas.size(); ++i) {
                        Object valor;
                        ColunaSQL coluna = (ColunaSQL)colunas.get(i);
                        obj[i] = coluna.getChavesEstrangeiras() != null && coluna.getChavesEstrangeiras().length > 0 ? "" : (valor = BeanUtil.get((Object)dado, (String)coluna.getNome(), (Object[])new Object[0]));
                    }
                    dados.add(obj);
                });
            }
        });
    }
}

