/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.pdv;

import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.sistema.PropriedadeRN;
import br.intelidata.commons.core.sistema.Sessao;
import br.intelidata.commons.domain.pojo.Operacao;
import br.intelidata.commons.domain.pojo.SimpleController;
import br.intelidata.commons.domain.pojo.enuns.StatusDAV;
import br.intelidata.commons.domain.pojo.pvdav.AbstractDav;
import br.intelidata.commons.domain.pojo.pvdav.Dav;
import br.intelidata.commons.domain.regranegocio.DavCommonRN;
import br.intelidata.commons.modulo.pvdav.regranegocio.DavRN;
import br.intelidata.core.aop.DBAutoCommit;
import br.intelidata.core.aop.DBTransaction;
import br.intelidata.uniplusweb.web.rest.app.crud.pdv.FiltroImportarDavWrapper;
import java.util.List;
import java.util.Map;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import unipaf.dto.doceletronico.DocumentoEletronicoRequest;
import unipaf.helper.DavHelper;
import unipaf.pojo.DavPdv;
import unipaf.servidor.DocumentoEletronicoDav;

@RestController
@RequestMapping(value={"/api/importar-dav"})
public class importarDavController
extends SimpleController {
    @PostMapping(value={"/carregar"})
    @DBAutoCommit
    public List<Map<String, Object>> listaDav(@RequestBody FiltroImportarDavWrapper filtro) throws UnicoMensagemUsuarioException {
        Sessao sessao = SessaoUtil.getSessao();
        PropriedadeRN.getInstance().setPropriedade(sessao, 941, filtro.getTipoDav().getId());
        return DavCommonRN.getInstance().buscarListaDavPdvWeb(Long.valueOf(0L), sessao.getIdFilial(), filtro.getInicio(), filtro.getFim(), filtro.getTipoDav(), StatusDAV.FECHADO);
    }

    @GetMapping(value={"/importar"})
    @DBTransaction
    public Operacao importarDav(@RequestParam Long idDav) throws UnicoMensagemUsuarioException {
        Sessao sessao = SessaoUtil.getSessao();
        Dav dav = (Dav)DavRN.getInstance().buscarPorId(idDav);
        DavPdv nfce = new DavHelper(sessao).getNfce((AbstractDav)dav);
        DocumentoEletronicoDav ded = new DocumentoEletronicoDav(sessao, nfce, (AbstractDav)dav);
        DocumentoEletronicoRequest der = ded.criar();
        return der.getOperacao();
    }
}

