/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.preco.margembruta;

import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.sistema.PropriedadeRN;
import br.intelidata.commons.core.sistema.Sessao;
import br.intelidata.commons.core.util.Util;
import br.intelidata.commons.domain.pojo.AbstractDavItem;
import br.intelidata.commons.domain.pojo.MargemBruta;
import br.intelidata.commons.domain.pojo.enuns.TipoDataCustoMargemBruta;
import br.intelidata.commons.domain.pojo.enuns.TipoMargemBruta;
import br.intelidata.commons.domain.pojo.pvdav.DavItem;
import br.intelidata.commons.modulo.documentoauxiliarfaturamento.regranegocio.OrcamentoFaturamentoItemRN;
import br.intelidata.commons.modulo.documentoauxiliarfaturamento.regranegocio.PedidoItemRN;
import br.intelidata.commons.modulo.documentoauxiliarfaturamento.regranegocio.VendaNfceItemRN;
import br.intelidata.commons.modulo.preco.regranegocio.MargemBrutaRN;
import br.intelidata.commons.modulo.pvdav.regranegocio.DavItemRN;
import br.intelidata.core.aop.DBAutoCommit;
import br.intelidata.uniplusweb.web.rest.app.crud.preco.margembruta.MargemBrutaCrudController;
import br.intelidata.uniplusweb.web.rest.app.crud.preco.margembruta.MargemBrutaWrapper;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/margem-bruta"})
public class MargemBrutaCrudController {
    @RequestMapping
    @DBAutoCommit
    public MargemBruta calcular(@RequestParam Long idPai, @RequestParam TipoMargemBruta tipoMargemBruta, @RequestParam TipoDataCustoMargemBruta tipoDataCusto) throws UnicoMensagemUsuarioException {
        Sessao sessao = SessaoUtil.getSessao();
        PropriedadeRN.getInstance().setPropriedade(sessao, 939, tipoDataCusto.getId());
        return MargemBrutaRN.getInstance().calcular(sessao, this.getItens(idPai, tipoMargemBruta), tipoDataCusto);
    }

    private <E extends AbstractDavItem> List<E> getItens(Long idPai, TipoMargemBruta tipoMargemBruta) {
        switch (1.$SwitchMap$br$intelidata$commons$domain$pojo$enuns$TipoMargemBruta[tipoMargemBruta.ordinal()]) {
            case 1: {
                return OrcamentoFaturamentoItemRN.getInstance().buscarListaPorIdFaturamento(idPai);
            }
            case 2: {
                return PedidoItemRN.getInstance().buscarListaPorIdFaturamento(idPai);
            }
            case 3: {
                return VendaNfceItemRN.getInstance().buscarListaPorIdFaturamento(idPai);
            }
            case 4: {
                return DavItemRN.getInstance().buscarListaPorIdDav(idPai);
            }
        }
        return null;
    }

    @RequestMapping(value={"/calcular-custototal-lucrobruto"}, method={RequestMethod.POST})
    @DBAutoCommit
    public Map<String, Object> calcularCustoTotalLucroBruto(@RequestBody MargemBrutaWrapper wrapper) {
        BigDecimal custoTotal = BigDecimal.ZERO;
        BigDecimal lucroBruto = BigDecimal.ZERO;
        int casasDecimaisCusto = 2;
        int casasDecimaisPreco = 2;
        List listaItens = wrapper.getItens();
        if (!Util.listNullOrEmpty((List)listaItens)) {
            MargemBrutaRN.getInstance().calcular(SessaoUtil.getSessao(), listaItens, TipoDataCustoMargemBruta.DATA_DOCUMENTO);
            for (DavItem item : listaItens) {
                MargemBruta margemBruta = item.getMargemBruta();
                if (margemBruta == null) continue;
                custoTotal = custoTotal.add(margemBruta.getCusto());
                lucroBruto = lucroBruto.add(margemBruta.getPrecoLiquido());
                casasDecimaisCusto = margemBruta.getCasasDecimaisCusto() > casasDecimaisCusto ? margemBruta.getCasasDecimaisCusto() : casasDecimaisCusto;
                casasDecimaisPreco = margemBruta.getCasasDecimaisPreco() > casasDecimaisPreco ? margemBruta.getCasasDecimaisPreco() : casasDecimaisPreco;
            }
        }
        HashMap<String, Object> valores = new HashMap<String, Object>();
        valores.put("custoTotal", custoTotal.setScale(casasDecimaisCusto, RoundingMode.HALF_EVEN));
        valores.put("lucroBruto", lucroBruto.subtract(custoTotal).setScale(casasDecimaisPreco, RoundingMode.HALF_EVEN));
        valores.put("casasDecimaisCusto", casasDecimaisCusto);
        valores.put("casasDecimaisPreco", casasDecimaisPreco);
        return valores;
    }
}

