/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.produto.custoadicional;

import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.sql.usql.ColunaSQL;
import br.intelidata.commons.domain.pojo.adicional.CustoAdicional;
import br.intelidata.commons.domain.regranegocio.AbstractRegraNegocio;
import br.intelidata.commons.modulo.produto.regranegocio.CustoAdicionalRN;
import br.intelidata.commons.modulo.produto.regranegocio.ProdutoRN;
import br.intelidata.core.aop.DBTransaction;
import br.intelidata.uniplusweb.core.grid.GridBuilder;
import br.intelidata.uniplusweb.core.util.NumberUtil;
import br.intelidata.uniplusweb.core.util.StringUtil;
import br.intelidata.uniplusweb.web.rest.app.client.crud.CrudController;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Optional;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/custos-adicionais"})
public class CustoAdicionalCrudController
extends CrudController<CustoAdicional, CustoAdicionalRN> {
    public CustoAdicionalCrudController() {
        super((AbstractRegraNegocio)CustoAdicionalRN.getInstance(), CustoAdicional::new);
        this.dependsOn("idProduto");
    }

    protected GridBuilder<CustoAdicionalRN> getGridBuilder() {
        ArrayList<ColunaSQL> colunas = new ArrayList<ColunaSQL>();
        colunas.add(new ColunaSQL("id", "ID", 0, false));
        colunas.add(new ColunaSQL("idProduto", "idProduto", 0, false));
        colunas.add(new ColunaSQL("idOrdemServico", "idOrdemServico", 0, false));
        colunas.add(new ColunaSQL("tipoDocumento", "Tipo", 100, true));
        colunas.add(new ColunaSQL("documento", "Documento", 100, true));
        colunas.add(new ColunaSQL("historico", "Hist\u00f3rico", 100, true));
        colunas.add(new ColunaSQL("data", "Data", 100, true));
        colunas.add(new ColunaSQL("valor", "Valor", 100, true));
        return new GridBuilder(CustoAdicionalRN.getInstance().getTabela(), colunas);
    }

    protected void beforeSave(CustoAdicional custoAdicional, Optional<Long> parentId) throws UnicoMensagemUsuarioException {
        if (NumberUtil.longNullOuZero((Long)custoAdicional.getIdProduto())) {
            throw new UnicoMensagemUsuarioException("COM236586", "O produto n\u00e3o foi informado para a inclus\u00e3o dos custos adicionais!");
        }
        if (custoAdicional.getData() == null) {
            throw new UnicoMensagemUsuarioException("WPRD137", "Data do lan\u00e7amento n\u00e3o foi informada! Verifique.");
        }
        if (StringUtil.stringNullOrEmpty((String)custoAdicional.getDocumento())) {
            throw new UnicoMensagemUsuarioException("WPRD138", "Documento do lan\u00e7amento n\u00e3o foi informada! Verifique.");
        }
        if (NumberUtil.bigDecimalNullOrZero((BigDecimal)custoAdicional.getValor())) {
            throw new UnicoMensagemUsuarioException("WPRD139", "Valor do lan\u00e7amento n\u00e3o foi informada! Verifique.");
        }
        boolean custoExistente = CustoAdicionalRN.getInstance().buscarListaPorProduto(custoAdicional.getIdProduto()).stream().anyMatch(c -> (NumberUtil.longNullOuZero((Long)custoAdicional.getId()) || !custoAdicional.getId().equals(c.getId())) && custoAdicional.getData().equals(c.getData()) && custoAdicional.getDocumento().equals(c.getDocumento()) && custoAdicional.getHistorico().equals(c.getHistorico()) && custoAdicional.getValor().equals(c.getValor()));
        if (custoExistente) {
            throw new UnicoMensagemUsuarioException("WPRD140", "Custo j\u00e1 existe! Verifique.");
        }
    }

    @RequestMapping(value={"{id}"}, method={RequestMethod.DELETE})
    @DBTransaction
    public void delete(@PathVariable Long id) throws UnicoMensagemUsuarioException {
        CustoAdicional custoAdicional = (CustoAdicional)((CustoAdicionalRN)this.rn).buscarPorId(id);
        super.delete(id);
        this.afterSave(custoAdicional, Optional.empty());
    }

    protected void afterSave(CustoAdicional custoAdicional, Optional<Long> parentId) throws UnicoMensagemUsuarioException {
        ProdutoRN.getInstance().atualizaCustoAdicionalProduto(SessaoUtil.getSessao(), custoAdicional.getIdProduto());
    }

    protected String getCacheId() {
        return "custos-adicionais";
    }
}

