/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.produto.embalagem;

import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.licenca.Funcionalidade;
import br.intelidata.commons.core.licenca.FuncionalidadeManager;
import br.intelidata.commons.core.sql.usql.ColunaSQL;
import br.intelidata.commons.core.util.DataHoraFactory;
import br.intelidata.commons.core.util.EnumSimNao;
import br.intelidata.commons.core.util.Util;
import br.intelidata.commons.domain.pojo.AbstractPojo;
import br.intelidata.commons.domain.pojo.Embalagem;
import br.intelidata.commons.domain.pojo.Produto;
import br.intelidata.commons.domain.pojo.enuns.TipoEmbalagem;
import br.intelidata.commons.domain.regranegocio.AbstractRegraNegocio;
import br.intelidata.commons.modulo.produto.regranegocio.EmbalagemLogRN;
import br.intelidata.commons.modulo.produto.regranegocio.EmbalagemRN;
import br.intelidata.commons.modulo.produto.regranegocio.ProdutoRN;
import br.intelidata.core.aop.DBAutoCommit;
import br.intelidata.core.aop.DBTransaction;
import br.intelidata.uniplusweb.core.grid.GridBuilder;
import br.intelidata.uniplusweb.core.util.NumberUtil;
import br.intelidata.uniplusweb.web.rest.app.client.crud.CrudController;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/embalagens-produto"})
public class EmbalagemCrudController
extends CrudController<Embalagem, EmbalagemRN> {
    @Autowired
    public EmbalagemCrudController() {
        super((AbstractRegraNegocio)EmbalagemRN.getInstance(), Embalagem::new, false);
        this.dependsOn("idProduto");
    }

    @RequestMapping(value={"/imprimir-etiquetas"}, method={RequestMethod.PUT})
    @DBTransaction
    public void impressaoEtiqueta(@RequestBody Embalagem embalagem) throws UnicoMensagemUsuarioException {
        if (embalagem.isImprimirEtiqueta()) {
            List embalagens = EmbalagemRN.getInstance().buscarPorIdProduto(embalagem.getIdProduto(), false);
            embalagens.forEach(emb -> emb.setImprimirEtiqueta(emb.getId().equals(embalagem.getId())));
            EmbalagemRN.getInstance().gravarLista(1, embalagens, SessaoUtil.getSessao());
        } else {
            this.update((AbstractPojo)embalagem, Optional.of(embalagem.getIdProduto()));
        }
    }

    @RequestMapping(value={"/filtrar-por-tipo-produto"})
    @DBAutoCommit
    public List<Embalagem> filtraPorTipoEmbalagemProduto(@RequestParam Long idProduto, @RequestParam List<TipoEmbalagem> tipos, @RequestParam(required=false) boolean filtrarSomenteEmbalagem) {
        if (!tipos.contains(TipoEmbalagem.COMPRAVENDA)) {
            tipos.add(TipoEmbalagem.COMPRAVENDA);
        }
        if (filtrarSomenteEmbalagem) {
            return EmbalagemRN.getInstance().buscarListaAtivaPorTipo(idProduto, false, tipos.toArray(new TipoEmbalagem[0])).stream().peek(embalagem -> {
                String cdEmbalagem = embalagem.getNomeUnidadeMedida().concat("(").concat(Util.bigDecimal2String((BigDecimal)embalagem.getFatorConversao(), (String)Util.getMascaraQuantidade((int)embalagem.getCasasDecimais()))).concat(")");
                embalagem.setDescricao(cdEmbalagem);
            }).collect(Collectors.toList());
        }
        Long idUnidadeMedidaProduto = ((Produto)ProdutoRN.getInstance().buscarPorId(idProduto)).getIdUnidadeMedida();
        return EmbalagemRN.getInstance().montarEmbalagensProdutoWeb(idProduto, idUnidadeMedidaProduto, tipos);
    }

    protected GridBuilder<EmbalagemRN> getGridBuilder() {
        return new GridBuilder(EmbalagemRN.getInstance().getTabela(), Arrays.asList(new ColunaSQL("id", "Id", 0, false), new ColunaSQL("idProduto", "idProduto", 0, false), new ColunaSQL("idUnidadeMedida", "idUnidadeMedida", 0, false), new ColunaSQL("inativo", "Periodo", 0, true), new ColunaSQL("nome", "nomeUnidadeMedida", "nomeUnidadeMedida", 0, true, new String[]{"fk_embalagem_unidademedida"}), new ColunaSQL("fatorConversao", "fatorConversao", 0, true), new ColunaSQL("codigoBarras", "codigoBarras", 0, true), new ColunaSQL("descricao", "descricao", 0, true), new ColunaSQL("codigoProduto", "codigoProduto", 0, false), new ColunaSQL("preco", "preco", 0, true), new ColunaSQL("percentualDesconto", "percentualDesconto", 0, true), new ColunaSQL("lucroBruto", "lucroBruto", 0, true), new ColunaSQL("percentualMarkup", "percentualMarkup", 0, true), new ColunaSQL("tipoEmbalagem", "tipoEmbalagem", 0, true, TipoEmbalagem.class), new ColunaSQL("imprimirEtiqueta", "imprimirEtiqueta", 0, true), new ColunaSQL("enviaMobile", "enviaMobile", 0, true), new ColunaSQL("enviaPdv", "enviaPdv", 0, true), new ColunaSQL("exportarBalanca", "exportarBalanca", 0, true), new ColunaSQL("unidadeTributavel", "unidadeTributavel", 0, true), new ColunaSQL("enviaEcommerce", "enviaEcommerce", 0, true)));
    }

    protected void beforeCreate(Embalagem embalagem, Optional<Long> parentId) {
        this.atualizaDataUsuarioEmbalagem(embalagem);
    }

    protected void beforeSave(Embalagem embalagem, Optional<Long> parentId) throws UnicoMensagemUsuarioException {
        Embalagem original;
        Integer kit = (Integer)ProdutoRN.getInstance().buscarValorPorID(embalagem.getIdProduto(), "kit");
        if (kit != null && kit == 1) {
            throw new UnicoMensagemUsuarioException("WPRD408", "Este produto \u00e9 um kit, e n\u00e3o ser\u00e1 permitido embalagens! ");
        }
        if (!NumberUtil.longNullOuZero((Long)embalagem.getId()) && !(original = (Embalagem)EmbalagemRN.getInstance().buscarPorId(embalagem.getId())).getIdUnidadeMedida().equals(embalagem.getIdUnidadeMedida())) {
            embalagem.setIdUnidadeMedida(original.getIdUnidadeMedida());
        }
    }

    protected void afterSave(Embalagem embalagem, Optional<Long> parentId) throws UnicoMensagemUsuarioException {
        if (!NumberUtil.longNullOuZero((Long)embalagem.getIdProduto()) && FuncionalidadeManager.getInstance().isAtiva(Funcionalidade.HISTORICO_PRECO)) {
            EmbalagemLogRN.getInstance().insert(SessaoUtil.getSessao(), Collections.singletonList(embalagem));
        }
    }

    protected String getCacheId() {
        return "embalagens-produto";
    }

    private void atualizaDataUsuarioEmbalagem(Embalagem embalagem) {
        if (embalagem.getInativo().equals(EnumSimNao.NAO.getId())) {
            embalagem.setIdUltimoUsuarioAtivo(SessaoUtil.getSessao().getUsuario().getId());
            embalagem.setDataUltimoAtivo(DataHoraFactory.getDataHora());
        } else {
            embalagem.setIdUltimoUsuarioInativo(SessaoUtil.getSessao().getUsuario().getId());
            embalagem.setDataUltimoInativo(DataHoraFactory.getDataHora());
        }
    }
}

