/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.promocao.kit;

import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.sistema.Sessao;
import br.intelidata.commons.core.sql.usql.ColunaSQL;
import br.intelidata.commons.core.util.Util;
import br.intelidata.commons.domain.pojo.AbstractPojo;
import br.intelidata.commons.domain.pojo.Promocao;
import br.intelidata.commons.domain.pojo.PromocaoKit;
import br.intelidata.commons.domain.regranegocio.AbstractRegraNegocio;
import br.intelidata.commons.domain.regranegocio.PromocaoCommonRN;
import br.intelidata.commons.domain.regranegocio.PromocaoItemKitCommonRN;
import br.intelidata.commons.domain.regranegocio.PromocaoKitCommonRN;
import br.intelidata.core.aop.DBTransaction;
import br.intelidata.uniplusweb.core.grid.GridBuilder;
import br.intelidata.uniplusweb.web.rest.app.client.crud.CrudController;
import br.intelidata.uniplusweb.web.rest.app.crud.promocao.PromocaoReturnWrapper;
import br.intelidata.uniplusweb.web.rest.app.crud.promocao.PromocaoWrapper;
import java.util.Arrays;
import java.util.List;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/promocoes-kit"})
public class PromocaoKitCrudController
extends CrudController<PromocaoKit, PromocaoKitCommonRN> {
    public PromocaoKitCrudController() {
        super((AbstractRegraNegocio)PromocaoKitCommonRN.getInstance(), PromocaoKit::new);
        this.dependsOn("idPromocao");
    }

    protected void beforeDelete(PromocaoKit promocaoKit) throws UnicoMensagemUsuarioException {
        List itens = PromocaoItemKitCommonRN.getInstance().buscarListaPorPromocaoKit(promocaoKit.getId());
        PromocaoItemKitCommonRN.getInstance().excluirLista(SessaoUtil.getSessao(), itens);
    }

    @RequestMapping(value={"/incluir"}, method={RequestMethod.POST})
    @DBTransaction
    public PromocaoReturnWrapper gravarDados(@RequestBody PromocaoWrapper wrapper) throws UnicoMensagemUsuarioException {
        Sessao sessao = SessaoUtil.getSessao();
        Promocao promocao = wrapper.getPromocao();
        PromocaoKit promocaoKit = wrapper.getPromocaoKit();
        Long idPai = promocao.getId();
        if (Util.longNullOuZero((Long)idPai)) {
            idPai = PromocaoCommonRN.getInstance().incluir(promocao, sessao);
        }
        promocaoKit.setIdPromocao(idPai);
        Long idFilho = PromocaoKitCommonRN.getInstance().incluir((AbstractPojo)promocaoKit, sessao);
        return new PromocaoReturnWrapper(idPai, idFilho);
    }

    protected GridBuilder<PromocaoKitCommonRN> getGridBuilder() {
        List<ColunaSQL> colunas = Arrays.asList(new ColunaSQL("id", "ID", 0, false), new ColunaSQL("idPromocao", "idPromocao", 0, false), new ColunaSQL("sequencia", "Seq", 0, true), new ColunaSQL("descricao", "Descri\u00e7\u00e3o", 0, true), new ColunaSQL("valor", "Valor", 0, true), new ColunaSQL("quantidade", "Quantidade", 0, true), new ColunaSQL("tipo", "Tipo", 0, true));
        return new GridBuilder(PromocaoKitCommonRN.getInstance().getTabela(), colunas);
    }

    protected String getCacheId() {
        return "promocoes-kit";
    }
}

