/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.scanntech.configuracao.promocao;

import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.util.InativoFilial;
import br.intelidata.commons.domain.pojo.ConfiguracaoScanntech;
import br.intelidata.commons.domain.pojo.Filial;
import br.intelidata.commons.domain.pojo.FilialScanntechDTO;
import br.intelidata.commons.domain.regranegocio.AbstractRegraNegocio;
import br.intelidata.commons.domain.regranegocio.ConfiguracaoScanntechCommonRN;
import br.intelidata.commons.modulo.cadastros.regranegocio.FilialRN;
import br.intelidata.commons.modulo.vendas.regranegocio.PromocaoRN;
import br.intelidata.core.aop.DBAutoCommit;
import br.intelidata.uniplusweb.core.coreinterfaces.SubMenuMapping;
import br.intelidata.uniplusweb.core.service.ResponseEntityService;
import br.intelidata.uniplusweb.web.rest.app.client.crud.SimpleCrudController;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Base64;
import java.util.Comparator;
import java.util.Objects;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/configuracao-promocao"})
@SubMenuMapping(MENU="SubMenuScanntech", NOME="Configura\u00e7\u00e3o promo\u00e7\u00e3o", ROTA="/cadastros/configuracao-promocao", PROGRAMA=6001)
@SuppressFBWarnings(value={"DM_DEFAULT_ENCODING"}, justification="Melhor n\u00e3o corrigir este bug para evitar problemas posteriores")
public class ScanntechConfiguracaoPromocaoSimpleController
extends SimpleCrudController<ConfiguracaoScanntech, ConfiguracaoScanntechCommonRN> {
    public ScanntechConfiguracaoPromocaoSimpleController(ResponseEntityService responseEntityService) {
        super((AbstractRegraNegocio)ConfiguracaoScanntechCommonRN.getInstance());
    }

    @DBAutoCommit
    public ConfiguracaoScanntech get(@RequestParam(required=false) Long parentId) {
        ConfiguracaoScanntech configuracao = ((ConfiguracaoScanntechCommonRN)this.getRegraNegocio()).buscar(false);
        if (configuracao == null) {
            configuracao = new ConfiguracaoScanntech();
        }
        for (Filial filial : FilialRN.getInstance().buscarLista()) {
            if (!InativoFilial.NAO.equals((Object)filial.getInativo())) continue;
            configuracao.getFiliais().add(new FilialScanntechDTO(filial));
        }
        configuracao.getFiliais().sort(Comparator.comparing(FilialScanntechDTO::getCodigo));
        return configuracao;
    }

    public void beforeSave(ConfiguracaoScanntech configuracaoScanntech) throws UnicoMensagemUsuarioException {
        ConfiguracaoScanntech configuracaoScanntechAtual = ConfiguracaoScanntechCommonRN.getInstance().buscar(false);
        if (configuracaoScanntechAtual != null && !Objects.equals(configuracaoScanntechAtual.getCodigoEmpresa(), configuracaoScanntech.getCodigoEmpresa())) {
            PromocaoRN.getInstance().limparDadosPromocaoCRMScanntech();
        }
        if (!configuracaoScanntech.getSenha().equalsIgnoreCase(configuracaoScanntech.getSenhaNova())) {
            configuracaoScanntech.setSenha(Base64.getEncoder().encodeToString(configuracaoScanntech.getSenhaNova().getBytes()));
        }
        if (!configuracaoScanntech.getSenhaTokenizacao().equalsIgnoreCase(configuracaoScanntech.getNovaSenhaTokenizacao())) {
            configuracaoScanntech.setSenhaTokenizacao(Base64.getEncoder().encodeToString(configuracaoScanntech.getNovaSenhaTokenizacao().getBytes()));
        }
        for (FilialScanntechDTO filialDTO : configuracaoScanntech.getFiliais()) {
            FilialRN.getInstance().gravarFilialScanntech(SessaoUtil.getSessao(), filialDTO);
        }
    }
}

