/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.unidademedida.sinonimo;

import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.sql.usql.ColunaSQL;
import br.intelidata.commons.domain.pojo.SinonimoUnidadeMedida;
import br.intelidata.commons.domain.pojo.Unidademedida;
import br.intelidata.commons.domain.regranegocio.AbstractRegraNegocio;
import br.intelidata.commons.modulo.produto.regranegocio.SinonimoUnidadeMedidaRN;
import br.intelidata.commons.modulo.produto.regranegocio.UnidademedidaRN;
import br.intelidata.core.aop.DBAutoCommit;
import br.intelidata.uniplusweb.core.grid.GridBuilder;
import br.intelidata.uniplusweb.core.util.NumberUtil;
import br.intelidata.uniplusweb.core.util.StringUtil;
import br.intelidata.uniplusweb.web.rest.app.client.crud.CrudController;
import java.util.ArrayList;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/sinonimos-unidades-medida"})
public class SinonimoUnidadeMedidaCrudController
extends CrudController<SinonimoUnidadeMedida, SinonimoUnidadeMedidaRN> {
    @Autowired
    public SinonimoUnidadeMedidaCrudController() {
        super((AbstractRegraNegocio)SinonimoUnidadeMedidaRN.getInstance(), SinonimoUnidadeMedida::new);
        this.dependsOn("idUnidadeMedida");
    }

    @RequestMapping(value={"/validar-sinonimo"})
    @DBAutoCommit
    public boolean verificarUNExistentePorSinonimo(@RequestParam(value="value") String sinonimo, @RequestParam(value="id", required=false) Long id) throws UnicoMensagemUsuarioException {
        Unidademedida unidademedida = UnidademedidaRN.getInstance().buscarUnidademedidaPorCodigo(sinonimo);
        if (unidademedida != null) {
            throw new UnicoMensagemUsuarioException("WPRD202", "O sin\u00f4nimo j\u00e1 est\u00e1 sendo utilizado na unidade de medida " + unidademedida.getCodigo() + " - " + unidademedida.getNome());
        }
        SinonimoUnidadeMedida sinonimoUnidadeMedida = (SinonimoUnidadeMedida)SinonimoUnidadeMedidaRN.getInstance().buscarPorCodigo(sinonimo);
        if (sinonimoUnidadeMedida != null && (NumberUtil.longNullOuZero((Long)id) || !sinonimoUnidadeMedida.getId().equals(id))) {
            throw new UnicoMensagemUsuarioException("WWW84", "O sin\u00f4nimo j\u00e1 est\u00e1 cadastrado em outra unidade de medida. Verifique!");
        }
        return false;
    }

    protected GridBuilder<SinonimoUnidadeMedidaRN> getGridBuilder() {
        ArrayList<ColunaSQL> colunas = new ArrayList<ColunaSQL>();
        colunas.add(new ColunaSQL("id", "ID", 0, false));
        colunas.add(new ColunaSQL("idUnidadeMedida", "ID", 0, false));
        colunas.add(new ColunaSQL("sinonimo", "Sin\u00f4nimo", 100, true));
        return new GridBuilder(SinonimoUnidadeMedidaRN.getInstance().getTabela(), colunas);
    }

    protected void beforeSave(SinonimoUnidadeMedida sinonimoUnidadeMedida, Optional<Long> parentId) throws UnicoMensagemUsuarioException {
        if (NumberUtil.longNullOuZero((Long)sinonimoUnidadeMedida.getIdUnidadeMedida())) {
            throw new UnicoMensagemUsuarioException("WWW82", "Unidade n\u00e3o informada");
        }
        if (StringUtil.stringNullOrEmpty((String)sinonimoUnidadeMedida.getSinonimo())) {
            throw new UnicoMensagemUsuarioException("WWW83", "Sin\u00f4nimo n\u00e3o informado");
        }
    }

    protected String getCacheId() {
        return "sinonimos-unidades-medida";
    }
}

